/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.descriptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.EmptyInterceptor;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.ow2.bonita.env.Descriptor;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireDefinition;
import org.ow2.bonita.env.WireException;
import org.ow2.bonita.env.descriptor.AbstractDescriptor;
import org.ow2.bonita.search.SearchUtil;
import org.ow2.bonita.util.DbTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Listener;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ReflectUtil;

public class HibernateSessionFactoryDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(HibernateSessionFactoryDescriptor.class.getName());
    String configurationName;
    Descriptor configurationDescriptor;

    @Override
    public Object construct(WireContext wireContext) {
        Configuration configuration = null;
        configuration = this.configurationName != null ? (Configuration)wireContext.get(this.configurationName) : (this.configurationDescriptor != null ? (Configuration)wireContext.create(this.configurationDescriptor, false) : wireContext.get(Configuration.class));
        if (configuration == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_HSF_1", new Object[0]);
            throw new WireException(message);
        }
        SearchUtil.addSearchConfiguration(configuration);
        DbTool.updateDatabaseSchema(configuration);
        HibernateSessionFactoryDescriptor.addInterceptor(configuration);
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        wireContext.addListener(new SessionFactoryCloser(sessionFactory));
        return sessionFactory;
    }

    private static void addInterceptor(Configuration configuration) {
        String interceptorClassName = configuration.getProperty("bonita.hibernate.interceptor");
        if (interceptorClassName != null) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Adding interceptor: " + interceptorClassName);
            }
            Class<?> interceptorClass = ReflectUtil.loadClass(Thread.currentThread().getContextClassLoader(), interceptorClassName);
            EmptyInterceptor interceptor = (EmptyInterceptor)ReflectUtil.newInstance(interceptorClass);
            configuration.setInterceptor((Interceptor)interceptor);
        }
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        return SessionFactory.class;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setConfigurationDescriptor(Descriptor configurationDescriptor) {
        this.configurationDescriptor = configurationDescriptor;
    }

    public static class SessionFactoryCloser
    implements Listener {
        SessionFactory sessionFactory;

        public SessionFactoryCloser(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        @Override
        public void event(Object source, String eventName, Object info) {
            if ("close".equals(eventName)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("closing hibernate session factory");
                }
                try {
                    this.sessionFactory.close();
                }
                catch (HibernateException e) {
                    if ("could not destruct listeners".equals(e.getMessage())) {
                        LOG.severe("Unable to destruct listener: " + Misc.getStackTraceFrom(e));
                    }
                    throw e;
                }
            }
        }
    }
}

