/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.generator;

import org.ow2.bonita.util.Misc;

public class EnvEntry {
    private boolean enabled = false;
    private final String name;
    private final String description;
    private final String xmlEntry;

    public EnvEntry(String name, String description, String xmlEntry, boolean enabled) {
        Misc.checkArgsNotNull(name, description, xmlEntry, enabled);
        this.name = name;
        this.description = description;
        this.xmlEntry = xmlEntry;
        this.enabled = enabled;
    }

    public String getEnvXml(String indent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(indent).append("<!-- Description: ").append(this.description).append(" -->").append(Misc.LINE_SEPARATOR);
        if (!this.enabled) {
            stringBuilder.append(indent).append("<!--").append(Misc.LINE_SEPARATOR);
        }
        stringBuilder.append(Misc.prefixAllLines(this.getXmlEntry(), indent)).append(Misc.LINE_SEPARATOR);
        if (!this.enabled) {
            stringBuilder.append(indent).append(" -->").append(Misc.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getXmlEntry() {
        return this.xmlEntry;
    }
}

