/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.interceptor;

import org.hibernate.EmptyInterceptor;

public abstract class DescNullFirstInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = -7671847499846010891L;
    static final String ORDER_BY = "order by";

    public String onPrepareStatement(String sql) {
        String query = sql.toLowerCase();
        int orderByIndex = query.indexOf(ORDER_BY);
        if (orderByIndex > -1) {
            int orderByEndIndex = this.getLast(query, this.getKeyWordsAfterOrderBy());
            if (orderByEndIndex == -1) {
                orderByEndIndex = query.length();
            }
            String orderByContent = sql.substring(orderByIndex + 9, orderByEndIndex);
            String[] orderByNames = orderByContent.split("\\,");
            for (int i = 0; i < orderByNames.length; ++i) {
                String current = orderByNames[i];
                String currentTrim = current.trim();
                if (currentTrim.length() <= 0) continue;
                String currentLC = currentTrim.toLowerCase();
                if (currentLC.endsWith(" desc")) {
                    current = current.substring(0, current.length() - 5);
                    orderByNames[i] = this.getDescValue(current);
                    continue;
                }
                if (currentLC.endsWith(" asc")) {
                    current = current.substring(0, current.length() - 4);
                    orderByNames[i] = this.getAscValue(current);
                    continue;
                }
                current = current.substring(0, current.length());
                orderByNames[i] = this.getAscValue(current);
            }
            orderByContent = DescNullFirstInterceptor.join(orderByNames, ",");
            sql = this.formatSelectQuery(sql, orderByIndex, orderByContent, orderByEndIndex);
        }
        return super.onPrepareStatement(sql);
    }

    protected abstract String getDescValue(String var1);

    protected abstract String getAscValue(String var1);

    protected abstract String[] getKeyWordsAfterOrderBy();

    protected int getLast(String query, String ... list) {
        int result = -1;
        int size = list.length;
        for (int i = 0; result == -1 && i < size; ++i) {
            result = this.getLast(query, list[i]);
        }
        return result;
    }

    protected int getLast(String query, String end) {
        return query.indexOf(end);
    }

    protected String formatSelectQuery(String sql, int orderByIndex, String orderByContent, int orderByEndIndex) {
        StringBuilder builder = new StringBuilder(sql.substring(0, orderByIndex));
        builder.append("order by ").append(orderByContent).append(" ").append(sql.substring(orderByEndIndex));
        return builder.toString();
    }

    protected static String join(String[] elements, String join) {
        StringBuilder joinBuilder = new StringBuilder();
        int penultimateIndex = elements.length - 1;
        for (int i = 0; i < penultimateIndex; ++i) {
            joinBuilder.append(elements[i]).append(",");
        }
        joinBuilder.append(elements[penultimateIndex]);
        return joinBuilder.toString();
    }
}

