/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.operation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireException;
import org.ow2.bonita.env.descriptor.ArgDescriptor;
import org.ow2.bonita.env.descriptor.ObjectDescriptor;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Listener;
import org.ow2.bonita.util.ReflectUtil;
import org.ow2.bonita.util.ReflectUtilDescriptor;

public class MethodInvokerListener
implements Listener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(MethodInvokerListener.class.getName());
    String methodName;
    List<ArgDescriptor> argDescriptors = null;
    WireContext wireContext;
    Object target;
    transient Method method = null;

    public MethodInvokerListener(String methodName, List<ArgDescriptor> argDescriptors, WireContext wireContext, Object target) {
        this.methodName = methodName;
        this.argDescriptors = argDescriptors;
        this.wireContext = wireContext;
        this.target = target;
    }

    @Override
    public void event(Object source, String eventName, Object info) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("invoking " + this.methodName + " on " + this.target + " for event " + eventName);
        }
        try {
            Object[] args = ObjectDescriptor.getArgs(this.wireContext, this.argDescriptors);
            Class<?> clazz = this.target.getClass();
            Method method = ReflectUtilDescriptor.findMethod(clazz, this.methodName, this.argDescriptors, args);
            if (method == null) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_MIL_1", ReflectUtilDescriptor.getSignature(this.methodName, this.argDescriptors, args), this.target);
                throw new WireException(message);
            }
            ReflectUtil.invoke(method, this.target, args);
        }
        catch (WireException e) {
            throw e;
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_MIL_2", this.methodName, e.getMessage());
            throw new WireException(message, e);
        }
    }
}

