/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Descriptor;
import org.ow2.bonita.env.WireDefinition;
import org.ow2.bonita.env.descriptor.AbstractDescriptor;
import org.ow2.bonita.env.descriptor.ArgDescriptor;
import org.ow2.bonita.env.xml.BindingParser;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ReflectUtil;
import org.ow2.bonita.util.xml.Bindings;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class WireParser
extends Parser {
    public static final String PVM_WIRE_BINDINGS_RESOURCES = "bonita.wire.bindings.xml";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(WireParser.class.getName());
    public static final String CATEGORY_DESCRIPTOR = "descriptor";
    public static final String CATEGORY_OPERATION = "operation";
    public static final String CATEGORY_INTERCEPTOR = "interceptor";
    private static WireParser instance;
    private static Bindings defaultBindings;

    public WireParser() {
        super(defaultBindings);
    }

    public static synchronized WireParser getInstance() {
        if (instance == null) {
            instance = new WireParser();
        }
        return instance;
    }

    public static WireDefinition parseXmlString(String xmlString) {
        Parse parse = WireParser.getInstance().createParse().setString(xmlString).execute();
        Misc.showProblems(parse.getProblems(), "wire definition xml string");
        return (WireDefinition)parse.getDocumentObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parseDocumentElement(Element documentElement, Parse parse) {
        List<Element> elements = XmlUtil.elements(documentElement);
        WireDefinition wireDefinition = new WireDefinition();
        wireDefinition.setClassLoader(this.classLoader);
        if (elements != null) {
            parse.pushObject(wireDefinition);
            try {
                for (Element descriptorElement : elements) {
                    this.parseElement(descriptorElement, parse, CATEGORY_DESCRIPTOR);
                }
            }
            finally {
                parse.popObject();
            }
        }
        return wireDefinition;
    }

    @Override
    public Object parseElement(Element element, Parse parse, String category) {
        if (element == null) {
            return null;
        }
        Object object = super.parseElement(element, parse, category);
        if (object != null && object instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)object;
            if (descriptor instanceof AbstractDescriptor) {
                AbstractDescriptor abstractDescriptor = (AbstractDescriptor)descriptor;
                if (element.hasAttribute("name")) {
                    String name = element.getAttribute("name");
                    abstractDescriptor.setName(name);
                }
                if (element.hasAttribute("init")) {
                    String initText = element.getAttribute("init");
                    if ("eager".equalsIgnoreCase(initText)) {
                        abstractDescriptor.setInit('E');
                    } else if ("immediate".equalsIgnoreCase(initText)) {
                        abstractDescriptor.setInit('I');
                    } else if ("required".equalsIgnoreCase(initText)) {
                        abstractDescriptor.setInit('R');
                    } else {
                        abstractDescriptor.setInit('L');
                    }
                }
            }
            WireDefinition wireDefinition = parse.findObject(WireDefinition.class);
            wireDefinition.addDescriptor(descriptor);
        }
        return object;
    }

    public List<ArgDescriptor> parseArgs(List<Element> argElements, Parse parse) {
        ArrayList<ArgDescriptor> args = null;
        if (argElements != null) {
            if (argElements.size() > 0) {
                args = new ArrayList<ArgDescriptor>(argElements.size());
            }
            for (Element argElement : argElements) {
                ArgDescriptor argDescriptor = new ArgDescriptor();
                argDescriptor.setTypeName(XmlUtil.attribute(argElement, "type"));
                Element descriptorElement = XmlUtil.element(argElement);
                if (descriptorElement == null) {
                    parse.addProblem("arg must contain exactly one descriptor element out of " + this.bindings.getTagNames(CATEGORY_DESCRIPTOR) + " as contents:" + XmlUtil.toString((Element)argElement.getParentNode()));
                } else {
                    Descriptor descriptor = (Descriptor)this.parseElement(descriptorElement, parse, CATEGORY_DESCRIPTOR);
                    argDescriptor.setDescriptor(descriptor);
                }
                args.add(argDescriptor);
            }
        }
        return args;
    }

    static {
        defaultBindings = new Bindings();
        BindingParser bindingParser = new BindingParser();
        Enumeration<URL> enumeration = ReflectUtil.getResources(null, PVM_WIRE_BINDINGS_RESOURCES);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("parsing bindings from resource url: " + url);
                }
                Parse parse = bindingParser.createParse().setUrl(url).pushObject(defaultBindings).execute();
                Misc.showProblems(parse.getProblems(), "default wire bindings");
            }
        }
    }
}

