/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ow2.bonita.facade.def.ConnectorParameters;
import org.ow2.bonita.facade.def.element.ConnectorDefinition;
import org.ow2.bonita.facade.def.element.impl.ConnectorDefinitionImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.VariableUtil;

public class InternalConnectorDefinition
extends ConnectorDefinitionImpl {
    protected long dbid;
    private static final long serialVersionUID = 1L;
    protected Map<String, ConnectorParameters> variableParameters;

    protected InternalConnectorDefinition() {
    }

    public InternalConnectorDefinition(ConnectorDefinition src, ProcessDefinitionUUID processUUID) {
        super(src);
        for (Map.Entry<String, Object[]> entries : src.getParameters().entrySet()) {
            String key = entries.getKey();
            Object[] parameters = entries.getValue();
            ArrayList<Variable> variables = new ArrayList<Variable>();
            for (Object parameter : parameters) {
                variables.add(VariableUtil.createVariable(processUUID, key, parameter));
            }
            this.addParameter(key, new ConnectorParameters(key, variables));
        }
        this.clientParameters = null;
    }

    private void addParameter(String key, ConnectorParameters value) {
        if (this.variableParameters == null) {
            this.variableParameters = new HashMap<String, ConnectorParameters>();
        }
        this.variableParameters.put(key, value);
    }

    private Map<String, Object[]> getVariableParameters() {
        if (this.variableParameters == null) {
            return null;
        }
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        for (Map.Entry<String, ConnectorParameters> entry : this.variableParameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getVariableValues());
        }
        return result;
    }

    @Override
    public Map<String, Object[]> getParameters() {
        if (this.getVariableParameters() != null) {
            return this.getVariableParameters();
        }
        return Collections.emptyMap();
    }

    public long getDbid() {
        return this.dbid;
    }
}

