/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def.element.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ow2.bonita.facade.def.element.ConnectorDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.def.element.impl.ConnectorDefinitionImpl;

public class IncomingEventDefinitionImpl
implements IncomingEventDefinition {
    private static final long serialVersionUID = -2771436497707685655L;
    protected long dbid;
    protected String name;
    protected List<ConnectorDefinition> connectors;
    protected String expression;

    public IncomingEventDefinitionImpl() {
    }

    public IncomingEventDefinitionImpl(String name, String expression) {
        this.name = name;
        this.expression = expression;
    }

    public IncomingEventDefinitionImpl(IncomingEventDefinition src) {
        this.name = src.getName();
        List<ConnectorDefinition> srcConnectors = src.getConnectors();
        if (srcConnectors != null) {
            this.connectors = new ArrayList<ConnectorDefinition>();
            for (ConnectorDefinition connector : srcConnectors) {
                this.connectors.add(new ConnectorDefinitionImpl(connector));
            }
        }
        this.expression = src.getExpression();
    }

    @Override
    public List<ConnectorDefinition> getConnectors() {
        if (this.connectors == null) {
            return Collections.emptyList();
        }
        return this.connectors;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public void addConnector(HookDefinition connector) {
        if (this.connectors == null) {
            this.connectors = new ArrayList<ConnectorDefinition>();
        }
        this.connectors.add(connector);
    }
}

