/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def.majorElement.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessElementImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.DataFieldDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;

public class DataFieldDefinitionImpl
extends ProcessElementImpl
implements DataFieldDefinition {
    private static final long serialVersionUID = 3520847216843051032L;
    protected DataFieldDefinitionUUID uuid;
    protected String dataTypeClassName;
    protected String scriptingValue;
    protected String enumerationValues;
    protected Serializable clientInitialValue;
    private boolean isTransient;

    protected DataFieldDefinitionImpl() {
    }

    public DataFieldDefinitionImpl(ProcessDefinitionUUID processUUID, String name, String dataTypeClassName) {
        super(name, processUUID);
        this.uuid = new DataFieldDefinitionUUID(processUUID, name);
        this.dataTypeClassName = dataTypeClassName;
        this.isTransient = false;
    }

    public DataFieldDefinitionImpl(ProcessDefinitionUUID processUUID, ActivityDefinitionUUID activityUUID, String name, String dataTypeClassName) {
        super(name, processUUID);
        this.uuid = new DataFieldDefinitionUUID(activityUUID, name);
        this.dataTypeClassName = dataTypeClassName;
        this.isTransient = false;
    }

    public DataFieldDefinitionImpl(DataFieldDefinition src) {
        super(src);
        this.uuid = new DataFieldDefinitionUUID(src.getUUID());
        this.dataTypeClassName = src.getDataTypeClassName();
        DataFieldDefinitionImpl srcImpl = (DataFieldDefinitionImpl)src;
        this.enumerationValues = srcImpl.enumerationValues;
        this.clientInitialValue = src.getInitialValue();
        this.scriptingValue = src.getScriptingValue();
        this.isTransient = src.isTransient();
    }

    @Override
    public String getDataTypeClassName() {
        return this.dataTypeClassName;
    }

    @Override
    public Serializable getInitialValue() {
        return this.getClientInitialValue();
    }

    @Override
    public DataFieldDefinitionUUID getUUID() {
        return this.uuid;
    }

    @Override
    public Set<String> getEnumerationValues() {
        if (this.enumerationValues == null) {
            return Collections.emptySet();
        }
        String[] values = this.enumerationValues.split(",");
        HashSet<String> result = new HashSet<String>();
        for (String s : values) {
            result.add(s);
        }
        return result;
    }

    public void setEnumerationValues(Set<String> enumerationValues) {
        if (enumerationValues != null) {
            this.enumerationValues = "";
            Iterator<String> it = enumerationValues.iterator();
            while (it.hasNext()) {
                this.enumerationValues = this.enumerationValues + it.next();
                if (!it.hasNext()) continue;
                this.enumerationValues = this.enumerationValues + ",";
            }
        }
    }

    public void setInitialValue(Serializable initialValue) {
        this.clientInitialValue = initialValue;
    }

    @Override
    public boolean isEnumeration() {
        return this.dataTypeClassName.equals(String.class.getName()) && this.enumerationValues != null;
    }

    private Serializable getClientInitialValue() {
        return this.clientInitialValue;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        DataFieldDefinitionImpl other = (DataFieldDefinitionImpl)o;
        return other.getUUID().equals(this.getUUID());
    }

    public void setScriptingValue(String scriptingValue) {
        this.scriptingValue = scriptingValue;
    }

    @Override
    public String getScriptingValue() {
        return this.scriptingValue;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }
}

