/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.ExceptionManager;

public class ActivityNotFoundException
extends BonitaException {
    private static final long serialVersionUID = -7298375846514108890L;
    private ProcessInstanceUUID instanceUUID;
    private String activityId;
    private ProcessDefinitionUUID processUUID;
    private ActivityInstanceUUID activityUUID;
    private String iterationId;

    public ActivityNotFoundException(String id, ProcessInstanceUUID instanceUUID, String activityId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("ANFE1", activityId, instanceUUID));
        this.instanceUUID = instanceUUID;
        this.activityId = activityId;
        this.iterationId = null;
        this.processUUID = null;
    }

    public ActivityNotFoundException(String id, ProcessInstanceUUID instanceUUID, String activityId, String iterationId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("ANFE2", activityId, instanceUUID, iterationId));
        this.instanceUUID = instanceUUID;
        this.activityId = activityId;
        this.iterationId = iterationId;
        this.processUUID = null;
    }

    public ActivityNotFoundException(String id, ProcessDefinitionUUID processId, String activityId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("ANFE3", activityId, processId));
        this.processUUID = processId;
        this.activityId = activityId;
        this.iterationId = null;
        this.instanceUUID = null;
    }

    public ActivityNotFoundException(String id, ActivityInstanceUUID activityUUID) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("ANFE4", activityUUID));
        this.activityUUID = activityUUID;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getIterationId() {
        return this.iterationId;
    }

    public ProcessInstanceUUID getInstanceUUID() {
        return this.instanceUUID;
    }

    public ProcessDefinitionUUID getProcessUUID() {
        return this.processUUID;
    }

    public ActivityInstanceUUID getActivityUUID() {
        return this.activityUUID;
    }
}

