/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.ExceptionManager;

public class InstanceNotFoundException
extends BonitaException {
    private static final long serialVersionUID = -925582175189740596L;
    private final ProcessInstanceUUID instanceUUID;

    public InstanceNotFoundException(String id, ProcessInstanceUUID instanceUUID) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("INFE1", instanceUUID));
        this.instanceUUID = instanceUUID;
    }

    public InstanceNotFoundException(InstanceNotFoundException e) {
        super(e.getMessage());
        this.instanceUUID = e.getInstanceUUID();
    }

    public static InstanceNotFoundException build(String id, Throwable e) {
        if (!(e instanceof InstanceNotFoundException)) {
            ExceptionManager manager = ExceptionManager.getInstance();
            String message = manager.getIdMessage(id) + manager.getMessage("INFE2", new Object[0]);
            throw new BonitaInternalException(message, e);
        }
        return new InstanceNotFoundException((InstanceNotFoundException)e);
    }

    public ProcessInstanceUUID getInstanceUUID() {
        return this.instanceUUID;
    }
}

