/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.RuleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RuleNotFoundException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableProcessException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.internal.AbstractRemoteManagementAPI;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.AbstractUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.PasswordOwner;
import org.ow2.bonita.identity.auth.RESTUserOwner;
import org.ow2.bonita.identity.auth.UserOwner;

public class AbstractRemoteManagementAPIImpl
implements AbstractRemoteManagementAPI {
    private static final long serialVersionUID = 7816343722790053864L;
    protected Map<String, ManagementAPI> apis = new HashMap<String, ManagementAPI>();

    protected ManagementAPI getAPI(Map<String, String> options) {
        String queryList = options.get("queryList");
        String user = options.get("user");
        String domain = options.get("domain");
        String restUser = options.get("restUser");
        UserOwner.setUser(user);
        DomainOwner.setDomain(domain);
        if (restUser != null) {
            RESTUserOwner.setUser(restUser);
            String restPswd = options.get("passwordHash");
            PasswordOwner.setPassword(restPswd);
        }
        if (!this.apis.containsKey(queryList)) {
            this.apis.put(queryList, new StandardAPIAccessorImpl().getManagementAPI(queryList));
        }
        return this.apis.get(queryList);
    }

    @Override
    public ProcessDefinition deploy(BusinessArchive businessArchive, Map<String, String> options) throws DeploymentException {
        return this.getAPI(options).deploy(businessArchive);
    }

    @Override
    public void deployJar(String jarName, byte[] jar, Map<String, String> options) throws DeploymentException {
        this.getAPI(options).deployJar(jarName, jar);
    }

    @Override
    public Set<String> getAvailableJars(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAvailableJars();
    }

    @Override
    public void removeJar(String jarName, Map<String, String> options) throws DeploymentException {
        this.getAPI(options).removeJar(jarName);
    }

    @Override
    public void deleteProcess(ProcessDefinitionUUID processUUID, Map<String, String> options) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException {
        this.getAPI(options).deleteProcess(processUUID);
    }

    @Override
    public void deleteAllProcesses(Map<String, String> options) throws UndeletableInstanceException, RemoteException, UndeletableProcessException {
        this.getAPI(options).deleteAllProcesses();
    }

    @Override
    public String getLoggedUser(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLoggedUser();
    }

    @Override
    public void addMetaData(String key, String value, Map<String, String> options) throws RemoteException {
        this.getAPI(options).addMetaData(key, value);
    }

    @Override
    public void deleteMetaData(String key, Map<String, String> options) throws RemoteException {
        this.getAPI(options).deleteMetaData(key);
    }

    @Override
    public String getMetaData(String key, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getMetaData(key);
    }

    @Override
    public void archive(ProcessDefinitionUUID processUUID, Map<String, String> options) throws DeploymentException {
        this.getAPI(options).archive(processUUID);
    }

    @Override
    public void disable(ProcessDefinitionUUID processUUID, Map<String, String> options) throws DeploymentException {
        this.getAPI(options).disable(processUUID);
    }

    @Override
    public void enable(ProcessDefinitionUUID processUUID, Map<String, String> options) throws DeploymentException {
        this.getAPI(options).enable(processUUID);
    }

    @Override
    public Boolean isUserAdmin(String username, Map<String, String> options) throws UserNotFoundException, RemoteException {
        return this.getAPI(options).isUserAdmin(username);
    }

    @Override
    public Boolean checkUserCredentials(String username, String password, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).checkUserCredentials(username, password);
    }

    @Override
    public Boolean checkUserCredentialsWithPasswordHash(String username, String passwordHash, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).checkUserCredentialsWithPasswordHash(username, passwordHash);
    }

    @Override
    public Rule createRule(String name, String label, String description, Rule.RuleType type, Map<String, String> options) throws RemoteException, RuleAlreadyExistsException {
        return this.getAPI(options).createRule(name, label, description, type);
    }

    @Override
    public List<Rule> getRules(Rule.RuleType ruleType, int fromIndex, int pageSige, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getRules(ruleType, fromIndex, pageSige);
    }

    @Override
    public long getNumberOfRules(Rule.RuleType ruleType, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfRules(ruleType);
    }

    @Override
    public PrivilegePolicy getRuleTypePolicy(Rule.RuleType ruleType, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getRuleTypePolicy(ruleType);
    }

    @Override
    public void setRuleTypePolicy(Rule.RuleType ruleType, PrivilegePolicy newPolicy, Map<String, String> options) throws RemoteException {
        this.getAPI(options).setRuleTypePolicy(ruleType, newPolicy);
    }

    public <E extends AbstractUUID> void addExceptionsToRuleByUUID(String ruleUUID, Set<E> exceptions, Map<String, String> options) throws RuleNotFoundException, RemoteException {
        this.getAPI(options).addExceptionsToRuleByUUID(ruleUUID, exceptions);
    }

    @Override
    public void deleteRuleByUUID(String ruleUUID, Map<String, String> options) throws RuleNotFoundException, RemoteException {
        this.getAPI(options).deleteRuleByUUID(ruleUUID);
    }

    @Override
    public List<Rule> getAllRules(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAllRules();
    }

    @Override
    public Rule getRuleByUUID(String ruleUUID, Map<String, String> options) throws RuleNotFoundException, RemoteException {
        return this.getAPI(options).getRuleByUUID(ruleUUID);
    }

    public <E extends AbstractUUID> void removeExceptionsFromRuleByUUID(String ruleUUID, Set<E> exceptions, Map<String, String> options) throws RuleNotFoundException, RemoteException {
        this.getAPI(options).removeExceptionsFromRuleByUUID(ruleUUID, exceptions);
    }

    @Override
    public Rule updateRuleByUUID(String ruleUUID, String name, String label, String description, Map<String, String> options) throws RuleNotFoundException, RuleAlreadyExistsException, RemoteException {
        return this.getAPI(options).updateRuleByUUID(ruleUUID, name, label, description);
    }

    @Override
    public void updateMigrationDate(ProcessDefinitionUUID processUUID, Date migrationDate, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        this.getAPI(options).updateMigrationDate(processUUID, migrationDate);
    }

    @Override
    public void setResource(ProcessDefinitionUUID processUUID, String resourcePath, byte[] content, Map<String, String> options) throws ProcessNotFoundException {
        this.getAPI(options).setResource(processUUID, resourcePath, content);
    }
}

