/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.EventNotFoundException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.TaskNotFoundException;
import org.ow2.bonita.facade.exception.VariableNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.internal.AbstractRemoteQueryRuntimeAPI;
import org.ow2.bonita.facade.paging.ActivityInstanceCriterion;
import org.ow2.bonita.facade.paging.ProcessInstanceCriterion;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.CatchingEvent;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.Document;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.CatchingEventUUID;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.PasswordOwner;
import org.ow2.bonita.identity.auth.RESTUserOwner;
import org.ow2.bonita.identity.auth.UserOwner;
import org.ow2.bonita.light.LightActivityInstance;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.light.LightTaskInstance;
import org.ow2.bonita.search.DocumentResult;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.search.SearchQueryBuilder;

public abstract class AbstractRemoteQueryRuntimeAPIImpl
implements AbstractRemoteQueryRuntimeAPI {
    protected Map<String, QueryRuntimeAPI> apis = new HashMap<String, QueryRuntimeAPI>();

    protected QueryRuntimeAPI getAPI(Map<String, String> options) {
        String queryList = options.get("queryList");
        String user = options.get("user");
        String domain = options.get("domain");
        UserOwner.setUser(user);
        DomainOwner.setDomain(domain);
        String restUser = options.get("restUser");
        if (restUser != null) {
            RESTUserOwner.setUser(restUser);
            String restPswd = options.get("passwordHash");
            PasswordOwner.setPassword(restPswd);
        }
        if (!this.apis.containsKey(queryList)) {
            this.putAPI(queryList);
        }
        return this.apis.get(queryList);
    }

    protected void putAPI(String queryList) {
        this.apis.put(queryList, new StandardAPIAccessorImpl().getQueryRuntimeAPI(queryList));
    }

    @Override
    public Set<String> getTaskCandidates(ActivityInstanceUUID taskUUID, Map<String, String> options) throws RemoteException, TaskNotFoundException {
        return this.getAPI(options).getTaskCandidates(taskUUID);
    }

    @Override
    public Map<ActivityInstanceUUID, Set<String>> getTaskCandidates(Set<ActivityInstanceUUID> taskUUIDs, Map<String, String> options) throws RemoteException, TaskNotFoundException {
        return this.getAPI(options).getTaskCandidates(taskUUIDs);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstances(int fromIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstances(fromIndex, pageSize);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstances(int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstances(fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstances(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstances(processUUIDs, fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesExcept(Set<ProcessDefinitionUUID> exceptions, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesExcept(exceptions, fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public int getNumberOfParentProcessInstances(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstances();
    }

    @Override
    public int getNumberOfProcessInstances(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfProcessInstances();
    }

    @Override
    public List<LightActivityInstance> getLightActivityInstancesFromRoot(ProcessInstanceUUID rootInstanceUUID, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightActivityInstancesFromRoot(rootInstanceUUID);
    }

    @Override
    public Map<ProcessInstanceUUID, List<LightActivityInstance>> getLightActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightActivityInstancesFromRoot(rootInstanceUUIDs);
    }

    @Override
    public List<LightTaskInstance> getLightTaskInstancesFromRoot(ProcessInstanceUUID rootInstanceUUID, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightTaskInstancesFromRoot(rootInstanceUUID);
    }

    @Override
    public Map<ProcessInstanceUUID, List<LightTaskInstance>> getLightTaskInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightTaskInstancesFromRoot(rootInstanceUUIDs);
    }

    @Override
    public ActivityInstanceUUID getOneTask(ProcessDefinitionUUID processUUID, ActivityState taskState, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getOneTask(processUUID, taskState);
    }

    @Override
    public ActivityInstanceUUID getOneTask(ProcessInstanceUUID instanceUUID, ActivityState taskState, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getOneTask(instanceUUID, taskState);
    }

    @Override
    public ActivityInstanceUUID getOneTask(ActivityState taskState, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getOneTask(taskState);
    }

    @Override
    public Set<ActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getActivityInstances(instanceUUID);
    }

    @Override
    public Set<ActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityId, Map<String, String> options) throws InstanceNotFoundException, ActivityNotFoundException, RemoteException {
        return this.getAPI(options).getActivityInstances(instanceUUID, activityId);
    }

    @Override
    public ActivityInstance getActivityInstance(ActivityInstanceUUID activityUUID, Map<String, String> options) throws ActivityNotFoundException, RemoteException {
        return this.getAPI(options).getActivityInstance(activityUUID);
    }

    @Override
    public ProcessInstance getProcessInstance(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getProcessInstance(instanceUUID);
    }

    @Override
    public Set<ProcessInstance> getProcessInstances(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProcessInstances();
    }

    @Override
    public Boolean canExecuteTask(ActivityInstanceUUID taskUUID, Map<String, String> options) throws TaskNotFoundException, RemoteException {
        return this.getAPI(options).canExecuteTask(taskUUID);
    }

    @Override
    public Set<ProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcessInstances(processUUID);
    }

    @Override
    public TaskInstance getTask(ActivityInstanceUUID taskUUID, Map<String, String> options) throws TaskNotFoundException, RemoteException {
        return this.getAPI(options).getTask(taskUUID);
    }

    @Override
    public Collection<TaskInstance> getTaskList(ProcessInstanceUUID instanceUUID, ActivityState taskState, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getTaskList(instanceUUID, taskState);
    }

    @Override
    public Collection<TaskInstance> getTaskList(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getTaskList(instanceUUID, userId, taskState);
    }

    @Override
    public Collection<TaskInstance> getTaskList(ActivityState taskState, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskList(taskState);
    }

    @Override
    public Collection<TaskInstance> getTaskList(String userId, ActivityState taskState, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskList(userId, taskState);
    }

    @Override
    public Set<TaskInstance> getTasks(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getTasks(instanceUUID);
    }

    @Override
    public Object getActivityInstanceVariable(ActivityInstanceUUID activityUUID, String variableId, Map<String, String> options) throws ActivityNotFoundException, VariableNotFoundException, RemoteException {
        return this.getAPI(options).getActivityInstanceVariable(activityUUID, variableId);
    }

    @Override
    public ActivityState getActivityInstanceState(ActivityInstanceUUID activityUUID, Map<String, String> options) throws ActivityNotFoundException, RemoteException {
        return this.getAPI(options).getActivityInstanceState(activityUUID);
    }

    @Override
    public Object getProcessInstanceVariable(ProcessInstanceUUID instanceUUID, String variableId, Map<String, String> options) throws InstanceNotFoundException, VariableNotFoundException, RemoteException {
        return this.getAPI(options).getProcessInstanceVariable(instanceUUID, variableId);
    }

    @Override
    public Map<String, Object> getActivityInstanceVariables(ActivityInstanceUUID activityUUID, Map<String, String> options) throws ActivityNotFoundException, RemoteException {
        return this.getAPI(options).getActivityInstanceVariables(activityUUID);
    }

    @Override
    public Map<String, Object> getProcessInstanceVariables(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getProcessInstanceVariables(instanceUUID);
    }

    @Override
    public Map<String, Object> getProcessInstanceVariables(ProcessInstanceUUID instanceUUID, Date maxDate, Map<String, String> options) throws RemoteException, InstanceNotFoundException {
        return this.getAPI(options).getProcessInstanceVariables(instanceUUID, maxDate);
    }

    @Override
    public Object getVariable(ActivityInstanceUUID activityUUID, String variableId, Map<String, String> options) throws ActivityNotFoundException, VariableNotFoundException, RemoteException {
        return this.getAPI(options).getVariable(activityUUID, variableId);
    }

    @Override
    public Map<String, Object> getVariables(ActivityInstanceUUID activityUUID, Map<String, String> options) throws InstanceNotFoundException, ActivityNotFoundException, RemoteException {
        return this.getAPI(options).getVariables(activityUUID);
    }

    @Override
    public List<Comment> getCommentFeed(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getCommentFeed(instanceUUID);
    }

    @Override
    public Set<ProcessInstance> getUserInstances(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getUserInstances();
    }

    @Override
    @Deprecated
    public Set<String> getAttachmentNames(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAttachmentNames(instanceUUID);
    }

    @Override
    @Deprecated
    public List<AttachmentInstance> getAttachments(ProcessInstanceUUID instanceUUID, String attachmentName, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAttachments(instanceUUID, attachmentName);
    }

    @Override
    @Deprecated
    public AttachmentInstance getLastAttachment(ProcessInstanceUUID instanceUUID, String attachmentName, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLastAttachment(instanceUUID, attachmentName);
    }

    @Override
    @Deprecated
    public Collection<AttachmentInstance> getLastAttachments(ProcessInstanceUUID instanceUUID, Set<String> attachmentNames, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLastAttachments(instanceUUID, attachmentNames);
    }

    @Override
    @Deprecated
    public AttachmentInstance getLastAttachment(ProcessInstanceUUID instanceUUID, String attachmentName, ActivityInstanceUUID activityUUID, Map<String, String> options) throws ActivityNotFoundException, RemoteException {
        return this.getAPI(options).getLastAttachment(instanceUUID, attachmentName, activityUUID);
    }

    @Override
    @Deprecated
    public AttachmentInstance getLastAttachment(ProcessInstanceUUID instanceUUID, String attachmentName, Date date, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLastAttachment(instanceUUID, attachmentName, date);
    }

    @Override
    @Deprecated
    public Collection<AttachmentInstance> getLastAttachments(ProcessInstanceUUID instanceUUID, String regex, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLastAttachments(instanceUUID, regex);
    }

    @Override
    @Deprecated
    public byte[] getAttachmentValue(AttachmentInstance attachmentInstance, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAttachmentValue(attachmentInstance);
    }

    @Override
    public Set<LightProcessInstance> getLightUserInstances(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightUserInstances();
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstances(int startingIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentUserInstances(startingIndex, pageSize);
    }

    @Override
    public LightProcessInstance getLightProcessInstance(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getLightProcessInstance(instanceUUID);
    }

    @Override
    public Set<LightProcessInstance> getLightProcessInstances(ProcessDefinitionUUID processUUID, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightProcessInstances(processUUID);
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(Set<ProcessInstanceUUID> instanceUUIDs, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightProcessInstances(instanceUUIDs, fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public Set<LightProcessInstance> getLightWeightProcessInstances(Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightWeightProcessInstances(processUUIDs);
    }

    @Override
    public Set<LightProcessInstance> getLightProcessInstances(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightProcessInstances();
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(int fromIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightProcessInstances(fromIndex, pageSize);
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstances(int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentUserInstances(fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightProcessInstances(fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUser(String userId, int fromIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUser(userId, fromIndex, pageSize);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUser(String userId, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUser(userId, fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, int fromIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, remainingDays, fromIndex, pageSize);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, remainingDays, fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasks(String userId, int fromIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithOverdueTasks(userId, fromIndex, pageSize);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasks(String userId, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithOverdueTasks(userId, fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public Set<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getLightActivityInstances(instanceUUID);
    }

    @Override
    public Set<LightTaskInstance> getLightTasks(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getLightTasks(instanceUUID);
    }

    @Override
    public Set<LightTaskInstance> getLightTasks(ProcessInstanceUUID instanceUUID, Set<String> taskNames, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightTasks(instanceUUID, taskNames);
    }

    @Override
    public List<Comment> getActivityInstanceCommentFeed(ActivityInstanceUUID activityUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getActivityInstanceCommentFeed(activityUUID);
    }

    @Override
    public List<Comment> getProcessInstanceCommentFeed(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getProcessInstanceCommentFeed(instanceUUID);
    }

    @Override
    public int getNumberOfActivityInstanceComments(ActivityInstanceUUID activityUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getNumberOfActivityInstanceComments(activityUUID);
    }

    @Override
    public Map<ActivityInstanceUUID, Integer> getNumberOfActivityInstanceComments(Set<ActivityInstanceUUID> activityUUIDs, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getNumberOfActivityInstanceComments(activityUUIDs);
    }

    @Override
    public int getNumberOfComments(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getNumberOfComments(instanceUUID);
    }

    @Override
    public int getNumberOfProcessInstanceComments(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getNumberOfProcessInstanceComments(instanceUUID);
    }

    @Override
    public LightTaskInstance getLightTaskInstance(ActivityInstanceUUID taskUUID, Map<String, String> options) throws TaskNotFoundException, RemoteException {
        return this.getAPI(options).getLightTaskInstance(taskUUID);
    }

    @Override
    public Set<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID, String activityName, Map<String, String> options) throws InstanceNotFoundException, ActivityNotFoundException, RemoteException {
        return this.getAPI(options).getLightActivityInstances(instanceUUID, activityName);
    }

    @Override
    public Set<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID, String activityName, String iterationId, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightActivityInstances(instanceUUID, activityName, iterationId);
    }

    @Override
    public LightActivityInstance getLightActivityInstance(ActivityInstanceUUID activityInstanceUUID, Map<String, String> options) throws ActivityNotFoundException, RemoteException {
        return this.getAPI(options).getLightActivityInstance(activityInstanceUUID);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ActivityState taskState, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightTaskList(taskState);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ProcessInstanceUUID instanceUUID, ActivityState taskState, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getLightTaskList(instanceUUID, taskState);
    }

    public Collection<LightTaskInstance> getLightTaskList(ProcessInstanceUUID instanceUUID, Collection<ActivityState> taskStates, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getLightTaskList(instanceUUID, taskStates);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getLightTaskList(instanceUUID, userId, taskState);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(String userId, ActivityState taskState, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightTaskList(userId, taskState);
    }

    @Override
    public Map<ProcessInstanceUUID, List<LightActivityInstance>> getLightActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, ActivityState state, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightActivityInstancesFromRoot(rootInstanceUUIDs, state);
    }

    @Override
    public Map<ProcessInstanceUUID, LightActivityInstance> getLightLastUpdatedActivityInstanceFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, boolean considerSystemTaks, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightLastUpdatedActivityInstanceFromRoot(rootInstanceUUIDs, considerSystemTaks);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUser(String userId, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithActiveUser(userId);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, remainingDays);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithOverdueTasks(String userId, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithOverdueTasks(userId);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUser(String userId, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithInvolvedUser(userId);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithStartedBy(String userId, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithStartedBy(userId);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUserAndCategory(String userId, String category, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithInvolvedUserAndCategory(userId, category);
    }

    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUser(String userId, Set<ProcessDefinitionUUID> processes, int fromIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize);
    }

    @Override
    public <T> List<T> search(SearchQueryBuilder query, int firstResult, int maxResults, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).search(query, firstResult, maxResults);
    }

    @Override
    public int search(SearchQueryBuilder query, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).search(query);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUser(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUser(userId, fromIndex, pageSize, processes);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUser(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUser(username, fromIndex, pageSize, processUUIDs, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, remainingDays, fromIndex, pageSize, processes);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String username, int remainingDays, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(username, remainingDays, fromIndex, pageSize, processUUIDs, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateExcept(String userId, int remainingDays, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateExcept(userId, remainingDays, fromIndex, pageSize, processes);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateExcept(String username, int remainingDays, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateExcept(username, remainingDays, fromIndex, pageSize, processUUIDs, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserExcept(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUserExcept(userId, fromIndex, pageSize, processes);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserExcept(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithActiveUserExcept(userId, fromIndex, pageSize, processUUIDs, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize, processUUIDs);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize, processUUIDs, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUserExcept(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithInvolvedUserExcept(userId, fromIndex, pageSize, processes);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUserExcept(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithInvolvedUserExcept(username, fromIndex, pageSize, processUUIDs, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasks(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithOverdueTasks(userId, fromIndex, pageSize, processes);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasks(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithOverdueTasks(username, fromIndex, pageSize, processUUIDs, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasksExcept(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithOverdueTasksExcept(userId, fromIndex, pageSize, processes);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasksExcept(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentProcessInstancesWithOverdueTasksExcept(username, fromIndex, pageSize, processUUIDs, pagingCriterion);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, remainingDays, processes);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateExcept(String userId, int remainingDays, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateExcept(userId, remainingDays, processes);
    }

    public Integer getNumberOfParentProcessInstancesWithActiveUserAndProcessUUIDs(String userId, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithActiveUser(userId, processes);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserExcept(String userId, Set<ProcessDefinitionUUID> processes, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithActiveUserExcept(userId, processes);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUser(String userId, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithInvolvedUser(userId, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUserAndCategory(String userId, String category, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithInvolvedUserAndCategory(userId, category, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUserAndCategoryExcept(String userId, String category, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithInvolvedUserAndCategoryExcept(userId, category, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUserExcept(String userId, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithInvolvedUserExcept(userId, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithOverdueTasks(String userId, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithOverdueTasks(userId, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithOverdueTasksExcept(String userId, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithOverdueTasksExcept(userId, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithStartedBy(String userId, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithStartedBy(userId, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithStartedByExcept(String userId, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithStartedByExcept(userId, processUUIDs);
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstances(int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentUserInstances(fromIndex, pageSize, processUUIDs);
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstances(int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentUserInstances(fromIndex, pageSize, processUUIDs, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstancesExcept(int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentUserInstancesExcept(fromIndex, pageSize, processUUIDs);
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstancesExcept(int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightParentUserInstancesExcept(fromIndex, pageSize, processUUIDs, pagingCriterion);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUser(String username, Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfParentProcessInstancesWithActiveUser(username, processUUIDs);
    }

    @Override
    public Set<String> getActiveUsersOfProcessInstance(ProcessInstanceUUID uuid, Map<String, String> options) throws RemoteException, InstanceNotFoundException {
        return this.getAPI(options).getActiveUsersOfProcessInstance(uuid);
    }

    @Override
    public Map<ProcessInstanceUUID, Set<String>> getActiveUsersOfProcessInstances(Set<ProcessInstanceUUID> instanceUUIDs, Map<String, String> options) throws RemoteException, InstanceNotFoundException {
        return this.getAPI(options).getActiveUsersOfProcessInstances(instanceUUIDs);
    }

    @Override
    public List<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID, int fromIdex, int pageSize, ActivityInstanceCriterion pagingCriterion, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        return this.getAPI(options).getLightActivityInstances(instanceUUID, fromIdex, pageSize, pagingCriterion);
    }

    @Override
    public CatchingEvent getEvent(CatchingEventUUID eventUUID, Map<String, String> options) throws RemoteException, EventNotFoundException {
        return this.getAPI(options).getEvent(eventUUID);
    }

    @Override
    public Set<CatchingEvent> getEvents(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getEvents();
    }

    @Override
    public Set<CatchingEvent> getEvents(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getEvents(instanceUUID);
    }

    @Override
    public Set<CatchingEvent> getEvents(ActivityInstanceUUID activityUUID, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getEvents(activityUUID);
    }

    @Override
    public byte[] getDocumentContent(DocumentUUID documentUUID, Map<String, String> options) throws RemoteException, DocumentNotFoundException {
        return this.getAPI(options).getDocumentContent(documentUUID);
    }

    @Override
    public DocumentResult searchDocuments(DocumentSearchBuilder builder, int fromResult, int maxResults, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).searchDocuments(builder, fromResult, maxResults);
    }

    @Override
    public Document getDocument(DocumentUUID documentUUID, Map<String, String> options) throws RemoteException, DocumentNotFoundException {
        return this.getAPI(options).getDocument(documentUUID);
    }

    @Override
    public List<Document> getDocuments(List<DocumentUUID> documentUUIDs, Map<String, String> options) throws RemoteException, DocumentNotFoundException {
        return this.getAPI(options).getDocuments(documentUUIDs);
    }

    @Override
    public List<Document> getDocumentVersions(DocumentUUID documentUUID, Map<String, String> options) throws RemoteException, DocumentNotFoundException {
        return this.getAPI(options).getDocumentVersions(documentUUID);
    }
}

