/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.exception.EventNotFoundException;
import org.ow2.bonita.facade.exception.IllegalTaskStateException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.TaskNotFoundException;
import org.ow2.bonita.facade.exception.UncancellableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.VariableNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.internal.AbstractRemoteRuntimeAPI;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.Document;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.CatchingEventUUID;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.UserOwner;
import org.ow2.bonita.util.GroovyException;

public abstract class AbstractRemoteRuntimeAPIImpl
implements AbstractRemoteRuntimeAPI {
    private static final long serialVersionUID = 4856106680913239049L;
    protected Map<String, RuntimeAPI> apis = new HashMap<String, RuntimeAPI>();

    protected RuntimeAPI getAPI(Map<String, String> options) {
        String queryList = options.get("queryList");
        String user = options.get("user");
        String domain = options.get("domain");
        UserOwner.setUser(user);
        DomainOwner.setDomain(domain);
        if (!this.apis.containsKey(queryList)) {
            this.putAPI(queryList);
        }
        return this.apis.get(queryList);
    }

    protected void putAPI(String queryList) {
        this.apis.put(queryList, new StandardAPIAccessorImpl().getRuntimeAPI(queryList));
    }

    @Override
    public void enableEventsInFailure(ProcessInstanceUUID instanceUUID, String activityName, Map<String, String> options) {
        this.getAPI(options).enableEventsInFailure(instanceUUID, activityName);
    }

    @Override
    public void enableEventsInFailure(ActivityInstanceUUID activityUUID, Map<String, String> options) {
        this.getAPI(options).enableEventsInFailure(activityUUID);
    }

    @Override
    public void enablePermanentEventInFailure(ActivityDefinitionUUID activityUUID, Map<String, String> options) throws RemoteException {
        this.getAPI(options).enablePermanentEventInFailure(activityUUID);
    }

    @Override
    public void startTask(ActivityInstanceUUID taskUUID, boolean assignTask, Map<String, String> options) throws TaskNotFoundException, IllegalTaskStateException {
        this.getAPI(options).startTask(taskUUID, assignTask);
    }

    @Override
    public void finishTask(ActivityInstanceUUID taskUUID, boolean taskAssign, Map<String, String> options) throws TaskNotFoundException, IllegalTaskStateException {
        this.getAPI(options).finishTask(taskUUID, taskAssign);
    }

    @Override
    public void resumeTask(ActivityInstanceUUID taskUUID, boolean taskAssign, Map<String, String> options) throws TaskNotFoundException, IllegalTaskStateException {
        this.getAPI(options).resumeTask(taskUUID, taskAssign);
    }

    @Override
    public void startActivity(ActivityInstanceUUID activityUUID, Map<String, String> options) throws ActivityNotFoundException, RemoteException {
        this.getAPI(options).startActivity(activityUUID);
    }

    @Override
    public void suspendTask(ActivityInstanceUUID taskUUID, boolean assignTask, Map<String, String> options) throws TaskNotFoundException, IllegalTaskStateException {
        this.getAPI(options).suspendTask(taskUUID, assignTask);
    }

    @Override
    public void assignTask(ActivityInstanceUUID taskUUID, Map<String, String> options) throws TaskNotFoundException {
        this.getAPI(options).assignTask(taskUUID);
    }

    @Override
    public void assignTask(ActivityInstanceUUID taskUUID, String actorId, Map<String, String> options) throws TaskNotFoundException {
        this.getAPI(options).assignTask(taskUUID, actorId);
    }

    @Override
    public void assignTask(ActivityInstanceUUID taskUUID, Set<String> candidates, Map<String, String> options) throws TaskNotFoundException {
        this.getAPI(options).assignTask(taskUUID, candidates);
    }

    @Override
    public void unassignTask(ActivityInstanceUUID taskUUID, Map<String, String> options) throws TaskNotFoundException {
        this.getAPI(options).unassignTask(taskUUID);
    }

    @Override
    public void deleteAllProcessInstances(ProcessDefinitionUUID processUUID, Map<String, String> options) throws ProcessNotFoundException, UndeletableInstanceException {
        this.getAPI(options).deleteAllProcessInstances(processUUID);
    }

    @Override
    public void executeTask(ActivityInstanceUUID taskUUID, boolean assignTask, Map<String, String> options) throws TaskNotFoundException, IllegalTaskStateException, RemoteException {
        this.getAPI(options).executeTask(taskUUID, assignTask);
    }

    @Override
    public void deleteProcessInstance(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, UndeletableInstanceException {
        this.getAPI(options).deleteProcessInstance(instanceUUID);
    }

    @Override
    public void cancelProcessInstance(ProcessInstanceUUID instanceUUID, Map<String, String> options) throws InstanceNotFoundException, UncancellableInstanceException {
        this.getAPI(options).cancelProcessInstance(instanceUUID);
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID, Map<String, String> options) throws ProcessNotFoundException {
        return this.getAPI(options).instantiateProcess(processUUID);
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID, ActivityDefinitionUUID activityUUID, Map<String, String> options) throws ProcessNotFoundException {
        return this.getAPI(options).instantiateProcess(processUUID, activityUUID);
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID, Map<String, Object> variables, Map<String, String> options) throws ProcessNotFoundException, VariableNotFoundException {
        return this.getAPI(options).instantiateProcess(processUUID, variables);
    }

    @Override
    public void setProcessInstanceVariable(ProcessInstanceUUID instanceUUID, String variableId, Object variableValue, Map<String, String> options) throws InstanceNotFoundException, VariableNotFoundException {
        this.getAPI(options).setProcessInstanceVariable(instanceUUID, variableId, variableValue);
    }

    @Override
    public void setProcessInstanceVariables(ProcessInstanceUUID instanceUUID, Map<String, Object> variables, Map<String, String> options) throws InstanceNotFoundException, VariableNotFoundException {
        this.getAPI(options).setProcessInstanceVariables(instanceUUID, variables);
    }

    @Override
    public void setActivityInstanceVariable(ActivityInstanceUUID activityUUID, String variableId, Object variableValue, Map<String, String> options) throws ActivityNotFoundException, VariableNotFoundException {
        this.getAPI(options).setActivityInstanceVariable(activityUUID, variableId, variableValue);
    }

    @Override
    public void setActivityInstanceVariables(ActivityInstanceUUID activityUUID, Map<String, Object> variables, Map<String, String> options) throws ActivityNotFoundException, VariableNotFoundException {
        this.getAPI(options).setActivityInstanceVariables(activityUUID, variables);
    }

    @Override
    public void setVariable(ActivityInstanceUUID activityUUID, String variableId, Object variableValue, Map<String, String> options) throws ActivityNotFoundException, VariableNotFoundException {
        this.getAPI(options).setVariable(activityUUID, variableId, variableValue);
    }

    @Override
    @Deprecated
    public void addComment(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID, String message, String userId, Map<String, String> options) throws InstanceNotFoundException, ActivityNotFoundException {
        this.getAPI(options).addComment(instanceUUID, activityUUID, message, userId);
    }

    @Override
    public void addComment(ProcessInstanceUUID instanceUUID, String message, String userId, Map<String, String> options) throws InstanceNotFoundException, RemoteException {
        this.getAPI(options).addComment(instanceUUID, message, userId);
    }

    @Override
    public void addComment(ActivityInstanceUUID activityUUID, String message, String userId, Map<String, String> options) throws ActivityNotFoundException, InstanceNotFoundException, RemoteException {
        this.getAPI(options).addComment(activityUUID, message, userId);
    }

    @Override
    public void addProcessMetaData(ProcessDefinitionUUID uuid, String key, String value, Map<String, String> options) throws ProcessNotFoundException {
        this.getAPI(options).addProcessMetaData(uuid, key, value);
    }

    @Override
    public void deleteProcessMetaData(ProcessDefinitionUUID uuid, String key, Map<String, String> options) throws ProcessNotFoundException {
        this.getAPI(options).deleteProcessMetaData(uuid, key);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessInstanceUUID instanceUUID, boolean propagate, Map<String, String> options) throws InstanceNotFoundException, GroovyException {
        return this.getAPI(options).evaluateGroovyExpression(expression, instanceUUID, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessInstanceUUID processInstanceUUID, Map<String, Object> context, boolean propagate, Map<String, String> options) throws InstanceNotFoundException, GroovyException, RemoteException {
        return this.getAPI(options).evaluateGroovyExpression(expression, processInstanceUUID, context, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ActivityInstanceUUID activityUUID, boolean useActivityScope, boolean propagate, Map<String, String> options) throws InstanceNotFoundException, ActivityNotFoundException, GroovyException {
        return this.getAPI(options).evaluateGroovyExpression(expression, activityUUID, useActivityScope, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ActivityInstanceUUID activityInstanceUUID, Map<String, Object> context, boolean useActivityScope, boolean propagate, Map<String, String> options) throws InstanceNotFoundException, ActivityNotFoundException, GroovyException, RemoteException {
        return this.getAPI(options).evaluateGroovyExpression(expression, activityInstanceUUID, context, useActivityScope, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessDefinitionUUID processDefinitionUUID, Map<String, String> options) throws ProcessNotFoundException, GroovyException, RemoteException {
        return this.getAPI(options).evaluateGroovyExpression(expression, processDefinitionUUID);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> context, Map<String, String> options) throws ProcessNotFoundException, GroovyException, RemoteException {
        return this.getAPI(options).evaluateGroovyExpression(expression, processDefinitionUUID, context);
    }

    @Override
    public Map<String, Object> evaluateGroovyExpressions(Map<String, String> expressions, ActivityInstanceUUID activityUUID, Map<String, Object> context, boolean useActivityScope, boolean propagate, Map<String, String> options) throws InstanceNotFoundException, ActivityNotFoundException, GroovyException {
        return this.getAPI(options).evaluateGroovyExpressions(expressions, activityUUID, context, useActivityScope, propagate);
    }

    @Override
    public Map<String, Object> evaluateGroovyExpressions(Map<String, String> expressions, ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> context, Map<String, String> options) throws InstanceNotFoundException, GroovyException, ProcessNotFoundException {
        return this.getAPI(options).evaluateGroovyExpressions(expressions, processDefinitionUUID, context);
    }

    @Override
    public Map<String, Object> evaluateGroovyExpressions(Map<String, String> expression, ProcessInstanceUUID processInstanceUUID, Map<String, Object> context, boolean useInitialVariableValues, boolean propagate, Map<String, String> options) throws InstanceNotFoundException, GroovyException, RemoteException {
        return this.getAPI(options).evaluateGroovyExpressions(expression, processInstanceUUID, context, useInitialVariableValues, propagate);
    }

    @Override
    public void addAttachment(ProcessInstanceUUID instanceUUID, String name, String fileName, byte[] value, Map<String, String> options) throws RemoteException {
        this.getAPI(options).addAttachment(instanceUUID, name, fileName, value);
    }

    @Override
    public void addAttachment(ProcessInstanceUUID instanceUUID, String name, String label, String description, String fileName, Map<String, String> metadata, byte[] value, Map<String, String> options) throws RemoteException {
        this.getAPI(options).addAttachment(instanceUUID, name, label, description, fileName, metadata, value);
    }

    @Override
    public void addAttachments(Map<AttachmentInstance, byte[]> attachments, Map<String, String> options) throws RemoteException {
        this.getAPI(options).addAttachments(attachments);
    }

    @Override
    public void removeAttachment(ProcessInstanceUUID instanceUUID, String name, Map<String, String> options) throws RemoteException, InstanceNotFoundException {
        this.getAPI(options).removeAttachment(instanceUUID, name);
    }

    @Override
    public void deleteEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID actiivtyUUID, Map<String, String> options) throws RemoteException {
        this.getAPI(options).deleteEvents(eventName, toProcessName, toActivityName, actiivtyUUID);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeConnector(connectorClassName, parameters, definitionUUID);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeConnector(connectorClassName, parameters);
    }

    @Override
    public Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members, ProcessDefinitionUUID definitionUUID, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeFilter(connectorClassName, parameters, members, definitionUUID);
    }

    @Override
    public Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeFilter(connectorClassName, parameters, members);
    }

    @Override
    public Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeRoleResolver(connectorClassName, parameters, definitionUUID);
    }

    @Override
    public Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeRoleResolver(connectorClassName, parameters);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ClassLoader classLoader, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeConnector(connectorClassName, parameters, classLoader);
    }

    @Override
    public Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members, ClassLoader classLoader, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeFilter(connectorClassName, parameters, members, classLoader);
    }

    @Override
    public Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters, ClassLoader classLoader, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeRoleResolver(connectorClassName, parameters, classLoader);
    }

    @Override
    public void setActivityInstancePriority(ActivityInstanceUUID activityInstanceUUID, int priority, Map<String, String> options) throws ActivityNotFoundException {
        this.getAPI(options).setActivityInstancePriority(activityInstanceUUID, priority);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID, Map<String, Object> context, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeConnector(connectorClassName, parameters, definitionUUID, context);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ProcessInstanceUUID processInstanceUUID, Map<String, Object> context, boolean useCurrentVariableValues, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeConnector(connectorClassName, parameters, processInstanceUUID, context, useCurrentVariableValues);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ActivityInstanceUUID activityInstanceUUID, Map<String, Object> context, boolean useCurrentVariableValues, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeConnector(connectorClassName, parameters, activityInstanceUUID, context, useCurrentVariableValues);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessInstanceUUID processInstanceUUID, Map<String, Object> context, boolean useInitialVariableValues, boolean propagate, Map<String, String> options) throws InstanceNotFoundException, GroovyException, RemoteException {
        return this.getAPI(options).evaluateGroovyExpression(expression, processInstanceUUID, context, useInitialVariableValues, propagate);
    }

    @Override
    public void skipTask(ActivityInstanceUUID taskUUID, Map<String, Object> variablesToUpdate, Map<String, String> options) throws TaskNotFoundException, IllegalTaskStateException, RemoteException {
        this.getAPI(options).skipTask(taskUUID, variablesToUpdate);
    }

    @Override
    public void skip(ActivityInstanceUUID activityInstanceUUID, Map<String, Object> variablesToUpdate, Map<String, String> options) throws ActivityNotFoundException, IllegalTaskStateException, RemoteException {
        this.getAPI(options).skip(activityInstanceUUID, variablesToUpdate);
    }

    @Override
    public void executeEvent(CatchingEventUUID eventUUID, Map<String, String> options) throws EventNotFoundException, RemoteException {
        this.getAPI(options).executeEvent(eventUUID);
    }

    @Override
    public void deleteEvent(CatchingEventUUID eventUUID, Map<String, String> options) throws EventNotFoundException, RemoteException {
        this.getAPI(options).deleteEvent(eventUUID);
    }

    public void deleteEvents(Collection<CatchingEventUUID> eventUUIDs, Map<String, String> options) throws EventNotFoundException, RemoteException {
        this.getAPI(options).deleteEvents(eventUUIDs);
    }

    @Override
    public void updateExpirationDate(CatchingEventUUID eventUUID, Date expiration, Map<String, String> options) throws EventNotFoundException, RemoteException {
        this.getAPI(options).updateExpirationDate(eventUUID, expiration);
    }

    @Override
    public Object getModifiedJavaObject(ProcessDefinitionUUID processUUID, String variableExpression, Object variableValue, Object attributeValue, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getModifiedJavaObject(processUUID, variableExpression, variableValue, attributeValue);
    }

    @Override
    public void updateActivityExpectedEndDate(ActivityInstanceUUID activityUUID, Date expectedEndDate, Map<String, String> options) throws RemoteException, ActivityNotFoundException {
        this.getAPI(options).updateActivityExpectedEndDate(activityUUID, expectedEndDate);
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID processDefinitionUUID, String fileName, String mimeType, byte[] content, Map<String, String> options) throws RemoteException, DocumentationCreationException, ProcessNotFoundException {
        return this.getAPI(options).createDocument(name, processDefinitionUUID, fileName, mimeType, content);
    }

    @Override
    public Document createDocument(String name, ProcessInstanceUUID instanceUUID, String fileName, String mimeType, byte[] content, Map<String, String> options) throws RemoteException, DocumentationCreationException, InstanceNotFoundException {
        return this.getAPI(options).createDocument(name, instanceUUID, fileName, mimeType, content);
    }

    @Override
    public Document addDocumentVersion(DocumentUUID documentUUID, boolean isMajorVersion, String fileName, String mimeType, byte[] content, Map<String, String> options) throws RemoteException, DocumentationCreationException {
        return this.getAPI(options).addDocumentVersion(documentUUID, isMajorVersion, fileName, mimeType, content);
    }

    @Override
    public void deleteDocuments(boolean allVersions, DocumentUUID[] documentUUIDs, Map<String, String> options) throws RemoteException, DocumentNotFoundException {
        this.getAPI(options).deleteDocuments(allVersions, documentUUIDs);
    }
}

