/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.IdentityAPI;
import org.ow2.bonita.facade.exception.GroupAlreadyExistsException;
import org.ow2.bonita.facade.exception.GroupNotFoundException;
import org.ow2.bonita.facade.exception.MembershipNotFoundException;
import org.ow2.bonita.facade.exception.MetadataAlreadyExistsException;
import org.ow2.bonita.facade.exception.MetadataNotFoundException;
import org.ow2.bonita.facade.exception.RoleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RoleNotFoundException;
import org.ow2.bonita.facade.exception.UserAlreadyExistsException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.identity.Group;
import org.ow2.bonita.facade.identity.Membership;
import org.ow2.bonita.facade.identity.ProfileMetadata;
import org.ow2.bonita.facade.identity.Role;
import org.ow2.bonita.facade.identity.User;
import org.ow2.bonita.facade.identity.impl.ContactInfoImpl;
import org.ow2.bonita.facade.identity.impl.GroupImpl;
import org.ow2.bonita.facade.identity.impl.MembershipImpl;
import org.ow2.bonita.facade.identity.impl.ProfileMetadataImpl;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.paging.GroupCriterion;
import org.ow2.bonita.facade.paging.RoleCriterion;
import org.ow2.bonita.facade.paging.UserCriterion;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.privilege.impl.RuleImpl;
import org.ow2.bonita.services.IdentityService;
import org.ow2.bonita.services.PrivilegeService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

public class IdentityAPIImpl
implements IdentityAPI {
    private String queryList;

    protected IdentityAPIImpl(String queryList) {
        this.queryList = queryList;
    }

    private String getQueryList() {
        return this.queryList;
    }

    @Override
    public Role addRole(String name) throws RoleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.findRoleByName(name);
        if (role != null) {
            throw new RoleAlreadyExistsException("bai_IAPII_1", name);
        }
        role = new RoleImpl(name);
        identityService.addRole(role);
        return role;
    }

    @Override
    public Role addRole(String name, String label, String description) throws RoleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.findRoleByName(name);
        if (role != null) {
            throw new RoleAlreadyExistsException("bai_IAPII_1", name);
        }
        role = new RoleImpl(name);
        role.setLabel(label);
        role.setDescription(description);
        identityService.addRole(role);
        return role;
    }

    @Override
    public Role importRole(String uuid, String name, String label, String description) throws RoleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(uuid);
        if (role != null) {
            throw new RoleAlreadyExistsException("bai_IAPII_1", uuid);
        }
        role = identityService.findRoleByName(name);
        if (role != null) {
            throw new RoleAlreadyExistsException("bai_IAPII_1", name);
        }
        RoleImpl roleToImport = new RoleImpl(uuid, name);
        roleToImport.setLabel(label);
        roleToImport.setDescription(description);
        identityService.addRole(roleToImport);
        return role;
    }

    @Override
    @Deprecated
    public void addRoleToUser(String roleName, String username) throws UserNotFoundException, RoleNotFoundException {
        RoleImpl role;
        FacadeUtil.checkArgsNotNull(roleName, username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", username);
        }
        Set<GroupImpl> groups = identityService.findGroupsByName("platform");
        GroupImpl defaultGroup = null;
        if (groups != null && !groups.isEmpty()) {
            defaultGroup = groups.iterator().next();
        }
        if ((role = identityService.findRoleByName(roleName)) == null || defaultGroup == null) {
            throw new RoleNotFoundException("bai_IAPII_3", roleName + ":" + "/" + "platform");
        }
        MembershipImpl membership = identityService.findMembershipByRoleAndGroup(role.getUUID(), defaultGroup.getUUID());
        if (membership == null) {
            membership = new MembershipImpl();
            membership.setGroup(defaultGroup);
            membership.setRole(role);
            identityService.addMembership(membership);
        }
        identityService.addMembershipToUser(user, membership);
    }

    @Override
    @Deprecated
    public void setUserRoles(String username, Set<String> roleNames) throws UserNotFoundException, RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", username);
        }
        Set<GroupImpl> groups = identityService.findGroupsByName("platform");
        GroupImpl defaultGroup = null;
        if (groups != null && !groups.isEmpty()) {
            defaultGroup = groups.iterator().next();
        }
        HashSet<MembershipImpl> memberships = new HashSet<MembershipImpl>();
        if (roleNames != null) {
            for (String roleName : roleNames) {
                RoleImpl role = identityService.findRoleByName(roleName);
                if (role == null || defaultGroup == null) {
                    throw new RoleNotFoundException("bai_IAPII_3", roleName + ":" + "/" + "platform");
                }
                MembershipImpl membership = identityService.findMembershipByRoleAndGroup(role.getUUID(), defaultGroup.getUUID());
                if (membership == null) {
                    membership = new MembershipImpl();
                    membership.setGroup(defaultGroup);
                    membership.setRole(role);
                    identityService.addMembership(membership);
                }
                memberships.add(membership);
            }
        }
        identityService.setUserMemberships(user, memberships);
    }

    @Override
    public User addUser(String username, String password) throws UserAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(username, password);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(username);
        if (user != null) {
            throw new UserAlreadyExistsException("bai_IAPII_4", username);
        }
        user = new UserImpl(username, password);
        identityService.addUser(user);
        return user;
    }

    @Override
    @Deprecated
    public User addUser(String username, String password, String firstName, String lastName, String email) throws UserAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(username, password);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(username);
        if (user != null) {
            throw new UserAlreadyExistsException("bai_IAPII_4", username);
        }
        user = new UserImpl(username, password);
        user.setEmail(email);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        identityService.addUser(user);
        return user;
    }

    @Override
    @Deprecated
    public Set<Role> getRoles() {
        IdentityService identityService = EnvTool.getIdentityService();
        List<RoleImpl> roles = identityService.getAllRoles();
        HashSet<Role> result = new HashSet<Role>();
        if (roles != null) {
            for (RoleImpl role : roles) {
                result.add(new RoleImpl(role));
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public Set<User> getUsers() {
        IdentityService identityService = EnvTool.getIdentityService();
        List<UserImpl> users = identityService.getAllUsers();
        HashSet<User> result = new HashSet<User>();
        if (users != null) {
            for (UserImpl user : users) {
                result.add(new UserImpl(user));
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public Role getRole(String name) throws RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.findRoleByName(name);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", name);
        }
        return new RoleImpl(role);
    }

    @Override
    @Deprecated
    public User getUser(String username) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", username);
        }
        return new UserImpl(user);
    }

    @Override
    @Deprecated
    public void removeRole(String name) throws RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.findRoleByName(name);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", name);
        }
        Set<MembershipImpl> memberships = identityService.getMembershipsByRole(role.getUUID());
        if (memberships != null) {
            HashSet<String> membershipUUIDs = new HashSet<String>();
            for (MembershipImpl membership : memberships) {
                List<UserImpl> usersInMembership = identityService.getUsersByMembership(membership.getUUID());
                for (UserImpl user : usersInMembership) {
                    identityService.removeMembershipFromUser(user, membership);
                }
                identityService.deleteMembership(membership);
                membershipUUIDs.add(membership.getUUID());
            }
            this.removeMembershipsFromRules(membershipUUIDs);
        }
        identityService.deleteRole(role);
        HashSet<String> roleUUIDs = new HashSet<String>();
        roleUUIDs.add(role.getUUID());
        this.removeRolesFromRules(roleUUIDs);
    }

    @Override
    @Deprecated
    public void removeUser(String username) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", username);
        }
        List<UserImpl> usersOfManager = identityService.getUsersByManager(user.getUUID());
        for (UserImpl userOfManager : usersOfManager) {
            userOfManager.setManagerUUID(null);
        }
        List<UserImpl> delegeesUsers = identityService.getUsersByDelegee(user.getUUID());
        for (UserImpl delegeesUser : delegeesUsers) {
            delegeesUser.setDelegeeUUID(null);
        }
        identityService.deleteUser(user);
        HashSet<String> userUUIDs = new HashSet<String>();
        userUUIDs.add(user.getUUID());
        this.removeUsersFromRules(userUUIDs);
    }

    @Override
    @Deprecated
    public void removeRoleFromUser(String roleName, String username) throws UserNotFoundException, RoleNotFoundException {
        RoleImpl role;
        FacadeUtil.checkArgsNotNull(roleName, username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", username);
        }
        Set<GroupImpl> groups = identityService.findGroupsByName("platform");
        GroupImpl defaultGroup = null;
        if (groups != null && !groups.isEmpty()) {
            defaultGroup = groups.iterator().next();
        }
        if ((role = identityService.findRoleByName(roleName)) == null || defaultGroup == null) {
            throw new RoleNotFoundException("bai_IAPII_3", roleName + ":" + "/" + "platform");
        }
        MembershipImpl membership = identityService.findMembershipByRoleAndGroup(role.getUUID(), defaultGroup.getUUID());
        if (membership != null) {
            identityService.removeMembershipFromUser(user, membership);
        }
    }

    @Override
    @Deprecated
    public Set<Role> getUserRoles(String username) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", username);
        }
        HashSet<Role> roles = new HashSet<Role>();
        Set<Membership> memberships = user.getMemberships();
        for (Membership membership : memberships) {
            if (!"platform".equals(membership.getGroup().getName())) continue;
            roles.add(new RoleImpl((RoleImpl)membership.getRole()));
        }
        return roles;
    }

    @Override
    @Deprecated
    public Set<User> getUsersInRole(String name) throws RoleNotFoundException {
        List<UserImpl> usersInRole;
        RoleImpl role;
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        Set<GroupImpl> groups = identityService.findGroupsByName("platform");
        GroupImpl defaultGroup = null;
        if (groups != null && !groups.isEmpty()) {
            defaultGroup = groups.iterator().next();
        }
        if ((role = identityService.findRoleByName(name)) == null || defaultGroup == null) {
            throw new RoleNotFoundException("bai_IAPII_3", name + ":" + "/" + "platform");
        }
        MembershipImpl membership = identityService.findMembershipByRoleAndGroup(role.getUUID(), defaultGroup.getUUID());
        HashSet<User> users = new HashSet<User>();
        if (membership != null && (usersInRole = identityService.getUsersByMembership(membership.getUUID())) != null) {
            for (UserImpl user : usersInRole) {
                users.add(new UserImpl(user));
            }
        }
        return users;
    }

    @Override
    @Deprecated
    public Role updateRole(String oldName, String name, String label, String description) throws RoleNotFoundException, RoleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(oldName, name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.findRoleByName(oldName);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", oldName);
        }
        if (!name.equals(oldName) && identityService.findRoleByName(name) != null) {
            throw new RoleAlreadyExistsException("bai_IAPII_5", name);
        }
        role.setName(name);
        role.setLabel(label);
        role.setDescription(description);
        identityService.updateRole(role);
        return new RoleImpl(role);
    }

    @Override
    @Deprecated
    public User updateUser(String oldUsername, String username, String password, String firstName, String lastName, String email) throws UserNotFoundException, UserAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(oldUsername, username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(oldUsername);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", oldUsername);
        }
        if (!username.equals(oldUsername) && identityService.findUserByUsername(username) != null) {
            throw new UserAlreadyExistsException("bai_IAPII_6", username);
        }
        user.setUsername(username);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmail(email);
        identityService.updateUser(user);
        identityService.updateUserPassword(user, password);
        return new UserImpl(user);
    }

    @Override
    public User updateUserPassword(String userUUID, String password) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        identityService.updateUserPassword(user, password);
        return new UserImpl(user);
    }

    @Override
    public Group addGroup(String name, String parentGroupUUID) throws GroupAlreadyExistsException, GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        List<GroupImpl> childrenGroups = identityService.getGroupChildren(parentGroupUUID);
        for (GroupImpl childGroup : childrenGroups) {
            if (!name.equalsIgnoreCase(childGroup.getName())) continue;
            throw new GroupAlreadyExistsException("bai_IAPII_7", name);
        }
        GroupImpl group = new GroupImpl(name);
        if (parentGroupUUID != null) {
            GroupImpl parentGroup = identityService.getGroup(parentGroupUUID);
            if (parentGroup == null) {
                throw new GroupNotFoundException("bai_IAPII_13", parentGroupUUID);
            }
            group.setParentGroup(parentGroup);
        }
        identityService.addGroup(group);
        return new GroupImpl(group);
    }

    @Override
    public Group addGroup(String name, String label, String description, String parentGroupUUID) throws GroupAlreadyExistsException, GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        List<GroupImpl> childrenGroups = identityService.getGroupChildren(parentGroupUUID);
        for (GroupImpl childGroup : childrenGroups) {
            if (!name.equalsIgnoreCase(childGroup.getName())) continue;
            throw new GroupAlreadyExistsException("bai_IAPII_7", name);
        }
        GroupImpl group = new GroupImpl(name);
        group.setLabel(label);
        group.setDescription(description);
        identityService.addGroup(group);
        if (parentGroupUUID != null) {
            GroupImpl parentGroup = identityService.getGroup(parentGroupUUID);
            if (parentGroup == null) {
                throw new GroupNotFoundException("bai_IAPII_13", parentGroupUUID);
            }
            group.setParentGroup(parentGroup);
        }
        return new GroupImpl(group);
    }

    @Override
    public Group importGroup(String uuid, String name, String label, String description, String parentGroupUUID) throws GroupAlreadyExistsException, GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        GroupImpl group = identityService.getGroup(uuid);
        if (group != null) {
            throw new GroupAlreadyExistsException("bai_IAPII_7", uuid);
        }
        List<GroupImpl> childrenGroups = identityService.getGroupChildren(parentGroupUUID);
        for (GroupImpl childGroup : childrenGroups) {
            if (!name.equalsIgnoreCase(childGroup.getName())) continue;
            throw new GroupAlreadyExistsException("bai_IAPII_7", name);
        }
        GroupImpl groupToImport = new GroupImpl(uuid, name);
        groupToImport.setLabel(label);
        groupToImport.setDescription(description);
        identityService.addGroup(groupToImport);
        if (parentGroupUUID != null) {
            GroupImpl parentGroup = identityService.getGroup(parentGroupUUID);
            if (parentGroup == null) {
                throw new GroupNotFoundException("bai_IAPII_13", parentGroupUUID);
            }
            groupToImport.setParentGroup(parentGroup);
        }
        return new GroupImpl(groupToImport);
    }

    @Override
    public void addMembershipToUser(String userUUID, String membershipUUID) throws UserNotFoundException, MembershipNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUID, membershipUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        MembershipImpl membership = identityService.getMembership(membershipUUID);
        if (membership == null) {
            throw new MembershipNotFoundException("bai_IAPII_8", membershipUUID);
        }
        identityService.addMembershipToUser(user, membership);
    }

    @Override
    public void addMembershipsToUser(String userUUID, Collection<String> membershipUUIDs) throws UserNotFoundException, MembershipNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUID, membershipUUIDs);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        for (String membershipUUID : membershipUUIDs) {
            MembershipImpl membership = identityService.getMembership(membershipUUID);
            if (membership == null) {
                throw new MembershipNotFoundException("bai_IAPII_8", membershipUUID);
            }
            identityService.addMembershipToUser(user, membership);
        }
    }

    @Override
    public ProfileMetadata addProfileMetadata(String name) throws MetadataAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        ProfileMetadataImpl metadata = identityService.findProfileMetadataByName(name);
        if (metadata != null) {
            throw new MetadataAlreadyExistsException("bai_IAPII_9", name);
        }
        ProfileMetadataImpl profileMetadata = new ProfileMetadataImpl(name);
        identityService.addProfileMetadata(profileMetadata);
        return profileMetadata;
    }

    @Override
    public ProfileMetadata addProfileMetadata(String name, String label) throws MetadataAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        ProfileMetadataImpl metadata = identityService.findProfileMetadataByName(name);
        if (metadata != null) {
            throw new MetadataAlreadyExistsException("bai_IAPII_9", name);
        }
        ProfileMetadataImpl profileMetadata = new ProfileMetadataImpl(name);
        profileMetadata.setLabel(label);
        identityService.addProfileMetadata(profileMetadata);
        return profileMetadata;
    }

    @Override
    public User addUser(String username, String password, String firstName, String lastName, String title, String jobTitle, String managerUserUUID, Map<String, String> profileMetadata) throws UserAlreadyExistsException, UserNotFoundException, MetadataNotFoundException {
        FacadeUtil.checkArgsNotNull(username, password);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(username);
        if (user != null) {
            throw new UserAlreadyExistsException("bai_IAPII_4", username);
        }
        user = new UserImpl(username, password);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        user.setTitle(title);
        if (managerUserUUID != null) {
            UserImpl manager = identityService.getUser(managerUserUUID);
            if (manager == null) {
                throw new UserNotFoundException("bai_IAPII_10", managerUserUUID);
            }
            user.setManagerUUID(managerUserUUID);
        }
        identityService.addUser(user);
        if (profileMetadata != null) {
            HashMap<ProfileMetadata, String> userMetadata = new HashMap<ProfileMetadata, String>();
            for (Map.Entry<String, String> profileMetadataEntry : profileMetadata.entrySet()) {
                ProfileMetadataImpl metadata = identityService.findProfileMetadataByName(profileMetadataEntry.getKey());
                if (metadata == null) {
                    throw new MetadataNotFoundException("bai_IAPII_11", profileMetadataEntry.getKey());
                }
                metadata.getUsers().put(user, profileMetadataEntry.getValue());
                identityService.updateProfileMetadata(metadata);
                userMetadata.put(metadata, profileMetadataEntry.getValue());
            }
            user.setMetadata(userMetadata);
            identityService.updateUser(user);
        }
        return new UserImpl(user);
    }

    @Override
    public ProfileMetadata findProfileMetadataByName(String metadataName) throws MetadataNotFoundException {
        FacadeUtil.checkArgsNotNull(metadataName);
        IdentityService identityService = EnvTool.getIdentityService();
        ProfileMetadataImpl metadata = identityService.findProfileMetadataByName(metadataName);
        if (metadata == null) {
            throw new MetadataNotFoundException("bai_IAPII_11", metadataName);
        }
        return new ProfileMetadataImpl(metadata);
    }

    @Override
    public Role findRoleByName(String name) throws RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.findRoleByName(name);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", name);
        }
        return new RoleImpl(role);
    }

    @Override
    public User findUserByUserName(String username) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.findUserByUsername(username);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", username);
        }
        return new UserImpl(user);
    }

    @Override
    public List<Group> getAllGroups() {
        IdentityService identityService = EnvTool.getIdentityService();
        List<GroupImpl> groups = identityService.getAllGroups();
        ArrayList<Group> result = new ArrayList<Group>();
        if (groups != null) {
            for (GroupImpl group : groups) {
                result.add(new GroupImpl(group));
            }
        }
        return result;
    }

    @Override
    public List<ProfileMetadata> getAllProfileMetadata() {
        IdentityService identityService = EnvTool.getIdentityService();
        List<ProfileMetadataImpl> profileMetadata = identityService.getAllProfileMetadata();
        ArrayList<ProfileMetadata> result = new ArrayList<ProfileMetadata>();
        if (profileMetadata != null) {
            for (ProfileMetadataImpl metadata : profileMetadata) {
                result.add(new ProfileMetadataImpl(metadata));
            }
        }
        return result;
    }

    @Override
    public List<ProfileMetadata> getProfileMetadata(int fromIndex, int numberOfMetadata) {
        IdentityService identityService = EnvTool.getIdentityService();
        List<ProfileMetadataImpl> profileMetadata = identityService.getProfileMetadata(fromIndex, numberOfMetadata);
        ArrayList<ProfileMetadata> result = new ArrayList<ProfileMetadata>();
        if (profileMetadata != null) {
            for (ProfileMetadataImpl metadata : profileMetadata) {
                result.add(new ProfileMetadataImpl(metadata));
            }
        }
        return result;
    }

    @Override
    public List<Role> getAllRoles() {
        IdentityService identityService = EnvTool.getIdentityService();
        List<RoleImpl> roles = identityService.getAllRoles();
        ArrayList<Role> result = new ArrayList<Role>();
        if (roles != null) {
            for (RoleImpl role : roles) {
                result.add(new RoleImpl(role));
            }
        }
        return result;
    }

    @Override
    public List<User> getAllUsers() {
        IdentityService identityService = EnvTool.getIdentityService();
        List<UserImpl> users = identityService.getAllUsers();
        ArrayList<User> result = new ArrayList<User>();
        if (users != null) {
            for (UserImpl user : users) {
                result.add(new UserImpl(user));
            }
        }
        return result;
    }

    @Override
    public List<User> getAllUsersInGroup(String groupUUID) throws GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(groupUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        GroupImpl group = identityService.getGroup(groupUUID);
        if (group == null) {
            throw new GroupNotFoundException("bai_IAPII_12", groupUUID);
        }
        List<UserImpl> users = identityService.getUsersByGroup(groupUUID);
        ArrayList<User> result = new ArrayList<User>();
        if (users != null) {
            for (UserImpl user : users) {
                result.add(new UserImpl(user));
            }
        }
        return result;
    }

    @Override
    public List<User> getAllUsersInMembership(String membershipUUID) throws MembershipNotFoundException {
        FacadeUtil.checkArgsNotNull(membershipUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        MembershipImpl membership = identityService.getMembership(membershipUUID);
        if (membership == null) {
            throw new MembershipNotFoundException("bai_IAPII_8", membershipUUID);
        }
        List<UserImpl> users = identityService.getUsersByMembership(membershipUUID);
        ArrayList<User> result = new ArrayList<User>();
        if (users != null) {
            for (UserImpl user : users) {
                result.add(new UserImpl(user));
            }
        }
        return result;
    }

    @Override
    public List<User> getAllUsersInRole(String roleUUID) throws RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(roleUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(roleUUID);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", roleUUID);
        }
        List<UserImpl> users = identityService.getUsersByRole(roleUUID);
        ArrayList<User> result = new ArrayList<User>();
        if (users != null) {
            for (UserImpl user : users) {
                result.add(new UserImpl(user));
            }
        }
        return result;
    }

    @Override
    public List<User> getAllUsersInRoleAndGroup(String roleUUID, String groupUUID) throws RoleNotFoundException, GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(roleUUID, groupUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(roleUUID);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", roleUUID);
        }
        GroupImpl group = identityService.getGroup(groupUUID);
        if (group == null) {
            throw new GroupNotFoundException("bai_IAPII_12", groupUUID);
        }
        MembershipImpl membership = identityService.findMembershipByRoleAndGroup(roleUUID, groupUUID);
        ArrayList<User> result = new ArrayList<User>();
        if (membership != null) {
            List<UserImpl> users = identityService.getUsersByMembership(membership.getUUID());
            for (UserImpl user : users) {
                result.add(new UserImpl(user));
            }
        }
        return result;
    }

    @Override
    public List<User> getUsersByManagerUUID(String managerUUID) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(managerUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl manager = identityService.getUser(managerUUID);
        if (manager == null) {
            throw new UserNotFoundException("bai_IAPII_2", managerUUID);
        }
        List<UserImpl> users = identityService.getUsersByManager(managerUUID);
        ArrayList<User> result = new ArrayList<User>();
        if (users != null) {
            for (UserImpl user : users) {
                result.add(new UserImpl(user));
            }
        }
        return result;
    }

    @Override
    public List<Group> getChildrenGroupsByUUID(String groupUUID) {
        IdentityService identityService = EnvTool.getIdentityService();
        List<GroupImpl> groups = identityService.getGroupChildren(groupUUID);
        ArrayList<Group> result = new ArrayList<Group>();
        if (groups != null) {
            for (GroupImpl group : groups) {
                result.add(new GroupImpl(group));
            }
        }
        return result;
    }

    @Override
    public List<Group> getChildrenGroups(String groupUUID, int fromIndex, int numberOfGroups) throws GroupNotFoundException {
        IdentityService identityService = EnvTool.getIdentityService();
        List<GroupImpl> groups = identityService.getGroupChildren(groupUUID, fromIndex, numberOfGroups);
        ArrayList<Group> result = new ArrayList<Group>();
        if (groups != null) {
            for (GroupImpl group : groups) {
                result.add(new GroupImpl(group));
            }
        }
        return result;
    }

    @Override
    public List<Group> getChildrenGroups(String groupUUID, int fromIndex, int numberOfGroups, GroupCriterion pagingCriterion) throws GroupNotFoundException {
        IdentityService identityService = EnvTool.getIdentityService();
        List<GroupImpl> groups = identityService.getGroupChildren(groupUUID, fromIndex, numberOfGroups, pagingCriterion);
        ArrayList<Group> result = new ArrayList<Group>();
        if (groups != null) {
            for (GroupImpl group : groups) {
                result.add(new GroupImpl(group));
            }
        }
        return result;
    }

    @Override
    public int getNumberOfChildrenGroups(String groupUUID) throws GroupNotFoundException {
        IdentityService identityService = EnvTool.getIdentityService();
        return identityService.getNumberOfGroupChildren(groupUUID);
    }

    @Override
    public Group getGroupByUUID(String groupUUID) throws GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(groupUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        GroupImpl group = identityService.getGroup(groupUUID);
        if (group == null) {
            throw new GroupNotFoundException("bai_IAPII_12", groupUUID);
        }
        return new GroupImpl(group);
    }

    @Override
    public List<Group> getGroupsByUUIDs(Collection<String> groupUUIDs) throws GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(groupUUIDs);
        ArrayList<Group> result = new ArrayList<Group>();
        IdentityService identityService = EnvTool.getIdentityService();
        if (groupUUIDs.size() > 0) {
            List<GroupImpl> groups = identityService.getGroups(groupUUIDs);
            if (groupUUIDs.size() != groups.size()) {
                HashSet<String> storedGroupUUIDs = new HashSet<String>();
                for (GroupImpl group : groups) {
                    storedGroupUUIDs.add(group.getUUID());
                }
                for (String groupUUID : groupUUIDs) {
                    if (storedGroupUUIDs.contains(groupUUID)) continue;
                    throw new GroupNotFoundException("bai_IAPII_12", groupUUID);
                }
            }
            for (GroupImpl group : groups) {
                result.add(new GroupImpl(group));
            }
        }
        return result;
    }

    @Override
    public List<Group> getGroups(int fromIndex, int numberOfGroups) {
        IdentityService identityService = EnvTool.getIdentityService();
        List<GroupImpl> groups = identityService.getGroups(fromIndex, numberOfGroups);
        ArrayList<Group> result = new ArrayList<Group>();
        if (groups != null) {
            for (GroupImpl group : groups) {
                result.add(new GroupImpl(group));
            }
        }
        return result;
    }

    @Override
    public List<Group> getGroups(int fromIndex, int numberOfGroups, GroupCriterion pagingCriterion) {
        IdentityService identityService = EnvTool.getIdentityService();
        List<GroupImpl> groups = identityService.getGroups(fromIndex, numberOfGroups, pagingCriterion);
        ArrayList<Group> result = new ArrayList<Group>();
        if (groups != null) {
            for (GroupImpl group : groups) {
                result.add(new GroupImpl(group));
            }
        }
        return result;
    }

    @Override
    public Membership getMembershipByUUID(String membershipUUID) throws MembershipNotFoundException {
        FacadeUtil.checkArgsNotNull(membershipUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        MembershipImpl membership = identityService.getMembership(membershipUUID);
        if (membership == null) {
            throw new MembershipNotFoundException("bai_IAPII_8", membershipUUID);
        }
        return new MembershipImpl(membership);
    }

    @Override
    public List<Membership> getMembershipsByUUIDs(Collection<String> membershipUUIDs) throws MembershipNotFoundException {
        FacadeUtil.checkArgsNotNull(membershipUUIDs);
        ArrayList<Membership> result = new ArrayList<Membership>();
        IdentityService identityService = EnvTool.getIdentityService();
        if (membershipUUIDs.size() > 0) {
            List<MembershipImpl> memberships = identityService.getMemberships(membershipUUIDs);
            if (membershipUUIDs.size() != memberships.size()) {
                HashSet<String> storedMembershipUUIDs = new HashSet<String>();
                for (MembershipImpl membership : memberships) {
                    storedMembershipUUIDs.add(membership.getUUID());
                }
                for (String membershipUUID : membershipUUIDs) {
                    if (storedMembershipUUIDs.contains(membershipUUID)) continue;
                    throw new MembershipNotFoundException("bai_IAPII_8", membershipUUID);
                }
            }
            for (MembershipImpl membership : memberships) {
                result.add(new MembershipImpl(membership));
            }
        }
        return result;
    }

    @Override
    public Membership getMembershipForRoleAndGroup(String roleUUID, String groupUUID) throws RoleNotFoundException, GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(roleUUID, groupUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(roleUUID);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", roleUUID);
        }
        GroupImpl group = identityService.getGroup(groupUUID);
        if (group == null) {
            throw new GroupNotFoundException("bai_IAPII_12", groupUUID);
        }
        MembershipImpl membership = identityService.findMembershipByRoleAndGroup(roleUUID, groupUUID);
        if (membership != null) {
            return new MembershipImpl(membership);
        }
        membership = new MembershipImpl();
        membership.setGroup(group);
        membership.setRole(role);
        identityService.addMembership(membership);
        return new MembershipImpl(membership);
    }

    @Override
    public int getNumberOfGroups() {
        IdentityService identityService = EnvTool.getIdentityService();
        return identityService.getNumberOfGroups();
    }

    @Override
    public int getNumberOfRoles() {
        IdentityService identityService = EnvTool.getIdentityService();
        return identityService.getNumberOfRoles();
    }

    @Override
    public int getNumberOfUsers() {
        IdentityService identityService = EnvTool.getIdentityService();
        return identityService.getNumberOfUsers();
    }

    @Override
    public int getNumberOfUsersInGroup(String groupUUID) {
        FacadeUtil.checkArgsNotNull(groupUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        return identityService.getNumberOfUsersByGroup(groupUUID);
    }

    @Override
    public int getNumberOfUsersInRole(String roleUUID) {
        FacadeUtil.checkArgsNotNull(roleUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        return identityService.getNumberOfUsersByRole(roleUUID);
    }

    @Override
    public ProfileMetadata getProfileMetadataByUUID(String metadataUUID) throws MetadataNotFoundException {
        FacadeUtil.checkArgsNotNull(metadataUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        ProfileMetadataImpl profileMetadata = identityService.getProfileMetadata(metadataUUID);
        if (profileMetadata == null) {
            throw new MetadataNotFoundException("bai_IAPII_11", metadataUUID);
        }
        return new ProfileMetadataImpl(profileMetadata);
    }

    @Override
    public Role getRoleByUUID(String roleUUID) throws RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(roleUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(roleUUID);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", roleUUID);
        }
        return new RoleImpl(role);
    }

    @Override
    public List<Role> getRolesByUUIDs(Collection<String> roleUUIDs) throws RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(roleUUIDs);
        ArrayList<Role> result = new ArrayList<Role>();
        IdentityService identityService = EnvTool.getIdentityService();
        if (roleUUIDs.size() > 0) {
            List<RoleImpl> roles = identityService.getRoles(roleUUIDs);
            if (roleUUIDs.size() != roles.size()) {
                HashSet<String> storedGroupUUIDs = new HashSet<String>();
                for (RoleImpl group : roles) {
                    storedGroupUUIDs.add(group.getUUID());
                }
                for (String roleUUID : roleUUIDs) {
                    if (storedGroupUUIDs.contains(roleUUID)) continue;
                    throw new RoleNotFoundException("bai_IAPII_3", roleUUID);
                }
            }
            for (RoleImpl role : roles) {
                result.add(new RoleImpl(role));
            }
        }
        return result;
    }

    @Override
    public List<Role> getRoles(int fromIndex, int numberOfRoles) {
        IdentityService identityService = EnvTool.getIdentityService();
        List<RoleImpl> roles = identityService.getRoles(fromIndex, numberOfRoles);
        ArrayList<Role> result = new ArrayList<Role>();
        if (roles != null) {
            for (RoleImpl role : roles) {
                result.add(new RoleImpl(role));
            }
        }
        return result;
    }

    @Override
    public List<Role> getRoles(int fromIndex, int numberOfRoles, RoleCriterion pagingCriterion) {
        IdentityService identityService = EnvTool.getIdentityService();
        List<RoleImpl> roles = identityService.getRoles(fromIndex, numberOfRoles, pagingCriterion);
        ArrayList<Role> result = new ArrayList<Role>();
        if (roles != null) {
            for (RoleImpl role : roles) {
                result.add(new RoleImpl(role));
            }
        }
        return result;
    }

    @Override
    public User getUserByUUID(String userUUID) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        return new UserImpl(user);
    }

    @Override
    public List<User> getUsersByUUIDs(Collection<String> userUUIDs) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUIDs);
        ArrayList<User> result = new ArrayList<User>();
        IdentityService identityService = EnvTool.getIdentityService();
        if (userUUIDs.size() > 0) {
            List<UserImpl> users = identityService.getUsers(userUUIDs);
            if (userUUIDs.size() != users.size()) {
                HashSet<String> storedUserUUIDs = new HashSet<String>();
                for (UserImpl user : users) {
                    storedUserUUIDs.add(user.getUUID());
                }
                for (String userUUID : userUUIDs) {
                    if (storedUserUUIDs.contains(userUUID)) continue;
                    throw new UserNotFoundException("bai_IAPII_2", userUUID);
                }
            }
            for (UserImpl user : users) {
                result.add(new UserImpl(user));
            }
        }
        return result;
    }

    @Override
    public List<User> getUsers(int fromIndex, int numberOfUsers) {
        IdentityService identityService = EnvTool.getIdentityService();
        List<UserImpl> usersInGroup = identityService.getUsers(fromIndex, numberOfUsers);
        ArrayList<User> users = new ArrayList<User>();
        for (UserImpl userInGroup : usersInGroup) {
            users.add(new UserImpl(userInGroup));
        }
        return users;
    }

    @Override
    public List<User> getUsers(int fromIndex, int numberOfUsers, UserCriterion pagingCriterion) {
        IdentityService identityService = EnvTool.getIdentityService();
        List<UserImpl> usersInGroup = identityService.getUsers(fromIndex, numberOfUsers, pagingCriterion);
        ArrayList<User> users = new ArrayList<User>();
        for (UserImpl userInGroup : usersInGroup) {
            users.add(new UserImpl(userInGroup));
        }
        return users;
    }

    @Override
    public List<User> getUsersInGroup(String groupUUID, int fromIndex, int numberOfUsers) throws GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(groupUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        GroupImpl group = identityService.getGroup(groupUUID);
        if (group == null) {
            throw new GroupNotFoundException("bai_IAPII_12", groupUUID);
        }
        List<UserImpl> usersInGroup = identityService.getUsersByGroup(groupUUID, fromIndex, numberOfUsers);
        ArrayList<User> users = new ArrayList<User>();
        for (UserImpl userInGroup : usersInGroup) {
            users.add(new UserImpl(userInGroup));
        }
        return users;
    }

    @Override
    public List<User> getUsersInGroup(String groupUUID, int fromIndex, int numberOfUsers, UserCriterion pagingCriterion) throws GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(groupUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        GroupImpl group = identityService.getGroup(groupUUID);
        if (group == null) {
            throw new GroupNotFoundException("bai_IAPII_12", groupUUID);
        }
        List<UserImpl> usersInGroup = identityService.getUsersByGroup(groupUUID, fromIndex, numberOfUsers, pagingCriterion);
        ArrayList<User> users = new ArrayList<User>();
        for (UserImpl userInGroup : usersInGroup) {
            users.add(new UserImpl(userInGroup));
        }
        return users;
    }

    @Override
    public List<User> getUsersInRole(String roleUUID, int fromIndex, int numberOfUsers) throws RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(roleUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(roleUUID);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", roleUUID);
        }
        List<UserImpl> usersInGroup = identityService.getUsersByRole(roleUUID, fromIndex, numberOfUsers);
        ArrayList<User> users = new ArrayList<User>();
        for (UserImpl userInGroup : usersInGroup) {
            users.add(new UserImpl(userInGroup));
        }
        return users;
    }

    @Override
    public List<User> getUsersInRole(String roleUUID, int fromIndex, int numberOfUsers, UserCriterion pagingCriterion) throws RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(roleUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(roleUUID);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", roleUUID);
        }
        List<UserImpl> usersInGroup = identityService.getUsersByRole(roleUUID, fromIndex, numberOfUsers, pagingCriterion);
        ArrayList<User> users = new ArrayList<User>();
        for (UserImpl userInGroup : usersInGroup) {
            users.add(new UserImpl(userInGroup));
        }
        return users;
    }

    @Override
    public void removeGroupByUUID(String groupUUID) throws GroupNotFoundException {
        Set<MembershipImpl> memberships;
        FacadeUtil.checkArgsNotNull(groupUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        GroupImpl group = identityService.getGroup(groupUUID);
        if (group == null) {
            throw new GroupNotFoundException("bai_IAPII_12", groupUUID);
        }
        List<GroupImpl> children = identityService.getGroupChildren(groupUUID);
        ArrayList<String> childrenUUIDs = new ArrayList<String>();
        for (GroupImpl child : children) {
            childrenUUIDs.add(child.getUUID());
        }
        if (children != null && !children.isEmpty()) {
            this.removeGroups(childrenUUIDs);
        }
        if ((memberships = identityService.getMembershipsByGroup(group.getUUID())) != null) {
            HashSet<String> membershipUUIDs = new HashSet<String>();
            for (MembershipImpl membership : memberships) {
                List<UserImpl> usersInMembership = identityService.getUsersByMembership(membership.getUUID());
                for (UserImpl user : usersInMembership) {
                    identityService.removeMembershipFromUser(user, membership);
                }
                identityService.deleteMembership(membership);
                membershipUUIDs.add(membership.getUUID());
            }
            this.removeMembershipsFromRules(membershipUUIDs);
        }
        identityService.deleteGroup(group);
        HashSet<String> groupUUIDs = new HashSet<String>();
        groupUUIDs.add(groupUUID);
        this.removeGroupsFromRules(groupUUIDs);
    }

    @Override
    public void removeMembershipFromUser(String userUUID, String membershipUUID) throws UserNotFoundException, MembershipNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUID, membershipUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        MembershipImpl membership = identityService.getMembership(membershipUUID);
        if (membership == null) {
            throw new MembershipNotFoundException("bai_IAPII_8", membershipUUID);
        }
        identityService.removeMembershipFromUser(user, membership);
    }

    @Override
    public void removeMembershipsFromUser(String userUUID, Collection<String> membershipUUIDs) throws UserNotFoundException, MembershipNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUID, membershipUUIDs);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        for (String membershipUUID : membershipUUIDs) {
            MembershipImpl membership = identityService.getMembership(membershipUUID);
            if (membership == null) {
                throw new MembershipNotFoundException("bai_IAPII_8", membershipUUID);
            }
            identityService.removeMembershipFromUser(user, membership);
        }
    }

    @Override
    public void removeProfileMetadataByUUID(String profileMetadataUUID) throws MetadataNotFoundException {
        Misc.checkArgsNotNull(profileMetadataUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        ProfileMetadataImpl profileMetadata = identityService.getProfileMetadata(profileMetadataUUID);
        if (profileMetadata == null) {
            throw new MetadataNotFoundException("bai_IAPII_11", profileMetadataUUID);
        }
        identityService.deleteProfileMetadata(profileMetadata);
    }

    @Override
    public void removeRoleByUUID(String roleUUID) throws RoleNotFoundException {
        Misc.checkArgsNotNull(roleUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(roleUUID);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", roleUUID);
        }
        identityService.deleteRole(role);
        HashSet<String> roleUUIDs = new HashSet<String>();
        roleUUIDs.add(roleUUID);
        this.removeRolesFromRules(roleUUIDs);
    }

    @Override
    public void removeUserByUUID(String userUUID) throws UserNotFoundException {
        Misc.checkArgsNotNull(userUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        List<UserImpl> usersOfManager = identityService.getUsersByManager(userUUID);
        for (UserImpl userOfManager : usersOfManager) {
            userOfManager.setManagerUUID(null);
        }
        List<UserImpl> delegeesUsers = identityService.getUsersByDelegee(userUUID);
        for (UserImpl delegeesUser : delegeesUsers) {
            delegeesUser.setDelegeeUUID(null);
        }
        identityService.deleteUser(user);
        HashSet<String> userUUIDs = new HashSet<String>();
        userUUIDs.add(userUUID);
        this.removeUsersFromRules(userUUIDs);
    }

    @Override
    public void setUserMemberships(String userUUID, Collection<String> membershipUUIDs) throws UserNotFoundException, MembershipNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUID, membershipUUIDs);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        HashSet<MembershipImpl> userMemberships = new HashSet<MembershipImpl>();
        for (String membershipUUID : membershipUUIDs) {
            MembershipImpl membership = identityService.getMembership(membershipUUID);
            if (membership == null) {
                throw new MembershipNotFoundException("bai_IAPII_8", membershipUUID);
            }
            userMemberships.add(membership);
        }
        identityService.setUserMemberships(user, userMemberships);
    }

    @Override
    public boolean groupExists(String groupUUID) {
        FacadeUtil.checkArgsNotNull(groupUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        return identityService.getGroup(groupUUID) != null;
    }

    @Override
    public Group updateGroupByUUID(String groupUUID, String name, String label, String description, String parentGroupUUID) throws GroupNotFoundException, GroupAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(groupUUID, name);
        IdentityService identityService = EnvTool.getIdentityService();
        GroupImpl group = identityService.getGroup(groupUUID);
        if (group == null) {
            throw new GroupNotFoundException("bai_IAPII_12", groupUUID);
        }
        GroupImpl parentGroup = null;
        if (parentGroupUUID != null && (parentGroup = identityService.getGroup(parentGroupUUID)) == null) {
            throw new GroupNotFoundException("bai_IAPII_13", parentGroupUUID);
        }
        if (!group.getName().equals(name)) {
            List<GroupImpl> groupChildren = identityService.getGroupChildren(parentGroupUUID);
            for (GroupImpl child : groupChildren) {
                if (!child.getName().equals(name)) continue;
                throw new GroupAlreadyExistsException("bai_IAPII_7", name);
            }
        }
        group.setParentGroup(parentGroup);
        group.setName(name);
        group.setLabel(label);
        group.setDescription(description);
        identityService.updateGroup(group);
        return new GroupImpl(group);
    }

    @Override
    public ProfileMetadata updateProfileMetadataByUUID(String profileMetadataUUID, String name, String label) throws MetadataNotFoundException, MetadataAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(profileMetadataUUID, name);
        IdentityService identityService = EnvTool.getIdentityService();
        ProfileMetadataImpl metadata = identityService.getProfileMetadata(profileMetadataUUID);
        if (metadata == null) {
            throw new MetadataNotFoundException("bai_IAPII_11", profileMetadataUUID);
        }
        if (!metadata.getName().equals(name) && identityService.findProfileMetadataByName(name) != null) {
            throw new MetadataAlreadyExistsException("bai_IAPII_14", name);
        }
        metadata.setName(name);
        metadata.setLabel(label);
        identityService.updateProfileMetadata(metadata);
        return new ProfileMetadataImpl(metadata);
    }

    @Override
    public Role updateRoleByUUID(String roleUUID, String name, String label, String description) throws RoleNotFoundException, RoleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(roleUUID, name);
        IdentityService identityService = EnvTool.getIdentityService();
        RoleImpl role = identityService.getRole(roleUUID);
        if (role == null) {
            throw new RoleNotFoundException("bai_IAPII_3", roleUUID);
        }
        if (!role.getName().equals(name) && identityService.findRoleByName(name) != null) {
            throw new RoleAlreadyExistsException("bai_IAPII_5", name);
        }
        role.setName(name);
        role.setLabel(label);
        role.setDescription(description);
        identityService.updateRole(role);
        return new RoleImpl(role);
    }

    @Override
    public User updateUserByUUID(String userUUID, String username, String firstName, String lastName, String title, String jobTitle, String managerUserUUID, Map<String, String> profileMetadata) throws UserNotFoundException, UserAlreadyExistsException, MetadataNotFoundException {
        UserImpl manager;
        FacadeUtil.checkArgsNotNull(userUUID, username);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        if (!user.getUsername().equals(username) && identityService.findUserByUsername(username) != null) {
            throw new UserAlreadyExistsException("bai_IAPII_6", username);
        }
        user.setUsername(username);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setTitle(title);
        user.setJobTitle(jobTitle);
        if (managerUserUUID != null && (manager = identityService.getUser(managerUserUUID)) == null) {
            throw new UserNotFoundException("bai_IAPII_10", managerUserUUID);
        }
        user.setManagerUUID(managerUserUUID);
        if (profileMetadata != null) {
            HashMap<ProfileMetadata, String> userMetadata = new HashMap<ProfileMetadata, String>();
            for (Map.Entry<String, String> profileMetadataEntry : profileMetadata.entrySet()) {
                ProfileMetadataImpl metadata = identityService.findProfileMetadataByName(profileMetadataEntry.getKey());
                if (metadata == null) {
                    throw new MetadataNotFoundException("bai_IAPII_11", profileMetadataEntry.getKey());
                }
                metadata.getUsers().put(user, profileMetadataEntry.getValue());
                identityService.updateProfileMetadata(metadata);
                userMetadata.put(metadata, profileMetadataEntry.getValue());
            }
            user.setMetadata(userMetadata);
            identityService.updateUser(user);
        }
        return new UserImpl(user);
    }

    @Override
    public void updateUserDelegee(String userUUID, String delegeeUserUUID) throws UserNotFoundException {
        UserImpl delegee;
        FacadeUtil.checkArgsNotNull(userUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        if (delegeeUserUUID != null && (delegee = identityService.getUser(delegeeUserUUID)) == null) {
            throw new UserNotFoundException("bai_IAPII_15", delegeeUserUUID);
        }
        user.setDelegeeUUID(delegeeUserUUID);
        identityService.updateUser(user);
    }

    @Override
    public void updateUserPersonalContactInfo(String userUUID, String email, String phoneNumber, String mobileNumber, String faxNumber, String building, String room, String address, String zipCode, String city, String state, String country, String website) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        ContactInfoImpl personalContactInfo = this.createContactInfo(email, phoneNumber, mobileNumber, faxNumber, building, room, address, zipCode, city, state, country, website);
        user.setPersonalContactInfo(personalContactInfo);
        identityService.updateUser(user);
    }

    @Override
    public void updateUserProfessionalContactInfo(String userUUID, String email, String phoneNumber, String mobileNumber, String faxNumber, String building, String room, String address, String zipCode, String city, String state, String country, String website) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUID);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(userUUID);
        if (user == null) {
            throw new UserNotFoundException("bai_IAPII_2", userUUID);
        }
        ContactInfoImpl professionalContactInfo = this.createContactInfo(email, phoneNumber, mobileNumber, faxNumber, building, room, address, zipCode, city, state, country, website);
        user.setProfessionalContactInfo(professionalContactInfo);
        identityService.updateUser(user);
    }

    private ContactInfoImpl createContactInfo(String email, String phoneNumber, String mobileNumber, String faxNumber, String building, String room, String address, String zipCode, String city, String state, String country, String website) {
        ContactInfoImpl contactInfo = new ContactInfoImpl();
        contactInfo.setEmail(email);
        contactInfo.setPhoneNumber(phoneNumber);
        contactInfo.setMobileNumber(mobileNumber);
        contactInfo.setFaxNumber(faxNumber);
        contactInfo.setBuilding(building);
        contactInfo.setRoom(room);
        contactInfo.setAddress(address);
        contactInfo.setZipCode(zipCode);
        contactInfo.setCity(city);
        contactInfo.setState(state);
        contactInfo.setCountry(country);
        contactInfo.setWebsite(website);
        return contactInfo;
    }

    @Override
    public void removeGroups(Collection<String> groupUUIDs) throws GroupNotFoundException {
        FacadeUtil.checkArgsNotNull(groupUUIDs);
        IdentityService identityService = EnvTool.getIdentityService();
        for (String groupUUID : groupUUIDs) {
            Set<MembershipImpl> memberships;
            GroupImpl group = identityService.getGroup(groupUUID);
            if (group == null) {
                throw new GroupNotFoundException("bai_IAPII_12", groupUUID);
            }
            List<GroupImpl> children = identityService.getGroupChildren(groupUUID);
            ArrayList<String> childrenUUIDs = new ArrayList<String>();
            for (GroupImpl child : children) {
                childrenUUIDs.add(child.getUUID());
            }
            if (children != null && !children.isEmpty()) {
                this.removeGroups(childrenUUIDs);
            }
            if ((memberships = identityService.getMembershipsByGroup(group.getUUID())) != null) {
                HashSet<String> membershipUUIDs = new HashSet<String>();
                for (MembershipImpl membership : memberships) {
                    List<UserImpl> usersInMembership = identityService.getUsersByMembership(membership.getUUID());
                    for (UserImpl user : usersInMembership) {
                        identityService.removeMembershipFromUser(user, membership);
                    }
                    identityService.deleteMembership(membership);
                    membershipUUIDs.add(membership.getUUID());
                }
                this.removeMembershipsFromRules(membershipUUIDs);
            }
            identityService.deleteGroup(group);
        }
        this.removeGroupsFromRules(groupUUIDs);
    }

    @Override
    public void removeRoles(Collection<String> roleUUIDs) throws RoleNotFoundException {
        FacadeUtil.checkArgsNotNull(roleUUIDs);
        IdentityService identityService = EnvTool.getIdentityService();
        for (String roleUUID : roleUUIDs) {
            RoleImpl role = identityService.getRole(roleUUID);
            if (role == null) {
                throw new RoleNotFoundException("bai_IAPII_3", roleUUID);
            }
            Set<MembershipImpl> memberships = identityService.getMembershipsByRole(role.getUUID());
            if (memberships != null) {
                HashSet<String> membershipUUIDs = new HashSet<String>();
                for (MembershipImpl membership : memberships) {
                    List<UserImpl> usersInMembership = identityService.getUsersByMembership(membership.getUUID());
                    for (UserImpl user : usersInMembership) {
                        identityService.removeMembershipFromUser(user, membership);
                    }
                    identityService.deleteMembership(membership);
                    membershipUUIDs.add(membership.getUUID());
                }
                this.removeMembershipsFromRules(membershipUUIDs);
            }
            identityService.deleteRole(role);
        }
        this.removeRolesFromRules(roleUUIDs);
    }

    @Override
    public void removeUsers(Collection<String> userUUIDs) throws UserNotFoundException {
        FacadeUtil.checkArgsNotNull(userUUIDs);
        IdentityService identityService = EnvTool.getIdentityService();
        for (String userUUID : userUUIDs) {
            UserImpl user = identityService.getUser(userUUID);
            if (user == null) {
                throw new UserNotFoundException("bai_IAPII_2", userUUID);
            }
            List<UserImpl> usersOfManager = identityService.getUsersByManager(userUUID);
            for (UserImpl userOfManager : usersOfManager) {
                userOfManager.setManagerUUID(null);
            }
            List<UserImpl> delegeesUsers = identityService.getUsersByDelegee(userUUID);
            for (UserImpl delegeesUser : delegeesUsers) {
                delegeesUser.setDelegeeUUID(null);
            }
            identityService.deleteUser(user);
        }
        this.removeUsersFromRules(userUUIDs);
    }

    @Override
    public void removeProfileMetadata(Collection<String> profileMetadataUUIDs) throws MetadataNotFoundException {
        Misc.checkArgsNotNull(profileMetadataUUIDs);
        IdentityService identityService = EnvTool.getIdentityService();
        for (String profileMetadataUUID : profileMetadataUUIDs) {
            ProfileMetadataImpl profileMetadata = identityService.getProfileMetadata(profileMetadataUUID);
            if (profileMetadata == null) {
                throw new MetadataNotFoundException("bai_IAPII_11", profileMetadataUUID);
            }
            identityService.deleteProfileMetadata(profileMetadata);
        }
    }

    @Override
    public int getNumberOfProfileMetadata() {
        IdentityService identityService = EnvTool.getIdentityService();
        return identityService.getNumberOfProfileMetadata();
    }

    private void removeMembershipsFromRules(Collection<String> membershipUUIDs) {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        List<Rule> rules = privilegeService.getAllApplicableRules(null, null, null, membershipUUIDs, null);
        for (Rule rule : rules) {
            ((RuleImpl)rule).removeMemberships(membershipUUIDs);
            privilegeService.updateRule(rule);
        }
    }

    private void removeRolesFromRules(Collection<String> roleUUIDs) {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        List<Rule> rules = privilegeService.getAllApplicableRules(null, roleUUIDs, null, null, null);
        for (Rule rule : rules) {
            ((RuleImpl)rule).removeRoles(roleUUIDs);
            privilegeService.updateRule(rule);
        }
    }

    private void removeGroupsFromRules(Collection<String> groupUUIDs) {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        List<Rule> rules = privilegeService.getAllApplicableRules(null, null, groupUUIDs, null, null);
        for (Rule rule : rules) {
            ((RuleImpl)rule).removeGroups(groupUUIDs);
            privilegeService.updateRule(rule);
        }
    }

    private void removeUsersFromRules(Collection<String> userUUIDs) {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        for (String userUUID : userUUIDs) {
            List<Rule> rules = privilegeService.getAllApplicableRules(userUUID, null, null, null, null);
            HashSet<String> userUUIDCollection = new HashSet<String>();
            userUUIDCollection.add(userUUID);
            for (Rule rule : rules) {
                ((RuleImpl)rule).removeUsers(userUUIDCollection);
                privilegeService.updateRule(rule);
            }
        }
    }

    @Override
    public User importUser(String uuid, String username, String passwordHash, String firstName, String lastName, String title, String jobTitle, String managerUserUUID, Map<String, String> profileMetadata) throws UserAlreadyExistsException, MetadataNotFoundException {
        FacadeUtil.checkArgsNotNull(uuid, username, passwordHash);
        IdentityService identityService = EnvTool.getIdentityService();
        UserImpl user = identityService.getUser(uuid);
        if (user != null) {
            throw new UserAlreadyExistsException("bai_IAPII_4", uuid);
        }
        user = identityService.findUserByUsername(username);
        if (user != null) {
            throw new UserAlreadyExistsException("bai_IAPII_4", username);
        }
        UserImpl userToImport = new UserImpl(uuid, username, passwordHash);
        userToImport.setFirstName(firstName);
        userToImport.setLastName(lastName);
        userToImport.setJobTitle(jobTitle);
        userToImport.setTitle(title);
        userToImport.setManagerUUID(managerUserUUID);
        identityService.importUser(userToImport);
        if (profileMetadata != null) {
            HashMap<ProfileMetadata, String> userMetadata = new HashMap<ProfileMetadata, String>();
            for (Map.Entry<String, String> profileMetadataEntry : profileMetadata.entrySet()) {
                ProfileMetadataImpl metadata = identityService.findProfileMetadataByName(profileMetadataEntry.getKey());
                if (metadata == null) {
                    throw new MetadataNotFoundException("bai_IAPII_11", profileMetadataEntry.getKey());
                }
                metadata.getUsers().put(userToImport, profileMetadataEntry.getValue());
                identityService.updateProfileMetadata(metadata);
                userMetadata.put(metadata, profileMetadataEntry.getValue());
            }
            userToImport.setMetadata(userMetadata);
            identityService.updateUser(userToImport);
        }
        return new UserImpl(userToImport);
    }

    @Override
    public Group getGroupUsingPath(List<String> path) {
        FacadeUtil.checkArgsNotNull(path);
        if (path.isEmpty()) {
            return null;
        }
        String groupName = path.get(path.size() - 1);
        IdentityService identityService = EnvTool.getIdentityService();
        Set<GroupImpl> possibleGroups = identityService.findGroupsByName(groupName);
        GroupImpl group = null;
        for (GroupImpl possibleGroup : possibleGroups) {
            if (!this.isAValidGroupPath(possibleGroup, path)) continue;
            group = possibleGroup;
            break;
        }
        if (group != null) {
            return new GroupImpl(group);
        }
        return null;
    }

    private boolean isAValidGroupPath(GroupImpl group, List<String> hierarchy) {
        String groupPath = this.getGroupPath(group);
        String expectedPath = this.getListPath(hierarchy);
        return groupPath.equals(expectedPath);
    }

    private String getListPath(List<String> hierarchy) {
        StringBuilder builder = new StringBuilder();
        for (String groupName : hierarchy) {
            builder.append("/").append(groupName);
        }
        return builder.toString();
    }

    private String getGroupPath(GroupImpl group) {
        StringBuilder builder = new StringBuilder();
        GroupImpl currentGroup = group;
        IdentityService identityService = EnvTool.getIdentityService();
        while (currentGroup != null) {
            builder.insert(0, currentGroup.getName());
            builder.insert(0, "/");
            Group parent = currentGroup.getParentGroup();
            if (parent != null) {
                currentGroup = identityService.getGroup(parent.getUUID());
                continue;
            }
            currentGroup = null;
        }
        return builder.toString();
    }
}

