/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.element.impl.BusinessArchiveImpl;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ParticipantDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ActivityDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.DataFieldDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ParticipantDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.facade.exception.ActivityDefNotFoundException;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.DataFieldNotFoundException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.ParticipantNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.impl.SearchResult;
import org.ow2.bonita.facade.paging.ProcessDefinitionCriterion;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.runtime.impl.InitialAttachmentImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ParticipantDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.light.impl.LightProcessDefinitionImpl;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.DocumentService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

public class QueryDefinitionAPIImpl
implements QueryDefinitionAPI {
    private String queryList;

    protected QueryDefinitionAPIImpl(String queryList) {
        this.queryList = queryList;
    }

    private String getQueryList() {
        return this.queryList;
    }

    private Set<ProcessDefinition> getProcessCopy(Set<ProcessDefinition> src) {
        HashSet<ProcessDefinition> result = new HashSet<ProcessDefinition>();
        if (src != null) {
            for (ProcessDefinition p : src) {
                result.add(new ProcessDefinitionImpl(p));
            }
        }
        return result;
    }

    private Set<ActivityDefinition> getActivityCopy(Set<ActivityDefinition> src) {
        HashSet<ActivityDefinition> result = new HashSet<ActivityDefinition>();
        if (src != null) {
            for (ActivityDefinition p : src) {
                result.add(new ActivityDefinitionImpl(p));
            }
        }
        return result;
    }

    private Set<ParticipantDefinition> getParticipantCopy(Set<ParticipantDefinition> src) {
        HashSet<ParticipantDefinition> result = new HashSet<ParticipantDefinition>();
        if (src != null) {
            for (ParticipantDefinition p : src) {
                result.add(new ParticipantDefinitionImpl(p));
            }
        }
        return result;
    }

    @Override
    public List<ProcessDefinition> getProcesses(int fromIndex, int pageSize) {
        ArrayList<ProcessDefinition> result = new ArrayList<ProcessDefinition>();
        if (pageSize <= 0) {
            return result;
        }
        List<InternalProcessDefinition> processes = this.getIndexedProcesses(fromIndex, pageSize, ProcessDefinitionCriterion.DEFAULT);
        for (InternalProcessDefinition record : processes) {
            result.add(new ProcessDefinitionImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessDefinition> getLightProcesses(int fromIndex, int pageSize) {
        ArrayList<LightProcessDefinition> result = new ArrayList<LightProcessDefinition>();
        if (pageSize <= 0) {
            return result;
        }
        List<InternalProcessDefinition> processes = this.getIndexedProcesses(fromIndex, pageSize, ProcessDefinitionCriterion.DEFAULT);
        for (InternalProcessDefinition record : processes) {
            result.add(new LightProcessDefinitionImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessDefinition> getLightProcesses(int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion) {
        ArrayList<LightProcessDefinition> result = new ArrayList<LightProcessDefinition>();
        if (pageSize <= 0) {
            return result;
        }
        List<InternalProcessDefinition> processes = this.getIndexedProcesses(fromIndex, pageSize, pagingCriterion);
        for (InternalProcessDefinition record : processes) {
            result.add(new LightProcessDefinitionImpl(record));
        }
        return result;
    }

    private List<InternalProcessDefinition> getIndexedProcesses(int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessDefinition> processes = new ArrayList<InternalProcessDefinition>();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && !(visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)).isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(visibleProcessUUIDs, fromIndex, pageSize, pagingCriterion);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(fromIndex, pageSize, pagingCriterion);
        }
        return processes;
    }

    @Override
    public int getNumberOfProcesses() {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        if (!access) {
            return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfProcesses();
        }
        String applicationName = EnvTool.getApplicationAccessName();
        if (applicationName != null) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            return visibleProcessUUIDs.size();
        }
        return 0;
    }

    @Override
    public BusinessArchive getBusinessArchive(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        Misc.checkArgsNotNull(processDefinitionUUID);
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        Map<String, byte[]> resources = ldr.getData(byte[].class, Misc.getBusinessArchiveCategories(processDefinitionUUID));
        BusinessArchiveImpl businessArchive = new BusinessArchiveImpl(processDefinitionUUID, resources);
        return businessArchive;
    }

    private Set<DataFieldDefinition> getDataFieldCopy(Set<DataFieldDefinition> src) {
        HashSet<DataFieldDefinition> result = new HashSet<DataFieldDefinition>();
        if (src != null) {
            for (DataFieldDefinition p : src) {
                result.add(new DataFieldDefinitionImpl(p));
            }
        }
        return result;
    }

    @Override
    public ProcessDefinition getLastProcess(String processId) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processId);
        boolean access = EnvTool.isRestrictedApplicationAcces();
        InternalProcessDefinition last = null;
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName == null) {
                throw new ProcessNotFoundException("bai_QDAPII_2", processId);
            }
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            if (visibleProcessUUIDs.isEmpty()) {
                throw new ProcessNotFoundException("bai_QDAPII_2", processId);
            }
            HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
            for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                InternalProcessDefinition definition = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processUUID);
                if (!processId.equals(definition.getName())) continue;
                definitionUUIDs.add(processUUID);
            }
            last = EnvTool.getAllQueriers(this.getQueryList()).getLastDeployedProcess(definitionUUIDs, ProcessDefinition.ProcessState.ENABLED);
        } else {
            last = EnvTool.getAllQueriers(this.getQueryList()).getLastDeployedProcess(processId, ProcessDefinition.ProcessState.ENABLED);
        }
        if (last == null) {
            throw new ProcessNotFoundException("bai_QDAPII_2", processId);
        }
        return new ProcessDefinitionImpl(last);
    }

    @Override
    public LightProcessDefinition getLastLightProcess(String processId) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processId);
        boolean access = EnvTool.isRestrictedApplicationAcces();
        InternalProcessDefinition last = null;
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName == null) {
                throw new ProcessNotFoundException("bai_QDAPII_2", processId);
            }
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            if (visibleProcessUUIDs.isEmpty()) {
                throw new ProcessNotFoundException("bai_QDAPII_2", processId);
            }
            HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
            for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                InternalProcessDefinition definition = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processUUID);
                if (!processId.equals(definition.getName())) continue;
                definitionUUIDs.add(processUUID);
            }
            last = EnvTool.getAllQueriers(this.getQueryList()).getLastDeployedProcess(definitionUUIDs, ProcessDefinition.ProcessState.ENABLED);
        } else {
            last = EnvTool.getAllQueriers(this.getQueryList()).getLastDeployedProcess(processId, ProcessDefinition.ProcessState.ENABLED);
        }
        if (last == null) {
            throw new ProcessNotFoundException("bai_QDAPII_2", processId);
        }
        return new LightProcessDefinitionImpl(last);
    }

    private InternalProcessDefinition getInternalProcess(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_5", processUUID);
        }
        return process;
    }

    @Override
    public ProcessDefinition getProcess(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        InternalProcessDefinition process = this.getInternalProcess(processUUID);
        return new ProcessDefinitionImpl(process);
    }

    @Override
    public LightProcessDefinition getLightProcess(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_5", processUUID);
        }
        return new LightProcessDefinitionImpl(process);
    }

    @Override
    public ProcessDefinition getProcess(String processId, String processVersion) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processId, processVersion);
        InternalProcessDefinition process = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processId, processVersion);
        if (process == null) {
            throw new ProcessNotFoundException(processId, processVersion);
        }
        boolean access = EnvTool.isRestrictedApplicationAcces();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName == null) {
                throw new ProcessNotFoundException(processId, processVersion);
            }
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            if (visibleProcessUUIDs == null || !visibleProcessUUIDs.contains(process.getUUID())) {
                throw new ProcessNotFoundException(processId, processVersion);
            }
        }
        return new ProcessDefinitionImpl(process);
    }

    @Override
    public Set<ActivityDefinition> getProcessActivities(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_7", processUUID);
        }
        Set<ActivityDefinition> activities = process.getActivities();
        return this.getActivityCopy(activities);
    }

    @Override
    public ActivityDefinition getProcessActivity(ProcessDefinitionUUID processUUID, String activityId) throws ProcessNotFoundException, ActivityNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID, activityId);
        InternalProcessDefinition process = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_8", processUUID);
        }
        Set<ActivityDefinition> activities = process.getActivities();
        if (activities != null) {
            for (ActivityDefinition activityDefinition : activities) {
                if (!activityDefinition.getName().equals(activityId)) continue;
                return new ActivityDefinitionImpl(activityDefinition);
            }
        }
        throw new ActivityNotFoundException("bai_QDAPII_9", processUUID, activityId);
    }

    @Override
    public ParticipantDefinition getProcessParticipant(ProcessDefinitionUUID processUUID, String participantId) throws ProcessNotFoundException, ParticipantNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID, participantId);
        Set<ParticipantDefinition> participants = this.getProcessParticipants(processUUID);
        if (participants != null) {
            for (ParticipantDefinition participant : participants) {
                if (!participant.getName().equals(participantId)) continue;
                return new ParticipantDefinitionImpl(participant);
            }
        }
        throw new ParticipantNotFoundException("bai_QDAPII_10", participantId, processUUID);
    }

    @Override
    public Set<ParticipantDefinition> getProcessParticipants(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        InternalProcessDefinition process = this.getInternalProcess(processUUID);
        Set<ParticipantDefinition> participants = process.getParticipants();
        return this.getParticipantCopy(participants);
    }

    @Override
    public Set<ProcessDefinition> getProcesses() {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses();
        }
        return this.getProcessCopy(processes);
    }

    @Override
    public Set<LightProcessDefinition> getLightProcesses() {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses();
        }
        HashSet<LightProcessDefinition> result = new HashSet<LightProcessDefinition>();
        for (InternalProcessDefinition internalProcessDefinition : processes) {
            result.add(new LightProcessDefinitionImpl(internalProcessDefinition));
        }
        return result;
    }

    @Override
    public Set<ProcessDefinition> getProcesses(String processId) {
        FacadeUtil.checkArgsNotNull(processId);
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
                for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                    InternalProcessDefinition definition = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processUUID);
                    if (!processId.equals(definition.getName())) continue;
                    definitionUUIDs.add(processUUID);
                }
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(definitionUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(processId);
        }
        return this.getProcessCopy(processes);
    }

    @Override
    public ParticipantDefinitionUUID getProcessParticipantId(ProcessDefinitionUUID processUUID, String participantName) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID, participantName);
        Set<ParticipantDefinition> participants = this.getProcessParticipants(processUUID);
        if (participants != null) {
            for (ParticipantDefinition participant : participants) {
                if (!participantName.equals(participant.getName())) continue;
                return participant.getUUID();
            }
        }
        return null;
    }

    @Override
    public ActivityDefinitionUUID getProcessActivityId(ProcessDefinitionUUID processUUID, String activityName) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID, activityName);
        Set<ActivityDefinition> activities = this.getProcessActivities(processUUID);
        if (activities != null) {
            for (ActivityDefinition activity : activities) {
                if (!activityName.equals(activity.getName())) continue;
                return activity.getUUID();
            }
        }
        return null;
    }

    @Override
    public Set<ProcessDefinition> getProcesses(String processId, ProcessDefinition.ProcessState processState) {
        FacadeUtil.checkArgsNotNull(new Object[]{processId, processState});
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<ProcessDefinition> processes = new HashSet<ProcessDefinition>();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
                for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                    InternalProcessDefinition definition = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processUUID);
                    if (!processId.equals(definition.getName())) continue;
                    definitionUUIDs.add(processUUID);
                }
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(definitionUUIDs, processState);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(processId, processState);
        }
        return this.getProcessCopy(processes);
    }

    @Override
    public Set<ProcessDefinition> getProcesses(ProcessDefinition.ProcessState processState) {
        FacadeUtil.checkArgsNotNull(new Object[]{processState});
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
                for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                    definitionUUIDs.add(processUUID);
                }
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(definitionUUIDs, processState);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(processState);
        }
        return this.getProcessCopy(processes);
    }

    @Override
    public Set<LightProcessDefinition> getLightProcesses(ProcessDefinition.ProcessState processState) {
        FacadeUtil.checkArgsNotNull(new Object[]{processState});
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                HashSet<ProcessDefinitionUUID> hashSet = new HashSet<ProcessDefinitionUUID>();
                for (ProcessDefinitionUUID processUUID : visibleProcessUUIDs) {
                    hashSet.add(processUUID);
                }
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(hashSet, processState);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(processState);
        }
        HashSet<LightProcessDefinition> result = new HashSet<LightProcessDefinition>();
        for (InternalProcessDefinition internalProcessDefinition : processes) {
            result.add(new LightProcessDefinitionImpl(internalProcessDefinition));
        }
        return result;
    }

    @Override
    public DataFieldDefinition getProcessDataField(ProcessDefinitionUUID processDefinitionUUID, String dataFieldId) throws ProcessNotFoundException, DataFieldNotFoundException {
        FacadeUtil.checkArgsNotNull(processDefinitionUUID, dataFieldId);
        Set<DataFieldDefinition> datafields = this.getProcessDataFields(processDefinitionUUID);
        if (datafields != null) {
            for (DataFieldDefinition datefield : datafields) {
                if (!datefield.getName().equals(dataFieldId)) continue;
                return new DataFieldDefinitionImpl(datefield);
            }
        }
        throw new DataFieldNotFoundException("bai_QDAPII_14", dataFieldId, processDefinitionUUID);
    }

    @Override
    public Set<DataFieldDefinition> getProcessDataFields(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        InternalProcessDefinition process = this.getInternalProcess(processDefinitionUUID);
        Set<DataFieldDefinition> datafields = process.getDataFields();
        return this.getDataFieldCopy(datafields);
    }

    @Override
    public Set<DataFieldDefinition> getActivityDataFields(ActivityDefinitionUUID activityDefinitionUUID) throws ActivityDefNotFoundException {
        FacadeUtil.checkArgsNotNull(activityDefinitionUUID);
        InternalActivityDefinition activity = EnvTool.getAllQueriers(this.getQueryList()).getActivity(activityDefinitionUUID);
        if (activity == null) {
            throw new ActivityDefNotFoundException("bai_QDAPII_16", activityDefinitionUUID);
        }
        Set<DataFieldDefinition> datafields = activity.getDataFields();
        return this.getDataFieldCopy(datafields);
    }

    @Override
    public DataFieldDefinition getActivityDataField(ActivityDefinitionUUID activityDefinitionUUID, String dataFieldId) throws ActivityDefNotFoundException, DataFieldNotFoundException {
        FacadeUtil.checkArgsNotNull(activityDefinitionUUID);
        InternalActivityDefinition activity = EnvTool.getAllQueriers(this.getQueryList()).getActivity(activityDefinitionUUID);
        if (activity == null) {
            throw new ActivityDefNotFoundException("bai_QDAPII_17", activityDefinitionUUID);
        }
        Set<DataFieldDefinition> datafields = activity.getDataFields();
        if (datafields != null) {
            for (DataFieldDefinition datefield : datafields) {
                if (!datefield.getName().equals(dataFieldId)) continue;
                return new DataFieldDefinitionImpl(datefield);
            }
        }
        throw new DataFieldNotFoundException("bai_QDAPII_18", dataFieldId, activityDefinitionUUID);
    }

    @Override
    public String getProcessMetaData(ProcessDefinitionUUID uuid, String key) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(uuid, key);
        InternalProcessDefinition process = EnvTool.getAllQueriers(this.getQueryList()).getProcess(uuid);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_19", uuid);
        }
        return process.getAMetaData(key);
    }

    private InitialAttachment getProcessAttachment(DocumentationManager manager, ProcessDefinitionUUID processUUID, AttachmentDefinition attachment) {
        SearchResult result = DocumentService.getDocuments(manager, processUUID, attachment.getName());
        List<Document> documents = result.getDocuments();
        byte[] content = null;
        if (!documents.isEmpty()) {
            try {
                content = manager.getContent(documents.get(0));
            }
            catch (DocumentNotFoundException e) {
                throw new BonitaRuntimeException(e);
            }
        }
        return new InitialAttachmentImpl(attachment, content);
    }

    @Override
    public InitialAttachment getProcessAttachment(ProcessDefinitionUUID processUUID, String attachmentName) throws ProcessNotFoundException {
        InternalProcessDefinition process = this.getInternalProcess(processUUID);
        AttachmentDefinition attachment = process.getAttachment(attachmentName);
        if (attachment == null) {
            return null;
        }
        DocumentationManager manager = EnvTool.getDocumentationManager();
        return this.getProcessAttachment(manager, processUUID, attachment);
    }

    @Override
    public Set<InitialAttachment> getProcessAttachments(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        InternalProcessDefinition process = this.getInternalProcess(processUUID);
        Map<String, AttachmentDefinition> processAttachments = process.getAttachments();
        HashSet<InitialAttachment> attachments = new HashSet<InitialAttachment>();
        if (!processAttachments.isEmpty()) {
            DocumentationManager manager = EnvTool.getDocumentationManager();
            for (AttachmentDefinition attachment : processAttachments.values()) {
                InitialAttachment attach = this.getProcessAttachment(manager, processUUID, attachment);
                attachments.add(attach);
            }
        }
        return attachments;
    }

    @Override
    public AttachmentDefinition getAttachmentDefinition(ProcessDefinitionUUID processUUID, String attachmentName) throws ProcessNotFoundException {
        InternalProcessDefinition process = this.getInternalProcess(processUUID);
        return process.getAttachment(attachmentName);
    }

    @Override
    public Set<AttachmentDefinition> getAttachmentDefinitions(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        InternalProcessDefinition process = this.getInternalProcess(processUUID);
        Map<String, AttachmentDefinition> processAttachments = process.getAttachments();
        HashSet<AttachmentDefinition> attachments = new HashSet<AttachmentDefinition>();
        if (!processAttachments.isEmpty()) {
            for (Map.Entry<String, AttachmentDefinition> processAttachment : processAttachments.entrySet()) {
                attachments.add(processAttachment.getValue());
            }
        }
        return attachments;
    }

    @Override
    public byte[] getResource(ProcessDefinitionUUID definitionUUID, String resourcePath) throws ProcessNotFoundException {
        this.getInternalProcess(definitionUUID);
        ClassLoader classLoader = EnvTool.getClassDataLoader().getProcessClassLoader(definitionUUID);
        InputStream in = classLoader.getResourceAsStream(resourcePath);
        byte[] resource = null;
        if (in != null) {
            try {
                resource = Misc.getAllContentFrom(in);
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return resource;
    }

    @Override
    public Set<LightProcessDefinition> getLightProcesses(Set<ProcessDefinitionUUID> processUUIDs) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        Set<InternalProcessDefinition> processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(processUUIDs);
        HashSet<LightProcessDefinition> result = new HashSet<LightProcessDefinition>();
        for (InternalProcessDefinition p : processes) {
            result.add(new LightProcessDefinitionImpl(p));
        }
        return result;
    }

    @Override
    public List<LightProcessDefinition> getLightProcesses(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion) {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        if (processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        List<InternalProcessDefinition> processes = EnvTool.getAllQueriers(this.getQueryList()).getProcesses(processUUIDs, fromIndex, pageSize, pagingCriterion);
        ArrayList<LightProcessDefinition> result = new ArrayList<LightProcessDefinition>();
        for (InternalProcessDefinition p : processes) {
            result.add(new LightProcessDefinitionImpl(p));
        }
        return result;
    }

    @Override
    public List<LightProcessDefinition> getAllLightProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize) {
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return this.getLightProcesses(fromIndex, pageSize);
        }
        List<InternalProcessDefinition> processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessesExcept(processUUIDs, fromIndex, pageSize);
        ArrayList<LightProcessDefinition> result = new ArrayList<LightProcessDefinition>();
        for (InternalProcessDefinition p : processes) {
            result.add(new LightProcessDefinitionImpl(p));
        }
        return result;
    }

    @Override
    public List<LightProcessDefinition> getAllLightProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion) {
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return this.getLightProcesses(fromIndex, pageSize, pagingCriterion);
        }
        List<InternalProcessDefinition> processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessesExcept(processUUIDs, fromIndex, pageSize, pagingCriterion);
        ArrayList<LightProcessDefinition> result = new ArrayList<LightProcessDefinition>();
        for (InternalProcessDefinition p : processes) {
            result.add(new LightProcessDefinitionImpl(p));
        }
        return result;
    }

    @Override
    public Set<ProcessDefinitionUUID> getProcessUUIDs(String category) {
        FacadeUtil.checkArgsNotNull(category);
        if (category.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        Set<ProcessDefinitionUUID> processUUIDs = EnvTool.getAllQueriers(this.getQueryList()).getProcessUUIDsFromCategory(category);
        HashSet<ProcessDefinitionUUID> result = new HashSet<ProcessDefinitionUUID>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            result.add(new ProcessDefinitionUUID(uuid));
        }
        return result;
    }

    @Override
    public Set<ActivityDefinitionUUID> getProcessTaskUUIDs(ProcessDefinitionUUID defintionUUID) throws ProcessNotFoundException {
        boolean exist = EnvTool.getAllQueriers(this.getQueryList()).processExists(defintionUUID);
        if (!exist) {
            throw new ProcessNotFoundException("bai_QDAPII_19", defintionUUID);
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getProcessTaskUUIDs(defintionUUID);
    }

    @Override
    public Date getMigrationDate(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_5", processUUID);
        }
        return process.getMigrationDate();
    }
}

