/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.EventNotFoundException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.TaskNotFoundException;
import org.ow2.bonita.facade.exception.VariableNotFoundException;
import org.ow2.bonita.facade.identity.impl.GroupImpl;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.impl.SearchResult;
import org.ow2.bonita.facade.paging.ActivityInstanceCriterion;
import org.ow2.bonita.facade.paging.ProcessInstanceCriterion;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.CatchingEvent;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.VariableUpdate;
import org.ow2.bonita.facade.runtime.impl.ActivityInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.AttachmentInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.CaseImpl;
import org.ow2.bonita.facade.runtime.impl.CatchingEventImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.ProcessInstanceImpl;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.CatchingEventUUID;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightActivityInstance;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.light.LightTaskInstance;
import org.ow2.bonita.light.impl.LightActivityInstanceImpl;
import org.ow2.bonita.light.impl.LightProcessDefinitionImpl;
import org.ow2.bonita.light.impl.LightProcessInstanceImpl;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.search.DocumentResult;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.search.SearchQueryBuilder;
import org.ow2.bonita.search.index.Index;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.CopyTool;
import org.ow2.bonita.util.DateUtil;
import org.ow2.bonita.util.DocumentService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.TransientData;
import org.xml.sax.SAXException;

public class QueryRuntimeAPIImpl
implements QueryRuntimeAPI {
    private String queryList;

    protected QueryRuntimeAPIImpl(String queryList) {
        this.queryList = queryList;
    }

    private String getQueryList() {
        return this.queryList;
    }

    @Override
    public int getNumberOfParentProcessInstances() {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        int count = 0;
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            if (visibleProcessUUIDs != null) {
                count = EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstances(visibleProcessUUIDs);
            }
        } else {
            count = EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstances();
        }
        return count;
    }

    @Override
    public int getNumberOfProcessInstances() {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        int count = 0;
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
            if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                count = EnvTool.getAllQueriers(this.getQueryList()).getNumberOfProcessInstances(visibleProcessUUIDs);
            }
        } else {
            count = EnvTool.getAllQueriers(this.getQueryList()).getNumberOfProcessInstances();
        }
        return count;
    }

    @Override
    public ProcessInstance getProcessInstance(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException {
        InternalProcessInstance instance = this.getInternalProcessInstanceWithAttachments(instanceUUID);
        if (instance == null) {
            throw new InstanceNotFoundException("bai_QRAPII_1", instanceUUID);
        }
        return new ProcessInstanceImpl(instance);
    }

    @Override
    public LightProcessInstance getLightProcessInstance(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException {
        InternalProcessInstance result = this.getInternalProcessInstanceWithoutAttachements(instanceUUID);
        if (result == null) {
            throw new InstanceNotFoundException("bai_QRAPII_1", instanceUUID);
        }
        return new LightProcessInstanceImpl(result);
    }

    private InternalProcessInstance getInternalProcessInstanceWithAttachments(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException {
        InternalProcessInstance internalProcessInstance = this.getInternalProcessInstanceWithoutAttachements(instanceUUID);
        if (internalProcessInstance != null && internalProcessInstance.getNbOfAttachments() > 0) {
            this.bindAttachementsToInternalProcessInstance(internalProcessInstance);
        }
        return internalProcessInstance;
    }

    private void bindAttachementsToInternalProcessInstance(InternalProcessInstance internalProcessInstance) {
        int nbOfAttachments;
        if (internalProcessInstance != null && (nbOfAttachments = internalProcessInstance.getNbOfAttachments()) > 0) {
            DocumentationManager manager = EnvTool.getDocumentationManager();
            List<AttachmentInstance> allAttachmentVersions = DocumentService.getAllAttachmentVersions(manager, internalProcessInstance.getProcessInstanceUUID());
            for (AttachmentInstance attachmentInstance : allAttachmentVersions) {
                internalProcessInstance.addAttachment(attachmentInstance);
            }
        }
    }

    private InternalProcessInstance getInternalProcessInstanceWithoutAttachements(ProcessInstanceUUID instanceUUID) {
        FacadeUtil.checkArgsNotNull(instanceUUID);
        Querier querier = EnvTool.getAllQueriers(this.getQueryList());
        InternalProcessInstance result = querier.getProcessInstance(instanceUUID);
        return result;
    }

    @Override
    public Set<ProcessInstance> getProcessInstances() {
        Set<InternalProcessInstance> processes = this.getInternalProcessInstancesWithAttachements();
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new ProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightProcessInstance> getLightProcessInstances() {
        Set<InternalProcessInstance> processes = this.getInternalProcessInstancesWithoutAttachements();
        HashSet<LightProcessInstance> result = new HashSet<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    private Set<InternalProcessInstance> getInternalProcessInstancesWithoutAttachements() {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances();
        }
        return processes;
    }

    private Set<InternalProcessInstance> getInternalProcessInstancesWithAttachements() {
        Set<InternalProcessInstance> processes = this.getInternalProcessInstancesWithoutAttachements();
        this.bindAttachementsToInternalProcessInstances(processes);
        return processes;
    }

    private void bindAttachementsToInternalProcessInstances(Set<InternalProcessInstance> processes) {
        for (InternalProcessInstance internalProcessInstance : processes) {
            this.bindAttachementsToInternalProcessInstance(internalProcessInstance);
        }
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(int fromIndex, int pageSize) {
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        if (pageSize <= 0) {
            return result;
        }
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<Object> processes = new ArrayList();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(visibleProcessUUIDs, fromIndex, pageSize);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(fromIndex, pageSize);
        }
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        if (pageSize <= 0) {
            return result;
        }
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<Object> processes = new ArrayList();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(visibleProcessUUIDs, fromIndex, pageSize, pagingCriterion);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(fromIndex, pageSize, pagingCriterion);
        }
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstances(int fromIndex, int pageSize) {
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        if (pageSize <= 0) {
            return result;
        }
        List<InternalProcessInstance> records = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstances(fromIndex, pageSize);
        for (InternalProcessInstance record : records) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstances(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        Misc.checkArgsNotNull(processUUIDs);
        if (processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        List<InternalProcessInstance> processes = this.getParentProcessInstances(processUUIDs, fromIndex, pageSize, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    private List<InternalProcessInstance> getParentProcessInstances(Set<ProcessDefinitionUUID> processUUIDs, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null || visibleProcessUUIDs.isEmpty()) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstances(visibleProcessUUIDs, startingIndex, pageSize, pagingCriterion);
                }
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstances(processUUIDs, startingIndex, pageSize, pagingCriterion);
        }
        return processes;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesExcept(Set<ProcessDefinitionUUID> exceptions, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        if (exceptions == null || exceptions.isEmpty()) {
            return this.getLightParentProcessInstances(fromIndex, pageSize, pagingCriterion);
        }
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<Object> processes = new ArrayList();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null || visibleProcessUUIDs.isEmpty()) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.removeAll(exceptions);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstances(visibleProcessUUIDs, fromIndex, pageSize, pagingCriterion);
                }
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesExcept(exceptions, fromIndex, pageSize, pagingCriterion);
        }
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance internalProcessInstance : processes) {
            result.add(new LightProcessInstanceImpl(internalProcessInstance));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstances(int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        if (pageSize <= 0) {
            return result;
        }
        List<InternalProcessInstance> records = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstances(fromIndex, pageSize, pagingCriterion);
        for (InternalProcessInstance record : records) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<ProcessInstance> getUserInstances() {
        Set<InternalProcessInstance> processes = this.getUserProcessInstances();
        this.bindAttachementsToInternalProcessInstances(processes);
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new ProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightProcessInstance> getLightUserInstances() {
        Set<InternalProcessInstance> processes = this.getUserProcessInstances();
        HashSet<LightProcessInstance> result = new HashSet<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstances(int startingIndex, int pageSize) {
        List<InternalProcessInstance> processes = this.getUserParentProcessInstances(startingIndex, pageSize);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstances(int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        List<InternalProcessInstance> processes = this.getUserParentProcessInstances(fromIndex, pageSize, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUser(String userId, int fromIndex, int pageSize) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithActiveUser(userId, fromIndex, pageSize);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUser(String userId, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithActiveUser(userId, fromIndex, pageSize, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, int fromIndex, int pageSize) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, remainingDays, fromIndex, pageSize);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, remainingDays, fromIndex, pageSize, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasks(String userId, int fromIndex, int pageSize) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithOverdueTasks(userId, fromIndex, pageSize, ProcessInstanceCriterion.DEFAULT);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasks(String userId, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithOverdueTasks(userId, fromIndex, pageSize, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithOverdueTasks(String userId, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        Date currentDate = new Date();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithOverdueTasks(userId, currentDate, fromIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithOverdueTasks(userId, currentDate, fromIndex, pageSize, pagingCriterion);
        }
        return processes;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithOverdueTasks(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        Date currentDate = new Date();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithOverdueTasks(userId, currentDate, fromIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
                }
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithOverdueTasks(userId, currentDate, fromIndex, pageSize, processUUIDs, pagingCriterion);
        }
        return processes;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, int startingIndex, int pageSize) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        Date currentDate = new Date();
        Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(currentDate);
        Date atRisk = DateUtil.backTo(beginningOfTheDay, -(remainingDays + 1));
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize, visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize);
        }
        return processes;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        Date currentDate = new Date();
        Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(currentDate);
        Date atRisk = DateUtil.backTo(beginningOfTheDay, -(remainingDays + 1));
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize, pagingCriterion);
        }
        return processes;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        Date currentDate = new Date();
        Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(currentDate);
        Date atRisk = DateUtil.backTo(beginningOfTheDay, -(remainingDays + 1));
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize, visibleProcessUUIDs);
                }
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize, processUUIDs);
        }
        return processes;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        Date currentDate = new Date();
        Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(currentDate);
        Date atRisk = DateUtil.backTo(beginningOfTheDay, -(remainingDays + 1));
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
                }
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, startingIndex, pageSize, processUUIDs, pagingCriterion);
        }
        return processes;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        List<InternalProcessInstance> internalProcesses = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize, processUUIDs);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : internalProcesses) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUser(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        List<InternalProcessInstance> internalProcesses = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithInvolvedUser(userId, fromIndex, pageSize, processUUIDs, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : internalProcesses) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUser(String userId) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithActiveUser(userId, visibleProcessUUIDs);
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithActiveUser(userId);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String userId, int remainingDays) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Date currentDate = new Date();
        Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(currentDate);
        Date atRisk = DateUtil.backTo(beginningOfTheDay, -(remainingDays + 1));
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk, visibleProcessUUIDs);
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(userId, currentDate, atRisk);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithOverdueTasks(String userId) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Date currentDate = new Date();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithOverdueTasks(userId, currentDate, visibleProcessUUIDs);
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithOverdueTasks(userId, currentDate);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUser(String userId) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithInvolvedUser(userId, visibleProcessUUIDs);
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithInvolvedUser(userId);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUserAndCategory(String userId, String category) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<ProcessDefinitionUUID> targetedProcesses = EnvTool.getAllQueriers(this.getQueryList()).getProcessUUIDsFromCategory(category);
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                visibleProcessUUIDs.retainAll(targetedProcesses);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithInvolvedUser(userId, visibleProcessUUIDs);
                }
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithInvolvedUser(userId, targetedProcesses);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithStartedBy(String userId) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithStartedBy(userId, visibleProcessUUIDs);
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithStartedBy(userId);
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String userId, int startingIndex, int pageSize) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUser(userId, startingIndex, pageSize, visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUser(userId, startingIndex, pageSize);
        }
        return processes;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String userId, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUser(userId, startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUser(userId, startingIndex, pageSize, pagingCriterion);
        }
        return processes;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String userId, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null || visibleProcessUUIDs.isEmpty()) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUser(userId, startingIndex, pageSize, visibleProcessUUIDs);
                }
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUser(userId, startingIndex, pageSize, processUUIDs);
        }
        return processes;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithActiveUser(String userId, int startingIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null || visibleProcessUUIDs.isEmpty()) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUser(userId, startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
                }
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithActiveUser(userId, startingIndex, pageSize, processUUIDs, pagingCriterion);
        }
        return processes;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithInvolvedUser(String userId, int startingIndex, int pageSize) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithInvolvedUser(userId, startingIndex, pageSize, visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithInvolvedUser(userId, startingIndex, pageSize);
        }
        return processes;
    }

    private List<InternalProcessInstance> getParentProcessInstancesWithInvolvedUser(String userId, int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithInvolvedUser(userId, startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentProcessInstancesWithInvolvedUser(userId, startingIndex, pageSize, pagingCriterion);
        }
        return processes;
    }

    private List<InternalProcessInstance> getUserParentProcessInstances(int startingIndex, int pageSize) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getParentUserInstances(EnvTool.getUserId(), startingIndex, pageSize, visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentUserInstances(EnvTool.getUserId(), startingIndex, pageSize);
        }
        return processes;
    }

    private List<InternalProcessInstance> getUserParentProcessInstances(int startingIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getParentUserInstances(EnvTool.getUserId(), startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentUserInstances(EnvTool.getUserId(), startingIndex, pageSize, pagingCriterion);
        }
        return processes;
    }

    private List<InternalProcessInstance> getUserParentProcessInstances(int startingIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    processes = EnvTool.getAllQueriers(this.getQueryList()).getParentUserInstances(EnvTool.getUserId(), startingIndex, pageSize, visibleProcessUUIDs);
                }
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentUserInstances(EnvTool.getUserId(), startingIndex, pageSize, processUUIDs);
        }
        return processes;
    }

    private List<InternalProcessInstance> getUserParentProcessInstances(int startingIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        List<InternalProcessInstance> processes = new ArrayList<InternalProcessInstance>();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    processes = EnvTool.getAllQueriers(this.getQueryList()).getParentUserInstances(EnvTool.getUserId(), startingIndex, pageSize, visibleProcessUUIDs, pagingCriterion);
                }
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getParentUserInstances(EnvTool.getUserId(), startingIndex, pageSize, processUUIDs, pagingCriterion);
        }
        return processes;
    }

    private Set<InternalProcessInstance> getUserProcessInstances() {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<InternalProcessInstance> processes = new HashSet<InternalProcessInstance>();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getUserInstances(EnvTool.getUserId(), visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getUserInstances(EnvTool.getUserId());
        }
        return processes;
    }

    @Override
    public Set<ProcessInstance> getProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs) {
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        if (instanceUUIDs == null || instanceUUIDs.isEmpty()) {
            return result;
        }
        for (InternalProcessInstance record : EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(instanceUUIDs)) {
            this.bindAttachementsToInternalProcessInstance(record);
            result.add(new ProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightProcessInstance> getLightProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs) {
        HashSet<LightProcessInstance> result = new HashSet<LightProcessInstance>();
        if (instanceUUIDs == null || instanceUUIDs.isEmpty()) {
            return result;
        }
        for (InternalProcessInstance record : EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(instanceUUIDs)) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, int fromIndex, int pageSize) {
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        if (pageSize <= 0) {
            return result;
        }
        if (instanceUUIDs == null || instanceUUIDs.isEmpty()) {
            return result;
        }
        for (InternalProcessInstance record : EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(instanceUUIDs, fromIndex, pageSize)) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(Set<ProcessInstanceUUID> instanceUUIDs, int fromIndex, int pageSize, ProcessInstanceCriterion pagingCriterion) {
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        if (pageSize <= 0) {
            return result;
        }
        if (instanceUUIDs == null || instanceUUIDs.isEmpty()) {
            return result;
        }
        for (InternalProcessInstance record : EnvTool.getAllQueriers(this.getQueryList()).getProcessInstancesWithInstanceUUIDs(instanceUUIDs, fromIndex, pageSize, pagingCriterion)) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<ProcessInstance> getProcessInstancesWithTaskState(Collection<ActivityState> activityStates) {
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        if (activityStates == null || activityStates.isEmpty()) {
            return result;
        }
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstancesWithTaskState(activityStates, visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstancesWithTaskState(activityStates);
        }
        for (InternalProcessInstance record : processes) {
            this.bindAttachementsToInternalProcessInstance(record);
            result.add(new ProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<ProcessInstance> getProcessInstancesWithInstanceStates(Collection<InstanceState> instanceStates) {
        Misc.checkArgsNotNull(instanceStates);
        if (instanceStates.isEmpty()) {
            throw new IllegalArgumentException(ExceptionManager.getInstance().getMessage("bai_QRAPII_15", new Object[0]));
        }
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<Object> processes = new HashSet();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstancesWithInstanceStates(instanceStates, visibleProcessUUIDs);
            }
        } else {
            processes = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstancesWithInstanceStates(instanceStates);
        }
        for (InternalProcessInstance record : processes) {
            this.bindAttachementsToInternalProcessInstance(record);
            result.add(new ProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<ProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID) {
        HashSet<ProcessInstance> result = new HashSet<ProcessInstance>();
        for (InternalProcessInstance record : EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(processUUID)) {
            this.bindAttachementsToInternalProcessInstance(record);
            result.add(new ProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightProcessInstance> getLightProcessInstances(ProcessDefinitionUUID processUUID) {
        HashSet<LightProcessInstance> result = new HashSet<LightProcessInstance>();
        for (InternalProcessInstance record : EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(processUUID)) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightProcessInstance> getLightWeightProcessInstances(Set<ProcessDefinitionUUID> processUUIDs) {
        HashSet<LightProcessInstance> result = new HashSet<LightProcessInstance>();
        for (InternalProcessInstance record : EnvTool.getAllQueriers(this.getQueryList()).getProcessInstances(processUUIDs)) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    public ActivityInstance getActivityInstance(ProcessInstanceUUID instanceUUID, String activityId, String iterationId, String activityInstanceId, String loopId) throws ActivityNotFoundException, InstanceNotFoundException {
        InternalActivityInstance result = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstance(instanceUUID, activityId, iterationId, activityInstanceId, loopId);
        if (result == null) {
            if (EnvTool.getAllQueriers(this.getQueryList()).getProcessInstance(instanceUUID) == null) {
                throw new InstanceNotFoundException("bai_QRAPII_2", instanceUUID);
            }
            throw new ActivityNotFoundException("bai_QRAPII_3", instanceUUID, activityId, iterationId);
        }
        return new ActivityInstanceImpl(result);
    }

    @Override
    public boolean canExecuteTask(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        TaskInstance task = this.getTask(taskUUID);
        if (task == null) {
            return false;
        }
        if (!task.getState().equals((Object)ActivityState.READY)) {
            return false;
        }
        String userId = EnvTool.getUserId();
        if (task.isTaskAssigned()) {
            return task.getTaskUser().equals(userId);
        }
        return task.getTaskCandidates().contains(userId);
    }

    @Override
    public Set<ActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID) {
        HashSet<ActivityInstance> result = new HashSet<ActivityInstance>();
        for (InternalActivityInstance record : EnvTool.getAllQueriers(this.getQueryList()).getActivityInstances(instanceUUID)) {
            result.add(new ActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightActivityInstance> getLightActivityInstancesFromRoot(ProcessInstanceUUID rootInstanceUUID) {
        ArrayList<LightActivityInstance> result = new ArrayList<LightActivityInstance>();
        List<InternalActivityInstance> activities = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesFromRoot(rootInstanceUUID);
        for (InternalActivityInstance record : activities) {
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Map<ProcessInstanceUUID, List<LightActivityInstance>> getLightActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, ActivityState state) {
        HashMap<ProcessInstanceUUID, List<LightActivityInstance>> result = new HashMap<ProcessInstanceUUID, List<LightActivityInstance>>();
        List<InternalActivityInstance> activities = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesFromRoot(rootInstanceUUIDs, state);
        for (InternalActivityInstance activity : activities) {
            ProcessInstanceUUID instanceUUID = activity.getRootInstanceUUID();
            if (!result.containsKey(instanceUUID)) {
                result.put(instanceUUID, new ArrayList());
            }
            ((List)result.get(instanceUUID)).add(new LightActivityInstanceImpl(activity));
        }
        return result;
    }

    @Override
    public Map<ProcessInstanceUUID, List<LightActivityInstance>> getLightActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs) {
        HashMap<ProcessInstanceUUID, List<LightActivityInstance>> result = new HashMap<ProcessInstanceUUID, List<LightActivityInstance>>();
        List<InternalActivityInstance> activities = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesFromRoot(rootInstanceUUIDs);
        for (InternalActivityInstance activity : activities) {
            ProcessInstanceUUID instanceUUID = activity.getRootInstanceUUID();
            if (!result.containsKey(instanceUUID)) {
                result.put(instanceUUID, new ArrayList());
            }
            ((List)result.get(instanceUUID)).add(new LightActivityInstanceImpl(activity));
        }
        return result;
    }

    @Override
    public Map<ProcessInstanceUUID, LightActivityInstance> getLightLastUpdatedActivityInstanceFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, boolean considerSystemTaks) {
        HashMap<ProcessInstanceUUID, LightActivityInstance> result = new HashMap<ProcessInstanceUUID, LightActivityInstance>();
        Map<ProcessInstanceUUID, InternalActivityInstance> temp = EnvTool.getAllQueriers(this.getQueryList()).getLastUpdatedActivityInstanceFromRoot(rootInstanceUUIDs, considerSystemTaks);
        for (Map.Entry<ProcessInstanceUUID, InternalActivityInstance> entry : temp.entrySet()) {
            result.put(entry.getKey(), new LightActivityInstanceImpl(entry.getValue()));
        }
        return result;
    }

    @Override
    public List<LightTaskInstance> getLightTaskInstancesFromRoot(ProcessInstanceUUID rootInstanceUUID) {
        ArrayList<LightTaskInstance> result = new ArrayList<LightTaskInstance>();
        for (InternalActivityInstance record : EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesFromRoot(rootInstanceUUID)) {
            if (!record.isTask()) continue;
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Map<ProcessInstanceUUID, List<LightTaskInstance>> getLightTaskInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs) {
        HashMap<ProcessInstanceUUID, List<LightTaskInstance>> result = new HashMap<ProcessInstanceUUID, List<LightTaskInstance>>();
        for (ProcessInstanceUUID instanceUUID : rootInstanceUUIDs) {
            result.put(instanceUUID, this.getLightTaskInstancesFromRoot(instanceUUID));
        }
        return result;
    }

    @Override
    public Set<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException {
        HashSet<LightActivityInstance> result = new HashSet<LightActivityInstance>();
        Set<InternalActivityInstance> activities = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstances(instanceUUID);
        for (InternalActivityInstance record : activities) {
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID, int fromIdex, int pageSize, ActivityInstanceCriterion pagingCriterion) throws InstanceNotFoundException {
        ArrayList<LightActivityInstance> result = new ArrayList<LightActivityInstance>();
        List<InternalActivityInstance> activities = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstances(instanceUUID, fromIdex, pageSize, pagingCriterion);
        for (InternalActivityInstance record : activities) {
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<ActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityId) throws ActivityNotFoundException {
        HashSet<ActivityInstance> result = new HashSet<ActivityInstance>();
        for (InternalActivityInstance record : EnvTool.getAllQueriers(this.getQueryList()).getActivityInstances(instanceUUID)) {
            if (!record.getActivityName().equals(activityId)) continue;
            result.add(new ActivityInstanceImpl(record));
        }
        if (result.isEmpty()) {
            throw new ActivityNotFoundException("bai_QRAPII_4", instanceUUID, activityId);
        }
        return result;
    }

    @Override
    public Set<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID, String activityName) throws InstanceNotFoundException, ActivityNotFoundException {
        HashSet<LightActivityInstance> result = new HashSet<LightActivityInstance>();
        Set<InternalActivityInstance> activities = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstances(instanceUUID);
        for (InternalActivityInstance record : activities) {
            if (!record.getActivityName().equals(activityName)) continue;
            result.add(new LightActivityInstanceImpl(record));
        }
        if (result.isEmpty()) {
            throw new ActivityNotFoundException("bai_QRAPII_4", instanceUUID, activityName);
        }
        return result;
    }

    @Override
    public Set<LightActivityInstance> getLightActivityInstances(ProcessInstanceUUID instanceUUID, String activityName, String iterationId) {
        HashSet<LightActivityInstance> result = new HashSet<LightActivityInstance>();
        Set<InternalActivityInstance> activities = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstances(instanceUUID, activityName, iterationId);
        for (InternalActivityInstance record : activities) {
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<TaskInstance> getTasks(ProcessInstanceUUID instanceUUID) {
        HashSet<TaskInstance> result = new HashSet<TaskInstance>();
        for (TaskInstance record : EnvTool.getAllQueriers(this.getQueryList()).getTaskInstances(instanceUUID)) {
            result.add(new ActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightTaskInstance> getLightTasks(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException {
        HashSet<LightTaskInstance> result = new HashSet<LightTaskInstance>();
        for (TaskInstance record : EnvTool.getAllQueriers(this.getQueryList()).getTaskInstances(instanceUUID)) {
            result.add(new LightActivityInstanceImpl(record));
        }
        return result;
    }

    @Override
    public Set<LightTaskInstance> getLightTasks(ProcessInstanceUUID instanceUUID, Set<String> taskNames) {
        HashSet<LightTaskInstance> result = new HashSet<LightTaskInstance>();
        if (taskNames != null && !taskNames.isEmpty()) {
            for (TaskInstance record : EnvTool.getAllQueriers(this.getQueryList()).getTaskInstances(instanceUUID, taskNames)) {
                result.add(new LightActivityInstanceImpl(record));
            }
        }
        return result;
    }

    @Override
    public Collection<TaskInstance> getTaskList(ProcessInstanceUUID instanceUUID, ActivityState taskState) throws InstanceNotFoundException {
        return this.getTaskListUser(instanceUUID, EnvTool.getUserId(), taskState);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ProcessInstanceUUID instanceUUID, ActivityState taskState) throws InstanceNotFoundException {
        return this.getLightTaskListUser(instanceUUID, EnvTool.getUserId(), taskState);
    }

    @Override
    public Collection<TaskInstance> getTaskList(ProcessInstanceUUID instanceUUID, Collection<ActivityState> taskStates) throws InstanceNotFoundException {
        FacadeUtil.checkArgsNotNull(instanceUUID, taskStates);
        HashSet<TaskInstance> todos = new HashSet<TaskInstance>();
        for (ActivityState taskState : taskStates) {
            Collection<TaskInstance> tasks = this.getTaskListUser(instanceUUID, EnvTool.getUserId(), taskState);
            if (tasks == null) continue;
            todos.addAll(tasks);
        }
        return todos;
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ProcessInstanceUUID instanceUUID, Collection<ActivityState> taskStates) throws InstanceNotFoundException {
        FacadeUtil.checkArgsNotNull(instanceUUID, taskStates);
        HashSet<LightTaskInstance> todos = new HashSet<LightTaskInstance>();
        for (ActivityState taskState : taskStates) {
            Collection<LightTaskInstance> tasks = this.getLightTaskListUser(instanceUUID, EnvTool.getUserId(), taskState);
            if (tasks == null) continue;
            todos.addAll(tasks);
        }
        return todos;
    }

    @Override
    public Collection<TaskInstance> getTaskList(ActivityState taskState) {
        return this.getTaskListUser(EnvTool.getUserId(), taskState);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ActivityState taskState) {
        return this.getLightTaskListUser(EnvTool.getUserId(), taskState);
    }

    @Override
    public TaskInstance getTask(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        TaskInstance taskInstance = EnvTool.getAllQueriers(this.getQueryList()).getTaskInstance(taskUUID);
        if (taskInstance == null) {
            throw new TaskNotFoundException("bai_QRAPII_5", taskUUID);
        }
        return new ActivityInstanceImpl(taskInstance);
    }

    @Override
    public Set<String> getTaskCandidates(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        TaskInstance taskInstance = EnvTool.getAllQueriers(this.getQueryList()).getTaskInstance(taskUUID);
        if (taskInstance == null) {
            throw new TaskNotFoundException("bai_QRAPII_5", taskUUID);
        }
        return CopyTool.copy(taskInstance.getTaskCandidates());
    }

    @Override
    public Map<ActivityInstanceUUID, Set<String>> getTaskCandidates(Set<ActivityInstanceUUID> taskUUIDs) throws TaskNotFoundException {
        HashMap<ActivityInstanceUUID, Set<String>> result = new HashMap<ActivityInstanceUUID, Set<String>>();
        for (ActivityInstanceUUID taskUUID : taskUUIDs) {
            TaskInstance taskInstance = EnvTool.getAllQueriers(this.getQueryList()).getTaskInstance(taskUUID);
            if (taskInstance == null) {
                throw new TaskNotFoundException("bai_QRAPII_5", taskUUID);
            }
            result.put(taskUUID, CopyTool.copy(taskInstance.getTaskCandidates()));
        }
        return result;
    }

    public Map<String, Object> getActivityInstanceVariables(ProcessInstanceUUID instanceUUID, String activityId, String iterationId, String activityInstanceId, String loopId) throws ActivityNotFoundException, InstanceNotFoundException {
        InternalActivityInstance activityInst = EnvTool.getAllQueriers().getActivityInstance(instanceUUID, activityId, iterationId, activityInstanceId, loopId);
        if (activityInst == null) {
            throw new ActivityNotFoundException("bai_QRAPII_6", instanceUUID, activityId);
        }
        Map<String, Object> variables = activityInst.getLastKnownVariableValues();
        return variables;
    }

    public Object getActivityInstanceVariable(ProcessInstanceUUID instanceUUID, String activityId, String iterationId, String activityInstanceId, String loopId, String variableId) throws InstanceNotFoundException, ActivityNotFoundException, VariableNotFoundException {
        Map<String, Object> variables = this.getActivityInstanceVariables(instanceUUID, activityId, iterationId, activityInstanceId, loopId);
        if (variables == null || !variables.containsKey(variableId)) {
            throw new VariableNotFoundException("bai_QRAPII_7", instanceUUID, activityId, variableId);
        }
        return variables.get(variableId);
    }

    @Override
    public Map<String, Object> getProcessInstanceVariables(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException {
        InternalProcessInstance processInstance = this.getInternalProcessInstanceWithoutAttachements(instanceUUID);
        if (processInstance == null) {
            throw new InstanceNotFoundException("bai_QRAPII_8", instanceUUID);
        }
        return processInstance.getLastKnownVariableValues();
    }

    @Override
    public Map<String, Object> getProcessInstanceVariables(ProcessInstanceUUID instanceUUID, Date maxDate) throws InstanceNotFoundException {
        InternalProcessInstance processInstance = this.getInternalProcessInstanceWithoutAttachements(instanceUUID);
        Map<String, Object> instanceInitialVars = processInstance.getInitialVariableValues();
        HashMap<String, Object> instanceVarBeforeMaxDate = new HashMap<String, Object>();
        instanceVarBeforeMaxDate.putAll(instanceInitialVars);
        HashMap<String, VariableUpdate> maxVarUpdates = new HashMap<String, VariableUpdate>();
        for (VariableUpdate varUpdate : processInstance.getVariableUpdates()) {
            VariableUpdate currentMax;
            if (varUpdate.getDate().getTime() > maxDate.getTime() || (currentMax = (VariableUpdate)maxVarUpdates.get(varUpdate.getName())) != null && currentMax.getDate().getTime() > varUpdate.getDate().getTime()) continue;
            maxVarUpdates.put(varUpdate.getName(), varUpdate);
            instanceVarBeforeMaxDate.put(varUpdate.getName(), varUpdate.getValue());
        }
        return instanceVarBeforeMaxDate;
    }

    private Object getProcessInstanceVariable(ProcessInstanceUUID instanceUUID, String variableId, Date maxDate) throws InstanceNotFoundException, VariableNotFoundException {
        String variableName = Misc.getVariableName(variableId);
        String xpath = Misc.getXPath(variableId);
        Map<String, Object> variables = this.getProcessInstanceVariables(instanceUUID, maxDate);
        if (variables == null || !variables.containsKey(variableName)) {
            throw new VariableNotFoundException("bai_QRAPII_9", instanceUUID, variableName);
        }
        Object value = variables.get(variableName);
        if (xpath != null && xpath.length() > 0) {
            try {
                return this.evaluateXPath(xpath, (org.w3c.dom.Document)value);
            }
            catch (Exception ex) {
                throw new VariableNotFoundException("bai_QRAPII_17", instanceUUID, variableName);
            }
        }
        return value;
    }

    @Override
    public Object getProcessInstanceVariable(ProcessInstanceUUID instanceUUID, String variableId) throws InstanceNotFoundException, VariableNotFoundException {
        String variableName = Misc.getVariableName(variableId);
        String xpath = Misc.getXPath(variableId);
        Map<String, Object> variables = this.getProcessInstanceVariables(instanceUUID);
        if (variables == null || !variables.containsKey(variableName)) {
            throw new VariableNotFoundException("bai_QRAPII_10", instanceUUID, variableName);
        }
        Object value = variables.get(variableName);
        if (xpath != null && xpath.length() > 0) {
            try {
                return this.evaluateXPath(xpath, (org.w3c.dom.Document)value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new VariableNotFoundException("bai_QRAPII_17", instanceUUID, variableId);
            }
        }
        return value;
    }

    @Override
    public ActivityInstance getActivityInstance(ActivityInstanceUUID activityUUID) throws ActivityNotFoundException {
        InternalActivityInstance activity = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstance(activityUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_QRAPII_11", activityUUID);
        }
        return new ActivityInstanceImpl(activity);
    }

    @Override
    public ActivityState getActivityInstanceState(ActivityInstanceUUID activityUUID) throws ActivityNotFoundException {
        FacadeUtil.checkArgsNotNull(activityUUID);
        Querier querier = EnvTool.getAllQueriers(this.getQueryList());
        ActivityState state = querier.getActivityInstanceState(activityUUID);
        if (state == null) {
            InternalActivityInstance activity = querier.getActivityInstance(activityUUID);
            throw new ActivityNotFoundException("bai_QRAPII_3", activity.getProcessInstanceUUID(), activity.getActivityName());
        }
        return state;
    }

    @Override
    public Object getActivityInstanceVariable(ActivityInstanceUUID activityUUID, String variableId) throws ActivityNotFoundException, VariableNotFoundException {
        Map<String, Object> transientVariables = TransientData.getActivityTransientVariables(activityUUID);
        if (transientVariables != null && transientVariables.containsKey(variableId)) {
            return transientVariables.get(variableId);
        }
        String variableName = Misc.getVariableName(variableId);
        String xpath = Misc.getXPath(variableId);
        InternalActivityInstance activity = EnvTool.getAllQueriers().getActivityInstance(activityUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_QRAPII_11", activityUUID);
        }
        Map<String, Object> variableValues = activity.getLastKnownVariableValues();
        if (!variableValues.containsKey(variableName)) {
            throw new VariableNotFoundException("bai_QRAPII_12", activityUUID, variableName);
        }
        Object value = activity.getLastKnownVariableValues().get(variableName);
        if (xpath != null && xpath.length() > 0) {
            try {
                return this.evaluateXPath(xpath, (org.w3c.dom.Document)value);
            }
            catch (Exception ex) {
                throw new VariableNotFoundException("bai_QRAPII_16", activityUUID, variableName);
            }
        }
        return value;
    }

    private Object evaluateXPath(String xpath, org.w3c.dom.Document doc) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        XPath xpathEval = XPathFactory.newInstance().newXPath();
        if (this.isTextExpected(xpath)) {
            return xpathEval.evaluate(xpath, doc);
        }
        return xpathEval.evaluate(xpath, doc, XPathConstants.NODE);
    }

    private boolean isTextExpected(String xpath) {
        String[] segments = xpath.split("/");
        String lastSegment = segments[segments.length - 1];
        return lastSegment.equals("text()") || lastSegment.startsWith("@");
    }

    @Override
    public Map<String, Object> getActivityInstanceVariables(ActivityInstanceUUID activityUUID) throws ActivityNotFoundException {
        InternalActivityInstance activity;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Map<String, Object> transientVariables = TransientData.getActivityTransientVariables(activityUUID);
        if (transientVariables != null) {
            variables.putAll(transientVariables);
        }
        if ((activity = EnvTool.getAllQueriers().getActivityInstance(activityUUID)) == null) {
            throw new ActivityNotFoundException("bai_QRAPII_11", activityUUID);
        }
        Map<String, Object> lastKnownVariables = activity.getLastKnownVariableValues();
        if (lastKnownVariables != null) {
            variables.putAll(lastKnownVariables);
        }
        return variables;
    }

    @Override
    public Collection<TaskInstance> getTaskList(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState) throws InstanceNotFoundException {
        return this.getTaskListUser(instanceUUID, userId, taskState);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState) throws InstanceNotFoundException {
        return this.getLightTaskListUser(instanceUUID, userId, taskState);
    }

    @Override
    public Collection<TaskInstance> getTaskList(String userId, ActivityState taskState) {
        return this.getTaskListUser(userId, taskState);
    }

    @Override
    public Collection<LightTaskInstance> getLightTaskList(String userId, ActivityState taskState) {
        return this.getLightTaskListUser(userId, taskState);
    }

    @Override
    public ActivityInstanceUUID getOneTask(ActivityState taskState) {
        Querier journal = EnvTool.getJournalQueriers(this.getQueryList());
        boolean access = EnvTool.isRestrictedApplicationAcces();
        TaskInstance task = null;
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                task = journal.getOneTask(EnvTool.getUserId(), taskState, visibleProcessUUIDs);
            }
        } else {
            task = journal.getOneTask(EnvTool.getUserId(), taskState);
        }
        if (task == null) {
            return null;
        }
        return new ActivityInstanceUUID(task.getUUID());
    }

    @Override
    public ActivityInstanceUUID getOneTask(ProcessInstanceUUID instanceUUID, ActivityState taskState) {
        Querier journal = EnvTool.getJournalQueriers(this.getQueryList());
        TaskInstance task = journal.getOneTask(EnvTool.getUserId(), instanceUUID, taskState);
        if (task == null) {
            return null;
        }
        return new ActivityInstanceUUID(task.getUUID());
    }

    @Override
    public ActivityInstanceUUID getOneTask(ProcessDefinitionUUID processUUID, ActivityState taskState) {
        Querier journal = EnvTool.getJournalQueriers(this.getQueryList());
        TaskInstance task = journal.getOneTask(EnvTool.getUserId(), processUUID, taskState);
        if (task == null) {
            return null;
        }
        return new ActivityInstanceUUID(task.getUUID());
    }

    private Collection<TaskInstance> getTaskListUser(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState) throws InstanceNotFoundException {
        ArrayList<TaskInstance> todos = new ArrayList<TaskInstance>();
        for (TaskInstance taskActivity : this.getInternalTaskListUser(instanceUUID, userId, taskState)) {
            todos.add(new ActivityInstanceImpl(taskActivity));
        }
        return todos;
    }

    private Collection<LightTaskInstance> getLightTaskListUser(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState) throws InstanceNotFoundException {
        ArrayList<LightTaskInstance> todos = new ArrayList<LightTaskInstance>();
        for (TaskInstance taskActivity : this.getInternalTaskListUser(instanceUUID, userId, taskState)) {
            todos.add(new LightActivityInstanceImpl(taskActivity));
        }
        return todos;
    }

    private Collection<TaskInstance> getInternalTaskListUser(ProcessInstanceUUID instanceUUID, String userId, ActivityState taskState) throws InstanceNotFoundException {
        FacadeUtil.checkArgsNotNull(new Object[]{instanceUUID, taskState, userId});
        InternalProcessInstance processInstance = this.getInternalProcessInstanceWithoutAttachements(instanceUUID);
        if (processInstance == null) {
            throw new InstanceNotFoundException("bai_QRAPII_13", instanceUUID);
        }
        Querier journal = EnvTool.getAllQueriers(this.getQueryList());
        return journal.getUserInstanceTasks(userId, instanceUUID, taskState);
    }

    private Collection<TaskInstance> getTaskListUser(String userId, ActivityState taskState) {
        HashSet<TaskInstance> result = new HashSet<TaskInstance>();
        for (TaskInstance taskInstance : this.getInternalTaskListUser(userId, taskState)) {
            result.add(new ActivityInstanceImpl(taskInstance));
        }
        return result;
    }

    private Collection<LightTaskInstance> getLightTaskListUser(String userId, ActivityState taskState) {
        HashSet<LightTaskInstance> result = new HashSet<LightTaskInstance>();
        for (TaskInstance taskInstance : this.getInternalTaskListUser(userId, taskState)) {
            result.add(new LightActivityInstanceImpl(taskInstance));
        }
        return result;
    }

    private Collection<TaskInstance> getInternalTaskListUser(String userId, ActivityState taskState) {
        FacadeUtil.checkArgsNotNull(new Object[]{userId, taskState});
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<TaskInstance> tasks = new HashSet<TaskInstance>();
        if (access) {
            Set<ProcessDefinitionUUID> visibleProcessUUIDs;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && (visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)) != null && !visibleProcessUUIDs.isEmpty()) {
                tasks = EnvTool.getAllQueriers(this.getQueryList()).getUserTasks(userId, taskState, visibleProcessUUIDs);
            }
        } else {
            tasks = EnvTool.getAllQueriers(this.getQueryList()).getUserTasks(userId, taskState);
        }
        return tasks;
    }

    @Override
    public Object getVariable(ActivityInstanceUUID activityUUID, String variableId) throws ActivityNotFoundException, VariableNotFoundException {
        try {
            return this.getActivityInstanceVariable(activityUUID, variableId);
        }
        catch (Throwable e) {
            InternalActivityInstance activity = EnvTool.getAllQueriers().getActivityInstance(activityUUID);
            if (activity == null) {
                throw new ActivityNotFoundException("bai_QRAPII_11", activityUUID);
            }
            Date maxDate = this.getMaxDate(activity);
            try {
                return this.getProcessInstanceVariable(activity.getProcessInstanceUUID(), variableId, maxDate);
            }
            catch (InstanceNotFoundException e1) {
                Misc.unreachableStatement();
                return null;
            }
        }
    }

    @Override
    public Map<String, Object> getVariables(ActivityInstanceUUID activityUUID) throws ActivityNotFoundException {
        InternalActivityInstance activity = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstance(activityUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_QRAPII_14", activityUUID);
        }
        Date maxDate = this.getMaxDate(activity);
        try {
            HashMap<String, Object> allVariables = new HashMap<String, Object>();
            Map<String, Object> localVariables = activity.getLastKnownVariableValues();
            Map<String, Object> globalVariables = this.getProcessInstanceVariables(activity.getProcessInstanceUUID(), maxDate);
            allVariables.putAll(globalVariables);
            allVariables.putAll(localVariables);
            return allVariables;
        }
        catch (InstanceNotFoundException e) {
            Misc.unreachableStatement();
            return null;
        }
    }

    private Date getMaxDate(ActivityInstance activity) {
        Date endedDate = activity.getEndedDate();
        if (endedDate == null) {
            return new Date();
        }
        return endedDate;
    }

    @Override
    public Set<String> getAttachmentNames(ProcessInstanceUUID instanceUUID) {
        FacadeUtil.checkArgsNotNull(instanceUUID);
        try {
            InternalProcessInstance instance = this.getInternalProcessInstanceWithAttachments(instanceUUID);
            HashSet<String> attachmentNames = new HashSet<String>();
            List<AttachmentInstance> attachments = instance.getAttachments();
            for (AttachmentInstance attachment : attachments) {
                attachmentNames.add(attachment.getName());
            }
            return attachmentNames;
        }
        catch (InstanceNotFoundException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public AttachmentInstance getLastAttachment(ProcessInstanceUUID instanceUUID, String attachmentName) {
        FacadeUtil.checkArgsNotNull(instanceUUID, attachmentName);
        DocumentationManager manager = EnvTool.getDocumentationManager();
        SearchResult result = DocumentService.getDocuments(manager, instanceUUID, attachmentName);
        List<Document> documents = result.getDocuments();
        if (documents.isEmpty()) {
            return null;
        }
        return DocumentService.getAttachmentFromDocument(manager, documents.get(0));
    }

    @Override
    public AttachmentInstance getLastAttachment(ProcessInstanceUUID instanceUUID, String attachmentName, ActivityInstanceUUID activityUUID) throws ActivityNotFoundException {
        ActivityInstance activity = this.getActivityInstance(activityUUID);
        Date date = null;
        date = !activity.getState().equals((Object)ActivityState.READY) && !activity.getState().equals((Object)ActivityState.SUSPENDED) && !activity.getState().equals((Object)ActivityState.EXECUTING) ? activity.getLastStateUpdate().getUpdatedDate() : new Date();
        return this.getLastAttachment(instanceUUID, attachmentName, date);
    }

    @Override
    public AttachmentInstance getLastAttachment(ProcessInstanceUUID instanceUUID, String attachmentName, Date date) {
        FacadeUtil.checkArgsNotNull(instanceUUID, attachmentName, date);
        DocumentationManager manager = EnvTool.getDocumentationManager();
        SearchResult result = DocumentService.getDocuments(manager, instanceUUID, attachmentName);
        List<Document> documents = result.getDocuments();
        ArrayList<Document> allDocuments = new ArrayList<Document>();
        for (Document document : documents) {
            try {
                List<Document> documentVersions = manager.getVersionsOfDocument(document.getId());
                allDocuments.addAll(documentVersions);
            }
            catch (DocumentNotFoundException e) {
                throw new BonitaRuntimeException(e);
            }
        }
        Document doc = null;
        for (int i = 0; i < allDocuments.size(); ++i) {
            Document tmp = (Document)allDocuments.get(i);
            long tmpDate = tmp.getCreationDate().getTime();
            if (tmpDate > date.getTime()) continue;
            if (doc == null) {
                doc = tmp;
                continue;
            }
            if (doc.getCreationDate().getTime() > tmpDate) continue;
            doc = tmp;
        }
        if (doc == null) {
            return null;
        }
        return DocumentService.getAttachmentFromDocument(manager, doc);
    }

    @Override
    public Collection<AttachmentInstance> getLastAttachments(ProcessInstanceUUID instanceUUID, Set<String> attachmentNames) {
        FacadeUtil.checkArgsNotNull(instanceUUID, attachmentNames);
        HashSet<AttachmentInstance> result = new HashSet<AttachmentInstance>();
        for (String attachmentName : attachmentNames) {
            AttachmentInstance attachmentInstance = this.getLastAttachment(instanceUUID, attachmentName);
            if (attachmentInstance == null) continue;
            result.add(attachmentInstance);
        }
        return result;
    }

    @Override
    public Collection<AttachmentInstance> getLastAttachments(ProcessInstanceUUID instanceUUID, String regex) {
        FacadeUtil.checkArgsNotNull(instanceUUID, regex);
        DocumentationManager manager = EnvTool.getDocumentationManager();
        List<AttachmentInstance> matchingAttachments = DocumentService.getAllAttachmentVersions(manager, instanceUUID);
        HashMap<String, AttachmentInstanceImpl> result = new HashMap<String, AttachmentInstanceImpl>();
        for (AttachmentInstance attachmentInstance : matchingAttachments) {
            if (!attachmentInstance.getName().matches(regex)) continue;
            result.put(attachmentInstance.getName(), new AttachmentInstanceImpl(attachmentInstance));
        }
        return result.values();
    }

    @Override
    public List<AttachmentInstance> getAttachments(ProcessInstanceUUID instanceUUID, String attachmentName) {
        FacadeUtil.checkArgsNotNull(instanceUUID, attachmentName);
        DocumentationManager manager = EnvTool.getDocumentationManager();
        return DocumentService.getAllAttachmentVersions(manager, instanceUUID, attachmentName);
    }

    @Override
    public byte[] getAttachmentValue(AttachmentInstance attachmentInstance) {
        DocumentationManager manager = EnvTool.getDocumentationManager();
        try {
            Document document = manager.getDocument(attachmentInstance.getUUID().getValue());
            return manager.getContent(document);
        }
        catch (DocumentNotFoundException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public List<Comment> getCommentFeed(ProcessInstanceUUID instanceUUID) {
        List<Comment> comments = EnvTool.getAllQueriers(this.getQueryList()).getCommentFeed(instanceUUID);
        return new ArrayList<Comment>(comments);
    }

    @Override
    public List<Comment> getActivityInstanceCommentFeed(ActivityInstanceUUID activityUUID) {
        FacadeUtil.checkArgsNotNull(activityUUID);
        List<Comment> comments = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstanceCommentFeed(activityUUID);
        return new ArrayList<Comment>(comments);
    }

    @Override
    public int getNumberOfActivityInstanceComments(ActivityInstanceUUID activityUUID) {
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfActivityInstanceComments(activityUUID);
    }

    @Override
    public Map<ActivityInstanceUUID, Integer> getNumberOfActivityInstanceComments(Set<ActivityInstanceUUID> activityUUIDs) {
        if (activityUUIDs == null || activityUUIDs.isEmpty()) {
            return Collections.emptyMap();
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfActivityInstanceComments(activityUUIDs);
    }

    @Override
    public int getNumberOfComments(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException {
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfComments(instanceUUID);
    }

    @Override
    public int getNumberOfProcessInstanceComments(ProcessInstanceUUID instanceUUID) {
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfProcessInstanceComments(instanceUUID);
    }

    @Override
    public List<Comment> getProcessInstanceCommentFeed(ProcessInstanceUUID instanceUUID) {
        FacadeUtil.checkArgsNotNull(instanceUUID);
        List<Comment> comments = EnvTool.getAllQueriers(this.getQueryList()).getProcessInstanceCommentFeed(instanceUUID);
        return new ArrayList<Comment>(comments);
    }

    @Override
    public LightTaskInstance getLightTaskInstance(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        TaskInstance taskInstance = EnvTool.getAllQueriers(this.getQueryList()).getTaskInstance(taskUUID);
        if (taskInstance == null) {
            throw new TaskNotFoundException("bai_QRAPII_5", taskUUID);
        }
        return new LightActivityInstanceImpl(taskInstance);
    }

    @Override
    public LightActivityInstance getLightActivityInstance(ActivityInstanceUUID activityInstanceUUID) throws ActivityNotFoundException {
        InternalActivityInstance activityInstance = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstance(activityInstanceUUID);
        if (activityInstance == null) {
            throw new ActivityNotFoundException("bai_QRAPII_11", activityInstanceUUID);
        }
        return new LightActivityInstanceImpl(activityInstance);
    }

    @Override
    public int search(SearchQueryBuilder query) {
        Class<?> indexClass = this.getIndexedClass(query);
        return EnvTool.getAllQueriers(this.getQueryList()).search(query, indexClass);
    }

    @Override
    public <T> List<T> search(SearchQueryBuilder query, int firstResult, int maxResults) {
        Index index = query.getIndex();
        Class<?> resultClass = index.getResultClass();
        Class<?> indexClass = this.getIndexedClass(query);
        List<Object> list = EnvTool.getAllQueriers(this.getQueryList()).search(query, firstResult, maxResults, indexClass);
        if (UserImpl.class.equals(resultClass)) {
            return this.getUsers(list);
        }
        if (LightProcessInstance.class.equals(resultClass)) {
            return this.getLightProcessInstances(list);
        }
        if (LightProcessDefinition.class.equals(resultClass)) {
            return this.getLightProcessDefinitions(list);
        }
        if (LightActivityInstance.class.equals(resultClass)) {
            return this.getLightActivityInstances(list);
        }
        if (GroupImpl.class.equals(resultClass)) {
            return this.getGroups(list);
        }
        if (RoleImpl.class.equals(resultClass)) {
            return this.getRoles(list);
        }
        if (CaseImpl.class.equals(resultClass)) {
            return this.getCases(list);
        }
        return Collections.emptyList();
    }

    private Class<?> getIndexedClass(SearchQueryBuilder query) {
        Index index = query.getIndex();
        Class<?> resultClass = index.getResultClass();
        Class indexClass = null;
        if (UserImpl.class.equals(resultClass)) {
            indexClass = UserImpl.class;
        } else if (LightProcessInstance.class.equals(resultClass)) {
            indexClass = InternalProcessInstance.class;
        } else if (LightProcessDefinition.class.equals(resultClass)) {
            indexClass = InternalProcessDefinition.class;
        } else if (LightActivityInstance.class.equals(resultClass)) {
            indexClass = InternalActivityInstance.class;
        } else if (GroupImpl.class.equals(resultClass)) {
            indexClass = GroupImpl.class;
        } else if (RoleImpl.class.equals(resultClass)) {
            indexClass = RoleImpl.class;
        } else if (CaseImpl.class.equals(resultClass)) {
            indexClass = CaseImpl.class;
        }
        return indexClass;
    }

    private List<LightActivityInstance> getLightActivityInstances(List<Object> list) {
        ArrayList<LightActivityInstance> result = new ArrayList<LightActivityInstance>();
        for (Object object : list) {
            result.add(new LightActivityInstanceImpl((InternalActivityInstance)object));
        }
        return result;
    }

    private List<LightProcessInstance> getLightProcessInstances(List<Object> list) {
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (Object object : list) {
            result.add(new LightProcessInstanceImpl((InternalProcessInstance)object));
        }
        return result;
    }

    private List<LightProcessDefinition> getLightProcessDefinitions(List<Object> list) {
        ArrayList<LightProcessDefinition> result = new ArrayList<LightProcessDefinition>();
        for (Object object : list) {
            result.add(new LightProcessDefinitionImpl((InternalProcessDefinition)object));
        }
        return result;
    }

    private List<UserImpl> getUsers(List<Object> list) {
        ArrayList<UserImpl> result = new ArrayList<UserImpl>();
        for (Object object : list) {
            result.add(new UserImpl((UserImpl)object));
        }
        return result;
    }

    private List<GroupImpl> getGroups(List<Object> list) {
        ArrayList<GroupImpl> result = new ArrayList<GroupImpl>();
        for (Object object : list) {
            result.add(new GroupImpl((GroupImpl)object));
        }
        return result;
    }

    private List<RoleImpl> getRoles(List<Object> list) {
        ArrayList<RoleImpl> result = new ArrayList<RoleImpl>();
        for (Object object : list) {
            result.add(new RoleImpl((RoleImpl)object));
        }
        return result;
    }

    private List<CaseImpl> getCases(List<Object> list) {
        ArrayList<CaseImpl> result = new ArrayList<CaseImpl>();
        for (Object object : list) {
            result.add(new CaseImpl((CaseImpl)object));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUser(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithActiveUser(username, fromIndex, pageSize, processUUIDs);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUser(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        List<Object> processes = null;
        processes = processUUIDs == null || processUUIDs.isEmpty() ? new ArrayList() : this.getParentProcessInstancesWithActiveUser(username, fromIndex, pageSize, processUUIDs, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String username, int remainingDays, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(username, remainingDays, fromIndex, pageSize, processUUIDs);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String username, int remainingDays, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return new ArrayList<LightProcessInstance>();
        }
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(username, remainingDays, fromIndex, pageSize, processUUIDs, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateExcept(String username, int remainingDays, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(username, remainingDays, fromIndex, pageSize, visibleProcesses);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateExcept(String username, int remainingDays, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        Set<ProcessDefinitionUUID> visibleProcesses = null;
        visibleProcesses = processUUIDs == null || processUUIDs.isEmpty() ? EnvTool.getAllQueriers().getAllProcessDefinitionUUIDs() : EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getLightParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(username, remainingDays, fromIndex, pageSize, visibleProcesses, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserExcept(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getLightParentProcessInstancesWithActiveUser(userId, fromIndex, pageSize, visibleProcesses);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithActiveUserExcept(String userId, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        Set<ProcessDefinitionUUID> visibleProcesses = null;
        visibleProcesses = processUUIDs == null || processUUIDs.isEmpty() ? EnvTool.getAllQueriers().getAllProcessDefinitionUUIDs() : EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getLightParentProcessInstancesWithActiveUser(userId, fromIndex, pageSize, visibleProcesses, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUserExcept(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getLightParentProcessInstancesWithInvolvedUser(username, fromIndex, pageSize, visibleProcesses);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithInvolvedUserExcept(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        Set<ProcessDefinitionUUID> visibleProcesses = null;
        visibleProcesses = processUUIDs == null || processUUIDs.isEmpty() ? EnvTool.getAllQueriers().getAllProcessDefinitionUUIDs() : EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getLightParentProcessInstancesWithInvolvedUser(username, fromIndex, pageSize, visibleProcesses, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasks(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithOverdueTasks(username, fromIndex, pageSize, processUUIDs, ProcessInstanceCriterion.DEFAULT);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasks(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        List<InternalProcessInstance> processes = this.getParentProcessInstancesWithOverdueTasks(username, fromIndex, pageSize, processUUIDs, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasksExcept(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getLightParentProcessInstancesWithOverdueTasks(username, fromIndex, pageSize, visibleProcesses);
    }

    @Override
    public List<LightProcessInstance> getLightParentProcessInstancesWithOverdueTasksExcept(String username, int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        Set<ProcessDefinitionUUID> visibleProcesses = null;
        visibleProcesses = processUUIDs == null || processUUIDs.isEmpty() ? EnvTool.getAllQueriers().getAllProcessDefinitionUUIDs() : EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getLightParentProcessInstancesWithOverdueTasks(username, fromIndex, pageSize, visibleProcesses, pagingCriterion);
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstances(int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        List<InternalProcessInstance> processes = this.getUserParentProcessInstances(fromIndex, pageSize, processUUIDs);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance record : processes) {
            result.add(new LightProcessInstanceImpl(record));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstances(int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        List<Object> processes = null;
        processes = processUUIDs == null || processUUIDs.isEmpty() ? new ArrayList() : this.getUserParentProcessInstances(fromIndex, pageSize, processUUIDs, pagingCriterion);
        ArrayList<LightProcessInstance> result = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance internalProcessInstance : processes) {
            result.add(new LightProcessInstanceImpl(internalProcessInstance));
        }
        return result;
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstancesExcept(int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = null;
        visibleProcesses = processUUIDs == null || processUUIDs.isEmpty() ? EnvTool.getAllQueriers().getAllProcessDefinitionUUIDs() : EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getLightParentUserInstances(fromIndex, pageSize, visibleProcesses);
    }

    @Override
    public List<LightProcessInstance> getLightParentUserInstancesExcept(int fromIndex, int pageSize, Set<ProcessDefinitionUUID> processUUIDs, ProcessInstanceCriterion pagingCriterion) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getLightParentUserInstances(fromIndex, pageSize, visibleProcesses, pagingCriterion);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUser(String username, Set<ProcessDefinitionUUID> processUUIDs) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithActiveUser(username, visibleProcessUUIDs);
                }
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithActiveUser(username, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(String username, int remainingDays, Set<ProcessDefinitionUUID> processUUIDs) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Date currentDate = new Date();
        Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(currentDate);
        Date atRisk = DateUtil.backTo(beginningOfTheDay, -(remainingDays + 1));
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(username, currentDate, atRisk, visibleProcessUUIDs);
                }
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(username, currentDate, atRisk, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDateExcept(String username, int remainingDays, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getNumberOfParentProcessInstancesWithActiveUserAndActivityInstanceExpectedEndDate(username, remainingDays, visibleProcesses);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithActiveUserExcept(String username, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getNumberOfParentProcessInstancesWithActiveUser(username, visibleProcesses);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUser(String username, Set<ProcessDefinitionUUID> processUUIDs) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithInvolvedUser(username, visibleProcessUUIDs);
                }
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithInvolvedUser(username, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUserExcept(String username, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getNumberOfParentProcessInstancesWithInvolvedUser(username, visibleProcesses);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithOverdueTasks(String username, Set<ProcessDefinitionUUID> processUUIDs) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Date currentDate = new Date();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithOverdueTasks(username, currentDate, visibleProcessUUIDs);
                }
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithOverdueTasks(username, currentDate, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithOverdueTasksExcept(String username, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getNumberOfParentProcessInstancesWithOverdueTasks(username, visibleProcesses);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithStartedBy(String username, Set<ProcessDefinitionUUID> processUUIDs) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                if (visibleProcessUUIDs == null) {
                    visibleProcessUUIDs = new HashSet<ProcessDefinitionUUID>();
                }
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithStartedBy(username, visibleProcessUUIDs);
                }
            }
            return 0;
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithStartedBy(username, processUUIDs);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithStartedByExcept(String username, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getNumberOfParentProcessInstancesWithStartedBy(username, visibleProcesses);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUserAndCategory(String username, String category, Set<ProcessDefinitionUUID> processUUIDs) {
        boolean access = EnvTool.isRestrictedApplicationAcces();
        Set<ProcessDefinitionUUID> targetedProcesses = EnvTool.getAllQueriers(this.getQueryList()).getProcessUUIDsFromCategory(category);
        if (access) {
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null) {
                Set<ProcessDefinitionUUID> visibleProcessUUIDs = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ);
                visibleProcessUUIDs.retainAll(targetedProcesses);
                visibleProcessUUIDs.retainAll(processUUIDs);
                if (visibleProcessUUIDs != null && !visibleProcessUUIDs.isEmpty()) {
                    return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithInvolvedUser(username, visibleProcessUUIDs);
                }
            }
            return 0;
        }
        targetedProcesses.retainAll(processUUIDs);
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfParentProcessInstancesWithInvolvedUser(username, targetedProcesses);
    }

    @Override
    public Integer getNumberOfParentProcessInstancesWithInvolvedUserAndCategoryExcept(String username, String category, Set<ProcessDefinitionUUID> processUUIDs) {
        Set<ProcessDefinitionUUID> visibleProcesses = EnvTool.getAllQueriers().getAllProcessDefinitionUUIDsExcept(processUUIDs);
        return this.getNumberOfParentProcessInstancesWithInvolvedUserAndCategory(username, category, visibleProcesses);
    }

    @Override
    public Set<String> getActiveUsersOfProcessInstance(ProcessInstanceUUID uuid) throws InstanceNotFoundException {
        InternalProcessInstance instance = this.getInternalProcessInstanceWithoutAttachements(uuid);
        if (instance == null) {
            throw new InstanceNotFoundException("bai_QRAPII_1", uuid);
        }
        return instance.getActiveUsers();
    }

    @Override
    public Map<ProcessInstanceUUID, Set<String>> getActiveUsersOfProcessInstances(Set<ProcessInstanceUUID> instanceUUIDs) throws InstanceNotFoundException {
        FacadeUtil.checkArgsNotNull(instanceUUIDs);
        HashMap<ProcessInstanceUUID, Set<String>> result = new HashMap<ProcessInstanceUUID, Set<String>>();
        for (ProcessInstanceUUID processInstanceUUID : instanceUUIDs) {
            result.put(processInstanceUUID, this.getActiveUsersOfProcessInstance(processInstanceUUID));
        }
        return result;
    }

    @Override
    public CatchingEvent getEvent(CatchingEventUUID eventUUID) throws EventNotFoundException {
        long incomingId;
        EventService eventService = EnvTool.getEventService();
        IncomingEventInstance incomingEvent = eventService.getIncomingEvent(incomingId = Long.parseLong(eventUUID.getValue()));
        if (incomingEvent == null) {
            throw new EventNotFoundException("Event " + incomingId + "does not exist.");
        }
        return this.getEvent(incomingEvent);
    }

    @Override
    public Set<CatchingEvent> getEvents() {
        EventService eventService = EnvTool.getEventService();
        Set<IncomingEventInstance> incomingEventInstances = eventService.getIncomingEvents();
        return this.getEvents(incomingEventInstances);
    }

    @Override
    public Set<CatchingEvent> getEvents(ProcessInstanceUUID instanceUUID) {
        EventService eventService = EnvTool.getEventService();
        Set<IncomingEventInstance> incomingEventInstances = eventService.getIncomingEvents(instanceUUID);
        return this.getEvents(incomingEventInstances);
    }

    @Override
    public Set<CatchingEvent> getEvents(ActivityInstanceUUID activityUUID) {
        EventService eventService = EnvTool.getEventService();
        Set<IncomingEventInstance> incomingEventInstances = eventService.getIncomingEvents(activityUUID);
        return this.getEvents(incomingEventInstances);
    }

    private Set<CatchingEvent> getEvents(Set<IncomingEventInstance> incomingEventInstances) {
        HashSet<CatchingEvent> events = new HashSet<CatchingEvent>();
        for (IncomingEventInstance incomingEventInstance : incomingEventInstances) {
            CatchingEvent event = this.getEvent(incomingEventInstance);
            if (event == null) continue;
            events.add(event);
        }
        return events;
    }

    private CatchingEvent getEvent(IncomingEventInstance incomingEventInstance) {
        String signal = incomingEventInstance.getSignal();
        CatchingEventImpl event = null;
        if (signal.contains("timer")) {
            CatchingEventUUID uuid = new CatchingEventUUID(String.valueOf(incomingEventInstance.getId()));
            CatchingEvent.Position position = null;
            if (signal.contains("event.start.")) {
                position = CatchingEvent.Position.START;
            } else if (signal.contains("event.intermediate.") || signal.equals("end_of_timer")) {
                position = CatchingEvent.Position.INTERMEDIATE;
            } else if (signal.contains("event.boundary.")) {
                position = CatchingEvent.Position.BOUNDARY;
            } else if (signal.equals("timer")) {
                position = CatchingEvent.Position.DEADLINE;
            }
            event = new CatchingEventImpl(uuid, position, CatchingEvent.Type.TIMER, incomingEventInstance.getEnableTime(), incomingEventInstance.getActivityDefinitionUUID(), incomingEventInstance.getActivityUUID(), incomingEventInstance.getInstanceUUID(), incomingEventInstance.getActivityName(), incomingEventInstance.getProcessName());
        }
        return event;
    }

    @Override
    public byte[] getDocumentContent(DocumentUUID documentUUID) throws DocumentNotFoundException {
        String documentId;
        DocumentationManager manager = EnvTool.getDocumentationManager();
        Document document = manager.getDocument(documentId = documentUUID.getValue());
        if (document == null) {
            throw new DocumentNotFoundException(documentId);
        }
        return manager.getContent(document);
    }

    @Override
    public DocumentResult searchDocuments(DocumentSearchBuilder builder, int fromResult, int MaxResults) {
        DocumentationManager manager = EnvTool.getDocumentationManager();
        SearchResult searchResult = manager.search(builder, fromResult, MaxResults);
        List<Document> searchDocuments = searchResult.getDocuments();
        ArrayList<org.ow2.bonita.facade.runtime.Document> documents = new ArrayList<org.ow2.bonita.facade.runtime.Document>();
        for (int i = 0; i < searchDocuments.size(); ++i) {
            Document searchDocument = searchDocuments.get(i);
            documents.add(DocumentService.getClientDocument(manager, searchDocument));
        }
        int count = searchResult.getCount();
        return new DocumentResult(count, documents);
    }

    @Override
    public org.ow2.bonita.facade.runtime.Document getDocument(DocumentUUID documentUUID) throws DocumentNotFoundException {
        FacadeUtil.checkArgsNotNull(documentUUID);
        DocumentationManager manager = EnvTool.getDocumentationManager();
        return this.getDocument(documentUUID, manager);
    }

    @Override
    public List<org.ow2.bonita.facade.runtime.Document> getDocuments(List<DocumentUUID> documentUUIDs) throws DocumentNotFoundException {
        FacadeUtil.checkArgsNotNull(documentUUIDs);
        ArrayList<org.ow2.bonita.facade.runtime.Document> documents = new ArrayList<org.ow2.bonita.facade.runtime.Document>();
        DocumentationManager manager = EnvTool.getDocumentationManager();
        for (int i = 0; i < documentUUIDs.size(); ++i) {
            DocumentUUID documentUUID = documentUUIDs.get(i);
            org.ow2.bonita.facade.runtime.Document document = this.getDocument(documentUUID, manager);
            documents.add(document);
        }
        return documents;
    }

    public org.ow2.bonita.facade.runtime.Document getDocument(DocumentUUID documentUUID, DocumentationManager manager) throws DocumentNotFoundException {
        Document document = manager.getDocument(documentUUID.getValue());
        return DocumentService.getClientDocument(manager, document);
    }

    @Override
    public List<org.ow2.bonita.facade.runtime.Document> getDocumentVersions(DocumentUUID documentUUID) throws DocumentNotFoundException {
        FacadeUtil.checkArgsNotNull(documentUUID);
        DocumentationManager manager = EnvTool.getDocumentationManager();
        List<Document> documentVersions = manager.getVersionsOfDocument(documentUUID.getValue());
        ArrayList<org.ow2.bonita.facade.runtime.Document> documents = new ArrayList<org.ow2.bonita.facade.runtime.Document>();
        for (int i = 0; i < documentVersions.size(); ++i) {
            Document documentVersion = documentVersions.get(i);
            documents.add(DocumentService.getClientDocument(manager, documentVersion));
        }
        return documents;
    }
}

