/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ow2.bonita.connector.core.Connector;
import org.ow2.bonita.connector.core.Filter;
import org.ow2.bonita.connector.core.Mapper;
import org.ow2.bonita.connector.core.RoleResolver;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.ActivityDefNotFoundException;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.exception.DataFieldNotFoundException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.exception.EventNotFoundException;
import org.ow2.bonita.facade.exception.IllegalTaskStateException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.TaskNotFoundException;
import org.ow2.bonita.facade.exception.UncancellableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.VariableNotFoundException;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.impl.QueryDefinitionAPIImpl;
import org.ow2.bonita.facade.impl.SearchResult;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.impl.CommentImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.AbstractUUID;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.CatchingEventUUID;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.ActivityManager;
import org.ow2.bonita.runtime.TaskManager;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Archiver;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.DocumentService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyBindingBuilder;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessUtil;
import org.ow2.bonita.util.TransientData;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class RuntimeAPIImpl
implements RuntimeAPI {
    private static final Logger LOG = Logger.getLogger(RuntimeAPIImpl.class.getName());
    private String queryList;

    protected RuntimeAPIImpl(String queryList) {
        this.queryList = queryList;
    }

    private String getQueryList() {
        return this.queryList;
    }

    @Override
    public void enableEventsInFailure(ActivityInstanceUUID activityUUID) {
        EventService eventService = EnvTool.getEventService();
        eventService.enableEventsInFailureIncomingEvents(activityUUID);
    }

    @Override
    public void enableEventsInFailure(ProcessInstanceUUID instanceUUID, String activityName) {
        Set<InternalActivityInstance> activities = EnvTool.getAllQueriers().getActivityInstances(instanceUUID, activityName);
        for (InternalActivityInstance activity : activities) {
            this.enableEventsInFailure(activity.getUUID());
        }
    }

    @Override
    public void enablePermanentEventInFailure(ActivityDefinitionUUID activityUUID) {
        EventService eventService = EnvTool.getEventService();
        eventService.enablePermanentEventsInFailure(activityUUID);
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        try {
            return this.instantiateProcess(processUUID, null, null);
        }
        catch (VariableNotFoundException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID, ActivityDefinitionUUID activityUUID) throws ProcessNotFoundException {
        try {
            return this.instantiateProcess(processUUID, null, null, activityUUID);
        }
        catch (VariableNotFoundException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID, Map<String, Object> variables) throws ProcessNotFoundException, VariableNotFoundException {
        return this.instantiateProcess(processUUID, variables, null);
    }

    @Override
    public ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID, Map<String, Object> variables, Collection<InitialAttachment> attachments) throws ProcessNotFoundException, VariableNotFoundException {
        return this.instantiateProcess(processUUID, variables, attachments, null);
    }

    private ProcessInstanceUUID instantiateProcess(ProcessDefinitionUUID processUUID, Map<String, Object> variables, Collection<InitialAttachment> attachments, ActivityDefinitionUUID activityUUID) throws ProcessNotFoundException, VariableNotFoundException {
        FacadeUtil.checkArgsNotNull(processUUID);
        ProcessDefinition.ProcessState state = new QueryDefinitionAPIImpl(this.queryList).getProcess(processUUID).getState();
        if (ProcessDefinition.ProcessState.DISABLED.equals((Object)state)) {
            String message = ExceptionManager.getInstance().getFullMessage("bai_RAPII_36", processUUID);
            throw new BonitaRuntimeException(message);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting a new instance of process : " + processUUID);
        }
        Execution rootExecution = ProcessUtil.createProcessInstance(processUUID, variables, attachments, null, null, activityUUID, null);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Started: " + rootExecution.getInstance());
        }
        InternalProcessInstance instance = rootExecution.getInstance();
        ProcessInstanceUUID instanceUUID = instance.getUUID();
        ProcessUtil.startEventSubProcesses(instance);
        rootExecution.getInstance().begin(activityUUID);
        return instanceUUID;
    }

    @Override
    public void executeTask(ActivityInstanceUUID taskUUID, boolean assignTask) throws TaskNotFoundException, IllegalTaskStateException {
        this.startTask(taskUUID, assignTask);
        this.finishTask(taskUUID, assignTask);
    }

    @Override
    public void cancelProcessInstance(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException, UncancellableInstanceException {
        FacadeUtil.checkArgsNotNull(instanceUUID);
        InternalProcessInstance instance = FacadeUtil.getInstance(instanceUUID, null);
        if (instance == null) {
            throw new InstanceNotFoundException("bai_RAPII_1", instanceUUID);
        }
        if (instance == null || instance.getParentInstanceUUID() != null || !instance.getInstanceState().equals((Object)InstanceState.STARTED)) {
            throw new UncancellableInstanceException("bai_RAPII_2", instanceUUID, instance.getParentInstanceUUID(), instance.getInstanceState());
        }
        instance.cancel();
    }

    @Override
    public void cancelProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs) throws InstanceNotFoundException, UncancellableInstanceException {
        FacadeUtil.checkArgsNotNull(instanceUUIDs);
        for (ProcessInstanceUUID instanceUUID : instanceUUIDs) {
            this.cancelProcessInstance(instanceUUID);
        }
    }

    @Override
    public void deleteProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs) throws InstanceNotFoundException, UndeletableInstanceException {
        if (instanceUUIDs != null) {
            for (ProcessInstanceUUID instanceUUID : instanceUUIDs) {
                this.deleteProcessInstance(instanceUUID);
            }
        }
    }

    @Override
    public void deleteProcessInstance(ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException, UndeletableInstanceException {
        boolean inJournal;
        FacadeUtil.checkArgsNotNull(instanceUUID);
        Querier allQueriers = EnvTool.getAllQueriers();
        Querier journal = EnvTool.getJournalQueriers();
        Querier history = EnvTool.getHistoryQueriers();
        InternalProcessInstance processInst = journal.getProcessInstance(instanceUUID);
        boolean inHistory = false;
        boolean bl = inJournal = processInst != null;
        if (!inJournal) {
            processInst = history.getProcessInstance(instanceUUID);
            boolean bl2 = inHistory = processInst != null;
        }
        if (processInst == null) {
            throw new InstanceNotFoundException("bai_RAPII_3", instanceUUID);
        }
        ProcessInstanceUUID parentInstanceUUID = processInst.getParentInstanceUUID();
        if (parentInstanceUUID != null && allQueriers.getProcessInstance(parentInstanceUUID) != null) {
            throw new UndeletableInstanceException("bai_RAPII_4", instanceUUID, parentInstanceUUID);
        }
        EnvTool.getLargeDataRepository().deleteData(Misc.getAttachmentCategories(instanceUUID));
        ProcessUtil.removeAllInstanceEvents(processInst);
        ProcessUtil.removeSubProcessEvents(processInst);
        if (inJournal) {
            Recorder recorder = EnvTool.getRecorder();
            recorder.remove(processInst);
        } else if (inHistory) {
            Archiver archiver = EnvTool.getArchiver();
            archiver.remove(processInst);
        }
        Set<ProcessInstanceUUID> children = processInst.getChildrenInstanceUUID();
        for (ProcessInstanceUUID child : children) {
            this.deleteProcessInstance(child);
        }
    }

    @Override
    public void deleteAllProcessInstances(Collection<ProcessDefinitionUUID> processUUIDs) throws ProcessNotFoundException, UndeletableInstanceException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        for (ProcessDefinitionUUID processUUID : processUUIDs) {
            this.deleteAllProcessInstances(processUUID);
        }
    }

    @Override
    public void deleteAllProcessInstances(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException, UndeletableInstanceException {
        FacadeUtil.checkArgsNotNull(processUUID);
        Querier querier = EnvTool.getAllQueriers();
        InternalProcessDefinition process = querier.getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_RAPII_5", processUUID);
        }
        this.deleteAllProcessInstances(process);
    }

    public void deleteAllProcessInstances(ProcessDefinition process) throws ProcessNotFoundException, UndeletableInstanceException {
        FacadeUtil.checkArgsNotNull(process);
        ProcessDefinitionUUID processUUID = process.getUUID();
        Querier querier = EnvTool.getAllQueriers();
        Set<InternalProcessInstance> instances = querier.getProcessInstances(processUUID);
        for (InternalProcessInstance instance : instances) {
            if (instance.getParentInstanceUUID() != null) continue;
            try {
                this.deleteProcessInstance(instance.getUUID());
            }
            catch (InstanceNotFoundException e) {
                String message = ExceptionManager.getInstance().getFullMessage("bai_RAPII_6", new Object[0]);
                throw new BonitaInternalException(message, e);
            }
        }
        instances = querier.getProcessInstances(processUUID);
        if (instances != null && !instances.isEmpty()) {
            ProcessInstance first = instances.iterator().next();
            throw new UndeletableInstanceException("bai_RAPII_7", first.getUUID(), first.getParentInstanceUUID());
        }
    }

    @Override
    public void startTask(ActivityInstanceUUID taskUUID, boolean assignTask) throws TaskNotFoundException, IllegalTaskStateException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.start(taskUUID, assignTask);
    }

    @Override
    public void startActivity(ActivityInstanceUUID activityUUID) throws ActivityNotFoundException {
    }

    @Override
    public void finishTask(ActivityInstanceUUID taskUUID, boolean assignTask) throws TaskNotFoundException, IllegalTaskStateException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.finish(taskUUID, assignTask);
    }

    @Override
    public void suspendTask(ActivityInstanceUUID taskUUID, boolean assignTask) throws TaskNotFoundException, IllegalTaskStateException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.suspend(taskUUID, assignTask);
    }

    @Override
    public void resumeTask(ActivityInstanceUUID taskUUID, boolean taskAssign) throws TaskNotFoundException, IllegalTaskStateException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.resume(taskUUID, taskAssign);
    }

    @Override
    public void assignTask(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.assign(taskUUID);
    }

    @Override
    public void assignTask(ActivityInstanceUUID taskUUID, String userId) throws TaskNotFoundException {
        FacadeUtil.checkArgsNotNull(taskUUID, userId);
        TaskManager.assign(taskUUID, userId);
    }

    @Override
    public void assignTask(ActivityInstanceUUID taskUUID, Set<String> candidates) throws TaskNotFoundException {
        FacadeUtil.checkArgsNotNull(taskUUID, candidates);
        TaskManager.assign(taskUUID, candidates);
    }

    @Override
    public void unassignTask(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.unAssign(taskUUID);
    }

    private String getDataTypeClassName(String variableId, Object variableValue, AbstractUUID uuid) {
        boolean mayBeAnXmlDocument;
        boolean bl = mayBeAnXmlDocument = variableValue != null && variableValue instanceof String && (((String)variableValue).trim().startsWith("<") || ((String)variableValue).trim().startsWith("&lt;"));
        if (mayBeAnXmlDocument) {
            String dataTypeClassName = null;
            DataFieldDefinition dataFieldDefinition = null;
            String dataFieldName = Misc.getVariableName(variableId);
            StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
            QueryDefinitionAPI queryDefinitionAPI = accessor.getQueryDefinitionAPI("journalQueryList");
            try {
                if (uuid instanceof ProcessDefinitionUUID) {
                    dataFieldDefinition = queryDefinitionAPI.getProcessDataField((ProcessDefinitionUUID)uuid, dataFieldName);
                } else if (uuid instanceof ActivityDefinitionUUID) {
                    dataFieldDefinition = queryDefinitionAPI.getActivityDataField((ActivityDefinitionUUID)uuid, dataFieldName);
                }
                dataTypeClassName = dataFieldDefinition.getDataTypeClassName();
            }
            catch (Exception e) {
                throw new BonitaRuntimeException("unable to find datafield with name: " + dataFieldName + " in " + uuid);
            }
            return dataTypeClassName;
        }
        return null;
    }

    @Override
    public void setProcessInstanceVariable(ProcessInstanceUUID instanceUUID, String variableId, Object variableValue) throws InstanceNotFoundException, VariableNotFoundException {
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        AttachmentInstance attachment = null;
        if (instance == null) {
            throw new InstanceNotFoundException("bai_RAPII_20", instanceUUID);
        }
        String variableName = Misc.getVariableName(variableId);
        if (!instance.getLastKnownVariableValues().containsKey(variableName)) {
            DocumentationManager manager = EnvTool.getDocumentationManager();
            List<Object> attachments = new ArrayList();
            if (instance.getNbOfAttachments() > 0) {
                attachments = DocumentService.getAllAttachmentVersions(manager, instanceUUID);
            }
            if (attachments.size() == 0) {
                throw new VariableNotFoundException("bai_RAPII_21", instanceUUID, variableName);
            }
            attachment = (AttachmentInstance)attachments.get(attachments.size() - 1);
        }
        Object newValue = variableValue;
        String targetVariable = variableId;
        String dataTypeClassName = this.getDataTypeClassName(variableId, variableValue, instance.getProcessDefinitionUUID());
        if (attachment == null) {
            if (variableId.contains("$")) {
                try {
                    targetVariable = Misc.getVariableName(variableId);
                    newValue = this.getXMLValueXPath(variableId, variableValue, null, instanceUUID);
                }
                catch (Exception e) {
                    throw new VariableNotFoundException("bai_RAPII_32", instanceUUID, variableId);
                }
            }
            if (variableId.contains("#")) {
                try {
                    targetVariable = Misc.getVariableName(variableId);
                    newValue = this.getModifiedJavaObject(variableId, variableValue, null, instance);
                }
                catch (Exception ex) {
                    throw new VariableNotFoundException("bai_RAPII_34", instanceUUID, null, variableId);
                }
            }
            if (org.w3c.dom.Document.class.getName().equals(dataTypeClassName) && variableValue instanceof String) {
                try {
                    newValue = Misc.generateDocument((String)variableValue);
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException("Unable to build a DOM Document from String: " + variableValue);
                }
            }
            EnvTool.getRecorder().recordInstanceVariableUpdated(targetVariable, newValue, instance.getUUID(), EnvTool.getUserId());
        } else if (variableValue instanceof byte[]) {
            this.addAttachment(instanceUUID, attachment.getName(), attachment.getFileName(), (byte[])variableValue);
        } else if (variableValue instanceof AttachmentInstance) {
            byte[] attachmentValue;
            AttachmentInstance newAttachment = (AttachmentInstance)variableValue;
            try {
                DocumentationManager manager = EnvTool.getDocumentationManager();
                Document document = manager.getDocument(newAttachment.getUUID().getValue());
                attachmentValue = manager.getContent(document);
            }
            catch (DocumentNotFoundException e) {
                throw new BonitaRuntimeException(e);
            }
            this.addAttachment(instanceUUID, attachment.getName(), newAttachment.getFileName(), attachmentValue);
        } else {
            String message = ExceptionManager.getInstance().getMessage("bai_RAPII_37", new Object[0]);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void setProcessInstanceVariables(ProcessInstanceUUID instanceUUID, Map<String, Object> variables) throws InstanceNotFoundException, VariableNotFoundException {
        for (String key : variables.keySet()) {
            this.setProcessInstanceVariable(instanceUUID, key, variables.get(key));
        }
    }

    @Override
    public void setActivityInstanceVariable(ActivityInstanceUUID activityUUID, String variableId, Object variableValue) throws ActivityNotFoundException, VariableNotFoundException {
        Map<String, Object> transientVariables = TransientData.getActivityTransientVariables(activityUUID);
        if (transientVariables != null && transientVariables.containsKey(variableId)) {
            TransientData.updateActivityTransientVariableValue(activityUUID, variableId, variableValue);
            return;
        }
        InternalActivityInstance activity = EnvTool.getJournalQueriers().getActivityInstance(activityUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_RAPII_22", activityUUID);
        }
        ProcessInstanceUUID instanceUUID = activity.getProcessInstanceUUID();
        String activityId = activity.getActivityName();
        if (!activity.getLastKnownVariableValues().containsKey(Misc.getVariableName(variableId))) {
            throw new VariableNotFoundException("bai_RAPII_24", instanceUUID, activityId, Misc.getVariableName(variableId));
        }
        Recorder recorder = EnvTool.getRecorder();
        Object newValue = variableValue;
        String targetVariable = variableId;
        String dataTypeClassName = this.getDataTypeClassName(variableId, variableValue, activity.getActivityDefinitionUUID());
        if (variableId.contains("$")) {
            try {
                targetVariable = Misc.getVariableName(variableId);
                newValue = this.getXMLValueXPath(variableId, variableValue, activityUUID, null);
            }
            catch (Exception e) {
                throw new VariableNotFoundException("bai_RAPII_31", instanceUUID, activityId, variableId);
            }
        }
        if (variableId.contains("#")) {
            try {
                targetVariable = Misc.getVariableName(variableId);
                newValue = this.getModifiedJavaObject(variableId, variableValue, activity, null);
            }
            catch (Exception ex) {
                throw new VariableNotFoundException("bai_RAPII_35", instanceUUID, activityId, variableId);
            }
        }
        if (org.w3c.dom.Document.class.getName().equals(dataTypeClassName) && variableValue instanceof String) {
            try {
                newValue = Misc.generateDocument((String)variableValue);
            }
            catch (Exception e) {
                throw new BonitaRuntimeException("Unable to build a DOM Document from String: " + variableValue);
            }
        }
        recorder.recordActivityVariableUpdated(targetVariable, newValue, activityUUID, EnvTool.getUserId());
    }

    @Override
    public void setActivityInstanceVariables(ActivityInstanceUUID activityUUID, Map<String, Object> variables) throws ActivityNotFoundException, VariableNotFoundException {
        for (String key : variables.keySet()) {
            this.setActivityInstanceVariable(activityUUID, key, variables.get(key));
        }
    }

    private Object getModifiedJavaObject(String variableExpression, Object attributeValue, ActivityInstance activity, ProcessInstance processInstance) throws ActivityNotFoundException, VariableNotFoundException, InstanceNotFoundException {
        String variableName = Misc.getVariableName(variableExpression);
        ActivityInstanceUUID activityUUID = null;
        if (activity != null) {
            activityUUID = activity.getUUID();
        }
        ProcessInstanceUUID processInstanceUUID = null;
        if (processInstance != null) {
            processInstanceUUID = processInstance.getUUID();
        }
        Object data = this.getVariable(variableName, activityUUID, processInstanceUUID);
        ProcessDefinitionUUID processDefUUID = null;
        processDefUUID = processInstanceUUID != null ? processInstance.getProcessDefinitionUUID() : activity.getProcessDefinitionUUID();
        return this.getModifiedJavaObject(processDefUUID, variableExpression, data, attributeValue);
    }

    @Override
    public Object getModifiedJavaObject(ProcessDefinitionUUID processUUID, String variableExpression, Object variableValue, Object attributeValue) {
        String variableName = Misc.getVariableName(variableExpression);
        String groovyPlaceholderAccessExpression = Misc.getGroovyPlaceholderAccessExpression(variableExpression);
        String setterName = Misc.getSetterName(variableExpression);
        ClassLoader processClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader(processUUID);
        return this.modifyJavaObject(variableValue, variableName, groovyPlaceholderAccessExpression, setterName, attributeValue, processClassLoader);
    }

    private Object modifyJavaObject(Object data, String variableName, String groovyPlaceholderAccessExpression, String setterName, Object variableValue, ClassLoader classLoader) {
        GroovyShell shell = new GroovyShell(classLoader);
        shell.setProperty(variableName, data);
        shell.setProperty("__variableValue__", variableValue);
        StringBuilder script = new StringBuilder();
        script.append("def __tmp__ =");
        if (groovyPlaceholderAccessExpression != null && groovyPlaceholderAccessExpression.trim().length() > 0) {
            script.append(groovyPlaceholderAccessExpression);
        } else {
            script.append(variableName);
        }
        script.append(";\n");
        script.append("__tmp__.");
        script.append(setterName);
        script.append("(__variableValue__);\n");
        script.append(variableName);
        return shell.evaluate(script.toString());
    }

    private Object getXMLValueXPath(String variableId, Object variableValue, ActivityInstanceUUID activityUUID, ProcessInstanceUUID processInstanceUUID) throws Exception {
        String variableName = Misc.getVariableName(variableId);
        String xpathExpression = Misc.getXPath(variableId);
        boolean isAppend = Misc.isXMLAppend(variableId);
        org.w3c.dom.Document doc = (org.w3c.dom.Document)this.getVariable(variableName, activityUUID, processInstanceUUID);
        return this.evaluateXPath(doc, xpathExpression, isAppend, variableValue);
    }

    private Object getVariable(String variableName, ActivityInstanceUUID activityUUID, ProcessInstanceUUID processInstanceUUID) throws ActivityNotFoundException, VariableNotFoundException, InstanceNotFoundException {
        Object oldValue = null;
        QueryRuntimeAPI queryAPI = new StandardAPIAccessorImpl().getQueryRuntimeAPI();
        oldValue = activityUUID != null ? queryAPI.getVariable(activityUUID, variableName) : queryAPI.getProcessInstanceVariable(processInstanceUUID, variableName);
        return oldValue;
    }

    private org.w3c.dom.Document evaluateXPath(org.w3c.dom.Document doc, String xpathExpression, boolean isAppend, Object variableValue) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.compile(xpathExpression).evaluate(doc, XPathConstants.NODE);
        if (this.isSetAttribute(xpathExpression, variableValue)) {
            if (node == null) {
                String parentPath = xpathExpression.substring(0, xpathExpression.lastIndexOf(47));
                String attributeName = xpathExpression.substring(xpathExpression.lastIndexOf(47) + 2);
                Node parentNode = (Node)xpath.compile(parentPath).evaluate(doc, XPathConstants.NODE);
                if (parentNode != null && parentNode instanceof Element) {
                    Element element = (Element)parentNode;
                    if (variableValue instanceof String) {
                        element.setAttribute(attributeName, (String)variableValue);
                    } else if (variableValue instanceof Attr) {
                        element.setAttribute(((Attr)variableValue).getName(), ((Attr)variableValue).getTextContent());
                    }
                }
            } else if (node instanceof Attr) {
                if (variableValue instanceof String) {
                    node.setTextContent((String)variableValue);
                } else if (variableValue instanceof Attr) {
                    node.setTextContent(((Attr)variableValue).getTextContent());
                }
            } else if (node instanceof Element) {
                Attr attr = (Attr)variableValue;
                ((Element)node).setAttribute(attr.getName(), attr.getValue());
            }
        } else if (node instanceof Text) {
            node.setTextContent((String)variableValue);
        } else if (node instanceof Element) {
            Node newNode = null;
            if (variableValue instanceof Node) {
                newNode = doc.importNode((Node)variableValue, true);
            } else if (variableValue instanceof String) {
                newNode = doc.importNode(Misc.generateDocument((String)variableValue).getDocumentElement(), true);
            }
            if (isAppend) {
                node.appendChild(newNode);
            } else {
                Node parentNode = node.getParentNode();
                parentNode.removeChild(node);
                parentNode.appendChild(newNode);
            }
        } else if (node == null && xpathExpression.endsWith("/text()") && variableValue instanceof String) {
            String parentPath = xpathExpression.substring(0, xpathExpression.lastIndexOf(47));
            Node parentNode = (Node)xpath.compile(parentPath).evaluate(doc, XPathConstants.NODE);
            parentNode.appendChild(doc.createTextNode((String)variableValue));
        }
        return doc;
    }

    private boolean isSetAttribute(String xpathExpression, Object variableValue) {
        if (variableValue instanceof Attr) {
            return true;
        }
        String[] segments = xpathExpression.split("/");
        return segments[segments.length - 1].startsWith("@");
    }

    @Override
    public void setVariable(ActivityInstanceUUID activityUUID, String variableId, Object variableValue) throws ActivityNotFoundException, VariableNotFoundException {
        try {
            this.setActivityInstanceVariable(activityUUID, variableId, variableValue);
        }
        catch (Throwable e) {
            InternalActivityInstance activity = EnvTool.getAllQueriers().getActivityInstance(activityUUID);
            if (activity == null) {
                throw new ActivityNotFoundException("bai_RAPII_25", activityUUID);
            }
            try {
                this.setProcessInstanceVariable(activity.getProcessInstanceUUID(), variableId, variableValue);
            }
            catch (InstanceNotFoundException e1) {
                Misc.unreachableStatement();
            }
        }
    }

    @Override
    public void addComment(ProcessInstanceUUID instanceUUID, String message, String userId) throws InstanceNotFoundException {
        CommentImpl comment = new CommentImpl(userId, message, instanceUUID);
        this.addComment(comment, instanceUUID);
    }

    @Override
    public void addComment(ActivityInstanceUUID activityUUID, String message, String userId) throws ActivityNotFoundException, InstanceNotFoundException {
        InternalActivityInstance activity = EnvTool.getJournalQueriers().getActivityInstance(activityUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_RAPII_28", activityUUID);
        }
        CommentImpl comment = new CommentImpl(userId, message, activityUUID, activity.getProcessInstanceUUID());
        this.addComment(comment, activity.getProcessInstanceUUID());
    }

    private void addComment(Comment comment, ProcessInstanceUUID instanceUUID) throws InstanceNotFoundException {
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        if (instance == null) {
            throw new InstanceNotFoundException("bai_RAPII_27", instanceUUID);
        }
        instance.addComment(comment);
    }

    @Override
    @Deprecated
    public void addComment(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID, String message, String userId) throws InstanceNotFoundException, ActivityNotFoundException {
        InternalActivityInstance activity;
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        if (instance == null) {
            throw new InstanceNotFoundException("bai_RAPII_27", instanceUUID);
        }
        if (activityUUID != null && (activity = EnvTool.getAllQueriers().getActivityInstance(activityUUID)) == null) {
            throw new ActivityNotFoundException("bai_RAPII_28", activityUUID);
        }
        CommentImpl comment = activityUUID != null ? new CommentImpl(userId, message, activityUUID, instanceUUID) : new CommentImpl(userId, message, instanceUUID);
        instance.addComment(comment);
    }

    @Override
    public void addProcessMetaData(ProcessDefinitionUUID uuid, String key, String value) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(uuid, key, value);
        InternalProcessDefinition process = EnvTool.getAllQueriers().getProcess(uuid);
        if (process == null) {
            throw new ProcessNotFoundException("bai_RAPII_29", uuid);
        }
        process.addAMetaData(key, value);
    }

    @Override
    public void deleteProcessMetaData(ProcessDefinitionUUID uuid, String key) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(uuid, key);
        InternalProcessDefinition process = EnvTool.getAllQueriers().getProcess(uuid);
        if (process == null) {
            throw new ProcessNotFoundException("bai_RAPII_29", uuid);
        }
        process.deleteAMetaData(key);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessInstanceUUID instanceUUID, boolean propagate) throws InstanceNotFoundException, GroovyException {
        return this.evaluateGroovyExpression(expression, instanceUUID, null, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessInstanceUUID instanceUUID, Map<String, Object> context, boolean propagate) throws InstanceNotFoundException, GroovyException {
        return GroovyUtil.evaluate(expression, context, instanceUUID, false, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessInstanceUUID instanceUUID, Map<String, Object> context, boolean useInitialVariableValues, boolean propagate) throws InstanceNotFoundException, GroovyException {
        return GroovyUtil.evaluate(expression, context, instanceUUID, useInitialVariableValues, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ActivityInstanceUUID activityUUID, boolean useActivityScope, boolean propagate) throws InstanceNotFoundException, ActivityNotFoundException, GroovyException {
        return this.evaluateGroovyExpression(expression, activityUUID, null, useActivityScope, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ActivityInstanceUUID activityUUID, Map<String, Object> context, boolean useActivityScope, boolean propagate) throws InstanceNotFoundException, ActivityNotFoundException, GroovyException {
        return GroovyUtil.evaluate(expression, context, activityUUID, useActivityScope, propagate);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException, GroovyException {
        return this.evaluateGroovyExpression(expression, processDefinitionUUID, null);
    }

    @Override
    public Object evaluateGroovyExpression(String expression, ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> context) throws ProcessNotFoundException, GroovyException {
        return GroovyUtil.evaluate(expression, context, processDefinitionUUID, false);
    }

    @Override
    public Map<String, Object> evaluateGroovyExpressions(Map<String, String> expressions, ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> context) throws ProcessNotFoundException, GroovyException {
        Misc.checkArgsNotNull(processDefinitionUUID);
        if (expressions == null || expressions.isEmpty()) {
            return Collections.emptyMap();
        }
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            Map<String, Object> results;
            ClassLoader processClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader(processDefinitionUUID);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            Binding simpleBinding = GroovyBindingBuilder.getSimpleBinding(processDefinitionUUID, null, null, context, true, true);
            Map<String, Object> map = results = this.evaluateGroovyExpressions(expressions, simpleBinding);
            return map;
        }
        catch (Exception e) {
            throw new GroovyException("Exception while getting binding. ProcessDefinitionUUID: " + processDefinitionUUID, e);
        }
        finally {
            if (ori != null && ori != Thread.currentThread().getContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(ori);
            }
        }
    }

    @Override
    public Map<String, Object> evaluateGroovyExpressions(Map<String, String> expressions, ActivityInstanceUUID activityUUID, Map<String, Object> context, boolean useActivityScope, boolean propagate) throws InstanceNotFoundException, ActivityNotFoundException, GroovyException {
        Misc.checkArgsNotNull(activityUUID);
        if (expressions == null || expressions.isEmpty()) {
            return Collections.emptyMap();
        }
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            InternalActivityInstance activityInstance = EnvTool.getAllQueriers().getActivityInstance(activityUUID);
            ProcessDefinitionUUID definitionUUID = activityInstance.getProcessDefinitionUUID();
            ClassLoader processClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader(definitionUUID);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            Binding binding = this.getBinding(definitionUUID, activityInstance.getProcessInstanceUUID(), activityUUID, context, useActivityScope, false, propagate);
            Map<String, Object> results = this.evaluateGroovyExpressions(expressions, binding);
            this.propagateVariablesIfNecessary(activityUUID, null, propagate, binding);
            Map<String, Object> map = results;
            return map;
        }
        catch (Exception e) {
            throw new GroovyException("Exception while evaluating expression. ActivityInstanceUUID: " + activityUUID, e);
        }
        finally {
            if (ori != null && ori != Thread.currentThread().getContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(ori);
            }
        }
    }

    private void propagateVariablesIfNecessary(ActivityInstanceUUID activityUUID, ProcessInstanceUUID instanceUUID, boolean propagate, Binding binding) throws GroovyException {
        if (propagate) {
            try {
                GroovyUtil.propagateVariables(((GroovyBindingBuilder.PropagateBinding)binding).getVariablesToPropagate(), activityUUID, instanceUUID);
            }
            catch (Exception e) {
                throw new GroovyException("Exception while propagating variables", e);
            }
        }
    }

    private Binding getBinding(ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID, Map<String, Object> context, boolean useActiveScope, boolean useInitialVariableValues, boolean propagate) throws GroovyException {
        Binding binding = null;
        try {
            binding = propagate ? GroovyBindingBuilder.getPropagateBinding(processUUID, instanceUUID, activityUUID, context, useActiveScope, useInitialVariableValues) : GroovyBindingBuilder.getSimpleBinding(processUUID, instanceUUID, activityUUID, context, useActiveScope, useInitialVariableValues);
        }
        catch (Exception e) {
            throw new GroovyException("Exception while getting binding", e);
        }
        return binding;
    }

    private Map<String, Object> evaluateGroovyExpressions(Map<String, String> expressions, Binding binding) throws GroovyException, NotSerializableException, ActivityDefNotFoundException, DataFieldNotFoundException, ProcessNotFoundException, IOException, ClassNotFoundException {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (String expressionName : expressions.keySet()) {
            String expression = expressions.get(expressionName);
            Object result = GroovyUtil.evaluate(expression, binding);
            results.put(expressionName, result);
        }
        return results;
    }

    @Override
    public Map<String, Object> evaluateGroovyExpressions(Map<String, String> expressions, ProcessInstanceUUID processInstanceUUID, Map<String, Object> context, boolean useInitialVariableValues, boolean propagate) throws InstanceNotFoundException, GroovyException {
        Misc.checkArgsNotNull(processInstanceUUID);
        if (expressions == null || expressions.isEmpty()) {
            return Collections.emptyMap();
        }
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            InternalProcessInstance instance = EnvTool.getAllQueriers().getProcessInstance(processInstanceUUID);
            ProcessDefinitionUUID definitionUUID = instance.getProcessDefinitionUUID();
            ClassLoader processClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader(definitionUUID);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            Binding binding = this.getBinding(definitionUUID, processInstanceUUID, null, context, false, useInitialVariableValues, propagate);
            Map<String, Object> results = this.evaluateGroovyExpressions(expressions, binding);
            this.propagateVariablesIfNecessary(null, processInstanceUUID, propagate, binding);
            Map<String, Object> map = results;
            return map;
        }
        catch (Exception e) {
            throw new GroovyException("Exception while evaluating expression. ProcessInstanceUUID: " + processInstanceUUID, e);
        }
        finally {
            if (ori != null && ori != Thread.currentThread().getContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(ori);
            }
        }
    }

    @Override
    public void addAttachment(ProcessInstanceUUID instanceUUID, String name, String fileName, byte[] value) {
        if (value == null && fileName != null) {
            throw new BonitaRuntimeException("The content of the attachment cannot be null");
        }
        try {
            this.createDocument(name, instanceUUID, fileName, "application/octet-stream", value);
        }
        catch (Exception e) {
            DocumentationManager manager = EnvTool.getDocumentationManager();
            SearchResult result = DocumentService.getDocuments(manager, instanceUUID, name);
            try {
                this.addDocumentVersion(result.getDocuments().get(0).getId(), true, fileName, "application/octet-stream", value);
            }
            catch (DocumentationCreationException e1) {
                throw new BonitaRuntimeException(e);
            }
        }
    }

    @Override
    public void addAttachment(ProcessInstanceUUID instanceUUID, String name, String label, String description, String fileName, Map<String, String> metadata, byte[] value) {
        if (value == null && fileName != null) {
            throw new BonitaRuntimeException("The content of the attachment cannot be null");
        }
        String mimeType = metadata.get("content-type");
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        try {
            this.createDocument(name, instanceUUID, fileName, mimeType, value);
        }
        catch (Exception e) {
            DocumentationManager manager = EnvTool.getDocumentationManager();
            SearchResult result = DocumentService.getDocuments(manager, instanceUUID, name);
            try {
                this.addDocumentVersion(result.getDocuments().get(0).getId(), true, fileName, mimeType, value);
            }
            catch (DocumentationCreationException e1) {
                throw new BonitaRuntimeException(e);
            }
        }
    }

    @Override
    public void addAttachments(Map<AttachmentInstance, byte[]> attachments) {
        if (attachments != null) {
            for (Map.Entry<AttachmentInstance, byte[]> attachment : attachments.entrySet()) {
                AttachmentInstance attachmentInstance = attachment.getKey();
                String name = attachmentInstance.getName();
                ProcessInstanceUUID instanceUUID = attachmentInstance.getProcessInstanceUUID();
                String fileName = attachmentInstance.getFileName();
                String mimeType = attachmentInstance.getMetaData().get("content-type");
                if (mimeType == null) {
                    mimeType = "application/octet-stream";
                }
                try {
                    this.createDocument(name, instanceUUID, fileName, mimeType, attachment.getValue());
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException(e);
                }
            }
        }
    }

    @Override
    public void removeAttachment(ProcessInstanceUUID instanceUUID, String name) throws InstanceNotFoundException {
        FacadeUtil.checkArgsNotNull(instanceUUID, name);
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        if (instance == null) {
            throw new InstanceNotFoundException("bai_RAPII_1", instanceUUID);
        }
        if (instance.getNbOfAttachments() <= 0) {
            throw new BonitaRuntimeException(new DocumentNotFoundException(name));
        }
        DocumentationManager manager = EnvTool.getDocumentationManager();
        SearchResult result = DocumentService.getDocuments(manager, instanceUUID, name);
        List<Document> documents = result.getDocuments();
        if (!documents.isEmpty()) {
            Document document = documents.get(0);
            try {
                manager.deleteDocument(document.getId(), true);
                instance.setNbOfAttachments(instance.getNbOfAttachments() - 1);
            }
            catch (DocumentNotFoundException e) {
                throw new BonitaRuntimeException(e);
            }
        }
    }

    @Override
    public void setActivityInstancePriority(ActivityInstanceUUID activityInstanceUUID, int priority) throws ActivityNotFoundException {
        InternalActivityInstance activity = EnvTool.getJournalQueriers().getActivityInstance(activityInstanceUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_RAPII_22", activityInstanceUUID);
        }
        ProcessInstanceUUID instanceUUID = activity.getProcessInstanceUUID();
        Execution execution = EnvTool.getJournalQueriers().getExecutionOnActivity(instanceUUID, activityInstanceUUID);
        if (execution == null) {
            throw new ActivityNotFoundException("bai_RAPII_23", activityInstanceUUID);
        }
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordActivityPriorityUpdated(activityInstanceUUID, priority);
    }

    @Override
    public void deleteEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID actiivtyUUID) {
        EventService eventService = EnvTool.getEventService();
        Set<OutgoingEventInstance> events = eventService.getOutgoingEvents(eventName, toProcessName, toActivityName, actiivtyUUID);
        if (events != null) {
            for (OutgoingEventInstance event : events) {
                eventService.removeEvent(event);
            }
        }
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID) throws Exception {
        return this.executeConnector(connectorClassName, parameters, definitionUUID, null, null, null, null, true);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters) throws Exception {
        return this.executeConnector(connectorClassName, parameters, null, null, null, null, null, true);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ClassLoader classLoader) throws Exception {
        return this.executeConnector(connectorClassName, parameters, null, null, null, classLoader, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityInstanceUUID, ClassLoader classLoader, Map<String, Object> context, boolean useCurrentVariableValues) throws Exception {
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Connector connector = null;
            if (classLoader == null && definitionUUID == null) {
                connector = (Connector)EnvTool.getClassDataLoader().getInstance(null, connectorClassName);
            } else {
                Class<?> objectClass = null;
                if (classLoader == null) {
                    ClassLoader processClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader(definitionUUID);
                    Thread.currentThread().setContextClassLoader(processClassLoader);
                    objectClass = Class.forName(connectorClassName, true, processClassLoader);
                } else {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    objectClass = Class.forName(connectorClassName, true, classLoader);
                }
                connector = (Connector)objectClass.newInstance();
            }
            if (connector instanceof Mapper) {
                throw new IllegalAccessException(connectorClassName + " is a instance of RoleResolver or Filter");
            }
            Map<String, Object> map = ConnectorExecutor.executeConnector(connector, definitionUUID, instanceUUID, activityInstanceUUID, parameters, context, useCurrentVariableValues);
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID, Map<String, Object> context) throws Exception {
        return this.executeConnector(connectorClassName, parameters, definitionUUID, null, null, null, context, true);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ProcessInstanceUUID processInstanceUUID, Map<String, Object> context, boolean useCurrentVariableValues) throws Exception {
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(processInstanceUUID);
        return this.executeConnector(connectorClassName, parameters, instance.getProcessDefinitionUUID(), processInstanceUUID, null, null, context, useCurrentVariableValues);
    }

    @Override
    public Map<String, Object> executeConnector(String connectorClassName, Map<String, Object[]> parameters, ActivityInstanceUUID activityInstanceUUID, Map<String, Object> context, boolean useCurrentVariableValues) throws Exception {
        InternalActivityInstance activity = EnvTool.getJournalQueriers().getActivityInstance(activityInstanceUUID);
        return this.executeConnector(connectorClassName, parameters, activity.getProcessDefinitionUUID(), null, activityInstanceUUID, null, context, useCurrentVariableValues);
    }

    @Override
    public Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members) throws Exception {
        return this.executeFilter(connectorClassName, parameters, members, null, null);
    }

    @Override
    public Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members, ProcessDefinitionUUID definitionUUID) throws Exception {
        return this.executeFilter(connectorClassName, parameters, members, definitionUUID, null);
    }

    @Override
    public Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members, ClassLoader classLoader) throws Exception {
        return this.executeFilter(connectorClassName, parameters, members, null, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> executeFilter(String connectorClassName, Map<String, Object[]> parameters, Set<String> members, ProcessDefinitionUUID definitionUUID, ClassLoader classLoader) throws Exception {
        FacadeUtil.checkArgsNotNull(members);
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Filter connector = null;
            if (classLoader == null) {
                connector = (Filter)EnvTool.getClassDataLoader().getInstance(definitionUUID, connectorClassName);
            } else {
                Thread.currentThread().setContextClassLoader(classLoader);
                Class<?> objectClass = Class.forName(connectorClassName, true, classLoader);
                connector = (Filter)objectClass.newInstance();
            }
            Set<String> set = ConnectorExecutor.executeFilter(connector, parameters, members);
            return set;
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    @Override
    public Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID) throws Exception {
        return this.executeRoleResolver(connectorClassName, parameters, definitionUUID, null);
    }

    @Override
    public Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters) throws Exception {
        return this.executeRoleResolver(connectorClassName, parameters, null, null);
    }

    @Override
    public Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters, ClassLoader classLoader) throws Exception {
        return this.executeRoleResolver(connectorClassName, parameters, null, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> executeRoleResolver(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID definitionUUID, ClassLoader classLoader) throws Exception {
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            RoleResolver connector = null;
            if (classLoader == null) {
                connector = (RoleResolver)EnvTool.getClassDataLoader().getInstance(definitionUUID, connectorClassName);
            } else {
                Thread.currentThread().setContextClassLoader(classLoader);
                Class<?> objectClass = Class.forName(connectorClassName, true, classLoader);
                connector = (RoleResolver)objectClass.newInstance();
            }
            Set<String> set = ConnectorExecutor.executeRoleResolver(connector, parameters);
            return set;
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    @Override
    public void skipTask(ActivityInstanceUUID taskUUID, Map<String, Object> variablesToUpdate) throws TaskNotFoundException, IllegalTaskStateException {
        FacadeUtil.checkArgsNotNull(taskUUID);
        TaskManager.skip(taskUUID, variablesToUpdate);
    }

    @Override
    public void skip(ActivityInstanceUUID activityInstanceUUID, Map<String, Object> variablesToUpdate) throws ActivityNotFoundException, IllegalTaskStateException {
        FacadeUtil.checkArgsNotNull(activityInstanceUUID);
        ActivityManager.skip(activityInstanceUUID, variablesToUpdate);
    }

    @Override
    public void executeEvent(CatchingEventUUID eventUUID) throws EventNotFoundException {
        long id;
        EventService eventService = EnvTool.getEventService();
        IncomingEventInstance internalEvent = eventService.getIncomingEvent(id = Long.parseLong(eventUUID.getValue()));
        String signal = internalEvent.getSignal();
        if (signal.contains("timer")) {
            this.updateExpirationDate(internalEvent, new Date());
        }
    }

    @Override
    public void deleteEvent(CatchingEventUUID eventUUID) throws EventNotFoundException {
        long id;
        EventService eventService = EnvTool.getEventService();
        IncomingEventInstance internalEvent = eventService.getIncomingEvent(id = Long.parseLong(eventUUID.getValue()));
        if (internalEvent == null) {
            throw new EventNotFoundException("Event " + id + "does not exist.");
        }
        eventService.removeEvent(internalEvent);
        EnvTool.getEventExecutor().refresh();
    }

    @Override
    public void deleteEvents(Collection<CatchingEventUUID> eventUUIDs) throws EventNotFoundException {
        if (eventUUIDs != null) {
            for (CatchingEventUUID eventUUID : eventUUIDs) {
                this.deleteEvent(eventUUID);
            }
        }
    }

    @Override
    public void updateExpirationDate(CatchingEventUUID eventUUID, Date expiration) throws EventNotFoundException {
        long id;
        EventService eventService = EnvTool.getEventService();
        IncomingEventInstance internalEvent = eventService.getIncomingEvent(id = Long.parseLong(eventUUID.getValue()));
        if (internalEvent == null) {
            throw new EventNotFoundException("Event " + id + "does not exist.");
        }
        this.updateExpirationDate(internalEvent, expiration);
    }

    private void updateExpirationDate(IncomingEventInstance internalEvent, Date expiration) throws EventNotFoundException {
        internalEvent.setEnableTime(expiration.getTime());
        EnvTool.getEventExecutor().refresh();
    }

    @Override
    public void updateActivityExpectedEndDate(ActivityInstanceUUID activityUUID, Date expectedEndDate) throws ActivityNotFoundException {
        InternalActivityInstance activity = EnvTool.getAllQueriers(this.getQueryList()).getActivityInstance(activityUUID);
        if (activity == null) {
            throw new ActivityNotFoundException("bai_QRAPII_11", activityUUID);
        }
        activity.setExpectedEndDate(expectedEndDate);
    }

    @Override
    public org.ow2.bonita.facade.runtime.Document createDocument(String name, ProcessInstanceUUID instanceUUID, String fileName, String mimeType, byte[] content) throws DocumentationCreationException, InstanceNotFoundException {
        InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
        if (instance == null) {
            throw new InstanceNotFoundException("bai_RAPII_1", instanceUUID);
        }
        if (content != null && (fileName == null || mimeType == null)) {
            new DocumentationCreationException("");
        }
        DocumentationManager manager = EnvTool.getDocumentationManager();
        ProcessDefinitionUUID definitionUUID = instance.getProcessDefinitionUUID();
        Document d = null;
        d = content != null ? manager.createDocument(name, definitionUUID, instanceUUID, fileName, mimeType, content) : manager.createDocument(name, definitionUUID, instanceUUID);
        int previousNbOfAttachments = instance.getNbOfAttachments();
        if (previousNbOfAttachments <= 0) {
            instance.setNbOfAttachments(1);
        } else {
            instance.setNbOfAttachments(previousNbOfAttachments + 1);
        }
        instance.updateLastUpdateDate();
        return DocumentService.getClientDocument(manager, d);
    }

    @Override
    public org.ow2.bonita.facade.runtime.Document createDocument(String name, ProcessDefinitionUUID processDefinitionUUID, String fileName, String mimeType, byte[] content) throws DocumentationCreationException, ProcessNotFoundException {
        InternalProcessDefinition process = EnvTool.getAllQueriers().getProcess(processDefinitionUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_RAPII_29", processDefinitionUUID);
        }
        if (content != null && (fileName == null || mimeType == null)) {
            new DocumentationCreationException("");
        }
        DocumentationManager manager = EnvTool.getDocumentationManager();
        Document d = null;
        d = content != null ? manager.createDocument(name, processDefinitionUUID, fileName, mimeType, content) : manager.createDocument(name, processDefinitionUUID);
        return DocumentService.getClientDocument(manager, d);
    }

    @Override
    public org.ow2.bonita.facade.runtime.Document addDocumentVersion(DocumentUUID documentUUID, boolean isMajorVersion, String fileName, String mimeType, byte[] content) throws DocumentationCreationException {
        return this.addDocumentVersion(documentUUID.getValue(), isMajorVersion, fileName, mimeType, content);
    }

    private org.ow2.bonita.facade.runtime.Document addDocumentVersion(String documentId, boolean isMajorVersion, String fileName, String mimeType, byte[] content) throws DocumentationCreationException {
        DocumentationManager manager = EnvTool.getDocumentationManager();
        Document d = null;
        d = content != null ? manager.createVersion(documentId, isMajorVersion, fileName, mimeType, content) : manager.createVersion(documentId, isMajorVersion);
        ProcessInstanceUUID instanceUUID = d.getProcessInstanceUUID();
        if (instanceUUID != null) {
            InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
            if (instance == null) {
                instance = EnvTool.getHistoryQueriers().getProcessInstance(instanceUUID);
            }
            if (instance != null) {
                instance.updateLastUpdateDate();
            }
        }
        return DocumentService.getClientDocument(manager, d);
    }

    @Override
    public void deleteDocuments(boolean allVersions, DocumentUUID ... documentUUIDs) throws DocumentNotFoundException {
        DocumentationManager manager = EnvTool.getDocumentationManager();
        Querier queriers = EnvTool.getAllQueriers();
        if (documentUUIDs != null) {
            for (DocumentUUID documentUUID : documentUUIDs) {
                Document doc = manager.getDocument(documentUUID.getValue());
                ProcessInstanceUUID processInstanceUUID = doc.getProcessInstanceUUID();
                manager.deleteDocument(documentUUID.getValue(), allVersions);
                if (processInstanceUUID == null) continue;
                InternalProcessInstance instance = queriers.getProcessInstance(processInstanceUUID);
                if (instance != null) {
                    instance.setNbOfAttachments(instance.getNbOfAttachments() - 1);
                    continue;
                }
                LOG.info("When deleting documents, cannot update the process instance because of its deletion");
            }
        }
    }
}

