/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.ow2.bonita.facade.exception.GroupAlreadyExistsException;
import org.ow2.bonita.facade.exception.GroupNotFoundException;
import org.ow2.bonita.facade.exception.MembershipNotFoundException;
import org.ow2.bonita.facade.exception.MetadataAlreadyExistsException;
import org.ow2.bonita.facade.exception.MetadataNotFoundException;
import org.ow2.bonita.facade.exception.RoleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RoleNotFoundException;
import org.ow2.bonita.facade.exception.UserAlreadyExistsException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.identity.Group;
import org.ow2.bonita.facade.identity.Membership;
import org.ow2.bonita.facade.identity.ProfileMetadata;
import org.ow2.bonita.facade.identity.Role;
import org.ow2.bonita.facade.identity.User;
import org.ow2.bonita.facade.paging.GroupCriterion;
import org.ow2.bonita.facade.paging.RoleCriterion;
import org.ow2.bonita.facade.paging.UserCriterion;

@Path(value="/API/identityAPI/")
@Produces(value={"text/*", "application/xml"})
@Consumes(value={"application/x-www-form-urlencoded", "text/*", "application/xml"})
public interface AbstractRemoteIdentityAPI
extends Remote {
    @POST
    @Path(value="getProfileMetadataByUUID/{metadataUUID}")
    public ProfileMetadata getProfileMetadataByUUID(@PathParam(value="metadataUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, MetadataNotFoundException;

    @POST
    @Path(value="findProfileMetadataByName/{metadataName}")
    public ProfileMetadata findProfileMetadataByName(@PathParam(value="metadataName") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, MetadataNotFoundException;

    @POST
    @Path(value="getAllProfileMetadata")
    public List<ProfileMetadata> getAllProfileMetadata(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getProfileMetadata")
    public List<ProfileMetadata> getProfileMetadata(@QueryParam(value="fromIndex") int var1, @QueryParam(value="numberOfMetadata") int var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getNumberOfProfileMetadata")
    public int getNumberOfProfileMetadata(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="addProfileMetadata/{name}")
    public ProfileMetadata addProfileMetadata(@PathParam(value="name") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, MetadataAlreadyExistsException;

    @POST
    @Path(value="addProfileMetadata/{name}/{label}")
    public ProfileMetadata addProfileMetadata(@PathParam(value="name") String var1, @PathParam(value="label") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, MetadataAlreadyExistsException;

    @POST
    @Path(value="updateProfileMetadataByUUID/{profileMetadataUUID}/{name}/{label}")
    public ProfileMetadata updateProfileMetadataByUUID(@PathParam(value="profileMetadataUUID") String var1, @PathParam(value="name") String var2, @PathParam(value="label") String var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException, MetadataNotFoundException, MetadataAlreadyExistsException;

    @POST
    @Path(value="removeProfileMetadataByUUID/{profileMetadataUUID}")
    public void removeProfileMetadataByUUID(@PathParam(value="profileMetadataUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, MetadataNotFoundException;

    @POST
    @Path(value="getUser/{username}")
    @Deprecated
    public User getUser(@PathParam(value="username") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="findUserByUserName/{username}")
    public User findUserByUserName(@PathParam(value="username") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="getUserByUUID/{userUUID}")
    public User getUserByUUID(@PathParam(value="userUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="getUsers")
    @Deprecated
    public Set<User> getUsers(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getAllUsers")
    public List<User> getAllUsers(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getUsersByIndexAndNumberOfUsers")
    public List<User> getUsers(@QueryParam(value="fromIndex") int var1, @QueryParam(value="numberOfUsers") int var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getUsersByIndexAndNumberOfUsersWithPagingCriterion")
    public List<User> getUsers(@QueryParam(value="fromIndex") int var1, @QueryParam(value="numberOfUsers") int var2, @QueryParam(value="pagingCriterion") UserCriterion var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getNumberOfUsers")
    public int getNumberOfUsers(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="addUser")
    public User addUser(@FormParam(value="username") String var1, @FormParam(value="password") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, UserAlreadyExistsException;

    @POST
    @Path(value="addUserWithEmail")
    @Deprecated
    public User addUser(@FormParam(value="username") String var1, @FormParam(value="password") String var2, @FormParam(value="firstName") String var3, @FormParam(value="lastName") String var4, @FormParam(value="email") String var5, @FormParam(value="options") Map<String, String> var6) throws RemoteException, UserAlreadyExistsException;

    @POST
    @Path(value="addUserFull")
    public User addUser(@FormParam(value="username") String var1, @FormParam(value="password") String var2, @FormParam(value="firstName") String var3, @FormParam(value="lastName") String var4, @FormParam(value="title") String var5, @FormParam(value="jobTitle") String var6, @FormParam(value="managerUserUUID") String var7, @FormParam(value="profileMetadata") Map<String, String> var8, @FormParam(value="options") Map<String, String> var9) throws RemoteException, UserAlreadyExistsException, UserNotFoundException, MetadataNotFoundException;

    @POST
    @Path(value="importUser")
    public User importUser(@FormParam(value="userUUID") String var1, @FormParam(value="username") String var2, @FormParam(value="password") String var3, @FormParam(value="firstName") String var4, @FormParam(value="lastName") String var5, @FormParam(value="title") String var6, @FormParam(value="jobTitle") String var7, @FormParam(value="managerUserUUID") String var8, @FormParam(value="profileMetadata") Map<String, String> var9, @FormParam(value="options") Map<String, String> var10) throws RemoteException, UserAlreadyExistsException, MetadataNotFoundException;

    @POST
    @Path(value="updateUserDelegate/{userUUID}/{delegateUserUUID}")
    public void updateUserDelegee(@PathParam(value="userUUID") String var1, @PathParam(value="delegateUserUUID") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="updateUserPersonalContactInfo")
    public void updateUserPersonalContactInfo(@FormParam(value="userUUID") String var1, @FormParam(value="email") String var2, @FormParam(value="phoneNumber") String var3, @FormParam(value="mobileNumber") String var4, @FormParam(value="faxNumber") String var5, @FormParam(value="building") String var6, @FormParam(value="room") String var7, @FormParam(value="address") String var8, @FormParam(value="zipCode") String var9, @FormParam(value="city") String var10, @FormParam(value="state") String var11, @FormParam(value="country") String var12, @FormParam(value="website") String var13, @FormParam(value="options") Map<String, String> var14) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="updateUserProfessionalContactInfo")
    public void updateUserProfessionalContactInfo(@FormParam(value="userUUID") String var1, @FormParam(value="email") String var2, @FormParam(value="phoneNumber") String var3, @FormParam(value="mobileNumber") String var4, @FormParam(value="faxNumber") String var5, @FormParam(value="building") String var6, @FormParam(value="room") String var7, @FormParam(value="address") String var8, @FormParam(value="zipCode") String var9, @FormParam(value="city") String var10, @FormParam(value="state") String var11, @FormParam(value="country") String var12, @FormParam(value="website") String var13, @FormParam(value="options") Map<String, String> var14) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="updateUser")
    @Deprecated
    public User updateUser(@FormParam(value="oldUsername") String var1, @FormParam(value="username") String var2, @FormParam(value="password") String var3, @FormParam(value="firstName") String var4, @FormParam(value="lastName") String var5, @FormParam(value="email") String var6, @FormParam(value="options") Map<String, String> var7) throws RemoteException, UserNotFoundException, UserAlreadyExistsException;

    @POST
    @Path(value="updateUserByUUID")
    public User updateUserByUUID(@FormParam(value="userUUID") String var1, @FormParam(value="username") String var2, @FormParam(value="firstName") String var3, @FormParam(value="lastName") String var4, @FormParam(value="title") String var5, @FormParam(value="jobTitle") String var6, @FormParam(value="managerUserUUID") String var7, @FormParam(value="profileMetadata") Map<String, String> var8, @FormParam(value="options") Map<String, String> var9) throws RemoteException, UserNotFoundException, UserAlreadyExistsException, MetadataNotFoundException;

    @POST
    @Path(value="updateUserPassword")
    public User updateUserPassword(@FormParam(value="userUUID") String var1, @FormParam(value="password") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="getUsersInRole/{roleName}")
    @Deprecated
    public Set<User> getUsersInRole(@PathParam(value="roleName") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, RoleNotFoundException;

    @POST
    @Path(value="getAllUsersInRole/{roleUUID}")
    public List<User> getAllUsersInRole(@PathParam(value="roleUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, RoleNotFoundException;

    @POST
    @Path(value="getUsersInRoleByIndexAndnumberOfUsers/{roleUUID}")
    public List<User> getUsersInRole(@PathParam(value="roleUUID") String var1, @QueryParam(value="fromIndex") int var2, @QueryParam(value="numberOfUsers") int var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException, RoleNotFoundException;

    @POST
    @Path(value="getUsersInRoleByIndexAndnumberOfUsersWithPagingCriterion/{roleUUID}")
    public List<User> getUsersInRole(@PathParam(value="roleUUID") String var1, @QueryParam(value="fromIndex") int var2, @QueryParam(value="numberOfUsers") int var3, @QueryParam(value="pagingCriterion") UserCriterion var4, @FormParam(value="options") Map<String, String> var5) throws RoleNotFoundException, RemoteException;

    @POST
    @Path(value="getNumberOfUsersInRole/{roleUUID}")
    public int getNumberOfUsersInRole(@PathParam(value="roleUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getAllUsersInGroup/{groupUUID}")
    public List<User> getAllUsersInGroup(@PathParam(value="groupUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, GroupNotFoundException;

    @POST
    @Path(value="getUsersInGroup/{groupUUID}")
    public List<User> getUsersInGroup(@PathParam(value="groupUUID") String var1, @QueryParam(value="fromIndex") int var2, @QueryParam(value="numberOfUsers") int var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException, GroupNotFoundException;

    @POST
    @Path(value="getUsersInGroupWithPagingCriterion/{groupUUID}")
    public List<User> getUsersInGroup(@PathParam(value="groupUUID") String var1, @QueryParam(value="fromIndex") int var2, @QueryParam(value="numberOfUsers") int var3, @QueryParam(value="pagingCriterion") UserCriterion var4, @FormParam(value="options") Map<String, String> var5) throws GroupNotFoundException, RemoteException;

    @POST
    @Path(value="getNumberOfUsersInGroup/{groupUUID}")
    public int getNumberOfUsersInGroup(@PathParam(value="groupUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getAllUsersInMembership/{membershipUUID}")
    public List<User> getAllUsersInMembership(@PathParam(value="membershipUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, MembershipNotFoundException;

    @POST
    @Path(value="getAllUsersInRoleAndGroup/{roleUUID}/{groupUUID}")
    public List<User> getAllUsersInRoleAndGroup(@PathParam(value="roleUUID") String var1, @PathParam(value="groupUUID") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, RoleNotFoundException, GroupNotFoundException;

    @POST
    @Path(value="getUsersByManagerUUID/{managerUUID}")
    public List<User> getUsersByManagerUUID(@PathParam(value="managerUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="removeUserByUUID/{userUUID}")
    public void removeUserByUUID(@PathParam(value="userUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="removeUser/{username}")
    @Deprecated
    public void removeUser(@PathParam(value="username") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="getRole/{name}")
    @Deprecated
    public Role getRole(@PathParam(value="name") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, RoleNotFoundException;

    @POST
    @Path(value="findRoleByName/{name}")
    public Role findRoleByName(@PathParam(value="name") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, RoleNotFoundException;

    @POST
    @Path(value="getRoleByUUID/{roleUUID}")
    public Role getRoleByUUID(@PathParam(value="roleUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, RoleNotFoundException;

    @POST
    @Path(value="getRoles")
    @Deprecated
    public Set<Role> getRoles(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getAllRoles")
    public List<Role> getAllRoles(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getRolesByIndexAndNumberOfUsers")
    public List<Role> getRoles(@QueryParam(value="fromIndex") int var1, @QueryParam(value="numberOfRoles") int var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getRolesByIndexAndNumberOfUsersWithPagingCriterion")
    public List<Role> getRoles(@QueryParam(value="fromIndex") int var1, @QueryParam(value="numberOfRoles") int var2, @QueryParam(value="pagingCriterion") RoleCriterion var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getNumberOfRoles")
    public int getNumberOfRoles(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getUserRoles/{username}")
    @Deprecated
    public Set<Role> getUserRoles(@PathParam(value="username") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, UserNotFoundException;

    @POST
    @Path(value="addRole/{name}")
    public Role addRole(@PathParam(value="name") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, RoleAlreadyExistsException;

    @POST
    @Path(value="addRole/{name}/{label}")
    public Role addRole(@PathParam(value="name") String var1, @PathParam(value="label") String var2, @FormParam(value="description") String var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException, RoleAlreadyExistsException;

    @POST
    @Path(value="importRole/{uuid}/{name}")
    public Role importRole(@PathParam(value="uuid") String var1, @PathParam(value="name") String var2, @QueryParam(value="label") String var3, @FormParam(value="description") String var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException, RoleAlreadyExistsException;

    @POST
    @Path(value="updateRoleByUUID/{roleUUID}/{name}")
    public Role updateRoleByUUID(@PathParam(value="roleUUID") String var1, @PathParam(value="name") String var2, @QueryParam(value="label") String var3, @FormParam(value="description") String var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException, RoleNotFoundException, RoleAlreadyExistsException;

    @POST
    @Path(value="updateRole")
    @Deprecated
    public Role updateRole(@FormParam(value="oldName") String var1, @FormParam(value="name") String var2, @FormParam(value="label") String var3, @FormParam(value="description") String var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException, RoleNotFoundException, RoleAlreadyExistsException;

    @POST
    @Path(value="removeRoleByUUID/{roleUUID}")
    public void removeRoleByUUID(@PathParam(value="roleUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, RoleNotFoundException;

    @POST
    @Path(value="removeRole/{name}")
    @Deprecated
    public void removeRole(@PathParam(value="name") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, RoleNotFoundException;

    @POST
    @Path(value="getGroupByUUID/{groupUUID}")
    public Group getGroupByUUID(@PathParam(value="groupUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, GroupNotFoundException;

    @POST
    @Path(value="getAllGroups")
    public List<Group> getAllGroups(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getGroups")
    public List<Group> getGroups(@QueryParam(value="fromIndex") int var1, @QueryParam(value="numberOfGroups") int var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getGroupsWithPagingCriterion")
    public List<Group> getGroups(@QueryParam(value="fromIndex") int var1, @QueryParam(value="numberOfGroups") int var2, @QueryParam(value="pagingCriterion") GroupCriterion var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getNumberOfGroups")
    public int getNumberOfGroups(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getChildrenGroupsByUUID")
    public List<Group> getChildrenGroupsByUUID(@QueryParam(value="groupUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getChildrenGroups/{groupUUID}")
    public List<Group> getChildrenGroups(@PathParam(value="groupUUID") String var1, @QueryParam(value="fromIndex") int var2, @QueryParam(value="numberOfGroups") int var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException, GroupNotFoundException;

    @POST
    @Path(value="getChildrenGroupsWithPagingCriterion/{groupUUID}")
    public List<Group> getChildrenGroups(@PathParam(value="groupUUID") String var1, @QueryParam(value="fromIndex") int var2, @QueryParam(value="numberOfGroups") int var3, @QueryParam(value="pagingCriterion") GroupCriterion var4, @FormParam(value="options") Map<String, String> var5) throws GroupNotFoundException, RemoteException;

    @POST
    @Path(value="getNumberOfChildrenGroups/{groupUUID}")
    public int getNumberOfChildrenGroups(@PathParam(value="groupUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, GroupNotFoundException;

    @POST
    @Path(value="addGroup/{name}")
    public Group addGroup(@PathParam(value="name") String var1, @QueryParam(value="parentGroupUUID") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, GroupAlreadyExistsException, GroupNotFoundException;

    @POST
    @Path(value="addGroupUsingLabelAndDescription/{name}")
    public Group addGroup(@PathParam(value="name") String var1, @QueryParam(value="label") String var2, @FormParam(value="description") String var3, @QueryParam(value="parentGroupUUID") String var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException, GroupAlreadyExistsException, GroupNotFoundException;

    @POST
    @Path(value="groupExists/{groupUUID}")
    public Boolean groupExists(@PathParam(value="groupUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="importGroup/{uuid}/{name}")
    public Group importGroup(@PathParam(value="uuid") String var1, @PathParam(value="name") String var2, @QueryParam(value="label") String var3, @FormParam(value="description") String var4, @QueryParam(value="parentGroupUUID") String var5, @FormParam(value="options") Map<String, String> var6) throws RemoteException, GroupAlreadyExistsException, GroupNotFoundException;

    @POST
    @Path(value="updateGroupByUUID/{groupUUID}/{name}")
    public Group updateGroupByUUID(@PathParam(value="groupUUID") String var1, @PathParam(value="name") String var2, @QueryParam(value="label") String var3, @FormParam(value="description") String var4, @QueryParam(value="parentGroupUUID") String var5, @FormParam(value="options") Map<String, String> var6) throws RemoteException, GroupNotFoundException, GroupAlreadyExistsException;

    @POST
    @Path(value="removeGroupByUUID/{groupUUID}")
    public void removeGroupByUUID(@PathParam(value="groupUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, GroupNotFoundException;

    @POST
    @Path(value="getMembershipByUUID/{membershipUUID}")
    public Membership getMembershipByUUID(@PathParam(value="membershipUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, MembershipNotFoundException;

    @POST
    @Path(value="getMembershipForRoleAndGroup/{roleUUID}/{groupUUID}")
    public Membership getMembershipForRoleAndGroup(@PathParam(value="roleUUID") String var1, @PathParam(value="groupUUID") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, RoleNotFoundException, GroupNotFoundException;

    @POST
    @Path(value="addMembershipToUser/{userUUID}/{membershipUUID}")
    public void addMembershipToUser(@PathParam(value="userUUID") String var1, @PathParam(value="membershipUUID") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, UserNotFoundException, MembershipNotFoundException;

    @POST
    @Path(value="removeMembershipFromUser/{userUUID}/{membershipUUID}")
    public void removeMembershipFromUser(@PathParam(value="userUUID") String var1, @PathParam(value="membershipUUID") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, UserNotFoundException, MembershipNotFoundException;

    @POST
    @Path(value="addRoleToUser/{roleName}/{username}")
    @Deprecated
    public void addRoleToUser(@PathParam(value="roleName") String var1, @PathParam(value="username") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, UserNotFoundException, RoleNotFoundException;

    @POST
    @Path(value="setUserRoles/{username}")
    @Deprecated
    public void setUserRoles(@PathParam(value="username") String var1, @FormParam(value="roleNames") Set<String> var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, UserNotFoundException, RoleNotFoundException;

    @POST
    @Path(value="removeRoleFromUser/{roleName}/{username}")
    @Deprecated
    public void removeRoleFromUser(@PathParam(value="roleName") String var1, @PathParam(value="username") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, UserNotFoundException, RoleNotFoundException;

    @POST
    @Path(value="getGroupUsingPath")
    public Group getGroupUsingPath(@FormParam(value="hierarchy") List<String> var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;
}

