/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.exception.MonitoringException;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;

@Path(value="/API/BAMAPI/")
@Produces(value={"text/*", "application/xml"})
@Consumes(value={"application/x-www-form-urlencoded", "text/*", "application/xml"})
public interface RemoteBAMAPI
extends Remote {
    @POST
    @Path(value="getNumberOfOverdueSteps")
    public int getNumberOfOverdueSteps(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getNumberOfStepsAtRisk")
    public int getNumberOfStepsAtRisk(@QueryParam(value="remainingDays") int var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getNumberOfOpenSteps")
    public int getNumberOfOpenSteps(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getNumberOfUserOverdueSteps")
    public int getNumberOfUserOverdueSteps(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getNumberOfUserStepsAtRisk")
    public int getNumberOfUserStepsAtRisk(@QueryParam(value="remainingDays") int var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getNumberOfUserOpenSteps")
    public int getNumberOfUserOpenSteps(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getNumberOfFinishedCasesPerDay")
    public List<Integer> getNumberOfFinishedCasesPerDay(@FormParam(value="since") Date var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getNumberOfExecutingCasesPerDay")
    public List<Integer> getNumberOfExecutingCasesPerDay(@FormParam(value="since") Date var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getNumberOfOpenStepsPerDay")
    public List<Integer> getNumberOfOpenStepsPerDay(@FormParam(value="since") Date var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getNumberOfUserOpenStepsByPriority")
    public int getNumberOfUserOpenSteps(@QueryParam(value="priority") int var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getNumberOfUserFinishedSteps")
    public int getNumberOfUserFinishedSteps(@QueryParam(value="priority") int var1, @FormParam(value="since") Date var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getNumberOfFinishedSteps")
    public int getNumberOfFinishedSteps(@QueryParam(value="priority") int var1, @FormParam(value="since") Date var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getNumberOfOpenStepsByPriority")
    public int getNumberOfOpenSteps(@QueryParam(value="priority") int var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getProcessInstancesDuration")
    public List<Long> getProcessInstancesDuration(@QueryParam(value="since") Date var1, @QueryParam(value="until") Date var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getProcessInstancesDuration/{processUUID}")
    public List<Long> getProcessInstancesDuration(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getProcessInstancesDurationFromProcessUUID")
    public List<Long> getProcessInstancesDuration(@FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesExecutionTime")
    public List<Long> getActivityInstancesExecutionTime(@QueryParam(value="since") Date var1, @QueryParam(value="until") Date var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesExecutionTimeFromProcessUUID/{processUUID}")
    public List<Long> getActivityInstancesExecutionTime(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesExecutionTimeFromProcessUUIDs")
    public List<Long> getActivityInstancesExecutionTimeFromProcessUUIDs(@FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesExecutionTimeFromActivityUUID/{activityUUID}")
    public List<Long> getActivityInstancesExecutionTime(@PathParam(value="activityUUID") ActivityDefinitionUUID var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesExecutionTimeFromActivityUUIDs")
    public List<Long> getActivityInstancesExecutionTimeFromActivityUUIDs(@FormParam(value="activityUUIDs") Set<ActivityDefinitionUUID> var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getTaskInstancesWaitingTime")
    public List<Long> getTaskInstancesWaitingTime(@QueryParam(value="since") Date var1, @QueryParam(value="until") Date var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getTaskInstancesWaitingTimeFromProcessUUID/{processUUID}")
    public List<Long> getTaskInstancesWaitingTime(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getTaskInstancesWaitingTimeFromProcessUUIDs")
    public List<Long> getTaskInstancesWaitingTimeFromProcessUUIDs(@FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getTaskInstancesWaitingTimeFromTaskUUID/{taskUUID}")
    public List<Long> getTaskInstancesWaitingTime(@PathParam(value="taskUUID") ActivityDefinitionUUID var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getTaskInstancesWaitingTimeFromTaskUUIDs")
    public List<Long> getTaskInstancesWaitingTimeFromTaskUUIDs(@FormParam(value="taskUUIDs") Set<ActivityDefinitionUUID> var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getTaskInstancesWaitingTimeOfUser/{username}")
    public List<Long> getTaskInstancesWaitingTimeOfUser(@PathParam(value="username") String var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getTaskInstancesWaitingTimeOfUserFromProcessUUID/{username}/{processUUID}")
    public List<Long> getTaskInstancesWaitingTimeOfUser(@PathParam(value="username") String var1, @PathParam(value="processUUID") ProcessDefinitionUUID var2, @QueryParam(value="since") Date var3, @QueryParam(value="until") Date var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException;

    @POST
    @Path(value="getTaskInstancesWaitingTimeOfUserFromProcessUUIDs/{username}")
    public List<Long> getTaskInstancesWaitingTimeOfUserFromProcessUUIDs(@PathParam(value="username") String var1, @FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var2, @QueryParam(value="since") Date var3, @QueryParam(value="until") Date var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException;

    @POST
    @Path(value="getTaskInstancesWaitingTimeOfUserFromTaskUUID/{username}/{taskUUID}")
    public List<Long> getTaskInstancesWaitingTimeOfUser(@PathParam(value="username") String var1, @PathParam(value="taskUUID") ActivityDefinitionUUID var2, @QueryParam(value="since") Date var3, @QueryParam(value="until") Date var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException;

    @POST
    @Path(value="getTaskInstancesWaitingTimeOfUserFromTaskUUIDs/{username}")
    public List<Long> getTaskInstancesWaitingTimeOfUserFromTaskUUIDs(@PathParam(value="username") String var1, @FormParam(value="taskUUIDs") Set<ActivityDefinitionUUID> var2, @QueryParam(value="since") Date var3, @QueryParam(value="until") Date var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesDuration")
    public List<Long> getActivityInstancesDuration(@QueryParam(value="since") Date var1, @QueryParam(value="until") Date var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesDurationFromProcessUUID/{processUUID}")
    public List<Long> getActivityInstancesDuration(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesDurationFromProcessUUIDs")
    public List<Long> getActivityInstancesDurationFromProcessUUIDs(@FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesDurationFromActivityUUID/{activityUUID}")
    public List<Long> getActivityInstancesDuration(@PathParam(value="activityUUID") ActivityDefinitionUUID var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesDurationFromActivityUUIDs")
    public List<Long> getActivityInstancesDurationFromActivityUUIDs(@FormParam(value="activityUUIDs") Set<ActivityDefinitionUUID> var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesDurationByActivityType/{activityType}")
    public List<Long> getActivityInstancesDurationByActivityType(@PathParam(value="activityType") ActivityDefinition.Type var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesDurationByActivityType/{activityType}/{processUUID}")
    public List<Long> getActivityInstancesDurationByActivityType(@PathParam(value="activityType") ActivityDefinition.Type var1, @PathParam(value="processUUID") ProcessDefinitionUUID var2, @QueryParam(value="since") Date var3, @QueryParam(value="until") Date var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException;

    @POST
    @Path(value="getActivityInstancesDurationByActivityTypeFromProcessUUIDs/{activityType}")
    public List<Long> getActivityInstancesDurationByActivityTypeFromProcessUUIDs(@PathParam(value="activityType") ActivityDefinition.Type var1, @FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var2, @QueryParam(value="since") Date var3, @QueryParam(value="until") Date var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException;

    @POST
    @Path(value="getNumberOfCreatedProcessInstances")
    public long getNumberOfCreatedProcessInstances(@QueryParam(value="since") Date var1, @QueryParam(value="until") Date var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getNumberOfCreatedProcessInstances/{processUUID}")
    public long getNumberOfCreatedProcessInstances(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getNumberOfCreatedActivityInstances")
    public long getNumberOfCreatedActivityInstances(@QueryParam(value="since") Date var1, @QueryParam(value="until") Date var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getNumberOfCreatedActivityInstancesFromProcessUUID/{processUUID}")
    public long getNumberOfCreatedActivityInstances(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getNumberOfCreatedActivityInstancesFromProcessUUIDs")
    public long getNumberOfCreatedActivityInstancesFromProcessUUIDs(@FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getNumberOfCreatedActivityInstancesFromActivityUUID/{activityUUID}")
    public long getNumberOfCreatedActivityInstances(@PathParam(value="activityUUID") ActivityDefinitionUUID var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getNumberOfCreatedActivityInstancesFromActivityUUIDs")
    public long getNumberOfCreatedActivityInstancesFromActivityUUIDs(@FormParam(value="activityUUIDs") Set<ActivityDefinitionUUID> var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getNumberOfCreatedActivityInstancesByActivityType/{activityType}")
    public long getNumberOfCreatedActivityInstancesByActivityType(@PathParam(value="activityType") ActivityDefinition.Type var1, @QueryParam(value="since") Date var2, @QueryParam(value="until") Date var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUID/{activityType}/{processUUID}")
    public long getNumberOfCreatedActivityInstancesByActivityType(@PathParam(value="activityType") ActivityDefinition.Type var1, @PathParam(value="processUUID") ProcessDefinitionUUID var2, @QueryParam(value="since") Date var3, @QueryParam(value="until") Date var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException;

    @POST
    @Path(value="getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUID/{activityType}")
    public long getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUIDs(@PathParam(value="activityType") ActivityDefinition.Type var1, @FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var2, @QueryParam(value="since") Date var3, @QueryParam(value="until") Date var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException;

    @POST
    @Path(value="getSystemLoadAverage")
    public double getSystemLoadAverage(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getCurrentMemoryUsage")
    public long getCurrentMemoryUsage(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getMemoryUsagePercentage")
    public float getMemoryUsagePercentage(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getUpTime")
    public long getUpTime(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getStartTime")
    public long getStartTime(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getTotalThreadsCpuTime")
    public long getTotalThreadsCpuTime(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getThreadCount")
    public int getThreadCount(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getAvailableProcessors")
    public int getAvailableProcessors(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getOSArch")
    public String getOSArch(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getOSName")
    public String getOSName(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getOSVersion")
    public String getOSVersion(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getJvmName")
    public String getJvmName(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getJvmVendor")
    public String getJvmVendor(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getJvmVersion")
    public String getJvmVersion(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;

    @POST
    @Path(value="getJvmSystemProperties")
    public Map<String, String> getJvmSystemProperties(@FormParam(value="options") Map<String, String> var1) throws RemoteException, MonitoringException;
}

