/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.rest.interceptor;

import com.thoughtworks.xstream.XStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.Precedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.ow2.bonita.identity.auth.APIMethodsSecurity;
import org.ow2.bonita.util.Base64;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.xml.XStreamUtil;

@Provider
@ServerInterceptor
@Precedence(value="SECURITY")
public class LoginPreProcessorInterceptor
implements PreProcessInterceptor {
    private static Logger LOG = Logger.getLogger(LoginPreProcessorInterceptor.class.getName());
    private static final String AUTHENTICATION_SCHEME = "Basic";
    private static final String OPTIONS = "options";
    private static final String AUTHORIZATION_PROPERTY = "Authorization";
    private boolean optionsMapCreatedOrModified = false;
    private boolean wasEncoded = false;

    public ServerResponse preProcess(HttpRequest request, ResourceMethod method) throws Failure, WebApplicationException {
        this.decodeParameters(request);
        List options = (List)request.getDecodedFormParameters().get((Object)OPTIONS);
        if (options == null || options.isEmpty()) {
            options = request.getHttpHeaders().getRequestHeader(OPTIONS);
        }
        Map<String, String> optionsMap = null;
        if (options != null && !options.isEmpty()) {
            String strOptions;
            block16: {
                if (options.size() > 1 && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Attention: there are more than one parameter named \"options\". Only the first one will be used.");
                }
                if (!(strOptions = (String)options.get(0)).startsWith("<")) {
                    this.wasEncoded = true;
                    try {
                        strOptions = URLDecoder.decode((String)options.get(0), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!LOG.isLoggable(Level.WARNING)) break block16;
                        LOG.warning("Error while decoding " + (String)options.get(0) + " using UTF-8: " + Misc.getStackTraceFrom(e));
                    }
                }
            }
            optionsMap = this.getOptionsMap(strOptions);
        } else {
            optionsMap = this.getOptionsMap(null);
        }
        if (optionsMap.get("queryList") == null) {
            this.optionsMapCreatedOrModified = true;
            optionsMap.put("queryList", "queryList");
        }
        if (optionsMap.get("domain") == null) {
            this.optionsMapCreatedOrModified = true;
            optionsMap.put("domain", "default");
        }
        if (!APIMethodsSecurity.isSecuredMethod(method.getMethod())) {
            if (this.optionsMapCreatedOrModified) {
                if (this.isOptionsMapInHeader(request)) {
                    this.updateOptionsHeaderParam(request, optionsMap);
                } else {
                    this.updateOptionsFormParam(request, optionsMap);
                }
            }
            return null;
        }
        String passwordHash = optionsMap.get("passwordHash");
        if (passwordHash != null) {
            return null;
        }
        HttpHeaders headers = request.getHttpHeaders();
        List authorization = headers.getRequestHeader(AUTHORIZATION_PROPERTY);
        String encodedUserPassword = ((String)authorization.get(0)).replaceFirst("Basic ", "");
        String usernameAndPassword = new String(Base64.decode(encodedUserPassword));
        StringTokenizer tokenizer = new StringTokenizer(usernameAndPassword, ":");
        String restUser = tokenizer.nextToken();
        String restPswd = tokenizer.nextToken();
        this.optionsMapCreatedOrModified = true;
        optionsMap.put("restUser", restUser);
        optionsMap.put("passwordHash", restPswd);
        if (this.isOptionsMapInHeader(request)) {
            this.updateOptionsHeaderParam(request, optionsMap);
        } else {
            this.updateOptionsFormParam(request, optionsMap);
        }
        return null;
    }

    private void decodeParameters(HttpRequest request) {
        this.decodeFormParameters(request);
    }

    private void decodeFormParameters(HttpRequest request) {
        block5: {
            block4: {
                try {
                    this.decodeMultiValuedMap((MultivaluedMap<String, String>)request.getFormParameters());
                }
                catch (Throwable e) {
                    if (!LOG.isLoggable(Level.WARNING)) break block4;
                    LOG.warning("Imposible to decode some parameters using UTF-8. Keeping encoded values: " + e);
                }
            }
            try {
                this.decodeMultiValuedMap((MultivaluedMap<String, String>)request.getDecodedFormParameters());
            }
            catch (Throwable e) {
                if (!LOG.isLoggable(Level.WARNING)) break block5;
                LOG.warning("Imposible to decode some parameters using UTF-8. Keeping encoded values: " + e);
            }
        }
    }

    private void decodeMultiValuedMap(MultivaluedMap<String, String> parameters) throws UnsupportedEncodingException {
        for (String parameter : parameters.keySet()) {
            List values = (List)parameters.get((Object)parameter);
            ArrayList<String> decodedValues = new ArrayList<String>();
            for (String value : values) {
                decodedValues.add(URLDecoder.decode(value, "UTF-8"));
            }
            parameters.put((Object)parameter, decodedValues);
        }
    }

    private boolean isOptionsMapInHeader(HttpRequest request) {
        String path = request.getPreprocessedPath();
        return path.equals("/API/managementAPI/deploy") || path.startsWith("/API/managementAPI/deployJar");
    }

    private void updateOptionsFormParam(HttpRequest request, Map<String, String> optionsMap) {
        String options = this.getNonEncodedStringRepresentation(optionsMap);
        request.getFormParameters().remove((Object)OPTIONS);
        request.getFormParameters().add((Object)OPTIONS, (Object)this.encodeIfNecessary(options));
        request.getDecodedFormParameters().remove((Object)OPTIONS);
        request.getDecodedFormParameters().add((Object)OPTIONS, (Object)options);
    }

    private void updateOptionsHeaderParam(HttpRequest request, Map<String, String> optionsMap) {
        request.getHttpHeaders().getRequestHeaders().remove((Object)OPTIONS);
        request.getHttpHeaders().getRequestHeaders().add((Object)OPTIONS, (Object)this.getStringRepresentationEncodedIfNecessary(optionsMap));
    }

    private String getStringRepresentationEncodedIfNecessary(Map<String, String> optionsMap) {
        String strRepresentation = this.getNonEncodedStringRepresentation(optionsMap);
        strRepresentation = this.encodeIfNecessary(strRepresentation);
        return strRepresentation;
    }

    private String getNonEncodedStringRepresentation(Map<String, String> optionsMap) {
        XStream xstream = XStreamUtil.getDefaultXstream();
        String strRepresentation = xstream.toXML(optionsMap);
        return strRepresentation;
    }

    private String encodeIfNecessary(String strRepresentation) {
        block3: {
            try {
                if (this.wasEncoded) {
                    strRepresentation = URLEncoder.encode(strRepresentation, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.warning("Cannot encode " + strRepresentation + " using UTF-8");
            }
        }
        return strRepresentation;
    }

    private Map<String, String> getOptionsMap(String strOptions) {
        if (strOptions == null || "".equals(strOptions.trim())) {
            this.optionsMapCreatedOrModified = true;
            return new HashMap<String, String>();
        }
        XStream xstream = null;
        if (strOptions.startsWith("<")) {
            xstream = XStreamUtil.getDefaultXstream();
            try {
                return (Map)xstream.fromXML(strOptions);
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Error while criating the java object from " + strOptions + ": " + Misc.getStackTraceFrom(e));
                }
                this.optionsMapCreatedOrModified = true;
                return new HashMap<String, String>();
            }
        }
        this.optionsMapCreatedOrModified = true;
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer optionsTokenizer = new StringTokenizer(strOptions, ",");
        while (optionsTokenizer.hasMoreTokens()) {
            String option = optionsTokenizer.nextToken();
            StringTokenizer elementTokenizer = new StringTokenizer(option, ": ");
            if (elementTokenizer.countTokens() != 2) continue;
            String key = elementTokenizer.nextToken();
            String value = elementTokenizer.nextToken();
            if (key.equalsIgnoreCase("queryList")) {
                map.put("queryList", value);
                continue;
            }
            if (key.equalsIgnoreCase("domain")) {
                map.put("domain", value);
                continue;
            }
            if (key.equalsIgnoreCase("user")) {
                map.put("user", value);
                continue;
            }
            if (!key.equalsIgnoreCase("restUser")) continue;
            map.put("restUser", value);
        }
        return map;
    }
}

