/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.rest.stringconverter;

import com.thoughtworks.xstream.XStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.spi.StringConverter;
import org.ow2.bonita.util.xml.XStreamUtil;

@Provider
public class MapStringConverter
implements StringConverter<Map<?, ?>> {
    private static Logger LOG = Logger.getLogger(MapStringConverter.class.getName());

    public Map<?, ?> fromString(String str) {
        block3: {
            try {
                if (!str.startsWith("<")) {
                    str = URLDecoder.decode(str, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.warning("Cannot decode " + str + " using UTF-8");
            }
        }
        XStream xstream = XStreamUtil.getDefaultXstream();
        return (Map)xstream.fromXML(str);
    }

    public String toString(Map<?, ?> value) {
        XStream xstream = XStreamUtil.getDefaultXstream();
        String xmap = xstream.toXML(value);
        return xmap;
    }
}

