/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.GroovyException;

public class WebExecuteTask
implements Command<Void> {
    private static final long serialVersionUID = -183964674754241232L;
    private static final Logger LOG = Logger.getLogger(WebExecuteTask.class.getName());
    protected ActivityInstanceUUID taskUUID;
    protected Map<String, Object> processVariables;
    protected Map<String, Object> activityVariables;
    protected Map<String, Object> undefinedVariables;
    protected Set<InitialAttachment> attachments;
    protected List<String> scriptsToExecute;
    protected Map<String, Object> scriptContext;

    public WebExecuteTask(ActivityInstanceUUID taskUUID, Map<String, Object> processVariables, Map<String, Object> activityVariables, Map<String, Object> undefinedVariables, Set<InitialAttachment> attachments, List<String> scriptsToExecute, Map<String, Object> scriptContext) {
        this.taskUUID = taskUUID;
        this.processVariables = processVariables;
        this.activityVariables = activityVariables;
        this.undefinedVariables = undefinedVariables;
        this.attachments = attachments;
        this.scriptsToExecute = scriptsToExecute;
        this.scriptContext = scriptContext;
    }

    protected void executeActions(RuntimeAPI runtimeAPI, QueryRuntimeAPI queryRuntimeAPI) throws Exception {
        TaskInstance task = queryRuntimeAPI.getTask(this.taskUUID);
        ProcessInstanceUUID instanceUUID = task.getProcessInstanceUUID();
        if (this.processVariables != null && !this.processVariables.isEmpty()) {
            runtimeAPI.setProcessInstanceVariables(instanceUUID, this.processVariables);
        }
        if (this.activityVariables != null && !this.activityVariables.isEmpty()) {
            runtimeAPI.setActivityInstanceVariables(this.taskUUID, this.activityVariables);
        }
        if (this.undefinedVariables != null) {
            for (Map.Entry entry : this.undefinedVariables.entrySet()) {
                runtimeAPI.setVariable(this.taskUUID, (String)entry.getKey(), entry.getValue());
            }
        }
        if (this.attachments != null) {
            for (InitialAttachment initialAttachment : this.attachments) {
                runtimeAPI.addAttachment(instanceUUID, initialAttachment.getName(), initialAttachment.getLabel(), initialAttachment.getDescription(), initialAttachment.getFileName(), initialAttachment.getMetaData(), initialAttachment.getContent());
            }
        }
        if (this.scriptsToExecute != null && !this.scriptsToExecute.isEmpty()) {
            HashMap<String, String> scriptsToExecuteInParallel = new HashMap<String, String>(this.scriptsToExecute.size());
            for (String scriptToExecute : this.scriptsToExecute) {
                scriptsToExecuteInParallel.put(String.valueOf(scriptsToExecuteInParallel.size()), scriptToExecute);
            }
            try {
                runtimeAPI.evaluateGroovyExpressions(scriptsToExecuteInParallel, this.taskUUID, this.scriptContext, false, true);
            }
            catch (GroovyException groovyException) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Error while executing action. unable to evaluate the groovy expression", groovyException);
                }
                throw new GroovyException(groovyException.getMessage(), groovyException);
            }
        }
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
        runtimeAPI.startTask(this.taskUUID, true);
        this.executeActions(runtimeAPI, accessor.getQueryRuntimeAPI());
        runtimeAPI.finishTask(this.taskUUID, true);
        return null;
    }
}

