/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.util.Command;

public class WebGetLightProcessInstancesFromCategoryCommand
implements Command<List<LightProcessInstance>> {
    private static final long serialVersionUID = 6552317918633404796L;
    private final String userId;
    private final int fromIndex;
    private final int pageSize;
    private final boolean searchInHistory;
    private final String category;

    public WebGetLightProcessInstancesFromCategoryCommand(String userId, String categoryName, int fromIndex, int pageSize, boolean searchInHistory) {
        this.userId = userId;
        this.category = categoryName;
        this.fromIndex = fromIndex;
        this.pageSize = pageSize;
        this.searchInHistory = searchInHistory;
    }

    @Override
    public List<LightProcessInstance> execute(Environment environment) throws Exception {
        QueryDefinitionAPI queryDefinitionAPI;
        QueryRuntimeAPI queryRuntimeAPI;
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        if (this.searchInHistory) {
            queryRuntimeAPI = accessor.getQueryRuntimeAPI("historyQueryList");
            queryDefinitionAPI = accessor.getQueryDefinitionAPI();
        } else {
            queryRuntimeAPI = accessor.getQueryRuntimeAPI("journalQueryList");
            queryDefinitionAPI = accessor.getQueryDefinitionAPI("journalQueryList");
        }
        Set<ProcessDefinitionUUID> processes = queryDefinitionAPI.getProcessUUIDs(this.category);
        List<LightProcessInstance> result = queryRuntimeAPI.getLightParentProcessInstancesWithInvolvedUser(this.userId, this.fromIndex, this.pageSize, processes);
        return result;
    }
}

