/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.Command;

public class WebGetNumberOfReadableProcessesCommand
implements Command<Integer> {
    private static final long serialVersionUID = -822497593009305244L;
    private final String userUUID;
    private final Collection<String> roleUUIDs;
    private final Collection<String> groupUUIDs;
    private final Collection<String> membershipUUIDs;
    private final String entityID;
    private final boolean searchInHistory;

    public WebGetNumberOfReadableProcessesCommand(boolean searchInHistory, String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String entityID) {
        this.searchInHistory = searchInHistory;
        this.userUUID = userUUID;
        this.roleUUIDs = roleUUIDs;
        this.groupUUIDs = groupUUIDs;
        this.membershipUUIDs = membershipUUIDs;
        this.entityID = entityID;
    }

    @Override
    public Integer execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        ManagementAPI managementAPI = accessor.getManagementAPI();
        QueryDefinitionAPI queryDefinitionAPI = this.searchInHistory ? accessor.getQueryDefinitionAPI("historyQueryList") : accessor.getQueryDefinitionAPI("journalQueryList");
        List<Object> applicableRules = new ArrayList();
        HashSet<String> exceptions = new HashSet<String>();
        applicableRules = managementAPI.getApplicableRules(Rule.RuleType.PROCESS_READ, this.userUUID, this.roleUUIDs, this.groupUUIDs, this.membershipUUIDs, this.entityID);
        for (Rule rule : applicableRules) {
            exceptions.addAll(rule.getItems());
        }
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : exceptions) {
            processUUIDs.add(new ProcessDefinitionUUID(processUUID));
        }
        PrivilegePolicy privilegePolicy = managementAPI.getRuleTypePolicy(Rule.RuleType.PROCESS_READ);
        switch (privilegePolicy) {
            case ALLOW_BY_DEFAULT: {
                int totalNumberOfProcesses = queryDefinitionAPI.getNumberOfProcesses();
                return totalNumberOfProcesses - processUUIDs.size();
            }
            case DENY_BY_DEFAULT: {
                return processUUIDs.size();
            }
        }
        throw new IllegalArgumentException();
    }
}

