/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.util.Command;

public class WebGetStartableProcessesCommand
implements Command<Set<LightProcessDefinition>> {
    private static final long serialVersionUID = -822497593009305244L;
    private final String userUUID;
    private final Collection<String> roleUUIDs;
    private final Collection<String> groupUUIDs;
    private final Collection<String> membershipUUIDs;
    private final String entityID;

    public WebGetStartableProcessesCommand(String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String entityID) {
        this.userUUID = userUUID;
        this.roleUUIDs = roleUUIDs;
        this.groupUUIDs = groupUUIDs;
        this.membershipUUIDs = membershipUUIDs;
        this.entityID = entityID;
    }

    @Override
    public Set<LightProcessDefinition> execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        ManagementAPI managementAPI = accessor.getManagementAPI();
        QueryDefinitionAPI queryDefinitionAPI = accessor.getQueryDefinitionAPI("journalQueryList");
        List<Object> applicableRules = new ArrayList();
        HashSet<String> exceptions = new HashSet<String>();
        applicableRules = managementAPI.getApplicableRules(Rule.RuleType.PROCESS_START, this.userUUID, this.roleUUIDs, this.groupUUIDs, this.membershipUUIDs, this.entityID);
        for (Rule rule : applicableRules) {
            exceptions.addAll(rule.getItems());
        }
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : exceptions) {
            processUUIDs.add(new ProcessDefinitionUUID(processUUID));
        }
        PrivilegePolicy privilegePolicy = managementAPI.getRuleTypePolicy(Rule.RuleType.PROCESS_START);
        switch (privilegePolicy) {
            case ALLOW_BY_DEFAULT: {
                if (processUUIDs != null && !processUUIDs.isEmpty()) {
                    List<LightProcessDefinition> tempResult = queryDefinitionAPI.getAllLightProcessesExcept(processUUIDs, 0, queryDefinitionAPI.getNumberOfProcesses());
                    HashSet<LightProcessDefinition> result = new HashSet<LightProcessDefinition>();
                    for (LightProcessDefinition lightProcessDefinition : tempResult) {
                        if (lightProcessDefinition.getState() != ProcessDefinition.ProcessState.ENABLED) continue;
                        result.add(lightProcessDefinition);
                    }
                    return result;
                }
                return queryDefinitionAPI.getLightProcesses(ProcessDefinition.ProcessState.ENABLED);
            }
            case DENY_BY_DEFAULT: {
                if (processUUIDs.size() > 0) {
                    Set<LightProcessDefinition> tempResult2 = queryDefinitionAPI.getLightProcesses(processUUIDs);
                    if (tempResult2 == null || tempResult2.isEmpty()) {
                        return Collections.emptySet();
                    }
                    HashSet<LightProcessDefinition> result2 = new HashSet<LightProcessDefinition>();
                    for (LightProcessDefinition lightProcessDefinition : tempResult2) {
                        if (lightProcessDefinition.getState() != ProcessDefinition.ProcessState.ENABLED) continue;
                        result2.add(lightProcessDefinition);
                    }
                    return result2;
                }
                return Collections.emptySet();
            }
        }
        throw new IllegalArgumentException();
    }
}

