/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.AssignUpdate;
import org.ow2.bonita.facade.runtime.StateUpdate;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.Update;
import org.ow2.bonita.facade.runtime.VariableUpdate;
import org.ow2.bonita.facade.runtime.impl.AssignUpdateImpl;
import org.ow2.bonita.facade.runtime.impl.StateUpdateImpl;
import org.ow2.bonita.facade.runtime.impl.VariableUpdateImpl;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.impl.LightActivityInstanceImpl;
import org.ow2.bonita.util.CopyTool;
import org.ow2.bonita.util.ExceptionManager;

public class ActivityInstanceImpl
extends LightActivityInstanceImpl
implements TaskInstance {
    private static final long serialVersionUID = -8515098234372896097L;
    protected List<StateUpdate> stateUpdates = new ArrayList<StateUpdate>();
    protected Map<String, Object> clientVariables;
    protected List<VariableUpdate> variableUpdates = new ArrayList<VariableUpdate>();
    protected List<AssignUpdate> assignUpdates;
    protected Set<String> candidates;

    protected ActivityInstanceImpl() {
    }

    public ActivityInstanceImpl(ActivityInstanceUUID uuid, ActivityDefinition activityDefinition, ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ProcessInstanceUUID rootInstanceUUID, String iterationId, String activityInstanceId, String loopId) {
        super(uuid, activityDefinition, processUUID, instanceUUID, rootInstanceUUID, iterationId, activityInstanceId, loopId);
    }

    public ActivityInstanceImpl(ActivityInstance src) {
        super(src);
        List<StateUpdate> stateList;
        this.clientVariables = src.getVariablesBeforeStarted();
        List<VariableUpdate> list = src.getVariableUpdates();
        if (list != null && !list.isEmpty()) {
            this.variableUpdates = new ArrayList<VariableUpdate>();
            for (VariableUpdate varUpdate : list) {
                this.variableUpdates.add(new VariableUpdateImpl(varUpdate));
            }
        }
        if ((stateList = src.getStateUpdates()) != null && !stateList.isEmpty()) {
            this.stateUpdates = new ArrayList<StateUpdate>();
            for (StateUpdate update : stateList) {
                this.stateUpdates.add(new StateUpdateImpl(update));
            }
        }
        if (src.isTask()) {
            TaskInstance task = src.getTask();
            List<AssignUpdate> assignList = task.getAssignUpdates();
            if (assignList != null && !assignList.isEmpty()) {
                this.assignUpdates = new ArrayList<AssignUpdate>();
                for (AssignUpdate update : assignList) {
                    this.assignUpdates.add(new AssignUpdateImpl(update));
                }
            }
            this.candidates = CopyTool.copy(task.getTaskCandidates());
        }
    }

    @Override
    public String toString() {
        Set<String> candidates;
        String userId;
        try {
            userId = this.getTaskUser();
        }
        catch (IllegalStateException e) {
            userId = null;
        }
        try {
            candidates = this.getTaskCandidates();
        }
        catch (IllegalStateException e) {
            candidates = null;
        }
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append("[uuid: ").append(this.getUUID()).append(", activityId: ").append(this.getActivityName()).append(", iterationId: ").append(this.getIterationId()).append(", loopId: ").append(this.getLoopId()).append(", processDefinitionUUID: ").append(this.getProcessDefinitionUUID()).append(", processUUID: ").append(this.getProcessInstanceUUID()).append(", variablesBeforeStarted: ").append(this.getVariablesBeforeStarted()).append(", variableUpdates: ").append(this.getVariableUpdates()).append(", startedDate: ").append(this.getStartedDate()).append(", endedDate: ").append(this.getEndedDate()).append(", readyDate: ").append(this.getReadyDate()).append(", userId: ").append(userId).append(", candidates: ").append(candidates).append(", state: ").append((Object)this.getState()).append(", createdDate: ").append(this.getCreatedDate()).append(", startedBy: ").append(this.getStartedBy()).append(", startedDate: ").append(this.getStartedDate()).append(", endedDate: ").append(this.getEndedDate()).append(", endedBy: ").append(this.getEndedBy()).append("]");
        return builder.toString();
    }

    @Override
    public Map<String, Object> getVariablesBeforeStarted() {
        return this.clientVariables;
    }

    @Override
    public Object getVariableValueBeforeStarted(String variableId) {
        return this.getVariablesBeforeStarted().get(variableId);
    }

    @Override
    public TaskInstance getTask() {
        if (this.isTask()) {
            return this;
        }
        return null;
    }

    @Override
    public List<VariableUpdate> getVariableUpdates() {
        if (this.variableUpdates == null) {
            return Collections.emptyList();
        }
        return this.variableUpdates;
    }

    @Override
    public Map<String, Object> getLastKnownVariableValues() {
        Map<String, Object> var = this.getVariablesBeforeStarted();
        var = var != null ? new HashMap<String, Object>(var) : new HashMap<String, Object>();
        for (VariableUpdate varUp : this.getVariableUpdates()) {
            var.put(varUp.getName(), varUp.getValue());
        }
        return var;
    }

    @Override
    public List<StateUpdate> getStateUpdates() {
        return this.stateUpdates;
    }

    @Override
    public String getUpdatedBy() {
        Update lastUpdate = this.getLastUpdate();
        if (lastUpdate == null) {
            return null;
        }
        if (lastUpdate.getUpdatedBy() != null) {
            return lastUpdate.getUpdatedBy();
        }
        String message = ExceptionManager.getInstance().getFullMessage("baoi_TII_2", this.getUUID());
        throw new IllegalStateException(message);
    }

    @Override
    public List<AssignUpdate> getAssignUpdates() {
        return this.assignUpdates;
    }

    @Override
    public StateUpdate getLastStateUpdate() {
        if (this.stateUpdates != null && !this.stateUpdates.isEmpty()) {
            return this.stateUpdates.get(this.stateUpdates.size() - 1);
        }
        return null;
    }

    @Override
    public AssignUpdate getLastAssignUpdate() {
        if (this.assignUpdates != null && !this.assignUpdates.isEmpty()) {
            return this.assignUpdates.get(this.assignUpdates.size() - 1);
        }
        return null;
    }

    protected Update getLastUpdate() {
        Update lastState = null;
        if (this.stateUpdates != null && !this.stateUpdates.isEmpty()) {
            lastState = this.stateUpdates.get(this.stateUpdates.size() - 1);
        }
        Update lastAssign = null;
        if (this.assignUpdates != null && !this.assignUpdates.isEmpty()) {
            lastAssign = this.assignUpdates.get(this.assignUpdates.size() - 1);
        }
        if (lastState == null && lastAssign == null) {
            return null;
        }
        if (lastState == null && lastAssign != null) {
            return lastAssign;
        }
        if (lastState != null && lastAssign == null) {
            return lastState;
        }
        if (lastAssign.getUpdatedDate().getTime() <= lastState.getUpdatedDate().getTime()) {
            return lastState;
        }
        return lastAssign;
    }

    @Override
    public Set<String> getTaskCandidates() {
        if (this.candidates == null) {
            return Collections.emptySet();
        }
        return this.candidates;
    }
}

