/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.VariableUpdate;
import org.ow2.bonita.facade.runtime.impl.ActivityInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.AssignUpdateImpl;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.InternalVariableUpdate;
import org.ow2.bonita.facade.runtime.impl.StateUpdateImpl;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.VariableUtil;

public class InternalActivityInstance
extends ActivityInstanceImpl {
    private static final long serialVersionUID = -8515098234372896097L;
    protected long dbid;
    protected Map<String, Variable> variables;

    protected InternalActivityInstance() {
    }

    public InternalActivityInstance(ActivityInstanceUUID uuid, ActivityDefinition activityDefinition, ProcessInstanceUUID instanceUUID, ProcessInstanceUUID rootInstanceUUID, String iterationId, String activityInstanceId, String loopId) {
        super(uuid, activityDefinition, activityDefinition.getProcessDefinitionUUID(), instanceUUID, rootInstanceUUID, iterationId, activityInstanceId, loopId);
    }

    public InternalActivityInstance(ActivityInstance src) {
        super(src);
        this.setVariables(VariableUtil.createVariableMap(src.getProcessDefinitionUUID(), src.getVariablesBeforeStarted()));
        this.variableUpdates = null;
        for (VariableUpdate varUpdate : src.getVariableUpdates()) {
            Serializable value = varUpdate.getValue();
            this.addVariableUpdate(new InternalVariableUpdate(varUpdate.getDate(), varUpdate.getUserId(), varUpdate.getName(), VariableUtil.createVariable(src.getProcessDefinitionUUID(), varUpdate.getName(), value)));
        }
    }

    public void setExpectedEndDate(Date expectedEndDate) {
        this.expectedEndDate = Misc.getTime(expectedEndDate);
    }

    public void setReadyDate(Date readyDate) {
        this.readyDate = Misc.getTime(readyDate);
    }

    public void setEndedDate(Date endedDate) {
        this.endedDate = Misc.getTime(endedDate);
    }

    public void addVariableUpdate(VariableUpdate varUpdate) {
        if (this.variableUpdates == null) {
            this.variableUpdates = new ArrayList();
        }
        this.variableUpdates.add(varUpdate);
    }

    public void setVariableValue(String variableName, Variable variable) {
        this.updateLastUpdateDate();
        this.variables.put(variableName, variable);
    }

    public void updateLastUpdateDate() {
        this.lastUpdate = System.currentTimeMillis();
        Querier querier = EnvTool.getJournalQueriers();
        querier.getProcessInstance(this.getProcessInstanceUUID()).updateLastUpdateDate();
    }

    public void setTaskAssign(ActivityState taskState, String loggedInUserId, String assignedUserId) {
        HashSet<String> previouslyActiveUsers = new HashSet<String>();
        if (this.isTaskAssigned()) {
            previouslyActiveUsers.add(this.getTaskUser());
        } else {
            previouslyActiveUsers.addAll(this.getTaskCandidates());
        }
        this.updateLastUpdateDate();
        if (this.getAssignUpdates() == null) {
            this.assignUpdates = new ArrayList();
        }
        this.userId = assignedUserId;
        this.getAssignUpdates().add(new AssignUpdateImpl(new Date(), taskState, loggedInUserId, this.candidates, this.userId));
        if (assignedUserId != null) {
            Querier querier = EnvTool.getJournalQueriers();
            InternalProcessInstance instance = querier.getProcessInstance(this.getRootInstanceUUID());
            if (previouslyActiveUsers != null && !previouslyActiveUsers.isEmpty()) {
                instance.removeActiveUsers(previouslyActiveUsers);
            }
            instance.addInvolvedUser(assignedUserId);
            if (assignedUserId != null) {
                instance.addActiveUser(assignedUserId);
            }
        }
    }

    public void setTaskAssign(ActivityState taskState, String loggedInUserId, Set<String> candidates) {
        HashSet<String> previouslyActiveUsers = new HashSet<String>();
        if (this.isTaskAssigned()) {
            previouslyActiveUsers.add(this.getTaskUser());
        } else {
            previouslyActiveUsers.addAll(this.getTaskCandidates());
        }
        this.updateLastUpdateDate();
        if (this.getAssignUpdates() == null) {
            this.assignUpdates = new ArrayList();
        }
        this.userId = null;
        this.candidates = candidates;
        this.getAssignUpdates().add(new AssignUpdateImpl(new Date(), taskState, loggedInUserId, this.candidates, this.userId));
        if (candidates != null && !candidates.isEmpty()) {
            Querier querier = EnvTool.getJournalQueriers();
            InternalProcessInstance instance = querier.getProcessInstance(this.getRootInstanceUUID());
            if (previouslyActiveUsers != null && !previouslyActiveUsers.isEmpty()) {
                instance.removeActiveUsers(previouslyActiveUsers);
            }
            instance.addInvolvedUsers(candidates);
            if (candidates != null && !candidates.isEmpty()) {
                instance.addActiveUsers(candidates);
            }
        }
    }

    public void setSubflowProcessInstanceUUID(ProcessInstanceUUID subflowProcessInstanceUUID) {
        this.subflowProcessInstanceUUID = subflowProcessInstanceUUID;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setDynamicDescription(String dynamicDescription) {
        this.dynamicDescription = dynamicDescription;
    }

    public void setDynamicLabel(String dynamicLabel) {
        this.dynamicLabel = dynamicLabel;
    }

    public void setDynamicExecutionSummary(String executionSummary) {
        this.executionSummary = executionSummary;
    }

    public void setActivityState(ActivityState newState, String userId) {
        if ((ActivityState.FINISHED.equals((Object)newState) || ActivityState.CANCELLED.equals((Object)newState) || ActivityState.ABORTED.equals((Object)newState) || ActivityState.SKIPPED.equals((Object)newState)) && this.isTask()) {
            Querier querier = EnvTool.getJournalQueriers();
            InternalProcessInstance instance = querier.getProcessInstance(this.getRootInstanceUUID());
            if (this.isTaskAssigned()) {
                instance.removeActiveUser(this.getTaskUser());
            } else {
                instance.removeActiveUsers(this.getTaskCandidates());
            }
        }
        this.updateLastUpdateDate();
        ActivityState oldState = this.getState();
        this.state = newState;
        Date actual = new Date();
        this.getStateUpdates().add(new StateUpdateImpl(actual, newState, oldState, userId));
        if (ActivityState.READY.equals((Object)newState)) {
            this.readyDate = actual.getTime();
        } else if (ActivityState.EXECUTING.equals((Object)newState)) {
            this.startedDate = actual.getTime();
            this.startedBy = userId;
        } else if (ActivityState.FINISHED.equals((Object)newState) || ActivityState.CANCELLED.equals((Object)newState) || ActivityState.ABORTED.equals((Object)newState)) {
            this.endedDate = actual.getTime();
            this.endedBy = userId;
        } else if (ActivityState.SKIPPED.equals((Object)newState)) {
            this.startedDate = actual.getTime();
            this.startedBy = userId;
            this.endedDate = actual.getTime();
            this.endedBy = userId;
        }
    }

    @Override
    public Map<String, Object> getVariablesBeforeStarted() {
        if (this.variables != null) {
            return VariableUtil.getVariableValues(this.variables);
        }
        return this.clientVariables;
    }

    public void setVariables(Map<String, Variable> variables) {
        Misc.badStateIfNotNull(this.variables, "variablesBeforeStarted can not be set twice!");
        this.variables = variables;
        this.clientVariables = null;
    }
}

