/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.VariableUpdate;
import org.ow2.bonita.facade.runtime.impl.InstanceStateUpdateImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalVariableUpdate;
import org.ow2.bonita.facade.runtime.impl.ProcessInstanceImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.handlers.FinishedInstanceHandler;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessUtil;
import org.ow2.bonita.util.TransientData;
import org.ow2.bonita.util.VariableUtil;

public class InternalProcessInstance
extends ProcessInstanceImpl {
    private static final long serialVersionUID = 370138202886825855L;
    protected long dbid;
    protected Execution rootExecution;
    protected long userXPRead = 0L;
    protected Map<String, String> transitionStates = new HashMap<String, String>();
    protected Map<String, Variable> variables;
    protected int nbOfAttachments;

    protected InternalProcessInstance() {
    }

    public InternalProcessInstance(ProcessInstanceUUID instanceUUID, InternalProcessDefinition process, ProcessInstanceUUID rootInstanceUUID, long iterationNb) {
        super(process.getUUID(), instanceUUID, rootInstanceUUID, iterationNb);
        this.nbOfAttachments = 0;
        Map<String, InternalActivityDefinition> initialActivities = process.getInternalInitialActivities();
        if (initialActivities.size() == 1) {
            InternalActivityDefinition initial = initialActivities.values().iterator().next();
            this.rootExecution = new Execution("Instance_" + this.getUUID().toString(), process, this, initial, "created", null);
        } else {
            this.rootExecution = new Execution("Instance_" + this.getUUID().toString(), process, this, null, "created", null);
        }
    }

    public InternalProcessInstance(ProcessInstance src) {
        super(src);
        this.activities = new HashSet();
        for (ActivityInstance activity : src.getActivities()) {
            this.activities.add(new InternalActivityInstance(activity));
        }
        this.variableUpdates = null;
        for (VariableUpdate varUpdate : src.getVariableUpdates()) {
            Serializable value = varUpdate.getValue();
            this.addVariableUpdate(new InternalVariableUpdate(varUpdate.getDate(), varUpdate.getUserId(), varUpdate.getName(), VariableUtil.createVariable(src.getProcessDefinitionUUID(), varUpdate.getName(), value)));
        }
        this.setVariables(src.getInitialVariableValues());
        if (src.getClass().equals(InternalProcessInstance.class)) {
            InternalProcessInstance other = (InternalProcessInstance)src;
            this.userXPRead = other.getUserXPRead();
            this.nbOfAttachments = other.nbOfAttachments;
        }
    }

    public void addVariableUpdate(VariableUpdate varUpdate) {
        if (this.variableUpdates == null) {
            this.variableUpdates = new ArrayList();
        }
        this.variableUpdates.add(varUpdate);
    }

    public void setVariableValue(String variableName, Variable variable) {
        this.updateLastUpdateDate();
        this.variables.put(variableName, variable);
    }

    public void updateLastUpdateDate() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public void addChildInstance(ProcessInstanceUUID childInstanceUUID) {
        if (this.childrenInstanceUUID == null) {
            this.childrenInstanceUUID = new HashSet();
        }
        this.updateLastUpdateDate();
        this.childrenInstanceUUID.add(childInstanceUUID);
    }

    public void addComment(Comment comment) {
        this.updateLastUpdateDate();
        this.commentFeed.add(comment);
    }

    public void addActivity(ActivityInstance activity) {
        if (this.getActivities() == null) {
            this.activities = new HashSet();
        }
        this.updateLastUpdateDate();
        this.activities.add(activity);
    }

    public void addAttachment(AttachmentInstance attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        }
        this.attachments.add(attachment);
    }

    public Map<String, Variable> getInitialVariables() {
        return this.variables;
    }

    @Override
    public Map<String, Object> getInitialVariableValues() {
        if (this.variables != null) {
            return VariableUtil.getVariableValues(this.variables);
        }
        return null;
    }

    private void setVariables(Map<String, Object> variables) {
        this.variables = VariableUtil.createVariableMap(this.getProcessDefinitionUUID(), variables);
        this.clientVariables = null;
    }

    public void begin(ActivityDefinitionUUID activityUUID) {
        if (this.rootExecution.getNode() != null) {
            this.rootExecution.beginWithOneStartNode();
        } else {
            this.rootExecution.beginWithManyStartNodes(activityUUID);
        }
    }

    public void setInitialVaribales(Map<String, Variable> initialVariables) {
        this.variables = initialVariables;
    }

    public boolean isInstanceState(InstanceState state) {
        return this.getInstanceState().equals((Object)state);
    }

    public TransitionState getTransitionState(String transitionName) {
        if (!this.transitionStates.containsKey(transitionName)) {
            return null;
        }
        return TransitionState.valueOf(this.transitionStates.get(transitionName));
    }

    public void setTransitionState(String transitionName, TransitionState state) {
        this.transitionStates.put(transitionName, state.toString());
    }

    public void removeTransitionState(String transitionName) {
        this.transitionStates.remove(transitionName);
    }

    public Map<String, String> getTransitionsStates() {
        return Collections.unmodifiableMap(this.transitionStates);
    }

    public Execution getRootExecution() {
        return this.rootExecution;
    }

    @Override
    public String toString() {
        String value = "Instance " + this.getUUID() + "(state:" + (Object)((Object)this.getInstanceState());
        if (this.getParentInstanceUUID() != null) {
            value = value + ", child of " + this.getParentInstanceUUID();
        }
        value = value + ")";
        return value;
    }

    public List<Execution> getExecOnNode(String nodeName) {
        return this.getExecOnNode(this.getRootExecution(), nodeName);
    }

    private List<Execution> getExecOnNode(Execution exec, String nodeName) {
        Misc.checkArgsNotNull(exec, nodeName);
        ArrayList<Execution> res = new ArrayList<Execution>();
        if ((exec.getExecutions() == null || exec.getExecutions().isEmpty()) && exec.getNode() != null && exec.getNode().getName().equals(nodeName)) {
            res.add(exec);
        }
        if (exec.getExecutions() != null) {
            for (Execution child : exec.getExecutions()) {
                res.addAll(this.getExecOnNode(child, nodeName));
            }
        }
        return res;
    }

    public void cancel() {
        ConnectorExecutor.executeConnectors(this.getRootExecution(), HookDefinition.Event.instanceOnCancel);
        this.getRootExecution().cancel();
        EnvTool.getRecorder().recordInstanceCancelled(this.getUUID(), EnvTool.getUserId());
        ProcessUtil.removeInternalInstanceEvents(this.getUUID());
        if (this.getParentInstanceUUID() == null) {
            this.finish();
        }
    }

    public void finish() {
        FinishedInstanceHandler handler = EnvTool.getFinishedInstanceHandler();
        handler.handleFinishedInstance(this);
    }

    public void setInstanceState(InstanceState newState, String userId) {
        this.updateLastUpdateDate();
        InstanceState oldState = this.getInstanceState();
        this.state = newState;
        if (this.getInstanceStateUpdates() == null) {
            this.instanceStateUpdates = new ArrayList();
        }
        Date newDate = new Date();
        this.getInstanceStateUpdates().add(new InstanceStateUpdateImpl(newDate, userId, oldState, newState));
        if (newState.equals((Object)InstanceState.STARTED)) {
            this.startedDate = newDate.getTime();
            this.startedBy = userId;
        } else {
            this.endedDate = newDate.getTime();
            this.endedBy = userId;
            if (this.activities != null) {
                for (ActivityInstance activity : this.activities) {
                    if (activity.getEndedDate() != null) continue;
                    EnvTool.getRecorder().recordBodyAborted(activity);
                    TransientData.removeTransientData(activity.getUUID());
                }
            }
        }
    }

    public void setUserXPRead(Date d) {
        this.userXPRead = d.getTime();
    }

    public long getUserXPRead() {
        return this.userXPRead;
    }

    public void setParentUUIDs(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID) {
        this.parentInstanceUUID = instanceUUID;
        this.parentActivityUUID = activityUUID;
    }

    public void removeAttachment(String name) {
        ArrayList<AttachmentInstance> removeAttachments = new ArrayList<AttachmentInstance>();
        for (AttachmentInstance attachment : this.attachments) {
            if (!attachment.getName().equals(name)) continue;
            removeAttachments.add(attachment);
        }
        this.attachments.removeAll(removeAttachments);
        this.updateLastUpdateDate();
    }

    public void removeAttachments() {
        this.attachments = null;
    }

    public int getNbOfAttachments() {
        return this.nbOfAttachments;
    }

    public void setNbOfAttachments(int nbOfAttachments) {
        this.nbOfAttachments = nbOfAttachments;
    }

    public static enum TransitionState {
        READY,
        TAKEN,
        ABORTED;

    }
}

