/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import org.ow2.bonita.facade.runtime.RuntimeRecord;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.Misc;

public abstract class RuntimeRecordImpl
implements RuntimeRecord {
    private static final long serialVersionUID = -5283156122103821954L;
    protected ProcessDefinitionUUID processUUID;
    protected ProcessInstanceUUID instanceUUID;
    protected ProcessInstanceUUID rootInstanceUUID;

    protected RuntimeRecordImpl() {
    }

    protected RuntimeRecordImpl(ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ProcessInstanceUUID rootInstanceUUID) {
        Misc.checkArgsNotNull(processUUID, instanceUUID, rootInstanceUUID);
        this.processUUID = processUUID;
        this.instanceUUID = instanceUUID;
        this.rootInstanceUUID = rootInstanceUUID;
    }

    protected RuntimeRecordImpl(RuntimeRecord src) {
        Misc.checkArgsNotNull(src);
        this.processUUID = new ProcessDefinitionUUID(src.getProcessDefinitionUUID());
        this.instanceUUID = new ProcessInstanceUUID(src.getProcessInstanceUUID());
        this.rootInstanceUUID = new ProcessInstanceUUID(src.getRootInstanceUUID());
    }

    @Override
    public ProcessDefinitionUUID getProcessDefinitionUUID() {
        return this.processUUID;
    }

    @Override
    public ProcessInstanceUUID getProcessInstanceUUID() {
        return this.instanceUUID;
    }

    @Override
    public ProcessInstanceUUID getRootInstanceUUID() {
        return this.rootInstanceUUID;
    }
}

