/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.connector.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.connector.core.desc.Array;
import org.ow2.bonita.connector.core.desc.Checkbox;
import org.ow2.bonita.connector.core.desc.Component;
import org.ow2.bonita.connector.core.desc.ConnectorDescriptor;
import org.ow2.bonita.connector.core.desc.Enumeration;
import org.ow2.bonita.connector.core.desc.Group;
import org.ow2.bonita.connector.core.desc.Option;
import org.ow2.bonita.connector.core.desc.Page;
import org.ow2.bonita.connector.core.desc.Password;
import org.ow2.bonita.connector.core.desc.Radio;
import org.ow2.bonita.connector.core.desc.Select;
import org.ow2.bonita.connector.core.desc.Setter;
import org.ow2.bonita.connector.core.desc.SimpleList;
import org.ow2.bonita.connector.core.desc.Text;
import org.ow2.bonita.connector.core.desc.Textarea;
import org.ow2.bonita.connector.core.desc.Widget;
import org.ow2.bonita.connector.core.desc.WidgetComponent;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class PageBinding
extends ElementBinding {
    private static final Set<String> allowedWidgets = new HashSet<String>();

    public PageBinding() {
        super("page");
    }

    @Override
    public Object parse(Element pageElement, Parse parse, Parser parser) {
        ConnectorDescriptor descriptor = parse.findObject(ConnectorDescriptor.class);
        List<Setter> inputs = descriptor.getInputs();
        String pageId = this.getChildTextContent(pageElement, "pageId");
        List<Component> widgets = this.getWidgets(pageElement, inputs);
        Page page = new Page(pageId, widgets);
        descriptor.addPage(page);
        return null;
    }

    private List<Component> getWidgets(Element page, List<Setter> inputs) {
        Element widgetsElement = XmlUtil.element(page, "widgets");
        if (widgetsElement != null) {
            ArrayList<Component> widgets = new ArrayList<Component>();
            List<Element> elements = XmlUtil.elements(widgetsElement, allowedWidgets);
            for (Element element : elements) {
                widgets.add(this.getComponent(element, inputs));
            }
            return widgets;
        }
        return null;
    }

    private Component getComponent(Element componentElement, List<Setter> inputs) {
        if ("group".equals(componentElement.getNodeName())) {
            String labelId = this.getChildTextContent(componentElement, "labelId");
            String optionalValue = XmlUtil.attribute(componentElement, "optional");
            boolean optional = Boolean.parseBoolean(optionalValue);
            Element widgetsElement = XmlUtil.element(componentElement, "widgets");
            ArrayList<WidgetComponent> widgets = null;
            if (widgetsElement != null) {
                widgets = new ArrayList<WidgetComponent>();
                List<Element> widgetsElem = XmlUtil.elements(widgetsElement, allowedWidgets);
                if (widgetsElem != null) {
                    for (Element widgetElement : widgetsElem) {
                        widgets.add(this.getWidget(widgetElement, inputs));
                    }
                }
            }
            return new Group(labelId, optional, widgets);
        }
        return this.getWidget(componentElement, inputs);
    }

    private WidgetComponent getWidget(Element widgetElement, List<Setter> inputs) {
        String name;
        String sizeValue;
        String reference;
        Widget component = null;
        Setter setter = null;
        String labelId = this.getChildTextContent(widgetElement, "labelId");
        Element setterElement = XmlUtil.element(widgetElement, "setter");
        if (setterElement != null && (reference = XmlUtil.attribute(setterElement, "reference")) != null) {
            reference = reference.replace("/connector/inputs/setter", "");
            reference = reference.replace("[", "");
            setter = "".equals(reference = reference.replace("]", "")) ? inputs.get(0) : inputs.get(Integer.parseInt(reference) - 1);
        }
        if ("text".equals(widgetElement.getNodeName())) {
            sizeValue = this.getChildTextContent(widgetElement, "size");
            int size = 20;
            if (sizeValue != null) {
                size = Integer.parseInt(sizeValue);
            }
            String maxCharValue = this.getChildTextContent(widgetElement, "maxChar");
            int maxChar = 100;
            if (maxCharValue != null) {
                maxChar = Integer.parseInt(maxCharValue);
            }
            component = new Text(labelId, setter, size, maxChar);
        } else if ("password".equals(widgetElement.getNodeName())) {
            sizeValue = this.getChildTextContent(widgetElement, "size");
            int size = 20;
            if (sizeValue != null) {
                size = Integer.parseInt(sizeValue);
            }
            String maxCharValue = this.getChildTextContent(widgetElement, "maxChar");
            int maxChar = 100;
            if (maxCharValue != null) {
                maxChar = Integer.parseInt(maxCharValue);
            }
            component = new Password(labelId, setter, size, maxChar);
        } else if ("textarea".equals(widgetElement.getNodeName())) {
            int rows = 10;
            String rowsValue = this.getChildTextContent(widgetElement, "rows");
            if (rowsValue != null) {
                rows = Integer.parseInt(rowsValue);
            }
            int columns = 60;
            String columnsValue = this.getChildTextContent(widgetElement, "columns");
            if (columnsValue != null) {
                columns = Integer.parseInt(columnsValue);
            }
            int maxChar = 100;
            String maxCharValue = this.getChildTextContent(widgetElement, "maxChar");
            if (maxCharValue != null) {
                maxChar = Integer.parseInt(maxCharValue);
            }
            int maxCharPerRow = 600;
            String maxCharPerRowValue = this.getChildTextContent(widgetElement, "maxCharPerRow");
            if (maxCharPerRowValue != null) {
                maxCharPerRow = Integer.parseInt(maxCharPerRowValue);
            }
            component = new Textarea(labelId, setter, rows, columns, maxChar, maxCharPerRow);
        } else if ("checkbox".equals(widgetElement.getNodeName())) {
            name = this.getChildTextContent(widgetElement, "name");
            String value = this.getChildTextContent(widgetElement, "value");
            component = new Checkbox(labelId, setter, name, value);
        } else if ("radio".equals(widgetElement.getNodeName())) {
            name = this.getChildTextContent(widgetElement, "name");
            String value = this.getChildTextContent(widgetElement, "value");
            component = new Radio(labelId, setter, name, value);
        } else if ("select".equals(widgetElement.getNodeName())) {
            String editableElement = this.getChildTextContent(widgetElement, "editable");
            boolean editable = false;
            if (editableElement != null) {
                editable = Boolean.parseBoolean(editableElement);
            }
            Element valuesElement = XmlUtil.element(widgetElement, "values");
            HashMap<String, String> values = null;
            if (valuesElement != null) {
                values = new HashMap<String, String>();
                List<Element> entries = XmlUtil.elements(valuesElement, "entry");
                if (entries != null) {
                    for (Element entryElement : entries) {
                        List<Element> entry = XmlUtil.elements(entryElement, "string");
                        values.put(entry.get(0).getTextContent(), entry.get(1).getTextContent());
                    }
                }
            }
            Option top = null;
            Element topElement = XmlUtil.element(widgetElement, "top");
            if (topElement != null) {
                String label = this.getChildTextContent(topElement, "label");
                String value = this.getChildTextContent(topElement, "value");
                top = new Option(label, value);
            }
            component = new Select(labelId, setter, values, editable, top);
        } else if ("enumeration".equals(widgetElement.getNodeName())) {
            List<Element> entries;
            Element valuesElement = XmlUtil.element(widgetElement, "values");
            HashMap<String, String> values = null;
            if (valuesElement != null) {
                values = new HashMap<String, String>();
                List<Element> entries2 = XmlUtil.elements(valuesElement, "entry");
                if (entries2 != null) {
                    for (Element entryElement : entries2) {
                        List<Element> entry = XmlUtil.elements(entryElement, "string");
                        values.put(entry.get(0).getTextContent(), entry.get(1).getTextContent());
                    }
                }
            }
            String linesValue = this.getChildTextContent(widgetElement, "lines");
            int lines = 1;
            if (linesValue != null) {
                lines = Integer.parseInt(linesValue);
            }
            String selectionValue = this.getChildTextContent(widgetElement, "selection");
            Enumeration.Selection selection = null;
            if (selectionValue != null) {
                if (selectionValue.equals(Enumeration.Selection.SINGLE.toString())) {
                    selection = Enumeration.Selection.SINGLE;
                } else if (selectionValue.equals(Enumeration.Selection.MUTLI.toString())) {
                    selection = Enumeration.Selection.MUTLI;
                }
            }
            int[] selectedIndices = null;
            Element selectedIndicesElement = XmlUtil.element(widgetElement, "selectedIndices");
            if (selectedIndicesElement != null && (entries = XmlUtil.elements(selectedIndicesElement, "int")) != null) {
                selectedIndices = new int[entries.size()];
                for (int i = 0; i < entries.size(); ++i) {
                    selectedIndices[i] = Integer.parseInt(entries.get(i).getTextContent());
                }
            }
            component = new Enumeration(labelId, setter, values, selectedIndices, lines, selection);
        } else if ("array".equals(widgetElement.getNodeName())) {
            List<Element> captionsElement;
            String colsValue = this.getChildTextContent(widgetElement, "cols");
            int cols = 2;
            if (colsValue != null) {
                cols = Integer.parseInt(colsValue);
            }
            String rowsValue = this.getChildTextContent(widgetElement, "rows");
            int rows = 0;
            if (rowsValue != null) {
                rows = Integer.parseInt(rowsValue);
            }
            String fixedColsValue = this.getChildTextContent(widgetElement, "fixedCols");
            boolean fixedCols = true;
            if (fixedColsValue != null) {
                fixedCols = Boolean.parseBoolean(fixedColsValue);
            }
            String fixedRowsValue = this.getChildTextContent(widgetElement, "fixedRows");
            boolean fixedRows = false;
            if (fixedRowsValue != null) {
                fixedRows = Boolean.parseBoolean(fixedRowsValue);
            }
            Element colsCaptionsElement = XmlUtil.element(widgetElement, "colsCaptions");
            ArrayList<String> colsCaptions = null;
            if (colsCaptionsElement != null && (captionsElement = XmlUtil.elements(colsCaptionsElement, "string")) != null) {
                colsCaptions = new ArrayList<String>();
                for (Element element : captionsElement) {
                    colsCaptions.add(element.getTextContent());
                }
            }
            component = new Array(labelId, setter, cols, rows, fixedCols, fixedRows, colsCaptions);
        } else if ("list".equals(widgetElement.getNodeName())) {
            String maxRowsValue = this.getChildTextContent(widgetElement, "maxRows");
            int maxRows = 0;
            if (maxRowsValue != null) {
                maxRows = Integer.parseInt(maxRowsValue);
            }
            component = new SimpleList(labelId, setter, maxRows);
        }
        return component;
    }

    static {
        allowedWidgets.add("text");
        allowedWidgets.add("password");
        allowedWidgets.add("textarea");
        allowedWidgets.add("array");
        allowedWidgets.add("list");
        allowedWidgets.add("checkbox");
        allowedWidgets.add("radio");
        allowedWidgets.add("select");
        allowedWidgets.add("enumeration");
        allowedWidgets.add("group");
    }
}

