/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.parsing.def.binding.ActivityBinding;
import org.ow2.bonita.parsing.def.binding.AttachmentBinding;
import org.ow2.bonita.parsing.def.binding.CategoryBinding;
import org.ow2.bonita.parsing.def.binding.ConnectorBinding;
import org.ow2.bonita.parsing.def.binding.DataFieldBinding;
import org.ow2.bonita.parsing.def.binding.EventSubProcessBinding;
import org.ow2.bonita.parsing.def.binding.ParticipantBinding;
import org.ow2.bonita.parsing.def.binding.ProcessBinding;
import org.ow2.bonita.parsing.def.binding.TransitionBinding;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.xml.Bindings;
import org.ow2.bonita.util.xml.Entity;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.UrlEntity;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class XmlDefParser
extends Parser {
    public static final String CATEGORY_MAJOR_ELT = "majorElements";
    private static final String RESSOURCES_DIR = "";
    private static final String[] SCHEMA_RESOURCES = new String[]{"XMLSchema.xsd", "XMLProcessDef_transitional.xsd"};
    public static final Bindings DEFAULT_BINDINGS = XmlDefParser.getDefaultBindings();
    private static final Map<String, Entity> defaultEntities = XmlDefParser.getDefaultEntities();
    private static final String[] schemaSources = XmlDefParser.getSchemaSources();

    public XmlDefParser() {
        super(DEFAULT_BINDINGS, defaultEntities);
    }

    @Override
    public Object parseDocumentElement(Element processDefinitionElement, Parse parse) {
        String processDefinitionTag = processDefinitionElement.getTagName();
        if (!"process-definition".equals(processDefinitionTag)) {
            String message = ExceptionManager.getInstance().getMessage("bpx_XDP_1", processDefinitionTag);
            throw new BonitaRuntimeException(message);
        }
        List<Element> processes = XmlUtil.elements(processDefinitionElement, "process");
        if (processes != null && processes.size() > 1) {
            String message = ExceptionManager.getInstance().getMessage("bpx_XDP_2", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        Element processElement = processes.get(0);
        ProcessDefinition processDef = (ProcessDefinition)this.parseElement(processElement, parse, CATEGORY_MAJOR_ELT);
        return processDef;
    }

    @Override
    public synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        this.documentBuilderFactory = this.newDocumentBuilderFactory();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(true);
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSources);
        return this.documentBuilderFactory;
    }

    private static Bindings getDefaultBindings() {
        Bindings defaultBindings = new Bindings();
        defaultBindings.addBinding(new ParticipantBinding());
        defaultBindings.addBinding(new DataFieldBinding());
        defaultBindings.addBinding(new ProcessBinding());
        defaultBindings.addBinding(new ActivityBinding());
        defaultBindings.addBinding(new TransitionBinding());
        defaultBindings.addBinding(new AttachmentBinding());
        defaultBindings.addBinding(new ConnectorBinding());
        defaultBindings.addBinding(new CategoryBinding());
        defaultBindings.addBinding(new EventSubProcessBinding());
        return defaultBindings;
    }

    private static Map<String, Entity> getDefaultEntities() {
        HashMap<String, Entity> defaultSchemaCatalog = new HashMap<String, Entity>();
        ClassLoader resourceLoader = XmlDefParser.class.getClassLoader();
        defaultSchemaCatalog.put("http://www.w3.org/2001/XMLSchema", new UrlEntity("XMLSchema.xsd", resourceLoader));
        defaultSchemaCatalog.put("http://www.w3.org/2001/xml.xsd", new UrlEntity("XMLSchema.xsd", resourceLoader));
        return defaultSchemaCatalog;
    }

    private static String[] getSchemaSources() {
        String[] tab = new String[SCHEMA_RESOURCES.length];
        ClassLoader resourceLoader = XmlDefParser.class.getClassLoader();
        for (int i = 0; i < SCHEMA_RESOURCES.length; ++i) {
            tab[i] = resourceLoader.getResource(SCHEMA_RESOURCES[i]).toExternalForm();
        }
        return tab;
    }
}

