/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def.binding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class AttachmentBinding
extends ElementBinding {
    private static final Logger LOGGER = Logger.getLogger(AttachmentBinding.class.getName());

    public AttachmentBinding() {
        super("attachment");
    }

    @Override
    public Object parse(Element attachmentElement, Parse parse, Parser parser) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsing element = " + attachmentElement);
        }
        String name = null;
        try {
            ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
            name = XmlUtil.attribute(attachmentElement, "name");
            String label = this.getChildTextContent(attachmentElement, "label");
            String filePath = this.getChildTextContent(attachmentElement, "file-path");
            String description = this.getChildTextContent(attachmentElement, "description");
            String fileName = this.getChildTextContent(attachmentElement, "file-name");
            processBuilder.addAttachment(name, filePath, fileName);
            processBuilder.addDescription(description);
            processBuilder.addLabel(label);
        }
        catch (Exception e) {
            parse.addProblem("Error parsing Attachment " + name, e);
        }
        return null;
    }
}

