/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.xpdl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.parsing.xpdl.binding.ActivityBinding;
import org.ow2.bonita.parsing.xpdl.binding.DataFieldBinding;
import org.ow2.bonita.parsing.xpdl.binding.ParticipantBinding;
import org.ow2.bonita.parsing.xpdl.binding.TransitionBinding;
import org.ow2.bonita.parsing.xpdl.binding.WorkflowProcessBinding;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.xml.Bindings;
import org.ow2.bonita.util.xml.Entity;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.Problem;
import org.ow2.bonita.util.xml.UrlEntity;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class XpdlParser
extends Parser {
    private static final Logger LOG = Logger.getLogger(XpdlParser.class.getName());
    public static final String CATEGORY_MAJOR_ELT = "majorElements";
    private static final String RESSOURCES_DIR = "";
    private static final String[] SCHEMA_RESOURCES = new String[]{"XMLSchema.xsd", "XPDL_1_0.xsd"};
    public static final Bindings DEFAULT_BINDINGS = XpdlParser.getDefaultBindings();
    private static final Map<String, Entity> defaultEntities = XpdlParser.getDefaultEntities();
    private static final String[] schemaSources = XpdlParser.getSchemaSources();

    public XpdlParser() {
        super(DEFAULT_BINDINGS, defaultEntities);
    }

    @Override
    public Object parseDocumentElement(Element packageElement, Parse parse) {
        String packageNS = packageElement.getNamespaceURI();
        if (!"http://www.wfmc.org/2002/XPDL1.0".equals(packageNS)) {
            String message = ExceptionManager.getInstance().getMessage("bpx_XP_1", packageNS);
            throw new BonitaRuntimeException(message);
        }
        Element processesContainer = XmlUtil.element(packageElement, "WorkflowProcesses");
        if (processesContainer == null) {
            String message = ExceptionManager.getInstance().getMessage("bpx_XP_3", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        List<Element> processes = XmlUtil.elements(processesContainer, "WorkflowProcess");
        if (processes != null && processes.size() > 1) {
            String message = ExceptionManager.getInstance().getMessage("bpx_XP_4", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        Element processElement = processes.get(0);
        return (ProcessDefinition)this.parseElement(processElement, parse, CATEGORY_MAJOR_ELT);
    }

    @Override
    public synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        this.documentBuilderFactory = this.newDocumentBuilderFactory();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(true);
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSources);
        return this.documentBuilderFactory;
    }

    private static Bindings getDefaultBindings() {
        Bindings defaultBindings = new Bindings();
        defaultBindings.addBinding(new ParticipantBinding());
        defaultBindings.addBinding(new DataFieldBinding());
        defaultBindings.addBinding(new WorkflowProcessBinding());
        defaultBindings.addBinding(new ActivityBinding());
        defaultBindings.addBinding(new TransitionBinding());
        return defaultBindings;
    }

    private static Map<String, Entity> getDefaultEntities() {
        HashMap<String, Entity> defaultSchemaCatalog = new HashMap<String, Entity>();
        ClassLoader resourceLoader = XpdlParser.class.getClassLoader();
        defaultSchemaCatalog.put("http://www.w3.org/2001/XMLSchema", new UrlEntity("XMLSchema.xsd", resourceLoader));
        defaultSchemaCatalog.put("http://www.w3.org/2001/xml.xsd", new UrlEntity("XMLSchema.xsd", resourceLoader));
        defaultSchemaCatalog.put("http://www.wfmc.org/2002/XPDL1.0", new UrlEntity("XPDL_1_0.xsd", resourceLoader));
        return defaultSchemaCatalog;
    }

    private static String[] getSchemaSources() {
        String[] tab = new String[SCHEMA_RESOURCES.length];
        ClassLoader resourceLoader = XpdlParser.class.getClassLoader();
        for (int i = 0; i < SCHEMA_RESOURCES.length; ++i) {
            tab[i] = resourceLoader.getResource(SCHEMA_RESOURCES[i]).toExternalForm();
        }
        return tab;
    }

    public void checkProblems(String description, Parse parse) {
        if (parse.hasProblems()) {
            StringBuffer errorMsg = null;
            for (Problem p : parse.getProblems()) {
                if (p.getSeverity().equals("error") || p.getSeverity().equals("fatal-error")) {
                    if (errorMsg == null) {
                        errorMsg = new StringBuffer();
                    }
                    errorMsg.append(Misc.LINE_SEPARATOR).append("  ").append(p.toString());
                    if (p.getCause() != null) {
                        LOG.log(Level.SEVERE, p.toString(), p.getCause());
                        continue;
                    }
                    LOG.severe(p.toString());
                    continue;
                }
                LOG.warning(p.toString());
            }
            if (errorMsg != null) {
                throw new BonitaRuntimeException("errors during parsing of " + description + ": " + errorMsg);
            }
        }
    }
}

