/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.xpdl.binding;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.definition.InstanceInitiator;
import org.ow2.bonita.parsing.xpdl.binding.MajorElementBinding;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ParticipantBinding
extends MajorElementBinding {
    private static final Logger LOG = Logger.getLogger(ParticipantBinding.class.getName());

    public ParticipantBinding() {
        super("Participant");
    }

    @Override
    public Object parse(Element participantElement, Parse parse, Parser parser) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("parsing element = " + participantElement);
        }
        String id = this.getId(participantElement);
        String description = this.getChildTextContent(participantElement, "Description");
        ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
        String participantType = null;
        Element participantTypeElement = XmlUtil.element(participantElement, "ParticipantType");
        if (participantElement != null) {
            participantType = XmlUtil.attribute(participantTypeElement, "Type");
        }
        if (participantType == null) {
            parse.addProblem("Participant: " + id + " does not define the mandatory Type attribute on ParticipantType element.");
        }
        if ("HUMAN".equals(participantType)) {
            processBuilder.addHuman(id);
        } else if (participantType.equals("ROLE")) {
            processBuilder.addGroup(id);
        }
        processBuilder.addDescription(description);
        processBuilder.addLabel(XmlUtil.attribute(participantElement, "Name"));
        if ("ROLE".equals(participantType)) {
            this.parseRoleMapper(participantElement, parse, processBuilder, id);
        }
        return null;
    }

    protected void parseRoleMapper(Element participantElement, Parse parse, ProcessBuilder processBuilder, String roleId) {
        Element mapperElement = this.getExtendedAttribute(participantElement, "Mapper");
        if (mapperElement != null) {
            String value = XmlUtil.attribute(mapperElement, "Value");
            String className = null;
            if ("Custom".equals(value)) {
                Element mapperClassNameElement = this.getExtendedAttribute(participantElement, "MapperClassName");
                className = XmlUtil.attribute(mapperClassNameElement, "Value");
            } else if ("Instance Initiator".equals(value)) {
                className = InstanceInitiator.class.getName();
            } else {
                parse.addProblem("Unsupported value on extendedAttribute Mapper: " + value);
            }
            processBuilder.addGroupResolver(className);
            Map<String, Object[]> parameters = this.getRoleMapperParameters(mapperElement, parse);
            if (parameters != null) {
                for (Map.Entry<String, Object[]> parameter : parameters.entrySet()) {
                    processBuilder.addInputParameter(parameter.getKey(), parameter.getValue());
                }
            }
        }
    }

    private Map<String, Object[]> getRoleMapperParameters(Element participantElement, Parse parse) {
        HashMap<String, Object[]> roleMapperParameters = null;
        Element roleMapperParameterElement = XmlUtil.element(participantElement, "Parameters");
        if (roleMapperParameterElement != null) {
            roleMapperParameters = new HashMap<String, Object[]>();
            List<Element> parameters = XmlUtil.elements(roleMapperParameterElement);
            for (Element param : parameters) {
                String paramType = param.getLocalName();
                String variable = param.getAttribute("Var");
                if (paramType.equals("InParameter")) {
                    if (param.hasAttribute("Setter")) {
                        String method = param.getAttribute("Setter");
                        if (method.length() != 0) {
                            roleMapperParameters.put(method, new Object[]{variable});
                            continue;
                        }
                        parse.addProblem("The Setter attribute should not be empty!");
                        continue;
                    }
                    parse.addProblem("InParameter need the Setter attribute");
                    continue;
                }
                if (paramType.equals("OutParameter")) {
                    parse.addProblem("A RoleMapper cannot set process variables.");
                    continue;
                }
                if (!paramType.equals("Properties")) continue;
                if (variable.startsWith("file:")) {
                    roleMapperParameters.put("file:", new Object[]{variable.substring(5)});
                    continue;
                }
                if (variable.startsWith("bar:")) {
                    roleMapperParameters.put("bar:", new Object[]{variable.substring(4)});
                    continue;
                }
                if (variable.startsWith("resource:")) {
                    roleMapperParameters.put("resource:", new Object[]{variable.substring(9)});
                    continue;
                }
                parse.addProblem("The value of Var attribute can only be either file:<absolute_file_path> or bar:<file_path_in_bar_file> orresource:<resource_path>");
            }
        }
        return roleMapperParameters;
    }
}

