/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.def.element.ConnectorDefinition;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.runtime.CommonClassLoader;
import org.ow2.bonita.runtime.ProcessClassLoader;
import org.ow2.bonita.runtime.VirtualCommonClassloader;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ReflectUtil;

public final class ClassDataLoader {
    private static final Logger LOG = Logger.getLogger(ClassDataLoader.class.getName());
    private Map<ProcessDefinitionUUID, ProcessClassLoader> processClassLoaders = new HashMap<ProcessDefinitionUUID, ProcessClassLoader>();
    private VirtualCommonClassloader virtualCommonClassloader = new VirtualCommonClassloader();

    public Class<?> getClass(ProcessDefinitionUUID processUUID, String className) throws ClassNotFoundException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Looking for class " + className + ", in process : " + processUUID);
        }
        Class<?> result = null;
        if (processUUID != null) {
            result = this.lookIntoProcessClassLoader(processUUID, className);
        }
        if (result != null) {
            return result;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Class " + className + " not found in packageClassLoaders...");
        }
        if ((result = this.lookIntoCommonClassLoader(className)) != null) {
            return result;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Class " + className + " not found in globalClassLoaders...");
        }
        return ClassDataLoader.class.getClassLoader().loadClass(className);
    }

    public Object getInstance(ProcessDefinitionUUID processUUID, String className) {
        try {
            Class<?> clazz = this.getClass(processUUID, className);
            return this.getClassInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            String message = ExceptionManager.getInstance().getFullMessage("be_CDL_1", className);
            throw new BonitaRuntimeException(message);
        }
    }

    protected Object getInstance(ProcessDefinitionUUID processUUID, ConnectorDefinition connector) {
        String className = connector.getClassName();
        return this.getInstance(processUUID, className);
    }

    private Object getClassInstance(Class<?> clazz) {
        Object obj = ReflectUtil.newInstance(clazz);
        if (obj == null) {
            String message = ExceptionManager.getInstance().getFullMessage("be_CDL_2", clazz.getName());
            throw new BonitaRuntimeException(message);
        }
        return obj;
    }

    private Class<?> lookIntoProcessClassLoader(ProcessDefinitionUUID processUUID, String className) {
        ClassLoader classLoader = this.getProcessClassLoader(processUUID);
        try {
            Class<?> result = classLoader.loadClass(className);
            if (result == null) break block4;
            if (result.getClassLoader().equals(classLoader)) {
                return result;
            }
        }
        finally {
            return null;
        }
        {
            block4: {
            }
        }
    }

    private synchronized Class<?> lookIntoCommonClassLoader(String className) {
        try {
            return this.virtualCommonClassloader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ClassLoader getProcessClassLoader(ProcessDefinitionUUID processUUID) {
        if (!this.processClassLoaders.containsKey(processUUID)) {
            this.processClassLoaders.put(processUUID, new ProcessClassLoader(processUUID));
        }
        return this.processClassLoaders.get(processUUID);
    }

    public <T> T getInstance(Class<T> clazz, ProcessDefinitionUUID processUUID, ConnectorDefinition connector) {
        Misc.checkArgsNotNull(clazz, connector);
        Object obj = this.getInstance(processUUID, connector);
        if (obj == null) {
            String className = connector.getClassName();
            String message = ExceptionManager.getInstance().getFullMessage("be_CDL_3", className);
            throw new BonitaRuntimeException(message);
        }
        if (obj.getClass().isAssignableFrom(clazz)) {
            String message = ExceptionManager.getInstance().getFullMessage("be_CDL_4", connector, clazz.getName(), obj);
            throw new BonitaRuntimeException(message);
        }
        return (T)obj;
    }

    public void removeProcessClassLoader(ProcessDefinitionUUID processUUID) {
        ProcessClassLoader loader = this.processClassLoaders.remove(processUUID);
        if (loader != null) {
            loader.release();
        }
    }

    public void clear() {
        for (ProcessClassLoader loader : this.processClassLoaders.values()) {
            loader.release();
        }
        this.processClassLoaders.clear();
        this.virtualCommonClassloader.cleanCommonClassLoader();
    }

    public Set<ProcessDefinitionUUID> getActiveProcessClassLoaders() {
        return this.processClassLoaders.keySet();
    }

    public CommonClassLoader getCommonClassLoader() {
        return this.virtualCommonClassloader.getCommonClassLoader();
    }

    public synchronized void resetCommonClassloader() {
        this.virtualCommonClassloader.resetCommonClassloader();
    }
}

