/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import org.ow2.bonita.persistence.EventDbSession;
import org.ow2.bonita.runtime.event.IncomingEventInstance;

public class EventAdded
implements Synchronization {
    static final Logger LOG = Logger.getLogger(EventAdded.class.getName());
    private EventDbSession dbSession;
    private long incomingEventInstanceId;
    private final long originalEnableTime;

    public EventAdded(EventDbSession dbSession, long incomingEventInstanceId, long originalEnableTime) {
        this.dbSession = dbSession;
        this.incomingEventInstanceId = incomingEventInstanceId;
        this.originalEnableTime = originalEnableTime;
    }

    public void afterCompletion(int arg0) {
    }

    public void beforeCompletion() {
        IncomingEventInstance incoming;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("notifying event executor of added event");
        }
        if ((incoming = this.dbSession.getIncomingEvent(this.incomingEventInstanceId)) != null) {
            incoming.setEnableTime(this.originalEnableTime);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Updating EnableTime of event: " + this.incomingEventInstanceId + " to " + this.originalEnableTime + "...");
            }
        }
    }

    public String toString() {
        return "event-added";
    }
}

