/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.EventExecutorThread;
import org.ow2.bonita.runtime.event.GetEventsCouplesCommand;
import org.ow2.bonita.runtime.event.RemoveOverdueEvents;
import org.ow2.bonita.util.Command;

public class EventDispatcherThread
extends Thread {
    static final Logger LOG = Logger.getLogger(EventDispatcherThread.class.getName());
    protected volatile boolean isActive = true;
    private EventExecutor executor;
    private boolean refresh;
    private int currentIdleInterval;
    private int minimumInterval;
    private Object semaphore = new Object();
    private Object threadSemaphore = new Object();

    EventDispatcherThread(EventExecutor executor, String name) {
        super(name);
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block32: {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("starting...");
            }
            this.currentIdleInterval = this.executor.getIdleMillis();
            this.minimumInterval = this.executor.getMinimumInterval();
            block19: while (true) {
                try {
                    while (this.isActive()) {
                        try {
                            long waitPeriod;
                            this.refresh = false;
                            this.currentIdleInterval = this.executor.getIdleMillis();
                            Map<ProcessInstanceUUID, Set<EventCoupleId>> validCouplesMap = this.executor.getCommandService().execute(new GetEventsCouplesCommand());
                            if (validCouplesMap != null && !validCouplesMap.isEmpty()) {
                                for (Set<EventCoupleId> validCouples : validCouplesMap.values()) {
                                    EventExecutorThread thread = new EventExecutorThread(this.executor, validCouples);
                                    this.executor.getThreadPool().submit(thread);
                                }
                                Object i$ = this.threadSemaphore;
                                synchronized (i$) {
                                    this.threadSemaphore.wait(this.executor.getLockMillis());
                                }
                            }
                            this.executor.getCommandService().execute(new RemoveOverdueEvents());
                            if (!this.isActive() || (waitPeriod = this.getWaitPeriod()) <= 0L) continue block19;
                            Object object = this.semaphore;
                            synchronized (object) {
                                if (!this.refresh) {
                                    if (LOG.isLoggable(Level.FINE)) {
                                        LOG.fine(this.getName() + " will wait for max " + waitPeriod + "ms on " + this.executor);
                                    }
                                    this.semaphore.wait(waitPeriod);
                                    if (LOG.isLoggable(Level.INFO)) {
                                        LOG.info(this.getName() + " woke up, refresh=" + this.refresh);
                                    }
                                } else if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("skipped wait because new message arrived");
                                }
                                continue block19;
                            }
                        }
                        catch (InterruptedException e) {
                            LOG.info((this.isActive() ? "active" : "inactive") + " event dispatcher thread '" + this.getName() + "' got interrupted");
                        }
                        catch (Exception e) {
                            block31: {
                                if (LOG.isLoggable(Level.SEVERE)) {
                                    LOG.severe("exception in event executor thread. waiting " + this.currentIdleInterval + " milliseconds: " + e.getMessage());
                                    e.printStackTrace();
                                }
                                try {
                                    Object waitPeriod = this.semaphore;
                                    synchronized (waitPeriod) {
                                        this.semaphore.wait(this.currentIdleInterval);
                                    }
                                }
                                catch (InterruptedException e2) {
                                    if (!LOG.isLoggable(Level.FINE)) break block31;
                                    LOG.fine("delay after exception got interrupted: " + e2);
                                }
                            }
                            this.currentIdleInterval *= 2;
                        }
                    }
                    break block32;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    break block32;
                }
            }
            finally {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info(this.getName() + " leaves cyberspace");
                }
            }
        }
    }

    protected Long getNextDueDate() {
        Command<Long> getNextDueDate = this.executor.getNextDueDateCommand();
        return this.executor.getCommandService().execute(getNextDueDate);
    }

    protected long getWaitPeriod() {
        long interval = this.executor.getIdleMillis();
        Long nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTimeMillis = System.currentTimeMillis();
            if (nextDueDate < currentTimeMillis + (long)this.currentIdleInterval) {
                interval = nextDueDate - currentTimeMillis;
            }
        }
        if (interval <= (long)this.minimumInterval) {
            interval = this.minimumInterval;
        }
        return interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("notifying Event executor dispatcher thread of new Event");
        }
        Object object = this.semaphore;
        synchronized (object) {
            this.refresh = true;
            this.semaphore.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThreadFinished() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("notifying Event executor dispatcher thread of new Event");
        }
        Object object = this.threadSemaphore;
        synchronized (object) {
            this.threadSemaphore.notify();
        }
    }

    public void deactivate(boolean join) {
        if (this.isActive()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("deactivating " + this.getName());
            }
            this.setIsActive(false);
            this.interrupt();
            if (join) {
                try {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("joining " + this.getName());
                    }
                    this.join(60000L);
                }
                catch (InterruptedException e) {
                    LOG.severe("joining " + this.getName() + " got interrupted");
                }
            }
        } else if (LOG.isLoggable(Level.INFO)) {
            LOG.info("ignoring deactivate: " + this.getName() + " is not active");
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Event dispatcher thread: " + this.getName() + " deactivated");
        }
    }

    private synchronized void setIsActive(boolean value) {
        this.isActive = false;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }
}

