/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Set;
import java.util.logging.Logger;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.ExecuteEventsCouplesCommand;
import org.ow2.bonita.util.Misc;

public class EventExecutorThread
implements Runnable {
    private static final Logger LOG = Logger.getLogger(EventExecutorThread.class.getName());
    private EventExecutor eventExecutor;
    private final Set<EventCoupleId> eventCouples;

    public EventExecutorThread(EventExecutor eventExecutor, Set<EventCoupleId> eventCouples) {
        this.eventExecutor = eventExecutor;
        this.eventCouples = eventCouples;
    }

    @Override
    public void run() {
        if (this.eventCouples != null && !this.eventCouples.isEmpty()) {
            for (EventCoupleId eventCouple : this.eventCouples) {
                try {
                    this.eventExecutor.getCommandService().execute(new ExecuteEventsCouplesCommand(eventCouple, this.eventExecutor));
                }
                catch (Throwable e) {
                    LOG.severe("exception in event block: " + Misc.getStackTraceFrom(e));
                }
            }
        }
        this.eventExecutor.notifyThreadFinished();
    }

    public String toString() {
        StringBuilder stb = new StringBuilder(EventExecutorThread.class.getSimpleName());
        if (this.eventCouples != null && !this.eventCouples.isEmpty()) {
            stb.append(this.eventCouples);
        }
        return stb.toString();
    }
}

