/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.Transaction;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.VariableNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventCoupleExceptionHandler;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.EventInstance;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.InstantiateProcessCommand;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.DocumentService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.ProcessUtil;

public class ExecuteEventsCouplesCommand
implements Command<Void> {
    private static final Logger LOG = Logger.getLogger(ExecuteEventsCouplesCommand.class.getName());
    private static final long serialVersionUID = -479276850307735480L;
    private EventCoupleId eventCouple;
    private EventExecutor eventExecutor;

    public ExecuteEventsCouplesCommand(EventCoupleId eventCouple, EventExecutor eventExecutor) {
        this.eventCouple = eventCouple;
        this.eventExecutor = eventExecutor;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        OutgoingEventInstance outgoing = null;
        EventInstance incoming = null;
        try {
            EventService eventService = EnvTool.getEventService();
            outgoing = eventService.getOutgoingEvent(this.eventCouple.getOutgoing());
            incoming = eventService.getIncomingEvent(this.eventCouple.getIncoming());
            if (incoming != null && outgoing != null) {
                if (((IncomingEventInstance)incoming).isPermanent() || ((IncomingEventInstance)incoming).getSignal().contains("event.start.")) {
                    this.executeStartEvent((IncomingEventInstance)incoming, outgoing);
                } else {
                    String signal = ((IncomingEventInstance)incoming).getSignal();
                    if (signal.startsWith("event.boundary.")) {
                        this.executeBoundaryEvent((IncomingEventInstance)incoming, outgoing);
                    } else {
                        this.executeEventCouple((IncomingEventInstance)incoming, outgoing);
                    }
                }
            }
        }
        catch (Throwable exception) {
            ActivityInstanceUUID activityUUID = incoming.getActivityUUID();
            if (((IncomingEventInstance)incoming).getRetries() == 1 && activityUUID != null) {
                InternalActivityInstance activityInstance = EnvTool.getJournal().getActivityInstance(activityUUID);
                Recorder recorder = EnvTool.getRecorder();
                recorder.recordActivityFailed(activityInstance);
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.severe("The activity \"" + activityUUID + "\" is in the state FAILED because an exception caught while executing eventCouple: " + exception + ". Exception: " + exception.getMessage());
                }
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Exception caught while executing eventCouple: " + exception + ". Exception: " + exception.getMessage());
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("handling events, incoming: " + incoming + ", outgoing: " + outgoing + " exception: " + exception.getMessage());
            }
            this.handleException(environment, this.eventCouple, exception);
        }
        return null;
    }

    private void executeBoundaryEvent(IncomingEventInstance incoming, OutgoingEventInstance outgoing) throws ActivityNotFoundException {
        String signal = incoming.getSignal();
        Map<Object, Object> parameters = new HashMap();
        if ("event.boundary.message".equals(signal)) {
            parameters = outgoing.getParameters();
        }
        if ("event.boundary.error".equals(signal)) {
            String incomingEventName = incoming.getName();
            int separator = incomingEventName.indexOf("@3^3NT5@");
            String eventName = incomingEventName.substring(0, separator);
            parameters.put("eventName", eventName);
        } else if ("event.boundary.signal".equals(signal)) {
            parameters.put("eventName", incoming.getActivityName());
        } else {
            parameters.put("eventName", incoming.getName());
        }
        EventService eventService = EnvTool.getEventService();
        eventService.removeEvent(outgoing);
        eventService.removeEvent(incoming);
        Authentication.setUserId("SYSTEM");
        Querier journal = EnvTool.getJournalQueriers();
        Execution execution = journal.getExecutionWithEventUUID(incoming.getExecutionUUID());
        if (execution == null) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("No active execution found for uuid: " + incoming.getExecutionUUID());
            }
            throw new BonitaRuntimeException("No active execution found with uuid: " + incoming.getExecutionUUID());
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Execution found for uuid: " + incoming.getExecutionUUID());
        }
        if (!execution.isActive()) {
            execution.unlock();
        }
        execution.signal(signal, parameters);
    }

    private void executeStartEvent(IncomingEventInstance incoming, OutgoingEventInstance outgoing) throws ProcessNotFoundException, GroovyException, InterruptedException, InstanceNotFoundException, VariableNotFoundException {
        EventService eventService = EnvTool.getEventService();
        InternalActivityDefinition activity = EnvTool.getJournal().getActivity(incoming.getActivityDefinitionUUID());
        ProcessDefinitionUUID processUUID = activity.getProcessDefinitionUUID();
        Authentication.setUserId("SYSTEM");
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
        ProcessInstanceUUID eventSubProcessRootInstanceUUID = incoming.getEventSubProcessRootInstanceUUID();
        if (eventSubProcessRootInstanceUUID != null) {
            block16: {
                Querier journal = EnvTool.getJournalQueriers();
                Set<Execution> executions = journal.getExecutions(eventSubProcessRootInstanceUUID);
                try {
                    Execution current = executions.iterator().next();
                    current.abort();
                    Recorder recorder = EnvTool.getRecorder();
                    recorder.recordInstanceAborted(eventSubProcessRootInstanceUUID, EnvTool.getUserId());
                }
                catch (BonitaRuntimeException e) {
                    if (!LOG.isLoggable(Level.WARNING)) break block16;
                    LOG.log(Level.WARNING, "The process: " + eventSubProcessRootInstanceUUID + " has already been aborted by another start event.", e);
                }
            }
            QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI();
            Map<String, Object> variables = queryRuntimeAPI.getProcessInstanceVariables(eventSubProcessRootInstanceUUID);
            InternalProcessInstance eventSubProcessInstance = this.instantiateEventSubProcess(processUUID, variables, eventSubProcessRootInstanceUUID);
            ProcessInstanceUUID instanceUUID = eventSubProcessInstance.getUUID();
            InternalProcessInstance processInstance = EnvTool.getAllQueriers().getProcessInstance(eventSubProcessRootInstanceUUID);
            if (processInstance.getNbOfAttachments() > 0) {
                DocumentationManager manager = EnvTool.getDocumentationManager();
                List<Document> lastAttachments = DocumentService.getAllDocumentVersions(manager, eventSubProcessRootInstanceUUID);
                for (Document document : lastAttachments) {
                    try {
                        manager.attachDocumentTo(processUUID, instanceUUID, document.getId());
                    }
                    catch (DocumentNotFoundException e) {
                        new BonitaRuntimeException(e);
                    }
                }
                eventSubProcessInstance.setNbOfAttachments(processInstance.getNbOfAttachments());
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("An event started a new process instance of " + processUUID);
            }
            if ("event.start.message".equals(incoming.getSignal())) {
                outgoing.setLockOwner(instanceUUID.toString());
                incoming.setLockOwner(null);
                incoming.unlock();
                IncomingEventInstance newIncoming = eventService.getIncomingEvent(instanceUUID, incoming.getName());
                this.executeEventCouple(newIncoming, outgoing);
            } else {
                eventService.removeEvent(outgoing);
                eventService.removeEvent(incoming);
            }
        } else {
            String signalType = incoming.getSignal();
            if ("event.start.timer".equals(signalType)) {
                this.executeStartTimerEvent(incoming, outgoing, eventService, processUUID);
            } else {
                ActivityDefinitionUUID activityUUID = incoming.getActivityDefinitionUUID();
                ProcessInstanceUUID instanceUUID = runtimeAPI.instantiateProcess(processUUID, activityUUID);
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("An event started a new process instance of " + processUUID);
                }
                if ("event.start.signal".equals(signalType)) {
                    eventService.removeEvent(outgoing);
                    incoming.unlock();
                } else {
                    outgoing.setLockOwner(instanceUUID.toString());
                    incoming.setLockOwner(null);
                    incoming.unlock();
                    IncomingEventInstance newIncoming = eventService.getIncomingEvent(instanceUUID, incoming.getName());
                    this.executeEventCouple(newIncoming, outgoing);
                }
            }
        }
    }

    private InternalProcessInstance instantiateEventSubProcess(ProcessDefinitionUUID processUUID, Map<String, Object> variables, ProcessInstanceUUID rootEventSubProcessInstanceUUID) throws ProcessNotFoundException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting a new instance of process : " + processUUID);
        }
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessInstance rootInstance = journal.getProcessInstance(rootEventSubProcessInstanceUUID);
        Execution rootExecution = ProcessUtil.createProcessInstance(processUUID, variables, null, rootEventSubProcessInstanceUUID, rootInstance.getRootInstanceUUID(), null, null);
        InternalProcessInstance instance = rootExecution.getInstance();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Started: " + instance);
        }
        instance.begin(null);
        return instance;
    }

    private void executeStartTimerEvent(IncomingEventInstance incoming, OutgoingEventInstance outgoing, EventService eventService, ProcessDefinitionUUID processUUID) throws GroovyException, InterruptedException {
        block5: {
            try {
                ActivityDefinitionUUID activityUUID = incoming.getActivityDefinitionUUID();
                StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
                accessor.getCommandAPI().execute(new InstantiateProcessCommand(processUUID, activityUUID));
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "The start timer event of process " + processUUID + " cannot start a new instance.", e);
            }
        }
        String condition = incoming.getExpression();
        long lastExecution = incoming.getEnableTime();
        Date nextTime = ProcessUtil.getTimerDate(condition, processUUID, lastExecution);
        if (incoming.getEnableTime() == nextTime.getTime()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("A start timer event of process " + incoming.getProcessName() + " ends its cycle.");
            }
            eventService.removeEvent(outgoing);
            eventService.removeEvent(incoming);
        } else {
            incoming.setEnableTime(nextTime.getTime());
            incoming.unlock();
            outgoing.unlock();
        }
    }

    private void executeEventCouple(IncomingEventInstance incoming, OutgoingEventInstance outgoing) {
        Querier journal = EnvTool.getJournalQueriers();
        Execution execution = journal.getExecutionWithEventUUID(incoming.executionUUID);
        if (execution == null) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("No active execution found for uuid: " + incoming.getExecutionUUID());
            }
            throw new BonitaRuntimeException("No active execution found for uuid: " + incoming.getExecutionUUID());
        }
        String signal = incoming.getSignal();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Execution found for uuid: " + incoming.getExecutionUUID());
        }
        Map<String, Object> parameters = outgoing.getParameters();
        if (incoming.isExecutionLocked() && !"active".equals(execution.getState())) {
            execution.unlock();
        }
        EventService eventService = EnvTool.getEventService();
        eventService.removeEvent(outgoing);
        eventService.removeEvent(incoming);
        execution.signal(signal, parameters);
    }

    protected void handleException(Environment environment, EventCoupleId eventCouple, Throwable exception) {
        Transaction transaction = environment.get(Transaction.class);
        EventCoupleExceptionHandler handler = new EventCoupleExceptionHandler(eventCouple, exception, this.eventExecutor.getCommandService());
        transaction.registerSynchronization(handler);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new BonitaRuntimeException("Execution of event couple (" + eventCouple + ") failed: " + exception.getMessage(), exception);
    }
}

