/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventCouple;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyUtil;

public class GetEventsCouplesCommand
implements Command<Map<ProcessInstanceUUID, Set<EventCoupleId>>> {
    private static final long serialVersionUID = -479276850307735480L;
    static final Logger LOG = Logger.getLogger(GetEventsCouplesCommand.class.getName());

    @Override
    public Map<ProcessInstanceUUID, Set<EventCoupleId>> execute(Environment environment) throws Exception {
        EventService eventService = EnvTool.getEventService();
        Set<EventCouple> eventCouples = eventService.getEventsCouples();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Found eventCouples in DB " + eventCouples);
        }
        if (eventCouples != null && !eventCouples.isEmpty()) {
            HashMap<ProcessInstanceUUID, Set<EventCouple>> validCouples = new HashMap<ProcessInstanceUUID, Set<EventCouple>>();
            HashSet<Long> usedIncomings = new HashSet<Long>();
            HashSet<Long> usedOutgoings = new HashSet<Long>();
            for (EventCouple eventCouple : eventCouples) {
                if (usedIncomings.contains(eventCouple.getIncoming().getId()) || usedOutgoings.contains(eventCouple.getOutgoing().getId())) continue;
                boolean match = true;
                IncomingEventInstance incoming = eventCouple.getIncoming();
                OutgoingEventInstance outgoing = eventCouple.getOutgoing();
                String expression = incoming.getExpression();
                Map<String, Object> parameters = outgoing.getParameters();
                String signal = incoming.getSignal();
                if (expression != null && !"event.start.timer".equals(signal)) {
                    String groovyExpression = "${" + expression + "}";
                    ActivityInstanceUUID activityUUID = incoming.getActivityUUID();
                    match = activityUUID != null ? ((Boolean)GroovyUtil.evaluate(groovyExpression, parameters, activityUUID, false, false)).booleanValue() : ((Boolean)GroovyUtil.evaluate(groovyExpression, parameters)).booleanValue();
                }
                if (match) {
                    usedIncomings.add(incoming.getId());
                    usedOutgoings.add(outgoing.getId());
                    this.addElement(validCouples, incoming.getInstanceUUID(), eventCouple);
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    LOG.info("Adding eventCouple:[incoming=" + incoming.getId() + " " + incoming.getSignal() + ", outgoing=" + outgoing.getId() + "] to the queue");
                    continue;
                }
                incoming.addIncompatibleEvent(outgoing.getId());
            }
            if (validCouples.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<ProcessInstanceUUID, Set<EventCoupleId>> result = new HashMap<ProcessInstanceUUID, Set<EventCoupleId>>();
            for (ProcessInstanceUUID processInstance : validCouples.keySet()) {
                HashSet<EventCoupleId> instanceResult = new HashSet<EventCoupleId>();
                for (EventCouple eventCouple : (Set)validCouples.get(processInstance)) {
                    IncomingEventInstance incoming = eventCouple.getIncoming();
                    OutgoingEventInstance outgoing = eventCouple.getOutgoing();
                    incoming.lock();
                    outgoing.lock();
                    instanceResult.add(new EventCoupleId(incoming.getId(), outgoing.getId()));
                }
                result.put(processInstance, instanceResult);
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("New event couples to execute: " + ((Object)result).toString());
            }
            return result;
        }
        return null;
    }

    private void addElement(Map<ProcessInstanceUUID, Set<EventCouple>> validCouples, ProcessInstanceUUID instanceUUID, EventCouple eventCouple) {
        if (validCouples.get(instanceUUID) == null) {
            validCouples.put(instanceUUID, new HashSet());
        }
        validCouples.get(instanceUUID).add(eventCouple);
    }
}

