/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventInstance;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.VariableUtil;

public class OutgoingEventInstance
extends EventInstance {
    private static final long serialVersionUID = -799578376710809099L;
    protected Map<String, Variable> parameters;
    protected long overdue;

    public OutgoingEventInstance() {
    }

    public OutgoingEventInstance(String name, String processName, String activityName, Map<String, Object> parameters, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID, long overdue) {
        super(name, processName, activityName, instanceUUID, activityUUID);
        if (parameters != null) {
            this.parameters = new HashMap<String, Variable>();
            InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                String key = parameter.getKey();
                Object value = parameter.getValue();
                this.parameters.put(key, VariableUtil.createVariable(instance.getProcessDefinitionUUID(), key, value));
            }
        }
        this.overdue = overdue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activityName == null ? 0 : this.activityName.hashCode());
        result = 31 * result + (this.activityUUID == null ? 0 : this.activityUUID.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.instanceUUID == null ? 0 : this.instanceUUID.hashCode());
        result = 31 * result + (this.lockOwner == null ? 0 : this.lockOwner.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.overdue ^ this.overdue >>> 32);
        result = 31 * result + (this.processName == null ? 0 : this.processName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutgoingEventInstance other = (OutgoingEventInstance)obj;
        if (this.activityName == null ? other.activityName != null : !this.activityName.equals(other.activityName)) {
            return false;
        }
        if (this.activityUUID == null ? other.activityUUID != null : !this.activityUUID.equals(other.activityUUID)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.instanceUUID == null ? other.instanceUUID != null : !this.instanceUUID.equals(other.instanceUUID)) {
            return false;
        }
        if (this.lockOwner == null ? other.lockOwner != null : !this.lockOwner.equals(other.lockOwner)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.overdue != other.overdue) {
            return false;
        }
        return !(this.processName == null ? other.processName != null : !this.processName.equals(other.processName));
    }

    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Variable> entry : this.parameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return result;
    }

    public long getOverdue() {
        return this.overdue;
    }

    public String toString() {
        return "OutgoingEventInstance [activityName=" + this.activityName + ", activityUUID=" + this.activityUUID + ", id=" + this.id + ", instanceUUID=" + this.instanceUUID + ", lockOwner=" + this.lockOwner + ", name=" + this.name + ", overdue=" + this.overdue + ", parameters=" + this.parameters + ", processName=" + this.processName + "]";
    }
}

