/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.model;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.ExternalActivity;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;

public class ExecuteNode {
    static final Logger LOG = Logger.getLogger(ExecuteNode.class.getName());

    public void perform(Execution execution) {
        this.perform(execution, true);
    }

    public void perform(Execution execution, boolean checkJoinType) {
        InternalActivityDefinition node = execution.getNode();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(execution.toString() + " executes " + node);
        }
        ExternalActivity activity = node.getBehaviour();
        try {
            execution.setPropagation(Execution.Propagation.UNSPECIFIED);
            activity.execute(execution, checkJoinType);
        }
        catch (Throwable e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Activity will be put in the state FAILED due to: " + e);
            }
            Recorder recorder = EnvTool.getRecorder();
            Collection<Execution> executions = execution.getExecutions();
            if (executions != null && !executions.isEmpty()) {
                for (Execution nextExecution : executions) {
                    InternalActivityInstance activityInstance = nextExecution.getActivityInstance();
                    if (activityInstance != null) {
                        recorder.recordActivityFailed(activityInstance);
                        continue;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    String message = ExceptionManager.getInstance().getFullMessage("bp_EHI_5", e + ": " + e.getMessage(), e.getMessage());
                    throw new BonitaRuntimeException(message, e);
                }
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            String message = ExceptionManager.getInstance().getFullMessage("bp_EHI_5", e + ": " + e.getMessage(), e.getMessage());
            throw new BonitaRuntimeException(message, e);
        }
        if (execution.getPropagation() == Execution.Propagation.UNSPECIFIED) {
            execution.proceed();
        }
    }

    public String toString() {
        return "execute(node)";
    }
}

