/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.definition.activity.ExternalActivity;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.runtime.model.ExecuteNode;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.EqualsUtil;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.ProcessUtil;
import org.ow2.bonita.util.TransientData;

public class Execution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Execution.class.getName());
    public static final String INITIAL_ITERATION_ID = "it1";
    protected long id;
    protected int dbversion;
    protected String activityInstanceId = "mainActivityInstance";
    protected String iterationId;
    protected int waitingForActivityInstanceNb;
    protected int activityInstanceNb;
    protected InternalProcessInstance instance;
    protected InternalActivityInstance activityInstance;
    protected String name;
    protected String state;
    protected String eventUUID;
    protected Propagation propagation = null;
    protected InternalProcessDefinition processDefinition;
    protected InternalActivityDefinition node;
    protected Collection<Execution> executions;
    protected Execution parent;
    protected Queue<ExecuteNode> atomicOperations;
    public static final String STATE_CREATED = "created";
    public static final String STATE_ACTIVE = "active";
    public static final String STATE_INACTIVE = "inactive";
    public static final String STATE_ENDED = "ended";
    public static final String STATE_CANCELLED = "cancelled";
    public static final String STATE_ASYNC = "async";

    protected Execution() {
    }

    public Execution(String name, InternalProcessDefinition processDefinition, InternalProcessInstance processInstance, InternalActivityDefinition activity, String state, String iterationId) {
        this.processDefinition = processDefinition;
        this.instance = processInstance;
        this.name = name;
        this.state = state;
        this.node = activity;
        this.iterationId = iterationId;
    }

    public void beginWithOneStartNode() {
        this.setIterationId(INITIAL_ITERATION_ID);
        if (!STATE_CREATED.equals(this.state)) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_EI_1 ", this.toString(), this.state);
            throw new BonitaRuntimeException(message);
        }
        this.state = STATE_ACTIVE;
        if (this.node != null) {
            this.performAtomicOperation(new ExecuteNode());
        }
    }

    public void beginWithManyStartNodes(ActivityDefinitionUUID activityUUID) {
        this.beginWithOneStartNode();
        for (InternalActivityDefinition activity : this.getProcessDefinition().getInternalInitialActivities().values()) {
            if ((activityUUID != null || activity.isReceiveEvent()) && (activityUUID == null || !activity.getUUID().equals(activityUUID))) continue;
            Execution child = this.createChildExecution(activity.getName());
            child.execute(activity);
        }
    }

    public Execution createChildExecution(String name) {
        if (this.isActive()) {
            this.lock(STATE_INACTIVE);
            this.propagation = Propagation.EXPLICIT;
        }
        Execution child = new Execution(name, this.getProcessDefinition(), this.getInstance(), this.getNode(), STATE_ACTIVE, this.getIterationId());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("creating " + child);
        }
        child.setPropagation(this.getPropagation());
        this.addExecution(child);
        return child;
    }

    public Execution backToParent() {
        if (this.parent == null) {
            return this;
        }
        this.getParent().setNode(this.getNode());
        this.getParent().setPropagation(this.getPropagation());
        this.end();
        this.parent.removeExecution(this);
        return this.parent;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("execution, name=").append(this.getName()).append(", parent= ").append(this.getParent()).append(", instance= ").append(this.getInstance()).append(", activityInstanceUUID= ").append(this.getActivityInstanceUUID());
        return builder.toString();
    }

    public void end() {
        this.end(STATE_ENDED);
    }

    public void end(String state) {
        if (state == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_EI_2", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        if (state.equals(STATE_ACTIVE) || state.equals(STATE_CREATED) || state.equals(STATE_INACTIVE) || state.equals(STATE_ASYNC)) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_EI_3", state);
            throw new BonitaRuntimeException(message);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.toString() + " ends with state " + state);
        }
        if (this.executions != null) {
            for (Execution child : this.executions) {
                child.end(state);
            }
        }
        this.lock(state);
        this.propagation = Propagation.EXPLICIT;
    }

    public void cancel() {
        if (this.getExecutions() != null) {
            for (Execution child : new ArrayList<Execution>(this.getExecutions())) {
                child.cancel();
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this + " cancelled.");
        }
        if (this.getActivityInstanceUUID() != null) {
            boolean isSubflow = this.getNode().isSubflow();
            if (isSubflow) {
                Querier journal = EnvTool.getJournalQueriers();
                InternalProcessInstance childInstance = journal.getProcessInstance(this.getActivityInstance().getSubflowProcessInstanceUUID());
                childInstance.cancel();
            }
            EnvTool.getRecorder().recordBodyCancelled(this.getActivityInstance());
            TransientData.removeTransientData(this.getActivityInstanceUUID());
        }
        if (!STATE_ACTIVE.equals(this.state)) {
            this.unlock();
        }
        this.end(STATE_CANCELLED);
        Execution parent = this.getParent();
        if (parent != null) {
            parent.removeExecution(this);
        }
    }

    public void abort() {
        if (this.getExecutions() != null) {
            for (Execution child : new ArrayList<Execution>(this.getExecutions())) {
                child.abort();
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this + " aborted.");
        }
        ConnectorExecutor.executeConnectors(this, HookDefinition.Event.instanceOnAbort);
        if (this.getActivityInstanceUUID() != null) {
            boolean isSubflow = this.getNode().isSubflow();
            if (isSubflow && this.getActivityInstance().getSubflowProcessInstanceUUID() != null) {
                Querier journal = EnvTool.getJournalQueriers();
                InternalProcessInstance childInstance = journal.getProcessInstance(this.getActivityInstance().getSubflowProcessInstanceUUID());
                childInstance.getRootExecution().abort();
                Recorder recorder = EnvTool.getRecorder();
                recorder.recordInstanceAborted(childInstance.getUUID(), EnvTool.getUserId());
                ProcessUtil.removeInternalInstanceEvents(this.instance.getUUID());
            }
            EnvTool.getRecorder().recordBodyAborted(this.getActivityInstance());
            TransientData.removeTransientData(this.getActivityInstanceUUID());
        }
        this.end(STATE_CANCELLED);
        Execution parent = this.getParent();
        if (parent != null) {
            parent.removeExecution(this);
        }
    }

    public void signal(String signal, Map<String, Object> parameters) {
        this.checkLock();
        if (this.node != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.toString() + " signals " + this.node);
            }
            ExternalActivity externalActivity = this.node.getBehaviour();
            try {
                this.setPropagation(Propagation.UNSPECIFIED);
                externalActivity.signal(this, signal, parameters);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_S_1", this.node, e.getMessage());
                throw new BonitaRuntimeException(message, e);
            }
            if (this.getPropagation() == Propagation.UNSPECIFIED) {
                this.proceed();
            }
        } else {
            String message = ExceptionManager.getInstance().getFullMessage("bp_EI_6", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
    }

    public void take(TransitionDefinition transition) {
        this.instance.setTransitionState(transition.getName(), InternalProcessInstance.TransitionState.TAKEN);
        this.checkLock();
        this.setPropagation(Propagation.EXPLICIT);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.toString() + " takes " + transition);
        }
        this.setNode(this.getProcessDefinition().getActivity(transition.getTo()));
        this.performAtomicOperation(new ExecuteNode());
    }

    public void execute(InternalActivityDefinition node) {
        if (node == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_EI_12", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        this.checkLock();
        this.propagation = Propagation.EXPLICIT;
        this.node = node;
        this.performAtomicOperation(new ExecuteNode());
    }

    public void waitForSignal() {
        this.propagation = Propagation.WAIT;
    }

    public void proceed() {
        this.checkLock();
        TransitionDefinition defaultTransition = Execution.getDefaultTransition(this.node);
        if (defaultTransition != null) {
            this.take(defaultTransition);
        } else {
            this.end();
        }
    }

    public void move(InternalActivityDefinition destination, Execution execution) {
        execution.move(destination);
    }

    public void move(InternalActivityDefinition destination) {
        this.checkLock();
        this.setNode(destination);
    }

    public void lock(String state) {
        if (state == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_EI_22", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        this.checkLock();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("locking " + this);
        }
        this.state = state;
    }

    public void unlock() {
        if (STATE_ACTIVE.equals(this.state)) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_EI_23", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("unlocking " + this);
        }
        this.state = STATE_ACTIVE;
    }

    protected void checkLock() {
        if (!STATE_ACTIVE.equals(this.state)) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_EI_24", this.toString(), this.state);
            throw new BonitaRuntimeException(message);
        }
    }

    public void performAtomicOperation(ExecuteNode operation) {
        this.performAtomicOperation(operation, true);
    }

    public void performAtomicOperation(ExecuteNode operation, boolean checkJoinType) {
        if (this.atomicOperations == null) {
            this.atomicOperations = new LinkedList<ExecuteNode>();
            this.atomicOperations.offer(operation);
            try {
                while (!this.atomicOperations.isEmpty()) {
                    ExecuteNode atomicOperation = this.atomicOperations.poll();
                    atomicOperation.perform(this, checkJoinType);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            finally {
                this.atomicOperations = null;
            }
        } else {
            this.atomicOperations.offer(operation);
        }
    }

    public boolean isActive() {
        return STATE_ACTIVE.equals(this.state);
    }

    public boolean isFinished() {
        return STATE_ENDED.equals(this.state) || STATE_CANCELLED.equals(this.state);
    }

    public String getState() {
        return this.state;
    }

    public InternalProcessInstance getInstance() {
        return this.instance;
    }

    public void setInstance(InternalProcessInstance instance) {
        this.instance = instance;
    }

    public String getIterationId() {
        return this.iterationId;
    }

    public void setIterationId(String iterationId) {
        this.iterationId = iterationId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public int getWaitingForActivityInstanceNb() {
        return this.waitingForActivityInstanceNb;
    }

    public void setWaitingForActivityInstanceNb(int waitingFor) {
        this.waitingForActivityInstanceNb = waitingFor;
    }

    public int getActivityInstanceNb() {
        return this.activityInstanceNb;
    }

    public void setActivityInstanceNb(int activityInstanceNb) {
        this.activityInstanceNb = activityInstanceNb;
    }

    public ActivityInstanceUUID getActivityInstanceUUID() {
        if (this.activityInstance == null) {
            return null;
        }
        return this.activityInstance.getUUID();
    }

    public InternalActivityInstance getActivityInstance() {
        return this.activityInstance;
    }

    public void setActivityInstance(InternalActivityInstance activityInstance) {
        this.activityInstance = activityInstance;
    }

    public void addExecution(Execution execution) {
        execution.parent = this;
        if (this.executions == null) {
            this.executions = new ArrayList<Execution>();
        }
        this.executions.add(execution);
    }

    public Execution getExecution(String name) {
        for (Execution exec : this.getExecutions()) {
            if (!exec.getName().equals(name)) continue;
            return exec;
        }
        return null;
    }

    public void removeExecution(Execution child) {
        if (this.executions != null) {
            if (this.executions.remove(child)) {
                if (this.state.equals(STATE_INACTIVE) && this.executions.isEmpty()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("last child execution was removed; unlocking");
                    }
                    this.state = STATE_ACTIVE;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("removed " + child + " from " + this);
                }
            } else {
                String message = ExceptionManager.getInstance().getFullMessage("bp_EI_29", child, this);
                throw new BonitaRuntimeException(message);
            }
        }
    }

    public String getNodeName() {
        if (this.node == null) {
            return null;
        }
        return this.node.getName();
    }

    protected TransitionDefinition findTransition(String transitionName) {
        return this.node.getOutgoingTransition(transitionName);
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public Collection<Execution> getExecutions() {
        if (this.executions == null) {
            return Collections.emptySet();
        }
        return this.executions;
    }

    public String getName() {
        return this.name;
    }

    public Execution getParent() {
        return this.parent;
    }

    public Propagation getPropagation() {
        return this.propagation;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setState(String state) {
        this.state = state;
    }

    public InternalActivityDefinition getNode() {
        return this.node;
    }

    private void setNode(InternalActivityDefinition node) {
        this.node = node;
    }

    public long getId() {
        return this.id;
    }

    public InternalProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    private static TransitionDefinition getDefaultTransition(InternalActivityDefinition activity) {
        if (activity.hasOutgoingTransitions()) {
            return activity.getOutgoingTransitions().iterator().next();
        }
        return null;
    }

    public String getEventUUID() {
        return this.eventUUID;
    }

    public void setEventUUID(String eventUUID) {
        this.eventUUID = eventUUID;
    }

    public static enum Propagation {
        UNSPECIFIED,
        WAIT,
        EXPLICIT;

    }
}

