/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.search;

import java.io.Serializable;
import org.ow2.bonita.search.QueryFormatter;
import org.ow2.bonita.search.SearchQueryBuilder;

public class Criterion
implements Serializable {
    private static final long serialVersionUID = 3605699586653944501L;
    private SearchQueryBuilder builder;
    private String fieldName;
    private String value;

    public Criterion(String fieldName, SearchQueryBuilder builder) {
        this.fieldName = fieldName;
        this.builder = builder;
    }

    public Criterion(SearchQueryBuilder builder) {
        this.builder = builder;
    }

    public Criterion startsWith(String value) {
        this.value = QueryFormatter.startsWith(value);
        return this;
    }

    public Criterion equalsTo(String value) {
        this.value = QueryFormatter.equals(value);
        return this;
    }

    public Criterion ranges(String from, String to, boolean exclusive) {
        this.value = QueryFormatter.ranges(from, to, exclusive);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.fieldName != null && !"".equals(this.fieldName.trim())) {
            builder.append(this.fieldName).append(":");
        }
        builder.append(this.value);
        return builder.toString();
    }

    public SearchQueryBuilder rightParenthesis() {
        this.builder.rightParenthesis();
        return this.builder;
    }

    public SearchQueryBuilder or() {
        this.builder.or();
        return this.builder;
    }

    public SearchQueryBuilder and() {
        this.builder.and();
        return this.builder;
    }
}

