/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.search;

class QueryFormatter {
    static final String OR = "OR";
    static final String AND = "AND";
    static final String TO = "TO";
    static final String L_PARENTHESIS = "(";
    static final String R_PARENTHESIS = ")";
    static final String L_SQUARE_BRACKET = "[";
    static final String R_SQUARE_BRACKET = "]";
    static final String L_CURLY_BRACKET = "{";
    static final String R_CURLY_BRACKET = "}";
    static final String FIELD_VALUE_SEPARATOR = ":";
    static final String WILDCARD = "*";
    protected static String[] specialCharacters = new String[]{"\\", "+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":"};

    QueryFormatter() {
    }

    protected static String escapeSpecialCharacters(String value) {
        String temp = value;
        for (String specialCharacter : specialCharacters) {
            temp = temp.replace(specialCharacter, "\\" + specialCharacter);
        }
        return temp;
    }

    protected static String field(String fieldName, String value) {
        StringBuilder field = new StringBuilder(fieldName);
        field.append(FIELD_VALUE_SEPARATOR).append(value);
        return field.toString();
    }

    protected static String startsWith(String value) {
        String formattedValue = QueryFormatter.escapeSpecialCharacters(value);
        StringBuilder starts = new StringBuilder(formattedValue);
        starts.append(WILDCARD);
        return starts.toString();
    }

    protected static String equals(String value) {
        String formattedValue = QueryFormatter.escapeSpecialCharacters(value);
        return formattedValue;
    }

    protected static String ranges(String from, String to, boolean exclusive) {
        StringBuilder range = new StringBuilder();
        String left = L_SQUARE_BRACKET;
        String right = R_SQUARE_BRACKET;
        if (exclusive) {
            left = L_CURLY_BRACKET;
            right = R_CURLY_BRACKET;
        }
        String formattedFrom = QueryFormatter.escapeSpecialCharacters(from);
        String formattedTo = QueryFormatter.escapeSpecialCharacters(to);
        range.append(left).append(formattedFrom).append(" ").append(TO).append(" ").append(formattedTo).append(right);
        return range.toString();
    }
}

