/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.search;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ow2.bonita.search.Criteria;
import org.ow2.bonita.search.Criterion;
import org.ow2.bonita.search.index.Index;
import org.ow2.bonita.util.xml.XStreamUtil;

public class SearchQueryBuilder
implements Serializable {
    private static final long serialVersionUID = -3830626827857893077L;
    private Index index;
    private List<Object> query;

    public SearchQueryBuilder(Index index) {
        this.index = index;
        this.query = new ArrayList<Object>();
    }

    public Criterion criterion() {
        Criterion criterion = new Criterion(this);
        this.query.add(criterion);
        return criterion;
    }

    public Criterion criterion(String fieldName) {
        Criterion criterion = new Criterion(fieldName, this);
        this.query.add(criterion);
        return criterion;
    }

    public Criteria criteria(List<String> fieldNames) {
        Criteria criteria = new Criteria(fieldNames, this);
        this.query.add(criteria);
        return criteria;
    }

    public SearchQueryBuilder leftParenthesis() {
        this.query.add("(");
        return this;
    }

    public SearchQueryBuilder rightParenthesis() {
        this.query.add(")");
        return this;
    }

    public SearchQueryBuilder or() {
        this.query.add(" OR ");
        return this;
    }

    public SearchQueryBuilder and() {
        this.query.add(" AND ");
        return this;
    }

    public Index getIndex() {
        return this.index;
    }

    public String getQuery() {
        StringBuilder builder = new StringBuilder();
        for (Object element : this.query) {
            builder.append(element.toString());
        }
        return builder.toString();
    }

    public static SearchQueryBuilder valueOf(String jsonSearchQueryBuilder) {
        XStream xstream = XStreamUtil.getDefaultXstream();
        return (SearchQueryBuilder)xstream.fromXML(jsonSearchQueryBuilder);
    }

    public String toString() {
        XStream xstream = XStreamUtil.getDefaultXstream();
        return xstream.toXML((Object)this);
    }
}

