/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services;

import java.util.Date;
import java.util.List;
import org.ow2.bonita.facade.exception.DocumentAlreadyExistsException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.exception.FolderAlreadyExistsException;
import org.ow2.bonita.facade.impl.SearchResult;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.Folder;

public interface DocumentationManager {
    public Folder createFolder(String var1) throws FolderAlreadyExistsException;

    public Folder createFolder(String var1, String var2) throws FolderAlreadyExistsException;

    public Document createDocument(String var1, ProcessDefinitionUUID var2) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(String var1, ProcessDefinitionUUID var2, ProcessInstanceUUID var3) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(String var1, ProcessDefinitionUUID var2, String var3, String var4, byte[] var5) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(String var1, ProcessDefinitionUUID var2, ProcessInstanceUUID var3, String var4, String var5, byte[] var6) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(String var1, String var2, String var3, String var4, byte[] var5) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(String var1, ProcessDefinitionUUID var2, ProcessInstanceUUID var3, String var4, Date var5) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(String var1, ProcessDefinitionUUID var2, ProcessInstanceUUID var3, String var4, Date var5, String var6, String var7, byte[] var8) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document createDocument(ProcessDefinitionUUID var1, String var2, String var3, String var4, String var5, byte[] var6) throws DocumentationCreationException, DocumentAlreadyExistsException;

    public Document getDocument(String var1) throws DocumentNotFoundException;

    public void deleteDocument(String var1, boolean var2) throws DocumentNotFoundException;

    public void deleteFolder(Folder var1);

    public byte[] getContent(Document var1) throws DocumentNotFoundException;

    public List<Folder> getFolders(String var1);

    public Folder getRootFolder();

    public List<Document> getChildrenDocuments(String var1);

    public List<Document> getChildrenDocuments(ProcessDefinitionUUID var1, String var2) throws DocumentationCreationException;

    public List<Folder> getChildrenFolder(String var1);

    public List<Document> getVersionsOfDocument(String var1) throws DocumentNotFoundException;

    public String getDocumentPath(String var1) throws DocumentNotFoundException;

    public Document createVersion(String var1, boolean var2) throws DocumentationCreationException;

    public Document createVersion(String var1, boolean var2, String var3, Date var4) throws DocumentationCreationException;

    public Document createVersion(String var1, boolean var2, String var3, String var4, byte[] var5) throws DocumentationCreationException;

    public Document createVersion(String var1, boolean var2, String var3, Date var4, String var5, String var6, byte[] var7) throws DocumentationCreationException;

    public SearchResult search(DocumentSearchBuilder var1, int var2, int var3);

    public void clear() throws DocumentNotFoundException;

    public void updateDocumentContent(String var1, String var2, String var3, int var4, byte[] var5) throws DocumentNotFoundException;

    public void attachDocumentTo(ProcessDefinitionUUID var1, String var2) throws DocumentNotFoundException;

    public void attachDocumentTo(ProcessDefinitionUUID var1, ProcessInstanceUUID var2, String var3) throws DocumentNotFoundException;
}

