/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthAwareCookieManager
extends CookieManager {
    private CookiePolicy policyCallback;
    private Map<HttpCookie, List<String>> authMap = new HashMap<HttpCookie, List<String>>();
    private ThreadLocal<List<String>> lastAuth = new ThreadLocal();

    public AuthAwareCookieManager(CookieStore store, CookiePolicy cookiePolicy) {
        super(store, cookiePolicy);
        this.policyCallback = cookiePolicy == null ? CookiePolicy.ACCEPT_ORIGINAL_SERVER : cookiePolicy;
    }

    @Override
    public void setCookiePolicy(CookiePolicy cookiePolicy) {
        if (cookiePolicy != null) {
            this.policyCallback = cookiePolicy;
            super.setCookiePolicy(cookiePolicy);
        }
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        if (uri == null || requestHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        HashMap<String, List<String>> cookieMap = new HashMap<String, List<String>>();
        if (this.getCookieStore() == null) {
            return Collections.unmodifiableMap(cookieMap);
        }
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        List<String> auth = requestHeaders.get("user_for_cookie");
        for (HttpCookie cookie : this.getCookieStore().get(uri)) {
            if (!this.pathMatches(uri.getPath(), cookie.getPath()) || !this.isSameAuth(auth, cookie)) continue;
            cookies.add(cookie);
        }
        this.lastAuth.set(auth);
        List<String> cookieHeader = this.sortByPath(cookies);
        cookieMap.put("Cookie", cookieHeader);
        return Collections.unmodifiableMap(cookieMap);
    }

    private boolean isSameAuth(List<String> list, HttpCookie cookie) {
        List<String> cred = this.authMap.get(cookie);
        return list == null || list != null && ((Object)list).equals(cred);
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        if (uri == null || responseHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (this.getCookieStore() == null) {
            return;
        }
        for (String headerKey : responseHeaders.keySet()) {
            if (headerKey == null || !headerKey.equalsIgnoreCase("Set-Cookie2") && !headerKey.equalsIgnoreCase("Set-Cookie")) continue;
            for (String headerValue : responseHeaders.get(headerKey)) {
                try {
                    List<HttpCookie> cookies = HttpCookie.parse(headerValue);
                    for (HttpCookie cookie : cookies) {
                        if (!this.shouldAcceptInternal(uri, cookie)) continue;
                        this.getCookieStore().add(uri, cookie);
                        this.authMap.put(cookie, this.lastAuth.get());
                        this.lastAuth.set(null);
                    }
                }
                catch (IllegalArgumentException e) {
                }
            }
        }
    }

    private boolean shouldAcceptInternal(URI uri, HttpCookie cookie) {
        try {
            return this.policyCallback.shouldAccept(uri, cookie);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private boolean pathMatches(String path, String pathToMatchWith) {
        if (path == pathToMatchWith) {
            return true;
        }
        if (path == null || pathToMatchWith == null) {
            return false;
        }
        return path.startsWith(pathToMatchWith);
    }

    private List<String> sortByPath(List<HttpCookie> cookies) {
        Collections.sort(cookies, new CookiePathComparator());
        ArrayList<String> cookieHeader = new ArrayList<String>();
        for (HttpCookie cookie : cookies) {
            if (cookies.indexOf(cookie) == 0 && cookie.getVersion() > 0) {
                cookieHeader.add("$Version=\"1\"");
            }
            cookieHeader.add(cookie.toString());
        }
        return cookieHeader;
    }

    static class CookiePathComparator
    implements Comparator<HttpCookie> {
        CookiePathComparator() {
        }

        @Override
        public int compare(HttpCookie c1, HttpCookie c2) {
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            if (!c1.getName().equals(c2.getName())) {
                return 0;
            }
            if (c1.getPath().startsWith(c2.getPath())) {
                return -1;
            }
            if (c2.getPath().startsWith(c1.getPath())) {
                return 1;
            }
            return 0;
        }
    }
}

