/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.CookieHandler;
import java.net.CookiePolicy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.ow2.bonita.facade.exception.DocumentAlreadyExistsException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.exception.FolderAlreadyExistsException;
import org.ow2.bonita.facade.impl.SearchResult;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.search.DocumentCriterion;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.services.CmisUserProvider;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.Folder;
import org.ow2.bonita.services.impl.AuthAwareCookieManager;
import org.ow2.bonita.services.impl.DocumentImpl;
import org.ow2.bonita.services.impl.FolderImpl;
import org.ow2.bonita.services.impl.StandardAuthenticationProviderWithUserInHeaders;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMISDocumentManager
implements DocumentationManager {
    private static ThreadLocal<SimpleDateFormat> CMIS_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            SimpleDateFormat gmtTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
            gmtTime.setTimeZone(TimeZone.getTimeZone("GMT"));
            return gmtTime;
        }
    };
    private final String binding;
    private final String url;
    private final String repositoryId;
    private String rootFolderId;
    private final Map<String, Session> sessionsMap = new HashMap<String, Session>();
    private final Map<ProcessDefinitionUUID, String> processDefinitionMap = new HashMap<ProcessDefinitionUUID, String>();
    private final Map<String, String> subFolderMap = new HashMap<String, String>();
    private final Map<String, String> processInstanceMap = new HashMap<String, String>();
    private final CmisUserProvider userProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(CMISDocumentManager.class);
    private final String pathOfRootFolder;
    private final Comparator<org.apache.chemistry.opencmis.client.api.Folder> comparator = new Comparator<org.apache.chemistry.opencmis.client.api.Folder>(){

        @Override
        public int compare(org.apache.chemistry.opencmis.client.api.Folder o1, org.apache.chemistry.opencmis.client.api.Folder o2) {
            return o2.getCreationDate().compareTo(o1.getCreationDate());
        }
    };

    public CMISDocumentManager(String binding, String url, String repositoryId, CmisUserProvider userProvider) {
        this(binding, url, repositoryId, userProvider, "/");
    }

    public CMISDocumentManager(String binding, String url, String repositoryId, CmisUserProvider userProvider, String pathOfRootFolder) {
        this.binding = binding;
        this.url = url;
        this.repositoryId = repositoryId;
        this.userProvider = userProvider;
        this.pathOfRootFolder = pathOfRootFolder;
        AuthAwareCookieManager cm = new AuthAwareCookieManager(null, CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cm);
    }

    public synchronized Session createSessionById(String repositoryId, String userId2) {
        Session session;
        String userId;
        SessionFactory f = SessionFactoryImpl.newInstance();
        if (userId2 == null) {
            userId = "SYSTEM";
            try {
                userId = EnvTool.getUserId();
            }
            catch (Exception e) {}
        } else {
            userId = userId2;
        }
        if ((session = this.sessionsMap.get(userId)) == null) {
            Map<String, String> parameter = this.fixParameters(this.userProvider.getUser(userId), this.userProvider.getPassword(userId));
            parameter.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId);
            session = f.createSession(parameter);
            if (this.rootFolderId == null) {
                CmisObject rootFolder = session.getObjectByPath(this.pathOfRootFolder);
                this.rootFolderId = rootFolder.getId();
            }
            this.sessionsMap.put(userId, session);
        }
        return session;
    }

    public synchronized Session getSession() {
        return this.createSessionById(this.repositoryId, null);
    }

    public synchronized Session getSession(String userId) {
        return this.createSessionById(this.repositoryId, userId);
    }

    protected Map<String, String> fixParameters(String username, String password) {
        HashMap<String, String> parameter = new HashMap<String, String>();
        if ("ATOM".equals(this.binding)) {
            parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        } else if (this.binding.toLowerCase().startsWith("WebService".toLowerCase())) {
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", this.url + "/ACLService/AccessControlServicePort?wsdl");
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", this.url + "/DiscoveryService/DiscoveryServicePort?wsdl");
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", this.url + "/MultiFilingService/MultiFilingServicePort?wsdl");
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", this.url + "/NavigationService/NavigationServicePort?wsdl");
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", this.url + "/ObjectService/ObjectServicePort?wsdl");
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", this.url + "/PolicyService/PolicyServicePort?wsdl");
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", this.url + "/RelationshipService/RelationshipServicePort?wsdl");
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", this.url + "/RepositoryService/RepositoryServicePort?wsdl");
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", this.url + "/VersioningService/VersioningServicePort?wsdl");
            parameter.put("org.apache.chemistry.opencmis.binding.auth.http.basic", "false");
            parameter.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", "false");
            parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
        }
        parameter.put("org.apache.chemistry.opencmis.binding.atompub.url", this.url);
        parameter.put("org.apache.chemistry.opencmis.user", username);
        parameter.put("org.apache.chemistry.opencmis.password", password);
        parameter.put("org.apache.chemistry.opencmis.cache.objects.size", "0");
        parameter.put("org.apache.chemistry.opencmis.binding.auth.classname", StandardAuthenticationProviderWithUserInHeaders.class.getName());
        return parameter;
    }

    @Override
    public Folder createFolder(String folderName) throws FolderAlreadyExistsException {
        try {
            return this.createFolder(this.getSession(), folderName);
        }
        catch (CmisRuntimeException e) {
            throw new FolderAlreadyExistsException(folderName, e);
        }
    }

    private Folder createFolder(Session session, String folderName) throws FolderAlreadyExistsException {
        try {
            session.getObject(session.createObjectId(this.rootFolderId));
        }
        catch (CmisObjectNotFoundException e) {
            this.rootFolderId = session.getObjectByPath(this.pathOfRootFolder).getId();
        }
        return this.createFolder(session, folderName, this.rootFolderId);
    }

    private Folder createFolder(Session session, String folderName, String parentFolderId) throws FolderAlreadyExistsException {
        org.apache.chemistry.opencmis.client.api.Folder folder;
        try {
            folder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(session.createObjectId(parentFolderId));
        }
        catch (CmisRuntimeException e) {
            throw new FolderAlreadyExistsException(folderName, e);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", folderName);
        properties.put("cmis:objectTypeId", "cmis:folder");
        properties.put("cmis:parentId", parentFolderId);
        ItemIterable children = folder.getChildren();
        for (CmisObject cmisObject : children) {
            if (!folderName.equals(cmisObject.getName())) continue;
            throw new FolderAlreadyExistsException(folderName);
        }
        try {
            org.apache.chemistry.opencmis.client.api.Folder child = folder.createFolder(properties, null, null, null, session.getDefaultContext());
            return this.convertFolder(child);
        }
        catch (CmisRuntimeException e) {
            LOGGER.error("Can't create folder", (Throwable)e);
            throw new FolderAlreadyExistsException(folderName);
        }
    }

    @Override
    public Folder createFolder(String folderName, String parentFolderId) throws FolderAlreadyExistsException {
        return this.createFolder(this.getSession(), folderName, parentFolderId);
    }

    private Document createDocument(Session session, String name, String parentFolderId) throws DocumentationCreationException {
        try {
            org.apache.chemistry.opencmis.client.api.Folder folder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(session.createObjectId(parentFolderId));
            HashMap<String, String> newDocProps = new HashMap<String, String>();
            newDocProps.put("cmis:objectTypeId", "cmis:document");
            newDocProps.put("cmis:name", name);
            for (CmisObject object : folder.getChildren()) {
                if (!name.equals(object.getName())) continue;
                throw new DocumentAlreadyExistsException(object.getId(), name);
            }
            org.apache.chemistry.opencmis.client.api.Document doc = folder.createDocument(newDocProps, null, null, null, null, null, session.getDefaultContext());
            return this.convertDocument(doc);
        }
        catch (CmisBaseException e) {
            LOGGER.error("Can't create a document", (Throwable)e);
            throw new DocumentationCreationException("Can't create a document named: " + name + "\n" + e.getMessage());
        }
    }

    @Override
    public Document getDocument(String documentId) throws DocumentNotFoundException {
        Session session2 = this.getSession();
        try {
            org.apache.chemistry.opencmis.client.api.Document doc = (org.apache.chemistry.opencmis.client.api.Document)session2.getObject(session2.createObjectId(documentId));
            return this.convertDocument(doc);
        }
        catch (CmisObjectNotFoundException e) {
            throw new DocumentNotFoundException(documentId);
        }
    }

    @Override
    public Document createDocument(String name, String parentFolderId, String fileName, String contentMimeType, byte[] fileContent) throws DocumentationCreationException {
        Session session = this.getSession();
        return this.createDocument(session, name, parentFolderId, fileName, contentMimeType, fileContent);
    }

    private Document createDocument(Session session, String name, String parentFolderId, String fileName, String contentMimeType, byte[] fileContent) throws DocumentationCreationException {
        if (contentMimeType != null) {
            try {
                new MimeType(contentMimeType);
            }
            catch (MimeTypeParseException e1) {
                throw new DocumentationCreationException("Mime type not valid", e1);
            }
        }
        try {
            ContentStreamImpl contentStream;
            org.apache.chemistry.opencmis.client.api.Folder folder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(session.createObjectId(parentFolderId));
            for (CmisObject object : folder.getChildren()) {
                if (!name.equals(object.getName())) continue;
                throw new DocumentAlreadyExistsException(object.getId(), name);
            }
            HashMap<String, String> newDocProps = new HashMap<String, String>();
            newDocProps.put("cmis:objectTypeId", "cmis:document");
            newDocProps.put("cmis:name", name);
            newDocProps.put("cmis:contentStreamFileName", fileName);
            BigInteger length = fileContent != null && fileContent.length > 0 ? BigInteger.valueOf(fileContent.length) : null;
            if (fileContent == null || fileContent.length <= 0) {
                contentStream = null;
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileContent);
                try {
                    contentStream = new ContentStreamImpl(fileName, length, contentMimeType, (InputStream)byteArrayInputStream);
                }
                catch (CmisBaseException e) {
                    throw new DocumentationCreationException("Can't create the content of the document " + name + "\n" + e.getMessage());
                }
                finally {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            String id = folder.createDocument(newDocProps, contentStream, null, null, null, null, session.getDefaultContext()).getId();
            return this.convertDocument((org.apache.chemistry.opencmis.client.api.Document)session.getObject(session.createObjectId(id)));
        }
        catch (CmisConstraintException e) {
            LOGGER.error("Can't create a document", (Throwable)e);
            throw new DocumentAlreadyExistsException(name, name);
        }
        catch (CmisBaseException e) {
            LOGGER.error("Can't create a document", (Throwable)e);
            throw new DocumentationCreationException("Can't create a document named: " + name + "\n" + e.getMessage());
        }
    }

    private Folder convertFolder(org.apache.chemistry.opencmis.client.api.Folder cmisFolder) {
        List parents = cmisFolder.getParents();
        String parentId = parents != null && parents.size() > 0 ? ((org.apache.chemistry.opencmis.client.api.Folder)parents.get(0)).getId() : null;
        FolderImpl folderImpl = new FolderImpl(cmisFolder.getName(), parentId);
        folderImpl.setId(cmisFolder.getId());
        return folderImpl;
    }

    private DocumentImpl convertDocument(org.apache.chemistry.opencmis.client.api.Document document) {
        Boolean latestVersion = document.isLatestVersion();
        Boolean majorVersion = document.isMajorVersion();
        List parents = document.getParents();
        ProcessInstanceUUID processInstanceUUID = null;
        ProcessDefinitionUUID processDefinitionUUID = null;
        org.apache.chemistry.opencmis.client.api.Folder folder = null;
        if (parents.size() > 0) {
            Collections.sort(parents, this.comparator);
            folder = (org.apache.chemistry.opencmis.client.api.Folder)parents.get(0);
            String path = folder.getPath().substring(this.pathOfRootFolder.length());
            String[] split = path.split("/");
            if (split.length >= 1) {
                processDefinitionUUID = new ProcessDefinitionUUID(split[0]);
            }
            if (split.length >= 2) {
                processInstanceUUID = new ProcessInstanceUUID(split[1]);
            }
        }
        String folderId = folder != null ? folder.getId() : null;
        DocumentImpl doc = new DocumentImpl(document.getName(), folderId, document.getCreatedBy(), this.convertDate(document.getCreationDate()), this.convertDate(document.getLastModificationDate()), latestVersion != null ? latestVersion : false, majorVersion != null ? majorVersion : false, document.getVersionLabel(), document.getVersionSeriesId(), document.getContentStreamFileName(), document.getContentStreamMimeType(), document.getContentStreamLength(), processDefinitionUUID, processInstanceUUID);
        doc.setId(document.getId());
        return doc;
    }

    private Date convertDate(GregorianCalendar creationDate) {
        Date convertedDate;
        if (creationDate != null) {
            long timeInMillis = creationDate.getTimeInMillis();
            convertedDate = new Date(timeInMillis);
        } else {
            convertedDate = null;
        }
        return convertedDate;
    }

    @Override
    public List<Document> getChildrenDocuments(String folderId) {
        Session session2 = this.getSession();
        return this.getChildrenDocuments(session2, folderId);
    }

    private List<Document> getChildrenDocuments(Session session, String folderId) {
        org.apache.chemistry.opencmis.client.api.Folder folder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(session.createObjectId(folderId));
        ArrayList<Document> documents = new ArrayList<Document>();
        for (CmisObject children : folder.getChildren()) {
            if (!(children instanceof org.apache.chemistry.opencmis.client.api.Document)) continue;
            documents.add(this.convertDocument((org.apache.chemistry.opencmis.client.api.Document)children));
        }
        return documents;
    }

    @Override
    public List<Document> getChildrenDocuments(ProcessDefinitionUUID processDefinitionUUID, String subfolderName) throws DocumentationCreationException {
        ArrayList<Document> result = new ArrayList();
        Session session = this.getSession();
        String folderId = this.createPath(session, processDefinitionUUID, subfolderName);
        result = this.getChildrenDocuments(folderId);
        return result;
    }

    private List<Folder> getChildrenFolder(Session session, String folderId) {
        try {
            org.apache.chemistry.opencmis.client.api.Folder folder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(session.createObjectId(folderId));
            ArrayList<Folder> subFolders = new ArrayList<Folder>();
            for (CmisObject children : folder.getChildren()) {
                if (!(children instanceof org.apache.chemistry.opencmis.client.api.Folder)) continue;
                subFolders.add(this.convertFolder((org.apache.chemistry.opencmis.client.api.Folder)children));
            }
            return subFolders;
        }
        catch (Throwable t) {
            LOGGER.error("Error while listing folders of folder with id=" + folderId, t);
            throw new BonitaRuntimeException("Error while listing folders of folder with id=" + folderId + "\n" + t.getMessage());
        }
    }

    @Override
    public List<Folder> getChildrenFolder(String folderId) {
        Session session2 = this.getSession();
        return this.getChildrenFolder(session2, folderId);
    }

    @Override
    public Folder getRootFolder() {
        Session session2 = this.getSession();
        return this.getRootFolder(session2);
    }

    public Folder getRootFolder(Session session3) {
        org.apache.chemistry.opencmis.client.api.Folder folder;
        try {
            folder = (org.apache.chemistry.opencmis.client.api.Folder)session3.getObject(session3.createObjectId(this.rootFolderId));
        }
        catch (CmisObjectNotFoundException e) {
            CmisObject rootFolder = session3.getObjectByPath(this.pathOfRootFolder);
            this.rootFolderId = rootFolder.getId();
            folder = null;
        }
        return this.convertFolder(folder);
    }

    @Override
    public void deleteFolder(Folder folder) {
        Session session2 = this.getSession();
        String id = folder.getId();
        try {
            session2.getObject(session2.createObjectId(id)).delete(true);
        }
        catch (Throwable e) {
            LOGGER.error("can't delete folder " + folder.getName() + " with id " + folder.getId(), e);
            throw new BonitaRuntimeException("can't delete folder " + folder.getName() + " with id " + folder.getId() + "\n" + e.getMessage());
        }
        Map.Entry<ProcessDefinitionUUID, String> entryToDelete = null;
        for (Map.Entry<ProcessDefinitionUUID, String> entry : this.processDefinitionMap.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            entryToDelete = entry;
            break;
        }
        if (entryToDelete != null) {
            this.processDefinitionMap.remove(entryToDelete.getKey());
            return;
        }
        Map.Entry<String, String> entryToDelete2 = null;
        for (Map.Entry<String, String> entry : this.subFolderMap.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            entryToDelete2 = entry;
            break;
        }
        Map.Entry<String, String> entryToDelete3 = null;
        for (Map.Entry<String, String> entry : this.processInstanceMap.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            entryToDelete3 = entry;
            break;
        }
        if (entryToDelete2 != null) {
            this.subFolderMap.remove(entryToDelete2.getKey());
            this.processInstanceMap.remove(entryToDelete3.getKey());
            return;
        }
    }

    @Override
    public void deleteDocument(String documentId, boolean allVersions) throws DocumentNotFoundException {
        this.deleteDocument(this.getSession(), documentId, allVersions);
    }

    private void deleteDocument(Session session, String documentId, boolean allVersions) throws DocumentNotFoundException {
        try {
            session.getBinding().getObjectService().deleteObject(this.repositoryId, documentId, Boolean.valueOf(allVersions), null);
        }
        catch (CmisObjectNotFoundException e) {
            throw new DocumentNotFoundException(documentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = null;
        try {
            output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            long count = 0L;
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getContent(Document document) throws DocumentNotFoundException {
        org.apache.chemistry.opencmis.client.api.Document doc;
        Session session2 = this.getSession();
        try {
            doc = (org.apache.chemistry.opencmis.client.api.Document)session2.getObject(session2.createObjectId(document.getId()));
        }
        catch (CmisBaseException e) {
            throw new DocumentNotFoundException(document.getId());
        }
        if (doc.getContentStreamLength() == 0L) {
            return null;
        }
        ContentStream contentStream = doc.getContentStream();
        if (contentStream != null) {
            InputStream stream = contentStream.getStream();
            try {
                byte[] byteArray;
                byte[] byArray = byteArray = CMISDocumentManager.toByteArray(stream);
                return byArray;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public String getDocumentPath(String documentId) throws DocumentNotFoundException {
        Session session2 = this.getSession();
        try {
            org.apache.chemistry.opencmis.client.api.Document object = (org.apache.chemistry.opencmis.client.api.Document)session2.getObject(session2.createObjectId(documentId));
            return ((org.apache.chemistry.opencmis.client.api.Folder)object.getParents().get(0)).getPath() + "/" + object.getName();
        }
        catch (CmisObjectNotFoundException e) {
            throw new DocumentNotFoundException(documentId);
        }
    }

    @Override
    public Document createVersion(String documentId, boolean isMajorVersion) throws DocumentationCreationException {
        Session session2 = this.getSession();
        return this.createVersion(session2, documentId, isMajorVersion, null, "application/octet-stream", null);
    }

    @Override
    public Document createVersion(String documentId, boolean isMajorVersion, String fileName, String mimeType, byte[] content) throws DocumentationCreationException {
        Session session2 = this.getSession();
        return this.createVersion(session2, documentId, isMajorVersion, fileName, mimeType, content);
    }

    private Document createVersion(Session session, String documentId, boolean isMajorVersion, String fileName, String mimeType, byte[] content) throws DocumentationCreationException {
        ObjectId pwcid;
        org.apache.chemistry.opencmis.client.api.Document cmisDoc;
        try {
            cmisDoc = (org.apache.chemistry.opencmis.client.api.Document)session.getObject(session.createObjectId(documentId));
        }
        catch (CmisObjectNotFoundException e) {
            throw new DocumentationCreationException("can't find the document", new DocumentNotFoundException(documentId));
        }
        if (!cmisDoc.isLatestVersion().booleanValue()) {
            cmisDoc = cmisDoc.getObjectOfLatestVersion(true);
        }
        try {
            pwcid = cmisDoc.checkOut();
        }
        catch (CmisRuntimeException e) {
            LOGGER.error("Unable to create document", (Throwable)e);
            throw new DocumentationCreationException("Unable to create document\n" + e.getMessage());
        }
        ObjectId newVersion = null;
        ByteArrayInputStream insputStream = null;
        try {
            ContentStream contentStream;
            org.apache.chemistry.opencmis.client.api.Document pwc = (org.apache.chemistry.opencmis.client.api.Document)session.getObject(pwcid);
            if (content != null && content.length > 0) {
                if (mimeType != null) {
                    try {
                        new MimeType(mimeType);
                    }
                    catch (MimeTypeParseException e1) {
                        LOGGER.error("Mime type not valid ", (Throwable)e1);
                        throw new DocumentationCreationException("Mime type not valid\n" + e1.getMessage());
                    }
                }
                insputStream = new ByteArrayInputStream(content);
                contentStream = session.getBinding().getObjectFactory().createContentStream(fileName, BigInteger.valueOf(content.length), mimeType, (InputStream)insputStream);
            } else {
                insputStream = new ByteArrayInputStream(new byte[0]);
                contentStream = session.getBinding().getObjectFactory().createContentStream(fileName, BigInteger.valueOf(0L), mimeType, (InputStream)insputStream);
            }
            HashMap<String, String> newDocProps = new HashMap<String, String>();
            newDocProps.put("cmis:contentStreamFileName", fileName);
            newDocProps.put("cmis:contentStreamMimeType", mimeType);
            newVersion = pwc.checkIn(isMajorVersion, newDocProps, contentStream, null, null, null, null);
        }
        catch (Throwable t) {
            session.getBinding().getVersioningService().cancelCheckOut(this.repositoryId, pwcid.getId(), null);
            LOGGER.error("Unable to create document", t);
            throw new DocumentationCreationException("Unable to create document\n" + t.getMessage());
        }
        finally {
            if (insputStream != null) {
                try {
                    insputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        session.clear();
        return this.convertDocument((org.apache.chemistry.opencmis.client.api.Document)session.getObject(newVersion));
    }

    @Override
    public List<Folder> getFolders(String folderName) {
        Session session2 = this.getSession();
        return this.getFolders(session2, folderName);
    }

    private List<Folder> getFolders(Session session, String folderName) {
        String statement = "SELECT * FROM cmis:folder WHERE cmis:name = '" + folderName + "'";
        ItemIterable query = session.query(statement, false);
        ArrayList<Folder> folders = new ArrayList<Folder>();
        try {
            for (QueryResult queryResult : query) {
                PropertyData propertyById = queryResult.getPropertyById("cmis:objectId");
                String objectId = (String)propertyById.getValues().get(0);
                org.apache.chemistry.opencmis.client.api.Folder cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(session.createObjectId(objectId));
                folders.add(this.convertFolder(cmisFolder));
            }
        }
        catch (CmisObjectNotFoundException e) {
            LOGGER.debug("can't find object with query: " + statement, (Throwable)e);
        }
        return folders;
    }

    @Override
    public List<Document> getVersionsOfDocument(String documentId) throws DocumentNotFoundException {
        org.apache.chemistry.opencmis.client.api.Document document;
        Session session2 = this.getSession();
        ArrayList<DocumentImpl> versions = new ArrayList<DocumentImpl>();
        try {
            document = (org.apache.chemistry.opencmis.client.api.Document)session2.getObject(session2.createObjectId(documentId));
        }
        catch (CmisObjectNotFoundException e) {
            throw new DocumentNotFoundException(documentId);
        }
        List allVersions2 = document.getAllVersions();
        for (org.apache.chemistry.opencmis.client.api.Document oldDoc : allVersions2) {
            versions.add(this.convertDocument(oldDoc));
        }
        ProcessInstanceUUID processInstanceUUID = null;
        ProcessDefinitionUUID processDefinitionUUID = null;
        String folderId = null;
        for (DocumentImpl version : versions) {
            if (version.getProcessInstanceUUID() == null) continue;
            folderId = version.getParentFolderId();
            processDefinitionUUID = version.getProcessDefinitionUUID();
            processInstanceUUID = version.getProcessInstanceUUID();
            break;
        }
        if (processInstanceUUID != null) {
            for (DocumentImpl version : versions) {
                if (version.getProcessInstanceUUID() != null) continue;
                version.setFolderId(folderId);
                version.setProcessDefinitionUUID(processDefinitionUUID);
                version.setProcessInstanceUUID(processInstanceUUID);
            }
        }
        return new ArrayList<Document>(versions);
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID) throws DocumentationCreationException, DocumentAlreadyExistsException {
        Session session = this.getSession();
        String folderId = this.createPath(session, definitionUUID, null);
        return this.createDocument(session, name, folderId);
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID, ProcessInstanceUUID instanceUUID) throws DocumentationCreationException, DocumentAlreadyExistsException {
        Session session = this.getSession();
        String folderName = null;
        if (instanceUUID != null) {
            folderName = instanceUUID.getValue();
        }
        String folderId = this.createPath(session, definitionUUID, folderName);
        return this.createDocument(session, name, folderId);
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID, String fileName, String contentMimeType, byte[] fileContent) throws DocumentationCreationException, DocumentAlreadyExistsException {
        Session session = this.getSession();
        String subFolder = this.createPath(session, definitionUUID, null);
        return this.createDocument(session, name, subFolder, fileName, contentMimeType, fileContent);
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID, ProcessInstanceUUID instanceUUID, String fileName, String contentMimeType, byte[] fileContent) throws DocumentationCreationException, DocumentAlreadyExistsException {
        Session session = this.getSession();
        String folderName = null;
        if (instanceUUID != null) {
            folderName = instanceUUID.getValue();
        }
        String subFolder = this.createPath(session, definitionUUID, folderName);
        return this.createDocument(session, name, subFolder, fileName, contentMimeType, fileContent);
    }

    private String createPath(Session session, ProcessDefinitionUUID definitionUUID, String subFolder) throws DocumentationCreationException {
        String mainFolderId = null;
        org.apache.chemistry.opencmis.client.api.Folder mainFolder = null;
        if (this.processDefinitionMap.containsKey(definitionUUID)) {
            mainFolderId = this.processDefinitionMap.get(definitionUUID);
            try {
                mainFolder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(session.createObjectId(mainFolderId));
            }
            catch (Throwable t) {
                mainFolderId = null;
                this.processDefinitionMap.remove(definitionUUID);
            }
        }
        if (mainFolderId == null) {
            List<Folder> childrenFolder;
            String processDefUUIDValue = definitionUUID.getValue();
            try {
                childrenFolder = this.getChildrenFolder(session, this.rootFolderId);
            }
            catch (BonitaRuntimeException e) {
                CmisObject rootFolder = session.getObjectByPath(this.pathOfRootFolder);
                this.rootFolderId = rootFolder.getId();
                childrenFolder = this.getChildrenFolder(session, this.rootFolderId);
            }
            for (Folder folder : childrenFolder) {
                if (!processDefUUIDValue.equals(folder.getName())) continue;
                mainFolderId = folder.getId();
                break;
            }
            if (mainFolderId == null) {
                try {
                    mainFolderId = this.createFolder(session, processDefUUIDValue, this.rootFolderId).getId();
                }
                catch (FolderAlreadyExistsException e) {
                    e.printStackTrace();
                }
            }
            this.processDefinitionMap.put(definitionUUID, mainFolderId);
        }
        if (subFolder == null) {
            return mainFolderId;
        }
        if (mainFolder == null) {
            mainFolder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(session.createObjectId(mainFolderId));
        }
        String subFolderId = null;
        if (this.subFolderMap.containsKey(definitionUUID.getValue() + subFolder)) {
            subFolderId = this.subFolderMap.get(definitionUUID.getValue() + subFolder);
            try {
                session.getObject(session.createObjectId(subFolderId));
            }
            catch (Throwable t) {
                subFolderId = null;
                this.subFolderMap.remove(definitionUUID.getValue() + subFolder);
            }
        }
        if (subFolderId == null) {
            for (CmisObject object : mainFolder.getChildren()) {
                if (!(object instanceof org.apache.chemistry.opencmis.client.api.Folder) || !subFolder.equals(object.getName())) continue;
                subFolderId = object.getId();
                break;
            }
            if (subFolderId == null) {
                try {
                    subFolderId = this.createFolder(session, subFolder, mainFolderId).getId();
                }
                catch (FolderAlreadyExistsException e) {
                    throw new DocumentationCreationException("Folder already exists", e);
                }
            }
            this.subFolderMap.put(definitionUUID.getValue() + subFolder, subFolderId);
            this.processInstanceMap.put(definitionUUID.getValue(), subFolderId);
        }
        return subFolderId;
    }

    @Override
    public SearchResult search(DocumentSearchBuilder builder, int fromResult, int maxResults) {
        boolean isNotAtRootOfTheDrive;
        Session session2 = this.getSession();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("SELECT * FROM cmis:document");
        List<Object> query = builder.getQuery();
        boolean bl = isNotAtRootOfTheDrive = this.pathOfRootFolder.length() > 1;
        if (!query.isEmpty() || isNotAtRootOfTheDrive) {
            whereClause.append(" WHERE ");
        }
        if (isNotAtRootOfTheDrive) {
            whereClause.append(" IN_TREE('");
            whereClause.append(this.rootFolderId);
            whereClause.append("')");
            if (!query.isEmpty()) {
                whereClause.append(" AND (");
            }
        }
        block12: for (Object object : query) {
            if (object instanceof DocumentCriterion) {
                DocumentCriterion criterion = (DocumentCriterion)object;
                switch (criterion.getField()) {
                    case ID: {
                        this.createEqualsOrInClause(whereClause, criterion, "cmis:objectId");
                        break;
                    }
                    case PROCESS_DEFINITION_UUID: {
                        String idOfProcessDefinitionUUID = this.getIdOfProcessDefinitionUUID(session2, criterion);
                        if (idOfProcessDefinitionUUID == null) {
                            List<Document> list = Collections.emptyList();
                            return new SearchResult(list, 0);
                        }
                        whereClause.append(" IN_TREE('");
                        whereClause.append(idOfProcessDefinitionUUID);
                        whereClause.append("') ");
                        break;
                    }
                    case PROCESS_DEFINITION_UUID_WITHOUT_INSTANCES: {
                        String idOfProcessDefinitionUUID2 = this.getIdOfProcessDefinitionUUID(session2, criterion);
                        if (idOfProcessDefinitionUUID2 == null) {
                            List<Document> list = Collections.emptyList();
                            return new SearchResult(list, 0);
                        }
                        whereClause.append(" IN_FOLDER('");
                        whereClause.append(idOfProcessDefinitionUUID2);
                        whereClause.append("') ");
                        break;
                    }
                    case PROCESS_INSTANCE_UUID: {
                        String value = (String)criterion.getValue();
                        ArrayList<String> ids = new ArrayList<String>();
                        if (value != null) {
                            String folderIfOfProcessInstance = this.getFolderIfOfProcessInstance(session2, value);
                            if (folderIfOfProcessInstance != null) {
                                ids.add(folderIfOfProcessInstance);
                            }
                        } else {
                            for (Object inValue : criterion.getValues()) {
                                String folderIfOfProcessInstance = this.getFolderIfOfProcessInstance(session2, (String)inValue);
                                if (folderIfOfProcessInstance == null) continue;
                                ids.add(folderIfOfProcessInstance);
                            }
                        }
                        if (ids.size() == 0) {
                            List<Document> list = Collections.emptyList();
                            return new SearchResult(list, 0);
                        }
                        Iterator iterator = ids.iterator();
                        while (iterator.hasNext()) {
                            String id = (String)iterator.next();
                            whereClause.append(" IN_FOLDER('");
                            whereClause.append(id);
                            whereClause.append("') ");
                            if (!iterator.hasNext()) continue;
                            whereClause.append(" OR ");
                        }
                        continue block12;
                    }
                    case NAME: {
                        this.createEqualsOrInClause(whereClause, criterion, "cmis:name");
                        break;
                    }
                    case FILENAME: {
                        this.createEqualsOrInClause(whereClause, criterion, "cmis:contentStreamFileName");
                        break;
                    }
                    case CREATION_DATE: {
                        this.getTimeComparison(whereClause, criterion, "cmis:creationDate");
                        break;
                    }
                    case AUTHOR: {
                        this.createEqualsOrInClause(whereClause, criterion, "cmis:createdBy");
                        break;
                    }
                    case LAST_MODIFICATION_DATE: {
                        this.getTimeComparison(whereClause, criterion, "cmis:lastModificationDate");
                        break;
                    }
                    case IS_EMPTY: {
                        if (((Boolean)criterion.getValue()).booleanValue()) {
                            whereClause.append(" cmis:contentStreamLength = 0 ");
                            break;
                        }
                        whereClause.append(" cmis:contentStreamLength > 0 ");
                    }
                }
                continue;
            }
            whereClause.append(" ").append(object).append(" ");
        }
        if (isNotAtRootOfTheDrive && !query.isEmpty()) {
            whereClause.append(" )");
        }
        ItemIterable queryResult = session2.query(whereClause.toString(), builder.isSearchAllVersions());
        queryResult = queryResult.skipTo((long)fromResult);
        ItemIterable page = queryResult.getPage(maxResults);
        ArrayList<Document> documents = new ArrayList<Document>();
        for (QueryResult queryResult2 : page) {
            PropertyData propertyById = queryResult2.getPropertyById("cmis:objectId");
            org.apache.chemistry.opencmis.client.api.Document doc = (org.apache.chemistry.opencmis.client.api.Document)session2.getObject(session2.createObjectId((String)propertyById.getValues().get(0)));
            documents.add(this.convertDocument(doc));
        }
        int totalNumItems = (int)queryResult.getTotalNumItems();
        SearchResult result = new SearchResult(documents, Math.max(totalNumItems, documents.size()));
        return result;
    }

    private String getFolderIfOfProcessInstance(Session session2, String processInstanceUUIDAsString) {
        String id2;
        ProcessInstanceUUID processInstanceUUID = new ProcessInstanceUUID(processInstanceUUIDAsString);
        if (this.processInstanceMap.containsKey(processInstanceUUID)) {
            id2 = this.processInstanceMap.get(processInstanceUUID);
        } else {
            List<Folder> folders2 = this.getFolders(session2, processInstanceUUID.getValue());
            if (folders2.size() == 0) {
                return null;
            }
            id2 = folders2.get(0).getId();
        }
        return id2;
    }

    private void createEqualsOrInClause(StringBuilder whereClause, DocumentCriterion criterion, String field) {
        if (criterion.getValues() != null) {
            whereClause.append(" " + field + " IN (");
            Collection<?> values = criterion.getValues();
            Iterator<?> iterator = values.iterator();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                whereClause.append("'");
                whereClause.append(object2);
                whereClause.append("'");
                if (!iterator.hasNext()) continue;
                whereClause.append(",");
            }
            whereClause.append(") ");
        } else {
            whereClause.append(" " + field + " = '");
            whereClause.append(criterion.getValue());
            whereClause.append("' ");
        }
    }

    private String getIdOfProcessDefinitionUUID(Session session2, DocumentCriterion criterion) {
        String id;
        ProcessDefinitionUUID processDef = new ProcessDefinitionUUID((String)criterion.getValue());
        if (this.processDefinitionMap.containsKey(processDef)) {
            id = this.processDefinitionMap.get(processDef);
        } else {
            List<Folder> folders = this.getFolders(session2, processDef.getValue());
            if (folders.size() == 0) {
                return null;
            }
            id = folders.get(0).getId();
        }
        return id;
    }

    private void getTimeComparison(StringBuilder whereClause, DocumentCriterion criterion, String attribute) {
        SimpleDateFormat cmisDateFormat = CMIS_DATE_FORMAT.get();
        if (criterion.getValue() != null) {
            whereClause.append(attribute);
            whereClause.append(" = TIMESTAMP '");
            Date value = (Date)criterion.getValue();
            String fromDate = cmisDateFormat.format(value);
            whereClause.append(fromDate);
            whereClause.append("' ");
        } else {
            whereClause.append(" (");
            whereClause.append(attribute);
            whereClause.append(" >= TIMESTAMP '");
            Date from = (Date)criterion.getFrom();
            String fromDate = cmisDateFormat.format(from);
            whereClause.append(fromDate);
            whereClause.append("' AND ");
            whereClause.append(attribute);
            whereClause.append(" <= TIMESTAMP '");
            Date to = (Date)criterion.getTo();
            String toDate = cmisDateFormat.format(to);
            whereClause.append(toDate);
            whereClause.append("') ");
        }
    }

    @Override
    public void clear() throws DocumentNotFoundException {
        Session session = this.getSession();
        this.clear(session, this.getRootFolder(session));
        this.processDefinitionMap.clear();
        this.subFolderMap.clear();
        this.processInstanceMap.clear();
        session = null;
    }

    public void clear(Folder folder) throws DocumentNotFoundException {
        Session session = this.getSession();
        this.clear(session, folder);
    }

    public void clear(Session session2, Folder folder) throws DocumentNotFoundException {
        org.apache.chemistry.opencmis.client.api.Folder cmisFolder = null;
        try {
            for (Folder subFolder : this.getChildrenFolder(session2, folder.getId())) {
                cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)session2.getObject(session2.createObjectId(subFolder.getId()));
                cmisFolder.deleteTree(true, null, true);
            }
            for (Document doc : this.getChildrenDocuments(session2, folder.getId())) {
                this.deleteDocument(session2, doc.getId(), true);
            }
        }
        catch (CmisBaseException e) {
            throw new DocumentNotFoundException(folder.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDocumentContent(String documentId, String fileName, String mimeType, int size, byte[] content) throws DocumentNotFoundException {
        Session session2 = this.getSession();
        org.apache.chemistry.opencmis.client.api.Document document = null;
        try {
            document = (org.apache.chemistry.opencmis.client.api.Document)session2.getObject(session2.createObjectId(documentId));
        }
        catch (Exception e) {
            throw new DocumentNotFoundException(documentId, e);
        }
        if (content != null) {
            ByteArrayInputStream inputStream = null;
            try {
                inputStream = new ByteArrayInputStream(content);
                ContentStream contentStream = session2.getBinding().getObjectFactory().createContentStream(fileName, BigInteger.valueOf(size), mimeType, (InputStream)inputStream);
                document.setContentStream(contentStream, true);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void attachDocumentTo(ProcessDefinitionUUID processDefinitionUUID, String documentId) throws DocumentNotFoundException {
        this.attachDocumentTo(processDefinitionUUID, null, documentId);
    }

    @Override
    public void attachDocumentTo(ProcessDefinitionUUID processDefinitionUUID, ProcessInstanceUUID processInstanceUUID, String documentId) throws DocumentNotFoundException {
        Session session2 = this.getSession();
        try {
            String parentFolder = this.createPath(session2, processDefinitionUUID, processInstanceUUID.getValue());
            org.apache.chemistry.opencmis.client.api.Document document = (org.apache.chemistry.opencmis.client.api.Document)session2.getObject(session2.createObjectId(documentId));
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)session2.getObject(session2.createObjectId(parentFolder));
            document.addToFolder((ObjectId)cmisFolder, true);
        }
        catch (CmisRuntimeException e) {
            throw new DocumentNotFoundException(documentId);
        }
        catch (DocumentationCreationException dce) {
            throw new DocumentNotFoundException(documentId, dce);
        }
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID, ProcessInstanceUUID instanceUUID, String author, Date versionDate) throws DocumentationCreationException, DocumentAlreadyExistsException {
        Session session = this.getSession(author);
        String folderName = null;
        if (instanceUUID != null) {
            folderName = instanceUUID.getValue();
        }
        String folderId = this.createPath(session, definitionUUID, folderName);
        return this.createDocument(session, name, folderId);
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID, ProcessInstanceUUID instanceUUID, String author, Date versionDate, String fileName, String mimeType, byte[] content) throws DocumentationCreationException, DocumentAlreadyExistsException {
        Session session = this.getSession(author);
        String folderName = null;
        if (instanceUUID != null) {
            folderName = instanceUUID.getValue();
        }
        String subFolder = this.createPath(session, definitionUUID, folderName);
        return this.createDocument(session, name, subFolder, fileName, mimeType, content);
    }

    @Override
    public Document createVersion(String documentId, boolean isMajorVersion, String author, Date versionDate) throws DocumentationCreationException {
        Session session2 = this.getSession(author);
        return this.createVersion(session2, documentId, isMajorVersion, "", "application/octet-stream", null);
    }

    @Override
    public Document createVersion(String documentId, boolean isMajorVersion, String author, Date versionDate, String fileName, String mimeType, byte[] content) throws DocumentationCreationException {
        Session session2 = this.getSession(author);
        return this.createVersion(session2, documentId, isMajorVersion, fileName, mimeType, content);
    }

    @Override
    public Document createDocument(ProcessDefinitionUUID definitionUUID, String name, String subFolderName, String fileName, String contentMimeType, byte[] fileContent) throws DocumentationCreationException, DocumentAlreadyExistsException {
        Session session = this.getSession();
        String subFolderId = this.createPath(session, definitionUUID, subFolderName);
        return this.createDocument(session, name, subFolderId, fileName, contentMimeType, fileContent);
    }
}

