/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.identity.Membership;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.persistence.IdentityDbSession;
import org.ow2.bonita.services.AuthenticationService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

public class DbAuthentication
implements AuthenticationService {
    private static final Logger LOG = Logger.getLogger(DbAuthentication.class.getName());
    private String persistenceServiceName;

    public DbAuthentication(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    protected IdentityDbSession getDbSession() {
        return EnvTool.getIdentityDbSession(this.persistenceServiceName);
    }

    @Override
    public boolean isUserAdmin(String username) {
        try {
            UserImpl user = this.getDbSession().findUserByUsername(username);
            if (user == null) {
                throw new UserNotFoundException("bsi_DBA_1", username);
            }
            Set<Membership> userMemberships = user.getMemberships();
            for (Membership membership : userMemberships) {
                if (!"admin".equals(membership.getRole().getName()) || !"platform".equals(membership.getGroup().getName())) continue;
                return true;
            }
            return false;
        }
        catch (UserNotFoundException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e.getCause());
            return false;
        }
    }

    @Override
    public boolean checkUserCredentials(String username, String password) {
        String passwordHash = Misc.hash(password);
        UserImpl user = this.getDbSession().findUserByUsername(username);
        if (user != null) {
            String dbPassword = user.getPassword();
            if (passwordHash == null && (dbPassword == null || dbPassword.equals(Misc.hash(""))) || passwordHash != null && passwordHash.equals(dbPassword)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkUserCredentialsWithPasswordHash(String username, String passwordHash) {
        UserImpl user = this.getDbSession().findUserByUsername(username);
        if (user != null) {
            String dbPassword = user.getPassword();
            if (passwordHash == null && (dbPassword == null || dbPassword.equals(Misc.hash(""))) || passwordHash != null && passwordHash.equals(dbPassword)) {
                return true;
            }
        }
        return false;
    }
}

